/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.toolkits.callgraph;

import com.google.common.collect.Iterables;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import soot.Body;
import soot.Kind;
import soot.MethodSubSignature;
import soot.ModuleUtil;
import soot.RefType;
import soot.Scene;
import soot.Value;
import soot.jimple.InstanceInvokeExpr;
import soot.jimple.InvokeExpr;
import soot.jimple.Stmt;
import soot.options.Options;
import soot.util.StringNumberer;

public class VirtualEdgesSummaries {
    public static final int BASE_INDEX = -1;
    private static final String SUMMARIESFILE = "virtualedges.xml";
    protected final HashMap<MethodSubSignature, VirtualEdge> instanceinvokeEdges = new LinkedHashMap<MethodSubSignature, VirtualEdge>();
    protected final HashMap<String, VirtualEdge> staticinvokeEdges = new LinkedHashMap<String, VirtualEdge>();
    private static final Logger logger = LoggerFactory.getLogger(VirtualEdgesSummaries.class);

    public VirtualEdgesSummaries() {
        String virtualEdgesPath = Options.v().virtualedges_path();
        Path summariesFile = null;
        if (virtualEdgesPath != null && !virtualEdgesPath.isEmpty()) {
            Path virtualEdgesFilePath = Paths.get(virtualEdgesPath, new String[0]);
            if (Files.exists(virtualEdgesFilePath, new LinkOption[0])) {
                summariesFile = virtualEdgesFilePath;
            } else {
                logger.error("The virtual edges path {} does not exist", (Object)virtualEdgesPath);
            }
        }
        if (summariesFile == null) {
            summariesFile = Paths.get(SUMMARIESFILE, new String[0]);
        }
        try (InputStream in = Files.exists(summariesFile, new LinkOption[0]) ? Files.newInputStream(summariesFile, new OpenOption[0]) : ModuleUtil.class.getResourceAsStream("/virtualedges.xml");){
            if (in == null) {
                logger.error("Virtual edge summaries file not found");
            } else {
                this.loadSummaries(in);
            }
        }
        catch (IOException | ParserConfigurationException | SAXException e1) {
            logger.error("An error occurred while reading in virtual edge summaries", e1);
        }
    }

    public VirtualEdgesSummaries(File summariesFile) {
        try (FileInputStream in = new FileInputStream(summariesFile);){
            this.loadSummaries(in);
        }
        catch (IOException | ParserConfigurationException | SAXException e1) {
            logger.error("An error occurred while reading in virtual edge summaries", e1);
        }
    }

    protected void loadSummaries(InputStream in) throws SAXException, IOException, ParserConfigurationException {
        Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(in);
        doc.getDocumentElement().normalize();
        NodeList edges = doc.getElementsByTagName("edge");
        int e = edges.getLength();
        for (int i = 0; i < e; ++i) {
            if (edges.item(i).getNodeType() != 1) continue;
            Element edge = (Element)edges.item(i);
            VirtualEdge edg = new VirtualEdge();
            switch (edge.getAttribute("type")) {
                case "THREAD": {
                    edg.edgeType = Kind.THREAD;
                    break;
                }
                case "EXECUTOR": {
                    edg.edgeType = Kind.EXECUTOR;
                    break;
                }
                case "HANDLER": {
                    edg.edgeType = Kind.HANDLER;
                    break;
                }
                case "ASYNCTASK": {
                    edg.edgeType = Kind.ASYNCTASK;
                    break;
                }
                case "PRIVILEGED": {
                    edg.edgeType = Kind.PRIVILEGED;
                    break;
                }
                default: {
                    edg.edgeType = Kind.GENERIC_FAKE;
                }
            }
            edg.source = VirtualEdgesSummaries.parseEdgeSource((Element)edge.getElementsByTagName("source").item(0));
            edg.targets = new HashSet<VirtualEdgeTarget>();
            Element targetsElement = (Element)edge.getElementsByTagName("targets").item(0);
            edg.targets.addAll(VirtualEdgesSummaries.parseEdgeTargets(targetsElement));
            if (edg.source instanceof InstanceinvokeSource) {
                InstanceinvokeSource inst = (InstanceinvokeSource)edg.source;
                MethodSubSignature subsig = inst.subSignature;
                this.addInstanceInvoke(edg, subsig);
            }
            if (!(edg.source instanceof StaticinvokeSource)) continue;
            StaticinvokeSource stat = (StaticinvokeSource)edg.source;
            this.staticinvokeEdges.put(stat.signature, edg);
        }
        logger.debug("Found {} instanceinvoke, {} staticinvoke edge descriptions", (Object)this.instanceinvokeEdges.size(), (Object)this.staticinvokeEdges.size());
    }

    protected void addInstanceInvoke(VirtualEdge edg, MethodSubSignature subsig) {
        VirtualEdge existing = this.instanceinvokeEdges.get(subsig);
        if (existing != null) {
            existing.targets.addAll(edg.targets);
        } else {
            this.instanceinvokeEdges.put(subsig, edg);
        }
    }

    public VirtualEdgesSummaries(Collection<VirtualEdge> edges) {
        for (VirtualEdge vi : edges) {
            if (vi.source instanceof InstanceinvokeSource) {
                InstanceinvokeSource inst = (InstanceinvokeSource)vi.source;
                this.addInstanceInvoke(vi, inst.subSignature);
                continue;
            }
            if (!(vi.source instanceof StaticinvokeSource)) continue;
            StaticinvokeSource stat = (StaticinvokeSource)vi.source;
            this.staticinvokeEdges.put(stat.signature, vi);
        }
    }

    public Document toXMLDocument() throws ParserConfigurationException {
        DocumentBuilderFactory documentFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentFactory.newDocumentBuilder();
        Document document = documentBuilder.newDocument();
        Element root = document.createElement("virtualedges");
        document.appendChild(root);
        for (VirtualEdge edge : Iterables.concat(this.instanceinvokeEdges.values(), this.staticinvokeEdges.values())) {
            Element e = VirtualEdgesSummaries.edgeToXML(document, edge);
            root.appendChild(e);
        }
        return document;
    }

    private static Element edgeToXML(Document doc, VirtualEdge edge) {
        VirtualEdgeSource inv;
        Element node = doc.createElement("edge");
        node.setAttribute("type", edge.edgeType.name());
        Element source = doc.createElement("source");
        node.appendChild(source);
        if (edge.source instanceof StaticinvokeSource) {
            inv = (StaticinvokeSource)edge.source;
            source.setAttribute("invoketype", "static");
            source.setAttribute("signature", inv.signature);
        } else if (edge.source instanceof InstanceinvokeSource) {
            inv = (InstanceinvokeSource)edge.source;
            source.setAttribute("invoketype", "instance");
            source.setAttribute("subsignature", ((InstanceinvokeSource)inv).subSignature.toString());
            if (((InstanceinvokeSource)inv).declaringType != null) {
                source.setAttribute("declaringclass", ((InstanceinvokeSource)inv).declaringType.getClassName());
            }
        } else {
            if (edge.source == null) {
                throw new IllegalArgumentException("Unsupported null source type");
            }
            throw new IllegalArgumentException("Unsupported source type " + edge.source.getClass());
        }
        Element targets = doc.createElement("targets");
        node.appendChild(targets);
        for (VirtualEdgeTarget e : edge.targets) {
            Element target = VirtualEdgesSummaries.edgeTargetToXML(doc, e);
            targets.appendChild(target);
        }
        return node;
    }

    private static Element edgeTargetToXML(Document doc, VirtualEdgeTarget e) {
        Element target;
        if (e instanceof DirectTarget) {
            target = doc.createElement("direct");
        } else if (e instanceof IndirectTarget) {
            target = doc.createElement("indirect");
            IndirectTarget id = (IndirectTarget)e;
            for (VirtualEdgeTarget i : id.targets) {
                target.appendChild(VirtualEdgesSummaries.edgeTargetToXML(doc, i));
            }
        } else if (e instanceof DeferredVirtualEdgeTarget) {
            target = doc.createElement("deferred");
        } else {
            if (e == null) {
                throw new IllegalArgumentException("Unsupported null edge type");
            }
            throw new IllegalArgumentException("Unsupported source type " + e.getClass());
        }
        if (e.targetType != null) {
            target.setAttribute("declaringclass", e.targetType.getClassName());
        }
        if (e instanceof InvocationVirtualEdgeTarget) {
            InvocationVirtualEdgeTarget it = (InvocationVirtualEdgeTarget)e;
            target.setAttribute("subsignature", it.targetMethod.toString());
            if (it.isBase()) {
                target.setAttribute("target-position", "base");
            } else {
                target.setAttribute("index", String.valueOf(it.argIndex));
                target.setAttribute("target-position", "argument");
            }
        }
        return target;
    }

    public VirtualEdge getVirtualEdgesMatchingSubSig(MethodSubSignature subsig) {
        return this.instanceinvokeEdges.get(subsig);
    }

    public VirtualEdge getVirtualEdgesMatchingFunction(String signature) {
        return this.staticinvokeEdges.get(signature);
    }

    private static VirtualEdgeSource parseEdgeSource(Element source) {
        switch (source.getAttribute("invoketype")) {
            case "instance": {
                RefType dClass = VirtualEdgesSummaries.getDeclaringClassType(source);
                return new InstanceinvokeSource(dClass, source.getAttribute("subsignature"));
            }
            case "static": {
                return new StaticinvokeSource(source.getAttribute("signature"));
            }
        }
        return null;
    }

    private static RefType getDeclaringClassType(Element source) {
        String declClass = source.getAttribute("declaringclass");
        RefType dClass = null;
        if (declClass != null && !declClass.isEmpty()) {
            dClass = RefType.v(declClass);
        }
        return dClass;
    }

    private static List<VirtualEdgeTarget> parseEdgeTargets(Element targetsElement) {
        ArrayList<VirtualEdgeTarget> targets = new ArrayList<VirtualEdgeTarget>();
        StringNumberer nmbr = Scene.v().getSubSigNumberer();
        NodeList children = targetsElement.getChildNodes();
        int e = children.getLength();
        block26: for (int i = 0; i < e; ++i) {
            if (children.item(i).getNodeType() != 1) continue;
            Element targetElement = (Element)children.item(i);
            RefType type = VirtualEdgesSummaries.getDeclaringClassType(targetElement);
            switch (targetElement.getTagName()) {
                case "direct": {
                    DirectTarget dt;
                    int argIdx;
                    String tpos;
                    MethodSubSignature subsignature = new MethodSubSignature(nmbr.findOrAdd(targetElement.getAttribute("subsignature")));
                    switch (tpos = targetElement.getAttribute("target-position")) {
                        case "argument": {
                            argIdx = Integer.valueOf(targetElement.getAttribute("index"));
                            dt = new DirectTarget(type, subsignature, argIdx);
                            break;
                        }
                        case "base": {
                            dt = new DirectTarget(type, subsignature);
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException("Unsupported target position " + tpos);
                        }
                    }
                    targets.add(dt);
                    NodeList cd2 = targetElement.getChildNodes();
                    for (int x = 0; x < cd2.getLength(); ++x) {
                        Element cee;
                        Node ce = cd2.item(x);
                        if (!(ce instanceof Element) || !(cee = (Element)ce).getTagName().equals("parameterMappings")) continue;
                        VirtualEdgesSummaries.parseParameterMappings(dt, cee);
                    }
                    continue block26;
                }
                case "indirect": {
                    VirtualEdgeTarget target;
                    String tpos;
                    int argIdx;
                    MethodSubSignature subsignature = new MethodSubSignature(nmbr.findOrAdd(targetElement.getAttribute("subsignature")));
                    switch (tpos = targetElement.getAttribute("target-position")) {
                        case "argument": {
                            argIdx = Integer.valueOf(targetElement.getAttribute("index"));
                            target = new IndirectTarget(type, subsignature, argIdx);
                            break;
                        }
                        case "base": {
                            target = new IndirectTarget(type, subsignature);
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException("Unsupported target position " + tpos);
                        }
                    }
                    targets.add(target);
                    ((IndirectTarget)target).addTargets(VirtualEdgesSummaries.parseEdgeTargets(targetElement));
                    targets.add(target);
                    continue block26;
                }
                case "deferred": {
                    VirtualEdgeTarget target = new DeferredVirtualEdgeTarget(type);
                    targets.add(target);
                    continue block26;
                }
            }
        }
        return targets;
    }

    private static void parseParameterMappings(DirectTarget dt, Element cee) {
        NodeList cn = cee.getChildNodes();
        block6: for (int i = 0; i < cn.getLength(); ++i) {
            Node d = cn.item(i);
            if (!(d instanceof Element)) continue;
            Element e = (Element)d;
            switch (e.getTagName()) {
                case "direct": {
                    int sourceIdx = Integer.parseInt(e.getAttribute("sourceIdx"));
                    int targetIdx = Integer.parseInt(e.getAttribute("targetIdx"));
                    dt.parameterMappings.add(new DirectParameterMapping(sourceIdx, targetIdx));
                    continue block6;
                }
                default: {
                    throw new RuntimeException("Not supported: " + e.getTagName());
                }
            }
        }
    }

    private static Value getValueByIndex(InvokeExpr expr, int idx) {
        if (idx == -1) {
            return ((InstanceInvokeExpr)expr).getBase();
        }
        return expr.getArg(idx);
    }

    public boolean isEmpty() {
        return this.instanceinvokeEdges.isEmpty() && this.staticinvokeEdges.isEmpty();
    }

    public Set<VirtualEdge> getAllVirtualEdges() {
        HashSet<VirtualEdge> allEdges = new HashSet<VirtualEdge>(this.instanceinvokeEdges.size() + this.staticinvokeEdges.size());
        allEdges.addAll(this.instanceinvokeEdges.values());
        allEdges.addAll(this.staticinvokeEdges.values());
        return allEdges;
    }

    public static class VirtualEdge {
        Kind edgeType;
        VirtualEdgeSource source;
        Set<VirtualEdgeTarget> targets;

        VirtualEdge() {
        }

        public VirtualEdge(Kind edgeType, VirtualEdgeSource source, VirtualEdgeTarget target) {
            this(edgeType, source, new ArrayList<VirtualEdgeTarget>(Collections.singletonList(target)));
        }

        public VirtualEdge(Kind edgeType, VirtualEdgeSource source, Collection<VirtualEdgeTarget> targets) {
            this.edgeType = edgeType;
            this.source = source;
            this.targets = new HashSet<VirtualEdgeTarget>(targets);
        }

        public Kind getEdgeType() {
            return this.edgeType;
        }

        public VirtualEdgeSource getSource() {
            return this.source;
        }

        public Set<VirtualEdgeTarget> getTargets() {
            return this.targets;
        }

        public void addTargets(Collection<VirtualEdgeTarget> newTargets) {
            this.targets.addAll(newTargets);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            for (VirtualEdgeTarget t2 : this.targets) {
                sb.append(t2.toString()).append(' ');
            }
            return String.format("%s %s => %s\n", this.edgeType, this.source.toString(), sb.toString());
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.edgeType == null ? 0 : this.edgeType.hashCode());
            result = 31 * result + (this.source == null ? 0 : this.source.hashCode());
            result = 31 * result + (this.targets == null ? 0 : this.targets.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            VirtualEdge other = (VirtualEdge)obj;
            if (this.edgeType == null ? other.edgeType != null : !this.edgeType.equals(other.edgeType)) {
                return false;
            }
            if (this.source == null ? other.source != null : !this.source.equals(other.source)) {
                return false;
            }
            return !(this.targets == null ? other.targets != null : !this.targets.equals(other.targets));
        }
    }

    public static class IndirectTarget
    extends InvocationVirtualEdgeTarget {
        List<VirtualEdgeTarget> targets = new ArrayList<VirtualEdgeTarget>();

        IndirectTarget() {
        }

        public IndirectTarget(RefType targetType, MethodSubSignature targetMethod, int argIndex) {
            super(targetType, targetMethod, argIndex);
        }

        public IndirectTarget(InstanceinvokeSource source) {
            super(source.declaringType, source.subSignature);
        }

        public IndirectTarget(RefType targetType, MethodSubSignature targetMethod) {
            super(targetType, targetMethod);
        }

        @Override
        public IndirectTarget clone() {
            IndirectTarget d = new IndirectTarget(this.targetType, this.targetMethod, this.argIndex);
            for (VirtualEdgeTarget i : this.getTargets()) {
                d.addTarget(i.clone());
            }
            return d;
        }

        @Override
        public IndirectTarget clone(int argIndex) {
            IndirectTarget d = new IndirectTarget(this.targetType, this.targetMethod, argIndex);
            for (VirtualEdgeTarget i : this.getTargets()) {
                d.addTarget(i.clone());
            }
            return d;
        }

        public void addTarget(VirtualEdgeTarget target) {
            if (!this.targets.contains(target)) {
                this.targets.add(target);
            }
        }

        public void addTargets(Collection<? extends VirtualEdgeTarget> targets) {
            for (VirtualEdgeTarget virtualEdgeTarget : targets) {
                this.addTarget(virtualEdgeTarget);
            }
        }

        public List<VirtualEdgeTarget> getTargets() {
            return this.targets;
        }

        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder();
            for (VirtualEdgeTarget t2 : this.targets) {
                sb.append('(').append(t2.toString()).append(") ");
            }
            return String.format("(Instances passed to <" + (Serializable)(this.targetType != null ? this.targetType : "?") + ": %s> on %s => %s)", this.targetMethod.toString(), super.toString(), sb.toString());
        }

        @Override
        public int hashCode() {
            int prime = 31;
            int result = super.hashCode();
            result = 31 * result + (this.targets == null ? 0 : this.targets.hashCode());
            return result;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!super.equals(obj) || this.getClass() != obj.getClass()) {
                return false;
            }
            IndirectTarget other = (IndirectTarget)obj;
            return !(this.targets == null ? other.targets != null : !this.targets.equals(other.targets));
        }
    }

    public static class DirectParameterMapping
    extends AbstractParameterMapping {
        private int sourceIndex;
        private int targetIndex;

        public DirectParameterMapping(int src, int tgt) {
            this.sourceIndex = src;
            this.targetIndex = tgt;
        }

        public int getSourceIndex() {
            return this.sourceIndex;
        }

        public int getTargetIndex() {
            return this.targetIndex;
        }

        @Override
        public Value getMappedSourceArgumentArg(InvokeExpr expr) {
            return VirtualEdgesSummaries.getValueByIndex(expr, this.sourceIndex);
        }

        @Override
        public Value getMappedTargetArgumentArg(Body body) {
            if (this.targetIndex == -1) {
                return body.getThisLocal();
            }
            return body.getParameterLocal(this.targetIndex);
        }
    }

    public static abstract class AbstractParameterMapping {
        public abstract Value getMappedSourceArgumentArg(InvokeExpr var1);

        public abstract Value getMappedTargetArgumentArg(Body var1);
    }

    public static class DirectTarget
    extends InvocationVirtualEdgeTarget {
        private List<AbstractParameterMapping> parameterMappings = new ArrayList<AbstractParameterMapping>();

        DirectTarget() {
        }

        public DirectTarget(RefType targetType, MethodSubSignature targetMethod, int argIndex) {
            super(targetType, targetMethod, argIndex);
        }

        public DirectTarget(RefType targetType, MethodSubSignature targetMethod) {
            super(targetType, targetMethod);
        }

        @Override
        public DirectTarget clone() {
            return new DirectTarget(this.targetType, this.targetMethod, this.argIndex);
        }

        @Override
        public DirectTarget clone(int argIndex) {
            return new DirectTarget(this.targetType, this.targetMethod, argIndex);
        }

        @Override
        public String toString() {
            return String.format("Direct to %s%s on %s", this.targetType != null ? this.targetType.getClassName() + ": " : "", this.targetMethod.toString(), super.toString());
        }

        @Override
        public int hashCode() {
            return super.hashCode();
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            return super.equals(obj) && this.getClass() == obj.getClass();
        }

        public List<AbstractParameterMapping> getParameterMappings() {
            return this.parameterMappings;
        }
    }

    public static abstract class InvocationVirtualEdgeTarget
    extends VirtualEdgeTarget {
        protected int argIndex;
        protected MethodSubSignature targetMethod;

        InvocationVirtualEdgeTarget() {
        }

        public InvocationVirtualEdgeTarget(RefType targetType, MethodSubSignature targetMethod) {
            super(targetType);
            this.argIndex = -1;
            this.targetMethod = targetMethod;
        }

        public InvocationVirtualEdgeTarget(RefType targetType, MethodSubSignature targetMethod, int argIndex) {
            super(targetType);
            this.argIndex = argIndex;
            this.targetMethod = targetMethod;
        }

        public String toString() {
            return this.isBase() ? "base" : String.format("argument %d", this.argIndex);
        }

        public boolean isBase() {
            return this.argIndex == -1;
        }

        public int getArgIndex() {
            return this.argIndex;
        }

        public void setArgIndex(int value) {
            this.argIndex = value;
        }

        public abstract VirtualEdgeTarget clone(int var1);

        public MethodSubSignature getTargetMethod() {
            return this.targetMethod;
        }

        @Override
        public int hashCode() {
            int prime = 31;
            int result = super.hashCode();
            result = 31 * result + Objects.hash(this.argIndex, this.targetMethod);
            return result;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!super.equals(obj)) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            InvocationVirtualEdgeTarget other = (InvocationVirtualEdgeTarget)obj;
            return this.argIndex == other.argIndex && Objects.equals(this.targetMethod, other.targetMethod);
        }
    }

    public static class DeferredVirtualEdgeTarget
    extends VirtualEdgeTarget {
        DeferredVirtualEdgeTarget() {
        }

        public DeferredVirtualEdgeTarget(RefType targetType) {
            super(targetType);
        }

        @Override
        public DeferredVirtualEdgeTarget clone() {
            return new DeferredVirtualEdgeTarget(this.targetType);
        }
    }

    public static abstract class VirtualEdgeTarget {
        protected RefType targetType;

        VirtualEdgeTarget() {
        }

        public abstract VirtualEdgeTarget clone();

        public VirtualEdgeTarget(RefType targetType) {
            this.targetType = targetType;
        }

        public RefType getTargetType() {
            return this.targetType;
        }

        public int hashCode() {
            return Objects.hash(this.targetType);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            VirtualEdgeTarget other = (VirtualEdgeTarget)obj;
            return Objects.equals(this.targetType, other.targetType);
        }
    }

    public static class InstanceinvokeSource
    extends VirtualEdgeSource {
        MethodSubSignature subSignature;
        RefType declaringType;

        public InstanceinvokeSource(RefType declaringType, String subSignature) {
            this.subSignature = new MethodSubSignature(Scene.v().getSubSigNumberer().findOrAdd(subSignature));
            this.declaringType = declaringType;
        }

        public InstanceinvokeSource(Stmt invokeStmt) {
            this(invokeStmt.getInvokeExpr().getMethodRef().getDeclaringClass().getType(), invokeStmt.getInvokeExpr().getMethodRef().getSubSignature().getString());
        }

        public String toString() {
            return (String)(this.declaringType != null ? this.declaringType + ": " : "") + this.subSignature.toString();
        }

        public RefType getDeclaringType() {
            return this.declaringType;
        }

        public MethodSubSignature getSubSignature() {
            return this.subSignature;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.declaringType == null ? 0 : this.declaringType.hashCode());
            result = 31 * result + (this.subSignature == null ? 0 : this.subSignature.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            InstanceinvokeSource other = (InstanceinvokeSource)obj;
            if (this.declaringType == null ? other.declaringType != null : !this.declaringType.equals(other.declaringType)) {
                return false;
            }
            return !(this.subSignature == null ? other.subSignature != null : !this.subSignature.equals(other.subSignature));
        }
    }

    public static class StaticinvokeSource
    extends VirtualEdgeSource {
        String signature;

        public StaticinvokeSource(String signature) {
            this.signature = signature;
        }

        public String getSignature() {
            return this.signature;
        }

        public String toString() {
            return this.signature;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.signature == null ? 0 : this.signature.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            StaticinvokeSource other = (StaticinvokeSource)obj;
            return !(this.signature == null ? other.signature != null : !this.signature.equals(other.signature));
        }
    }

    public static abstract class VirtualEdgeSource {
    }
}

