/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.toolkits.callgraph;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import soot.MethodOrMethodContext;
import soot.SootMethod;
import soot.jimple.toolkits.callgraph.CallGraph;
import soot.jimple.toolkits.callgraph.Targets;

public class TopologicalOrderer {
    private final CallGraph cg;
    private final List<SootMethod> order;
    private final Set<SootMethod> visited;

    public TopologicalOrderer(CallGraph cg) {
        this.cg = cg;
        this.order = new ArrayList<SootMethod>();
        this.visited = new HashSet<SootMethod>();
    }

    public void go() {
        Iterator<MethodOrMethodContext> methods = this.cg.sourceMethods();
        while (methods.hasNext()) {
            SootMethod m4 = (SootMethod)methods.next();
            this.dfsVisit(m4);
        }
    }

    private void dfsVisit(SootMethod m4) {
        if (this.visited.contains(m4)) {
            return;
        }
        this.visited.add(m4);
        Targets targets = new Targets(this.cg.edgesOutOf(m4));
        while (targets.hasNext()) {
            SootMethod target = (SootMethod)targets.next();
            this.dfsVisit(target);
        }
        this.order.add(m4);
    }

    public List<SootMethod> order() {
        return this.order;
    }
}

