/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.toolkits.callgraph;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.AnySubType;
import soot.ArrayType;
import soot.Body;
import soot.BooleanType;
import soot.ByteType;
import soot.CharType;
import soot.Context;
import soot.DoubleType;
import soot.EntryPoints;
import soot.FastHierarchy;
import soot.FloatType;
import soot.IntType;
import soot.Kind;
import soot.Local;
import soot.LocalGenerator;
import soot.LongType;
import soot.MethodContext;
import soot.MethodOrMethodContext;
import soot.MethodSubSignature;
import soot.NullType;
import soot.PackManager;
import soot.PhaseOptions;
import soot.PrimType;
import soot.RefLikeType;
import soot.RefType;
import soot.Scene;
import soot.SceneTransformer;
import soot.ShortType;
import soot.SootClass;
import soot.SootMethod;
import soot.SootMethodRef;
import soot.Transform;
import soot.Type;
import soot.Unit;
import soot.UnitPatchingChain;
import soot.Value;
import soot.jimple.AssignStmt;
import soot.jimple.DynamicInvokeExpr;
import soot.jimple.FieldRef;
import soot.jimple.InstanceInvokeExpr;
import soot.jimple.InvokeExpr;
import soot.jimple.InvokeStmt;
import soot.jimple.Jimple;
import soot.jimple.NewArrayExpr;
import soot.jimple.NewExpr;
import soot.jimple.NewMultiArrayExpr;
import soot.jimple.NullConstant;
import soot.jimple.SpecialInvokeExpr;
import soot.jimple.StaticFieldRef;
import soot.jimple.StaticInvokeExpr;
import soot.jimple.Stmt;
import soot.jimple.StringConstant;
import soot.jimple.VirtualInvokeExpr;
import soot.jimple.spark.pag.AllocDotField;
import soot.jimple.toolkits.annotation.nullcheck.NullnessAnalysis;
import soot.jimple.toolkits.callgraph.CallGraph;
import soot.jimple.toolkits.callgraph.ConstantArrayAnalysis;
import soot.jimple.toolkits.callgraph.ContextManager;
import soot.jimple.toolkits.callgraph.Edge;
import soot.jimple.toolkits.callgraph.InvokeCallSite;
import soot.jimple.toolkits.callgraph.ReachableMethods;
import soot.jimple.toolkits.callgraph.ReflectionModel;
import soot.jimple.toolkits.callgraph.VirtualCallSite;
import soot.jimple.toolkits.callgraph.VirtualCalls;
import soot.jimple.toolkits.callgraph.VirtualEdgesSummaries;
import soot.jimple.toolkits.reflection.ReflectionTraceInfo;
import soot.options.CGOptions;
import soot.options.Options;
import soot.options.SparkOptions;
import soot.toolkits.graph.ExceptionalUnitGraph;
import soot.toolkits.graph.ExceptionalUnitGraphFactory;
import soot.util.HashMultiMap;
import soot.util.MultiMap;
import soot.util.NumberedString;
import soot.util.StringNumberer;
import soot.util.queue.ChunkedQueue;
import soot.util.queue.QueueReader;

public class OnFlyCallGraphBuilder {
    private static final Logger logger = LoggerFactory.getLogger(OnFlyCallGraphBuilder.class);
    static boolean registeredGuardsTransformation = false;
    private static final PrimType[] CHAR_NARROWINGS;
    private static final PrimType[] INT_NARROWINGS;
    private static final PrimType[] SHORT_NARROWINGS;
    private static final PrimType[] LONG_NARROWINGS;
    private static final ByteType[] BYTE_NARROWINGS;
    private static final PrimType[] FLOAT_NARROWINGS;
    private static final PrimType[] BOOLEAN_NARROWINGS;
    private static final PrimType[] DOUBLE_NARROWINGS;
    protected final NumberedString sigFinalize;
    protected final NumberedString sigInit;
    protected final NumberedString sigForName;
    protected final RefType clRunnable = RefType.v("java.lang.Runnable");
    protected final RefType clAsyncTask = RefType.v("android.os.AsyncTask");
    protected final RefType clHandler = RefType.v("android.os.Handler");
    private final CallGraph cicg = Scene.v().internalMakeCallGraph();
    protected final Map<Local, List<VirtualCallSite>> receiverToSites;
    protected final Map<SootMethod, List<Local>> methodToReceivers;
    protected final Map<SootMethod, List<Local>> methodToInvokeBases;
    protected final Map<SootMethod, List<Local>> methodToInvokeArgs;
    protected final Map<SootMethod, List<Local>> methodToStringConstants;
    protected final Map<Local, List<VirtualCallSite>> stringConstToSites;
    protected final HashSet<SootMethod> analyzedMethods = new HashSet();
    protected final MultiMap<Local, InvokeCallSite> baseToInvokeSite = new HashMultiMap<Local, InvokeCallSite>();
    protected final MultiMap<Local, InvokeCallSite> invokeArgsToInvokeSite = new HashMultiMap<Local, InvokeCallSite>();
    protected final Map<Local, BitSet> invokeArgsToSize = new IdentityHashMap<Local, BitSet>();
    protected final MultiMap<AllocDotField, Local> allocDotFieldToLocal = new HashMultiMap<AllocDotField, Local>();
    protected final MultiMap<Local, Type> reachingArgTypes = new HashMultiMap<Local, Type>();
    protected final MultiMap<Local, Type> reachingBaseTypes = new HashMultiMap<Local, Type>();
    protected final ChunkedQueue<SootMethod> targetsQueue = new ChunkedQueue();
    protected final QueueReader<SootMethod> targets = this.targetsQueue.reader();
    protected final ReflectionModel reflectionModel;
    protected final CGOptions options;
    protected boolean appOnly;
    protected final ReachableMethods rm;
    protected final QueueReader<MethodOrMethodContext> worklist;
    protected final ContextManager cm;
    protected final VirtualEdgesSummaries virtualEdgeSummaries = this.initializeEdgeSummaries();
    protected NullnessAnalysis nullnessCache = null;
    protected ConstantArrayAnalysis arrayCache = null;
    protected SootMethod analysisKey = null;

    public OnFlyCallGraphBuilder(ContextManager cm, ReachableMethods rm, boolean appOnly) {
        Scene sc = Scene.v();
        StringNumberer nmbr = sc.getSubSigNumberer();
        this.sigFinalize = Options.v().src_prec() == 7 ? nmbr.findOrAdd("void Finalize()") : nmbr.findOrAdd("void finalize()");
        this.sigInit = nmbr.findOrAdd("void <init>()");
        this.sigForName = nmbr.findOrAdd("void <init>()");
        this.receiverToSites = new HashMap<Local, List<VirtualCallSite>>();
        this.methodToReceivers = new HashMap<SootMethod, List<Local>>();
        this.methodToInvokeBases = new HashMap<SootMethod, List<Local>>();
        this.methodToInvokeArgs = new HashMap<SootMethod, List<Local>>();
        this.methodToStringConstants = new HashMap<SootMethod, List<Local>>();
        this.stringConstToSites = new HashMap<Local, List<VirtualCallSite>>();
        this.cm = cm;
        this.rm = rm;
        this.worklist = rm.listener();
        this.options = new CGOptions(PhaseOptions.v().getPhaseOptions("cg"));
        if (!this.options.verbose()) {
            logger.debug("[Call Graph] For information on where the call graph may be incomplete, use the verbose option to the cg phase.");
        }
        this.reflectionModel = this.options.reflection_log() == null || this.options.reflection_log().length() == 0 ? (this.options.types_for_invoke() && new SparkOptions(PhaseOptions.v().getPhaseOptions("cg.spark")).enabled() ? new TypeBasedReflectionModel() : new DefaultReflectionModel()) : new TraceBasedReflectionModel();
        this.appOnly = appOnly;
    }

    public OnFlyCallGraphBuilder(ContextManager cm, ReachableMethods rm) {
        this(cm, rm, false);
    }

    protected VirtualEdgesSummaries initializeEdgeSummaries() {
        return new VirtualEdgesSummaries();
    }

    public ContextManager getContextManager() {
        return this.cm;
    }

    public Map<SootMethod, List<Local>> methodToReceivers() {
        return this.methodToReceivers;
    }

    public Map<SootMethod, List<Local>> methodToInvokeArgs() {
        return this.methodToInvokeArgs;
    }

    public Map<SootMethod, List<Local>> methodToInvokeBases() {
        return this.methodToInvokeBases;
    }

    public Map<SootMethod, List<Local>> methodToStringConstants() {
        return this.methodToStringConstants;
    }

    public void processReachables() {
        while (true) {
            MethodOrMethodContext momc;
            if (!this.worklist.hasNext()) {
                this.rm.update();
                if (!this.worklist.hasNext()) break;
            }
            if ((momc = this.worklist.next()) == null) continue;
            SootMethod m4 = momc.method();
            if (this.appOnly && !m4.getDeclaringClass().isApplicationClass()) continue;
            if (this.analyzedMethods.add(m4)) {
                this.processNewMethod(m4);
            }
            this.processNewMethodContext(momc);
        }
    }

    public boolean wantTypes(Local receiver) {
        return this.receiverToSites.get(receiver) != null || this.baseToInvokeSite.get(receiver) != null;
    }

    public void addBaseType(Local base, Context context, Type ty) {
        assert (context == null);
        Set<InvokeCallSite> invokeSites = this.baseToInvokeSite.get(base);
        if (invokeSites != null && this.reachingBaseTypes.put(base, ty) && !invokeSites.isEmpty()) {
            this.resolveInvoke(invokeSites);
        }
    }

    public void addInvokeArgType(Local argArray, Context context, Type t2) {
        assert (context == null);
        Set<InvokeCallSite> invokeSites = this.invokeArgsToInvokeSite.get(argArray);
        if (invokeSites != null && this.reachingArgTypes.put(argArray, t2)) {
            this.resolveInvoke(invokeSites);
        }
    }

    public void setArgArrayNonDetSize(Local argArray, Context context) {
        assert (context == null);
        Set<InvokeCallSite> invokeSites = this.invokeArgsToInvokeSite.get(argArray);
        if (invokeSites != null && !this.invokeArgsToSize.containsKey(argArray)) {
            this.invokeArgsToSize.put(argArray, null);
            this.resolveInvoke(invokeSites);
        }
    }

    public void addPossibleArgArraySize(Local argArray, int value, Context context) {
        BitSet sizeSet;
        assert (context == null);
        Set<InvokeCallSite> invokeSites = this.invokeArgsToInvokeSite.get(argArray);
        if (!(invokeSites == null || (sizeSet = this.invokeArgsToSize.get(argArray)) != null && sizeSet.isEmpty())) {
            if (sizeSet == null) {
                sizeSet = new BitSet();
                this.invokeArgsToSize.put(argArray, sizeSet);
            }
            if (!sizeSet.get(value)) {
                sizeSet.set(value);
                this.resolveInvoke(invokeSites);
            }
        }
    }

    private static Set<RefLikeType> resolveToClasses(Set<Type> rawTypes) {
        HashSet<RefLikeType> toReturn = new HashSet<RefLikeType>();
        if (!rawTypes.isEmpty()) {
            FastHierarchy fh = Scene.v().getOrMakeFastHierarchy();
            for (Type ty : rawTypes) {
                if (ty instanceof AnySubType) {
                    AnySubType anySubType = (AnySubType)ty;
                    RefType base = anySubType.getBase();
                    Set<SootClass> classRoots = base.getSootClass().isInterface() ? fh.getAllImplementersOfInterface(base.getSootClass()) : Collections.singleton(base.getSootClass());
                    toReturn.addAll(OnFlyCallGraphBuilder.getTransitiveSubClasses(classRoots));
                    continue;
                }
                if (!(ty instanceof RefType)) continue;
                toReturn.add((RefType)ty);
            }
        }
        return toReturn;
    }

    private static Collection<RefLikeType> getTransitiveSubClasses(Set<SootClass> classRoots) {
        HashSet<RefLikeType> resolved = new HashSet<RefLikeType>();
        if (!classRoots.isEmpty()) {
            FastHierarchy fh = Scene.v().getOrMakeFastHierarchy();
            LinkedList<SootClass> worklist = new LinkedList<SootClass>(classRoots);
            while (!worklist.isEmpty()) {
                SootClass cls = worklist.removeFirst();
                if (!resolved.add(cls.getType())) continue;
                worklist.addAll(fh.getSubclassesOf(cls));
            }
        }
        return resolved;
    }

    private void resolveInvoke(Collection<InvokeCallSite> list) {
        for (InvokeCallSite ics : list) {
            boolean mustBeNull;
            Set<Type> s2 = this.reachingBaseTypes.get(ics.base());
            if (s2 == null || s2.isEmpty()) continue;
            if (ics.reachingTypes() != null) {
                assert (ics.nullnessCode() != 0);
                this.resolveStaticTypes(s2, ics);
                continue;
            }
            boolean mustNotBeNull = ics.nullnessCode() == 1;
            boolean bl = mustBeNull = ics.nullnessCode() == 0;
            if (mustBeNull || ics.nullnessCode() == -1 && (!this.invokeArgsToSize.containsKey(ics.argArray()) || !this.reachingArgTypes.containsKey(ics.argArray()))) {
                for (Type type : OnFlyCallGraphBuilder.resolveToClasses(s2)) {
                    assert (type instanceof RefType);
                    if (type instanceof ArrayType) continue;
                    SootClass baseClass = ((RefType)type).getSootClass();
                    assert (!baseClass.isInterface());
                    Iterator<SootMethod> iterator = OnFlyCallGraphBuilder.getPublicNullaryMethodIterator(baseClass);
                    while (iterator.hasNext()) {
                        SootMethod sm = iterator.next();
                        this.cm.addVirtualEdge(ics.getContainer(), ics.getStmt(), sm, Kind.REFL_INVOKE, null);
                    }
                }
                continue;
            }
            Set<Type> reachingTypes = this.reachingArgTypes.get(ics.argArray());
            if (reachingTypes == null || !this.invokeArgsToSize.containsKey(ics.argArray())) {
                assert (ics.nullnessCode() == 1) : ics;
                return;
            }
            BitSet bitSet = this.invokeArgsToSize.get(ics.argArray());
            for (Type type : OnFlyCallGraphBuilder.resolveToClasses(s2)) {
                assert (type instanceof RefLikeType);
                if (type instanceof NullType || type instanceof ArrayType) continue;
                SootClass baseClass = ((RefType)type).getSootClass();
                Iterator<SootMethod> mIt = OnFlyCallGraphBuilder.getPublicMethodIterator(baseClass, reachingTypes, bitSet, mustNotBeNull);
                while (mIt.hasNext()) {
                    SootMethod sm = mIt.next();
                    this.cm.addVirtualEdge(ics.getContainer(), ics.getStmt(), sm, Kind.REFL_INVOKE, null);
                }
            }
        }
    }

    private void resolveStaticTypes(Set<Type> s2, InvokeCallSite ics) {
        ConstantArrayAnalysis.ArrayTypes at = ics.reachingTypes();
        for (Type type : OnFlyCallGraphBuilder.resolveToClasses(s2)) {
            if (type instanceof ArrayType) continue;
            SootClass baseClass = ((RefType)type).getSootClass();
            Iterator<SootMethod> mIt = OnFlyCallGraphBuilder.getPublicMethodIterator(baseClass, at);
            while (mIt.hasNext()) {
                SootMethod sm = mIt.next();
                this.cm.addVirtualEdge(ics.getContainer(), ics.getStmt(), sm, Kind.REFL_INVOKE, null);
            }
        }
    }

    private static Iterator<SootMethod> getPublicMethodIterator(SootClass baseClass, final ConstantArrayAnalysis.ArrayTypes at) {
        return new AbstractMethodIterator(baseClass){

            @Override
            protected boolean acceptMethod(SootMethod m4) {
                if (!at.possibleSizes.contains(m4.getParameterCount())) {
                    return false;
                }
                for (int i = 0; i < m4.getParameterCount(); ++i) {
                    Set<Type> possibleType = at.possibleTypes[i];
                    if (possibleType.isEmpty() || OnFlyCallGraphBuilder.isReflectionCompatible(m4.getParameterType(i), possibleType)) continue;
                    return false;
                }
                return true;
            }
        };
    }

    private static PrimType[] narrowings(PrimType f) {
        if (f instanceof IntType) {
            return INT_NARROWINGS;
        }
        if (f instanceof ShortType) {
            return SHORT_NARROWINGS;
        }
        if (f instanceof LongType) {
            return LONG_NARROWINGS;
        }
        if (f instanceof ByteType) {
            return BYTE_NARROWINGS;
        }
        if (f instanceof FloatType) {
            return FLOAT_NARROWINGS;
        }
        if (f instanceof BooleanType) {
            return BOOLEAN_NARROWINGS;
        }
        if (f instanceof DoubleType) {
            return DOUBLE_NARROWINGS;
        }
        if (f instanceof CharType) {
            return CHAR_NARROWINGS;
        }
        throw new RuntimeException("Unexpected primitive type: " + f);
    }

    private static boolean isReflectionCompatible(Type paramType, Set<Type> reachingTypes) {
        if (reachingTypes.contains(NullType.v())) {
            return true;
        }
        if (paramType instanceof RefLikeType) {
            FastHierarchy fh = Scene.v().getOrMakeFastHierarchy();
            for (Type rType : reachingTypes) {
                if (!fh.canStoreType(rType, paramType)) continue;
                return true;
            }
            return false;
        }
        if (paramType instanceof PrimType) {
            for (PrimType narrowings : OnFlyCallGraphBuilder.narrowings((PrimType)paramType)) {
                if (!reachingTypes.contains(narrowings.boxedType())) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    private static Iterator<SootMethod> getPublicMethodIterator(SootClass baseClass, final Set<Type> reachingTypes, final BitSet methodSizes, final boolean mustNotBeNull) {
        if (baseClass.isPhantom()) {
            return Collections.emptyIterator();
        }
        return new AbstractMethodIterator(baseClass){

            @Override
            protected boolean acceptMethod(SootMethod n) {
                if (methodSizes != null) {
                    boolean compatibleSize;
                    int nParams = n.getParameterCount();
                    boolean bl = compatibleSize = methodSizes.get(nParams) || !mustNotBeNull && nParams == 0;
                    if (!compatibleSize) {
                        return false;
                    }
                }
                for (Type pTy : n.getParameterTypes()) {
                    if (OnFlyCallGraphBuilder.isReflectionCompatible(pTy, reachingTypes)) continue;
                    return false;
                }
                return true;
            }
        };
    }

    private static Iterator<SootMethod> getPublicNullaryMethodIterator(SootClass baseClass) {
        if (baseClass.isPhantom()) {
            return Collections.emptyIterator();
        }
        return new AbstractMethodIterator(baseClass){

            @Override
            protected boolean acceptMethod(SootMethod n) {
                return n.getParameterCount() == 0;
            }
        };
    }

    public void addType(Local receiver, Context srcContext, Type type, Context typeContext) {
        List<VirtualCallSite> rcvrToCallSites = this.receiverToSites.get(receiver);
        if (rcvrToCallSites != null) {
            VirtualCalls virtualCalls = VirtualCalls.v();
            Scene sc = Scene.v();
            FastHierarchy fh = sc.getOrMakeFastHierarchy();
            for (VirtualCallSite site : rcvrToCallSites) {
                SootMethod target;
                if (this.skipSite(site, fh, type)) continue;
                InstanceInvokeExpr iie = site.iie();
                if (iie instanceof SpecialInvokeExpr && !Kind.isFake(site.kind())) {
                    target = virtualCalls.resolveSpecial(iie.getMethodRef(), site.getContainer(), this.appOnly);
                    if (target != null) {
                        this.targetsQueue.add(target);
                    }
                } else {
                    SootMethodRef ref = null;
                    Type receiverType = receiver.getType();
                    if (receiverType instanceof RefType) {
                        SootClass receiverClass = ((RefType)receiverType).getSootClass();
                        MethodSubSignature subsig = site.subSig();
                        ref = sc.makeMethodRef(receiverClass, subsig.methodName, subsig.parameterTypes, subsig.getReturnType(), Kind.isStatic(site.kind()));
                    } else {
                        ref = site.getStmt().getInvokeExpr().getMethodRef();
                    }
                    if (ref != null) {
                        virtualCalls.resolve(type, receiver.getType(), ref, site.getContainer(), this.targetsQueue, this.appOnly);
                        if (!this.targets.hasNext() && this.options.resolve_all_abstract_invokes()) {
                            virtualCalls.resolveSuperType(type, receiver.getType(), iie.getMethodRef(), this.targetsQueue, this.appOnly);
                        }
                    }
                }
                while (this.targets.hasNext()) {
                    target = this.targets.next();
                    this.cm.addVirtualEdge(MethodContext.v(site.getContainer(), srcContext), site.getStmt(), target, site.kind(), typeContext);
                }
            }
        }
        if (this.baseToInvokeSite.get(receiver) != null) {
            this.addBaseType(receiver, srcContext, type);
        }
    }

    protected boolean skipSite(VirtualCallSite site, FastHierarchy fh, Type type) {
        Kind k = site.kind();
        if (k == Kind.THREAD) {
            return !fh.canStoreType(type, this.clRunnable);
        }
        if (k == Kind.EXECUTOR) {
            return !fh.canStoreType(type, this.clRunnable);
        }
        if (k == Kind.ASYNCTASK) {
            return !fh.canStoreType(type, this.clAsyncTask);
        }
        if (k == Kind.HANDLER) {
            return !fh.canStoreType(type, this.clHandler);
        }
        return false;
    }

    public boolean wantStringConstants(Local stringConst) {
        return this.stringConstToSites.get(stringConst) != null;
    }

    public void addStringConstant(Local l, Context srcContext, String constant) {
        block7: {
            block6: {
                if (constant == null) break block6;
                Scene sc = Scene.v();
                for (VirtualCallSite site : this.stringConstToSites.get(l)) {
                    int constLen = constant.length();
                    if (constLen > 0 && constant.charAt(0) == '[') {
                        if (constLen <= 2 || constant.charAt(1) != 'L' || constant.charAt(constLen - 1) != ';') continue;
                        constant = constant.substring(2, constLen - 1);
                    }
                    if (sc.containsClass(constant)) {
                        SootClass sootcls = sc.getSootClass(constant);
                        if (!sootcls.isApplicationClass() && !sootcls.isPhantom()) {
                            sootcls.setLibraryClass();
                        }
                        for (SootMethod clinit : EntryPoints.v().clinitsOf(sootcls)) {
                            this.cm.addStaticEdge(MethodContext.v(site.getContainer(), srcContext), site.getStmt(), clinit, Kind.CLINIT);
                        }
                        continue;
                    }
                    if (!this.options.verbose()) continue;
                    logger.warn("Class " + constant + " is a dynamic class and was not specified as such; graph will be incomplete!");
                }
                break block7;
            }
            if (!this.options.verbose()) break block7;
            for (VirtualCallSite site : this.stringConstToSites.get(l)) {
                logger.warn("Method " + site.getContainer() + " is reachable, and calls Class.forName on a non-constant String; graph will be incomplete! Use safe-forname option for a conservative result.");
            }
        }
    }

    public boolean wantArrayField(AllocDotField df) {
        return this.allocDotFieldToLocal.containsKey(df);
    }

    public void addInvokeArgType(AllocDotField df, Context context, Type type) {
        if (this.allocDotFieldToLocal.containsKey(df)) {
            for (Local l : this.allocDotFieldToLocal.get(df)) {
                this.addInvokeArgType(l, context, type);
            }
        }
    }

    public boolean wantInvokeArg(Local receiver) {
        return this.invokeArgsToInvokeSite.containsKey(receiver);
    }

    public void addInvokeArgDotField(Local receiver, AllocDotField dot) {
        this.allocDotFieldToLocal.put(dot, receiver);
    }

    private void addInvokeCallSite(Stmt s2, SootMethod container2, InstanceInvokeExpr d) {
        InvokeCallSite ics;
        Local l = (Local)d.getArg(0);
        Value argArray = d.getArg(1);
        if (argArray instanceof NullConstant) {
            ics = new InvokeCallSite(s2, container2, d, l);
        } else {
            Local argLocal;
            int nullnessCode;
            if (this.analysisKey != container2) {
                ExceptionalUnitGraph graph = ExceptionalUnitGraphFactory.createExceptionalUnitGraph(container2.getActiveBody());
                this.nullnessCache = new NullnessAnalysis(graph);
                this.arrayCache = new ConstantArrayAnalysis(graph, container2.getActiveBody());
                this.analysisKey = container2;
            }
            if ((nullnessCode = this.nullnessCache.isAlwaysNonNullBefore(s2, argLocal = (Local)argArray) ? 1 : (this.nullnessCache.isAlwaysNullBefore(s2, argLocal) ? 0 : -1)) != 0 && this.arrayCache.isConstantBefore(s2, argLocal)) {
                ConstantArrayAnalysis.ArrayTypes reachingArgTypes = this.arrayCache.getArrayTypesBefore(s2, argLocal);
                if (nullnessCode == -1) {
                    reachingArgTypes.possibleSizes.add(0);
                }
                ics = new InvokeCallSite(s2, container2, d, l, reachingArgTypes, nullnessCode);
            } else {
                ics = new InvokeCallSite(s2, container2, d, l, argLocal, nullnessCode);
                this.invokeArgsToInvokeSite.put(argLocal, ics);
            }
        }
        this.baseToInvokeSite.put(l, ics);
    }

    private void addVirtualCallSite(Stmt s2, SootMethod m4, Local receiver, InstanceInvokeExpr iie, MethodSubSignature subSig, Kind kind) {
        List<VirtualCallSite> sites = this.receiverToSites.get(receiver);
        if (sites == null) {
            sites = new ArrayList<VirtualCallSite>();
            this.receiverToSites.put(receiver, sites);
            List<Local> receivers = this.methodToReceivers.get(m4);
            if (receivers == null) {
                receivers = new ArrayList<Local>();
                this.methodToReceivers.put(m4, receivers);
            }
            receivers.add(receiver);
        }
        sites.add(new VirtualCallSite(s2, m4, iie, subSig, kind));
    }

    protected void processNewMethod(SootMethod m4) {
        if (m4.isConcrete()) {
            Body b = m4.retrieveActiveBody();
            this.getImplicitTargets(m4);
            this.findReceivers(m4, b);
        }
    }

    protected void findReceivers(SootMethod m4, Body b) {
        for (Unit u : b.getUnits()) {
            Stmt s2 = (Stmt)u;
            if (!s2.containsInvokeExpr()) continue;
            InvokeExpr ie = s2.getInvokeExpr();
            if (ie instanceof InstanceInvokeExpr) {
                InstanceInvokeExpr iie = (InstanceInvokeExpr)ie;
                Local receiver = (Local)iie.getBase();
                if (!(iie instanceof SpecialInvokeExpr)) {
                    MethodSubSignature subSig = new MethodSubSignature(iie.getMethodRef());
                    VirtualEdgesSummaries.VirtualEdge virtualEdge = this.virtualEdgeSummaries.getVirtualEdgesMatchingSubSig(subSig);
                    if (virtualEdge != null) {
                        for (VirtualEdgesSummaries.VirtualEdgeTarget t2 : virtualEdge.targets) {
                            if (t2 instanceof VirtualEdgesSummaries.InvocationVirtualEdgeTarget) {
                                this.processVirtualEdgeSummary(m4, s2, receiver, (VirtualEdgesSummaries.InvocationVirtualEdgeTarget)t2, virtualEdge.edgeType);
                                continue;
                            }
                            if (!(t2 instanceof VirtualEdgesSummaries.DeferredVirtualEdgeTarget)) continue;
                            this.addVirtualCallSite(s2, m4, receiver, iie, new MethodSubSignature(iie.getMethodRef()), Kind.GENERIC_FAKE);
                        }
                    }
                } else {
                    this.addEdge(m4, s2, ie.getMethod(), Kind.SPECIAL);
                }
                this.addVirtualCallSite(s2, m4, receiver, iie, new MethodSubSignature(iie.getMethodRef()), Edge.ieToKind(iie));
                continue;
            }
            if (ie instanceof DynamicInvokeExpr) {
                if (!this.options.verbose()) continue;
                logger.warn("InvokeDynamic to " + ie + " not resolved during call-graph construction.");
                continue;
            }
            SootMethod tgt = ie.getMethod();
            if (tgt != null) {
                this.addEdge(m4, s2, tgt);
                String signature = tgt.getSignature();
                VirtualEdgesSummaries.VirtualEdge virtualEdge = this.virtualEdgeSummaries.getVirtualEdgesMatchingFunction(signature);
                if (virtualEdge == null) continue;
                for (VirtualEdgesSummaries.VirtualEdgeTarget t3 : virtualEdge.targets) {
                    Value runnable;
                    VirtualEdgesSummaries.DirectTarget directTarget;
                    if (!(t3 instanceof VirtualEdgesSummaries.DirectTarget) || (directTarget = (VirtualEdgesSummaries.DirectTarget)t3).isBase() || !((runnable = ie.getArg(directTarget.argIndex)) instanceof Local)) continue;
                    this.addVirtualCallSite(s2, m4, (Local)runnable, null, directTarget.targetMethod, Kind.GENERIC_FAKE);
                }
                continue;
            }
            if (Options.v().ignore_resolution_errors()) continue;
            throw new InternalError("Unresolved target " + ie.getMethod() + ". Resolution error should have occured earlier.");
        }
    }

    protected void processVirtualEdgeSummary(SootMethod m4, Stmt s2, Local receiver, VirtualEdgesSummaries.InvocationVirtualEdgeTarget target, Kind edgeType) {
        this.processVirtualEdgeSummary(m4, s2, s2, receiver, target, edgeType);
    }

    private Local getLocalForTarget(InvokeExpr ie, VirtualEdgesSummaries.InvocationVirtualEdgeTarget target) {
        Value arg;
        if (target.isBase() && ie instanceof InstanceInvokeExpr) {
            return (Local)((InstanceInvokeExpr)ie).getBase();
        }
        int index = target.getArgIndex();
        if (index < ie.getArgCount() && (arg = ie.getArg(index)) instanceof Local) {
            return (Local)arg;
        }
        return null;
    }

    public Set<Local> getReceiversOfVirtualEdge(VirtualEdgesSummaries.InvocationVirtualEdgeTarget edgeTarget, InvokeExpr invokeExpr) {
        if (edgeTarget instanceof VirtualEdgesSummaries.IndirectTarget) {
            VirtualEdgesSummaries.IndirectTarget indirectTarget = (VirtualEdgesSummaries.IndirectTarget)edgeTarget;
            Local l = this.getLocalForTarget(invokeExpr, edgeTarget);
            if (l == null) {
                return Collections.emptySet();
            }
            List<VirtualCallSite> sites = this.receiverToSites.get(l);
            if (sites == null) {
                return Collections.emptySet();
            }
            HashSet<Local> results = new HashSet<Local>();
            MethodSubSignature methodName = edgeTarget.getTargetMethod();
            for (VirtualCallSite site : sites) {
                if (!methodName.equals(site.subSig())) continue;
                for (VirtualEdgesSummaries.VirtualEdgeTarget subTargets : indirectTarget.getTargets()) {
                    if (!(subTargets instanceof VirtualEdgesSummaries.InvocationVirtualEdgeTarget)) continue;
                    results.addAll(this.getReceiversOfVirtualEdge((VirtualEdgesSummaries.InvocationVirtualEdgeTarget)subTargets, site.iie()));
                }
            }
            return results;
        }
        assert (edgeTarget instanceof VirtualEdgesSummaries.DirectTarget);
        Local l = this.getLocalForTarget(invokeExpr, edgeTarget);
        return l == null ? Collections.emptySet() : Collections.singleton(l);
    }

    protected void processVirtualEdgeSummary(SootMethod callSiteMethod, Stmt callSite, Stmt curStmt, Local receiver, VirtualEdgesSummaries.InvocationVirtualEdgeTarget target, Kind edgeType) {
        InvokeExpr ie = curStmt.getInvokeExpr();
        Local targetLocal = this.getLocalForTarget(ie, target);
        if (targetLocal == null) {
            return;
        }
        if (target instanceof VirtualEdgesSummaries.DirectTarget) {
            VirtualEdgesSummaries.DirectTarget directTarget = (VirtualEdgesSummaries.DirectTarget)target;
            this.addVirtualCallSite(callSite, callSiteMethod, targetLocal, (InstanceInvokeExpr)ie, directTarget.targetMethod, edgeType);
        } else if (target instanceof VirtualEdgesSummaries.IndirectTarget) {
            VirtualEdgesSummaries.IndirectTarget w = (VirtualEdgesSummaries.IndirectTarget)target;
            List<VirtualCallSite> indirectSites = this.receiverToSites.get(targetLocal);
            if (indirectSites != null) {
                for (VirtualCallSite site : new ArrayList<VirtualCallSite>(indirectSites)) {
                    if (!w.getTargetMethod().equals(site.subSig())) continue;
                    for (VirtualEdgesSummaries.VirtualEdgeTarget siteTarget : w.getTargets()) {
                        Stmt siteStmt = site.getStmt();
                        if (!siteStmt.containsInvokeExpr() || !(siteTarget instanceof VirtualEdgesSummaries.InvocationVirtualEdgeTarget)) continue;
                        this.processVirtualEdgeSummary(callSiteMethod, callSite, siteStmt, receiver, (VirtualEdgesSummaries.InvocationVirtualEdgeTarget)siteTarget, edgeType);
                    }
                }
            }
        }
    }

    private void getImplicitTargets(SootMethod source) {
        SootClass scl = source.getDeclaringClass();
        if (!source.isConcrete()) {
            return;
        }
        if (source.isConstructor()) {
            this.handleInit(source, scl);
        }
        for (Unit u : source.retrieveActiveBody().getUnits()) {
            FieldRef fr;
            Object cl;
            Stmt s2 = (Stmt)u;
            if (s2.containsInvokeExpr()) {
                InvokeExpr ie = s2.getInvokeExpr();
                SootMethodRef methodRef = ie.getMethodRef();
                switch (methodRef.getDeclaringClass().getName()) {
                    case "java.lang.reflect.Method": {
                        if (!"java.lang.Object invoke(java.lang.Object,java.lang.Object[])".equals(methodRef.getSubSignature().getString())) break;
                        this.reflectionModel.methodInvoke(source, s2);
                        break;
                    }
                    case "java.lang.Class": {
                        if (!"java.lang.Object newInstance()".equals(methodRef.getSubSignature().getString())) break;
                        this.reflectionModel.classNewInstance(source, s2);
                        break;
                    }
                    case "java.lang.reflect.Constructor": {
                        if (!"java.lang.Object newInstance(java.lang.Object[])".equals(methodRef.getSubSignature().getString())) break;
                        this.reflectionModel.contructorNewInstance(source, s2);
                    }
                }
                if (methodRef.getSubSignature() == this.sigForName) {
                    this.reflectionModel.classForName(source, s2);
                }
                if (ie instanceof StaticInvokeExpr) {
                    cl = ie.getMethodRef().getDeclaringClass();
                    for (SootMethod clinit : EntryPoints.v().clinitsOf((SootClass)cl)) {
                        this.addEdge(source, s2, clinit, Kind.CLINIT);
                    }
                }
            }
            if (s2.containsFieldRef() && (fr = s2.getFieldRef()) instanceof StaticFieldRef) {
                SootClass cl2 = fr.getFieldRef().declaringClass();
                for (SootMethod clinit : EntryPoints.v().clinitsOf(cl2)) {
                    this.addEdge(source, s2, clinit, Kind.CLINIT);
                }
            }
            if (!(s2 instanceof AssignStmt)) continue;
            Value rhs = ((AssignStmt)s2).getRightOp();
            if (rhs instanceof NewExpr) {
                NewExpr r = (NewExpr)rhs;
                cl = r.getBaseType().getSootClass();
                for (SootMethod clinit : EntryPoints.v().clinitsOf((SootClass)cl)) {
                    this.addEdge(source, s2, clinit, Kind.CLINIT);
                }
                continue;
            }
            if (!(rhs instanceof NewArrayExpr) && !(rhs instanceof NewMultiArrayExpr)) continue;
            Type t2 = rhs.getType();
            if (t2 instanceof ArrayType) {
                t2 = ((ArrayType)t2).baseType;
            }
            if (!(t2 instanceof RefType)) continue;
            cl = ((RefType)t2).getSootClass();
            for (SootMethod clinit : EntryPoints.v().clinitsOf((SootClass)cl)) {
                this.addEdge(source, s2, clinit, Kind.CLINIT);
            }
        }
    }

    protected void processNewMethodContext(MethodOrMethodContext momc) {
        SootMethod m4 = momc.method();
        Iterator<Edge> it = this.cicg.edgesOutOf(m4);
        while (it.hasNext()) {
            Edge e = it.next();
            this.cm.addStaticEdge(momc, e.srcUnit(), e.tgt(), e.kind());
        }
    }

    private void handleInit(SootMethod source, SootClass scl) {
        this.addEdge(source, null, scl, this.sigFinalize, Kind.FINALIZE);
    }

    private void constantForName(String cls, SootMethod src, Stmt srcUnit) {
        int clsLen = cls.length();
        if (clsLen > 0 && cls.charAt(0) == '[') {
            if (clsLen > 2 && cls.charAt(1) == 'L' && cls.charAt(clsLen - 1) == ';') {
                this.constantForName(cls.substring(2, clsLen - 1), src, srcUnit);
            }
        } else {
            Scene sc = Scene.v();
            if (sc.containsClass(cls)) {
                SootClass sootcls = sc.getSootClass(cls);
                if (!sootcls.isPhantomClass()) {
                    if (!sootcls.isApplicationClass()) {
                        sootcls.setLibraryClass();
                    }
                    for (SootMethod clinit : EntryPoints.v().clinitsOf(sootcls)) {
                        this.addEdge(src, srcUnit, clinit, Kind.CLINIT);
                    }
                }
            } else if (this.options.verbose()) {
                logger.warn("Class " + cls + " is a dynamic class and was not specified as such; graph will be incomplete!");
            }
        }
    }

    private void addEdge(SootMethod src, Stmt stmt, SootMethod tgt, Kind kind) {
        if (src.equals(tgt) && src.isStaticInitializer()) {
            return;
        }
        this.cicg.addEdge(new Edge(src, stmt, tgt, kind));
    }

    private void addEdge(SootMethod src, Stmt stmt, SootClass cls, NumberedString methodSubSig, Kind kind) {
        SootMethod sm = cls.getMethodUnsafe(methodSubSig);
        if (sm != null) {
            this.addEdge(src, stmt, sm, kind);
        }
    }

    private void addEdge(SootMethod src, Stmt stmt, SootMethod tgt) {
        InvokeExpr ie = stmt.getInvokeExpr();
        this.addEdge(src, stmt, tgt, Edge.ieToKind(ie));
    }

    public VirtualEdgesSummaries getVirtualEdgeSummaries() {
        return this.virtualEdgeSummaries;
    }

    static {
        CharType cT = CharType.v();
        IntType iT = IntType.v();
        ShortType sT = ShortType.v();
        ByteType bT = ByteType.v();
        LongType lT = LongType.v();
        FloatType fT = FloatType.v();
        CHAR_NARROWINGS = new PrimType[]{cT};
        INT_NARROWINGS = new PrimType[]{iT, cT, sT, bT, sT};
        SHORT_NARROWINGS = new PrimType[]{sT, bT};
        LONG_NARROWINGS = new PrimType[]{lT, iT, cT, sT, bT, sT};
        BYTE_NARROWINGS = new ByteType[]{bT};
        FLOAT_NARROWINGS = new PrimType[]{fT, lT, iT, cT, sT, bT, sT};
        BOOLEAN_NARROWINGS = new PrimType[]{BooleanType.v()};
        DOUBLE_NARROWINGS = new PrimType[]{DoubleType.v(), fT, lT, iT, cT, sT, bT, sT};
    }

    private static abstract class AbstractMethodIterator
    implements Iterator<SootMethod> {
        private SootMethod next;
        private SootClass currClass;
        private Iterator<SootMethod> methodIterator;

        AbstractMethodIterator(SootClass baseClass) {
            this.currClass = baseClass;
            this.next = null;
            this.methodIterator = baseClass.methodIterator();
            this.findNextMethod();
        }

        protected void findNextMethod() {
            this.next = null;
            if (this.methodIterator != null) {
                while (true) {
                    if (this.methodIterator.hasNext()) {
                        SootMethod n = this.methodIterator.next();
                        if (!n.isPublic() || n.isStatic() || n.isConstructor() || n.isStaticInitializer() || !n.isConcrete() || !this.acceptMethod(n)) continue;
                        this.next = n;
                        return;
                    }
                    if (!this.currClass.hasSuperclass()) {
                        this.methodIterator = null;
                        return;
                    }
                    SootClass superclass = this.currClass.getSuperclass();
                    if (superclass.isPhantom() || Scene.v().getObjectType().toString().equals(superclass.getName())) {
                        this.methodIterator = null;
                        return;
                    }
                    this.methodIterator = superclass.methodIterator();
                    this.currClass = superclass;
                }
            }
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public SootMethod next() {
            SootMethod toRet = this.next;
            this.findNextMethod();
            return toRet;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        protected abstract boolean acceptMethod(SootMethod var1);
    }

    static final class Guard {
        final SootMethod container;
        final Stmt stmt;
        final String message;

        public Guard(SootMethod container2, Stmt stmt, String message) {
            this.container = container2;
            this.stmt = stmt;
            this.message = message;
        }
    }

    public class TraceBasedReflectionModel
    implements ReflectionModel {
        protected final Set<Guard> guards;
        protected final ReflectionTraceInfo reflectionInfo;

        private TraceBasedReflectionModel() {
            String logFile = OnFlyCallGraphBuilder.this.options.reflection_log();
            if (logFile == null) {
                throw new InternalError("Trace based refection model enabled but no trace file given!?");
            }
            this.reflectionInfo = new ReflectionTraceInfo(logFile);
            this.guards = new HashSet<Guard>();
        }

        @Override
        public void classForName(SootMethod container2, Stmt forNameInvokeStmt) {
            Set<String> classNames = this.reflectionInfo.classForNameClassNames(container2);
            if (classNames == null || classNames.isEmpty()) {
                this.registerGuard(container2, forNameInvokeStmt, "Class.forName() call site; Soot did not expect this site to be reached");
            } else {
                for (String clsName : classNames) {
                    OnFlyCallGraphBuilder.this.constantForName(clsName, container2, forNameInvokeStmt);
                }
            }
        }

        @Override
        public void classNewInstance(SootMethod container2, Stmt newInstanceInvokeStmt) {
            Set<String> classNames = this.reflectionInfo.classNewInstanceClassNames(container2);
            if (classNames == null || classNames.isEmpty()) {
                this.registerGuard(container2, newInstanceInvokeStmt, "Class.newInstance() call site; Soot did not expect this site to be reached");
            } else {
                Scene sc = Scene.v();
                for (String clsName : classNames) {
                    SootMethod constructor = sc.getSootClass(clsName).getMethodUnsafe(OnFlyCallGraphBuilder.this.sigInit);
                    if (constructor == null) continue;
                    OnFlyCallGraphBuilder.this.addEdge(container2, newInstanceInvokeStmt, constructor, Kind.REFL_CLASS_NEWINSTANCE);
                }
            }
        }

        @Override
        public void contructorNewInstance(SootMethod container2, Stmt newInstanceInvokeStmt) {
            Set<String> constructorSignatures = this.reflectionInfo.constructorNewInstanceSignatures(container2);
            if (constructorSignatures == null || constructorSignatures.isEmpty()) {
                this.registerGuard(container2, newInstanceInvokeStmt, "Constructor.newInstance(..) call site; Soot did not expect this site to be reached");
            } else {
                Scene sc = Scene.v();
                for (String constructorSignature : constructorSignatures) {
                    SootMethod constructor = sc.getMethod(constructorSignature);
                    OnFlyCallGraphBuilder.this.addEdge(container2, newInstanceInvokeStmt, constructor, Kind.REFL_CONSTR_NEWINSTANCE);
                }
            }
        }

        @Override
        public void methodInvoke(SootMethod container2, Stmt invokeStmt) {
            Set<String> methodSignatures = this.reflectionInfo.methodInvokeSignatures(container2);
            if (methodSignatures == null || methodSignatures.isEmpty()) {
                this.registerGuard(container2, invokeStmt, "Method.invoke(..) call site; Soot did not expect this site to be reached");
            } else {
                Scene sc = Scene.v();
                for (String methodSignature : methodSignatures) {
                    SootMethod method = sc.getMethod(methodSignature);
                    OnFlyCallGraphBuilder.this.addEdge(container2, invokeStmt, method, Kind.REFL_INVOKE);
                }
            }
        }

        private void registerGuard(SootMethod container2, Stmt stmt, String string) {
            this.guards.add(new Guard(container2, stmt, string));
            if (OnFlyCallGraphBuilder.this.options.verbose()) {
                logger.debug("Incomplete trace file: Class.forName() is called in method '" + container2 + "' but trace contains no information about the receiver class of this call.");
                switch (OnFlyCallGraphBuilder.this.options.guards()) {
                    case "ignore": {
                        logger.debug("Guarding strategy is set to 'ignore'. Will ignore this problem.");
                        break;
                    }
                    case "print": {
                        logger.debug("Guarding strategy is set to 'print'. Program will print a stack trace if this location is reached during execution.");
                        break;
                    }
                    case "throw": {
                        logger.debug("Guarding strategy is set to 'throw'. Program will throw an error if this location is reached during execution.");
                        break;
                    }
                    default: {
                        throw new RuntimeException("Invalid value for phase option (guarding): " + OnFlyCallGraphBuilder.this.options.guards());
                    }
                }
            }
            if (!registeredGuardsTransformation) {
                registeredGuardsTransformation = true;
                PackManager.v().getPack("wjap").add(new Transform("wjap.guards", new SceneTransformer(){

                    @Override
                    protected void internalTransform(String phaseName, Map<String, String> options) {
                        for (Guard g2 : TraceBasedReflectionModel.this.guards) {
                            TraceBasedReflectionModel.this.insertGuard(g2);
                        }
                    }
                }));
                PhaseOptions.v().setPhaseOption("wjap.guards", "enabled");
            }
        }

        private void insertGuard(Guard guard) {
            if ("ignore".equals(OnFlyCallGraphBuilder.this.options.guards())) {
                return;
            }
            SootMethod container2 = guard.container;
            if (!container2.hasActiveBody()) {
                logger.warn("Tried to insert guard into " + container2 + " but couldn't because method has no body.");
            } else {
                Jimple jimp = Jimple.v();
                Body body = container2.getActiveBody();
                UnitPatchingChain units = body.getUnits();
                LocalGenerator lg = Scene.v().createLocalGenerator(body);
                RefType runtimeExceptionType = RefType.v("java.lang.Error");
                Local exceptionLocal = lg.generateLocal(runtimeExceptionType);
                AssignStmt assignStmt = jimp.newAssignStmt(exceptionLocal, jimp.newNewExpr(runtimeExceptionType));
                units.insertBefore(assignStmt, guard.stmt);
                SootMethodRef cref = runtimeExceptionType.getSootClass().getMethod("<init>", Collections.singletonList(RefType.v("java.lang.String"))).makeRef();
                InvokeStmt initStmt = jimp.newInvokeStmt(jimp.newSpecialInvokeExpr(exceptionLocal, cref, (Value)StringConstant.v(guard.message)));
                units.insertAfter(initStmt, assignStmt);
                switch (OnFlyCallGraphBuilder.this.options.guards()) {
                    case "print": {
                        VirtualInvokeExpr printStackTraceExpr = jimp.newVirtualInvokeExpr(exceptionLocal, Scene.v().getSootClass(Scene.v().getBaseExceptionType().toString()).getMethod("printStackTrace", Collections.emptyList()).makeRef());
                        units.insertAfter(jimp.newInvokeStmt(printStackTraceExpr), initStmt);
                        break;
                    }
                    case "throw": {
                        units.insertAfter(jimp.newThrowStmt(exceptionLocal), initStmt);
                        break;
                    }
                    default: {
                        throw new RuntimeException("Invalid value for phase option (guarding): " + OnFlyCallGraphBuilder.this.options.guards());
                    }
                }
            }
        }
    }

    public class TypeBasedReflectionModel
    extends DefaultReflectionModel {
        @Override
        public void methodInvoke(SootMethod container2, Stmt invokeStmt) {
            if (container2.getDeclaringClass().isJavaLibraryClass()) {
                super.methodInvoke(container2, invokeStmt);
                return;
            }
            InstanceInvokeExpr d = (InstanceInvokeExpr)invokeStmt.getInvokeExpr();
            Value base = d.getArg(0);
            if (!(base instanceof Local)) {
                super.methodInvoke(container2, invokeStmt);
                return;
            }
            OnFlyCallGraphBuilder.this.addInvokeCallSite(invokeStmt, container2, d);
        }
    }

    public class DefaultReflectionModel
    implements ReflectionModel {
        protected final CGOptions options = new CGOptions(PhaseOptions.v().getPhaseOptions("cg"));
        protected final HashSet<SootMethod> warnedAlready = new HashSet();

        @Override
        public void classForName(SootMethod source, Stmt s2) {
            Value className;
            List<Local> stringConstants = OnFlyCallGraphBuilder.this.methodToStringConstants.get(source);
            if (stringConstants == null) {
                stringConstants = new ArrayList<Local>();
                OnFlyCallGraphBuilder.this.methodToStringConstants.put(source, stringConstants);
            }
            if ((className = s2.getInvokeExpr().getArg(0)) instanceof StringConstant) {
                String cls = ((StringConstant)className).value;
                OnFlyCallGraphBuilder.this.constantForName(cls, source, s2);
            } else if (className instanceof Local) {
                Local constant = (Local)className;
                if (this.options.safe_forname()) {
                    for (SootMethod tgt : EntryPoints.v().clinits()) {
                        OnFlyCallGraphBuilder.this.addEdge(source, s2, tgt, Kind.CLINIT);
                    }
                } else {
                    EntryPoints ep = EntryPoints.v();
                    for (SootClass cls : Scene.v().dynamicClasses()) {
                        for (SootMethod clinit : ep.clinitsOf(cls)) {
                            OnFlyCallGraphBuilder.this.addEdge(source, s2, clinit, Kind.CLINIT);
                        }
                    }
                    VirtualCallSite site = new VirtualCallSite(s2, source, null, null, Kind.CLINIT);
                    List<VirtualCallSite> sites = OnFlyCallGraphBuilder.this.stringConstToSites.get(constant);
                    if (sites == null) {
                        sites = new ArrayList<VirtualCallSite>();
                        OnFlyCallGraphBuilder.this.stringConstToSites.put(constant, sites);
                        stringConstants.add(constant);
                    }
                    sites.add(site);
                }
            }
        }

        @Override
        public void classNewInstance(SootMethod source, Stmt s2) {
            if (this.options.safe_newinstance()) {
                for (SootMethod tgt : EntryPoints.v().inits()) {
                    OnFlyCallGraphBuilder.this.addEdge(source, s2, tgt, Kind.NEWINSTANCE);
                }
            } else {
                for (SootClass cls : Scene.v().dynamicClasses()) {
                    SootMethod sm = cls.getMethodUnsafe(OnFlyCallGraphBuilder.this.sigInit);
                    if (sm == null) continue;
                    OnFlyCallGraphBuilder.this.addEdge(source, s2, sm, Kind.NEWINSTANCE);
                }
                if (this.options.verbose()) {
                    logger.warn("Method " + source + " is reachable, and calls Class.newInstance; graph will be incomplete! Use safe-newinstance option for a conservative result.");
                }
            }
        }

        @Override
        public void contructorNewInstance(SootMethod source, Stmt s2) {
            if (this.options.safe_newinstance()) {
                for (SootMethod tgt : EntryPoints.v().allInits()) {
                    OnFlyCallGraphBuilder.this.addEdge(source, s2, tgt, Kind.NEWINSTANCE);
                }
            } else {
                for (SootClass cls : Scene.v().dynamicClasses()) {
                    for (SootMethod m4 : cls.getMethods()) {
                        if (!"<init>".equals(m4.getName())) continue;
                        OnFlyCallGraphBuilder.this.addEdge(source, s2, m4, Kind.NEWINSTANCE);
                    }
                }
                if (this.options.verbose()) {
                    logger.warn("Method " + source + " is reachable, and calls Constructor.newInstance; graph will be incomplete! Use safe-newinstance option for a conservative result.");
                }
            }
        }

        @Override
        public void methodInvoke(SootMethod container2, Stmt invokeStmt) {
            if (!this.warnedAlready(container2)) {
                if (this.options.verbose()) {
                    logger.warn("Call to java.lang.reflect.Method: invoke() from " + container2 + "; graph will be incomplete!");
                }
                this.markWarned(container2);
            }
        }

        private void markWarned(SootMethod m4) {
            this.warnedAlready.add(m4);
        }

        private boolean warnedAlready(SootMethod m4) {
            return this.warnedAlready.contains(m4);
        }
    }
}

