/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.toolkits.base;

import java.util.HashMap;
import java.util.Map;
import soot.Body;
import soot.BodyTransformer;
import soot.Local;
import soot.SootMethod;
import soot.Trap;
import soot.Unit;
import soot.UnitPatchingChain;
import soot.Value;
import soot.ValueBox;
import soot.jimple.AssignStmt;
import soot.jimple.CaughtExceptionRef;
import soot.jimple.GotoStmt;
import soot.jimple.IdentityStmt;
import soot.jimple.InvokeStmt;
import soot.jimple.Jimple;
import soot.jimple.JimpleBody;
import soot.jimple.ParameterRef;
import soot.jimple.ReturnVoidStmt;
import soot.jimple.SpecialInvokeExpr;
import soot.jimple.Stmt;
import soot.jimple.ThisRef;
import soot.jimple.toolkits.scalar.LocalNameStandardizer;
import soot.shimple.ShimpleBody;

public class ThisInliner
extends BodyTransformer {
    private static final boolean DEBUG = false;

    @Override
    public void internalTransform(Body b, String phaseName, Map<String, String> options) {
        assert (b instanceof JimpleBody || b instanceof ShimpleBody);
        if (!"<init>".equals(b.getMethod().getName())) {
            return;
        }
        InvokeStmt invokeStmt = this.getFirstSpecialInvoke(b);
        if (invokeStmt == null) {
            return;
        }
        SpecialInvokeExpr specInvokeExpr = (SpecialInvokeExpr)invokeStmt.getInvokeExpr();
        SootMethod specInvokeMethod = specInvokeExpr.getMethod();
        if (specInvokeMethod.getDeclaringClass().equals(b.getMethod().getDeclaringClass())) {
            Stmt inlineeStmt;
            Body specInvokeBody = specInvokeMethod.retrieveActiveBody();
            assert (b.getClass() == specInvokeBody.getClass());
            HashMap<Local, Local> oldLocalsToNew = new HashMap<Local, Local>();
            for (Local l : specInvokeBody.getLocals()) {
                Local newLocal = (Local)l.clone();
                b.getLocals().add(newLocal);
                oldLocalsToNew.put(l, newLocal);
            }
            Value origIdStmtLHS = this.findIdentityStmt(b).getLeftOp();
            HashMap<Stmt, Stmt> oldStmtsToNew = new HashMap<Stmt, Stmt>();
            UnitPatchingChain containerUnits = b.getUnits();
            for (Unit u : specInvokeBody.getUnits()) {
                inlineeStmt = (Stmt)u;
                if (inlineeStmt instanceof IdentityStmt) {
                    IdentityStmt idStmt = (IdentityStmt)inlineeStmt;
                    Value rightOp = idStmt.getRightOp();
                    if (rightOp instanceof ThisRef) {
                        AssignStmt newThis = Jimple.v().newAssignStmt((Value)oldLocalsToNew.get((Local)idStmt.getLeftOp()), origIdStmtLHS);
                        containerUnits.insertBefore(newThis, invokeStmt);
                        oldStmtsToNew.put(inlineeStmt, newThis);
                        continue;
                    }
                    if (rightOp instanceof CaughtExceptionRef) {
                        Stmt newInlinee = (Stmt)inlineeStmt.clone();
                        for (ValueBox vb : newInlinee.getUseAndDefBoxes()) {
                            Value val = vb.getValue();
                            if (!(val instanceof Local)) continue;
                            vb.setValue((Value)oldLocalsToNew.get((Local)val));
                        }
                        containerUnits.insertBefore(newInlinee, invokeStmt);
                        oldStmtsToNew.put(inlineeStmt, newInlinee);
                        continue;
                    }
                    if (!(rightOp instanceof ParameterRef)) continue;
                    AssignStmt newParam = Jimple.v().newAssignStmt((Value)oldLocalsToNew.get((Local)idStmt.getLeftOp()), specInvokeExpr.getArg(((ParameterRef)rightOp).getIndex()));
                    containerUnits.insertBefore(newParam, invokeStmt);
                    oldStmtsToNew.put(inlineeStmt, newParam);
                    continue;
                }
                if (inlineeStmt instanceof ReturnVoidStmt) {
                    GotoStmt newRet = Jimple.v().newGotoStmt(containerUnits.getSuccOf(invokeStmt));
                    containerUnits.insertBefore(newRet, invokeStmt);
                    oldStmtsToNew.put(inlineeStmt, newRet);
                    continue;
                }
                Stmt newInlinee = (Stmt)inlineeStmt.clone();
                for (ValueBox vb : newInlinee.getUseAndDefBoxes()) {
                    Value val = vb.getValue();
                    if (!(val instanceof Local)) continue;
                    vb.setValue((Value)oldLocalsToNew.get((Local)val));
                }
                containerUnits.insertBefore(newInlinee, invokeStmt);
                oldStmtsToNew.put(inlineeStmt, newInlinee);
            }
            for (Trap t2 : specInvokeBody.getTraps()) {
                Unit newBegin = (Unit)oldStmtsToNew.get(t2.getBeginUnit());
                Unit newEnd = (Unit)oldStmtsToNew.get(t2.getEndUnit());
                Unit newHandler = (Unit)oldStmtsToNew.get(t2.getHandlerUnit());
                if (newBegin == null || newEnd == null || newHandler == null) {
                    throw new RuntimeException("couldn't map trap!");
                }
                b.getTraps().add(Jimple.v().newTrap(t2.getException(), newBegin, newEnd, newHandler));
            }
            for (Unit u : specInvokeBody.getUnits()) {
                if (!(u instanceof GotoStmt)) continue;
                inlineeStmt = (GotoStmt)u;
                ((GotoStmt)oldStmtsToNew.get(inlineeStmt)).setTarget((Unit)oldStmtsToNew.get(inlineeStmt.getTarget()));
            }
            containerUnits.remove(invokeStmt);
            LocalNameStandardizer.v().transform(b, "ji.lns");
        }
    }

    private InvokeStmt getFirstSpecialInvoke(Body b) {
        for (Unit u : b.getUnits()) {
            InvokeStmt s2;
            if (!(u instanceof InvokeStmt) || !((s2 = (InvokeStmt)u).getInvokeExpr() instanceof SpecialInvokeExpr)) continue;
            return s2;
        }
        return null;
    }

    private IdentityStmt findIdentityStmt(Body b) {
        for (Unit u : b.getUnits()) {
            IdentityStmt s2;
            if (!(u instanceof IdentityStmt) || !((s2 = (IdentityStmt)u).getRightOp() instanceof ThisRef)) continue;
            return s2;
        }
        return null;
    }
}

