/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.toolkits.base;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.Body;
import soot.BodyTransformer;
import soot.Local;
import soot.Type;
import soot.Unit;
import soot.UnitPatchingChain;
import soot.Value;
import soot.jimple.AssignStmt;
import soot.jimple.InvokeExpr;
import soot.jimple.InvokeStmt;
import soot.jimple.Jimple;
import soot.jimple.JimpleBody;
import soot.jimple.NewExpr;
import soot.jimple.SpecialInvokeExpr;
import soot.options.Options;
import soot.toolkits.scalar.LocalUses;
import soot.toolkits.scalar.UnitValueBoxPair;

public class PartialConstructorFolder
extends BodyTransformer {
    private static final Logger logger = LoggerFactory.getLogger(PartialConstructorFolder.class);
    private List<Type> types;

    public void setTypes(List<Type> t2) {
        this.types = t2;
    }

    public List<Type> getTypes() {
        return this.types;
    }

    @Override
    public void internalTransform(Body b, String phaseName, Map<String, String> options) {
        JimpleBody body = (JimpleBody)b;
        if (Options.v().verbose()) {
            logger.debug("[" + body.getMethod().getName() + "] Folding Jimple constructors...");
        }
        UnitPatchingChain units = body.getUnits();
        ArrayList<Unit> stmtList = new ArrayList<Unit>(units);
        LocalUses localUses = LocalUses.Factory.newLocalUses(body);
        Iterator nextStmtIt = stmtList.iterator();
        nextStmtIt.next();
        for (Unit u : stmtList) {
            SpecialInvokeExpr invokeExpr;
            InvokeExpr ie;
            Unit next;
            Value rhs;
            AssignStmt as;
            Value lhs;
            if (!(u instanceof AssignStmt) || !((lhs = (as = (AssignStmt)u).getLeftOp()) instanceof Local) || !((rhs = as.getRightOp()) instanceof NewExpr)) continue;
            if (nextStmtIt.hasNext() && (next = (Unit)nextStmtIt.next()) instanceof InvokeStmt && (ie = ((InvokeStmt)next).getInvokeExpr()) instanceof SpecialInvokeExpr && (invokeExpr = (SpecialInvokeExpr)ie).getBase() == lhs) break;
            if (!this.types.contains(((NewExpr)rhs).getType())) continue;
            boolean madeNewInvokeExpr = false;
            for (UnitValueBoxPair uvb : localUses.getUsesOf(u)) {
                InvokeExpr ie2;
                Unit use = uvb.unit;
                if (!(use instanceof InvokeStmt) || !((ie2 = ((InvokeStmt)use).getInvokeExpr()) instanceof SpecialInvokeExpr) || lhs != ((SpecialInvokeExpr)ie2).getBase()) continue;
                AssignStmt constructStmt = Jimple.v().newAssignStmt(lhs, rhs);
                constructStmt.setRightOp(Jimple.v().newNewExpr(((NewExpr)rhs).getBaseType()));
                madeNewInvokeExpr = true;
                use.redirectJumpsToThisTo(constructStmt);
                units.insertBefore(constructStmt, use);
                constructStmt.addTag(u.getTag("SourceLnPosTag"));
            }
            if (!madeNewInvokeExpr) continue;
            units.remove(u);
        }
    }
}

