/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.toolkits.base;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.Body;
import soot.BodyTransformer;
import soot.Local;
import soot.Unit;
import soot.UnitPatchingChain;
import soot.Value;
import soot.ValueBox;
import soot.jimple.AssignStmt;
import soot.jimple.InstanceInvokeExpr;
import soot.jimple.InvokeExpr;
import soot.jimple.InvokeStmt;
import soot.jimple.Jimple;
import soot.jimple.JimpleBody;
import soot.jimple.NewExpr;
import soot.jimple.SpecialInvokeExpr;
import soot.jimple.Stmt;
import soot.options.Options;
import soot.toolkits.graph.BriefUnitGraph;
import soot.toolkits.graph.DirectedGraph;
import soot.toolkits.scalar.ForwardFlowAnalysis;
import soot.util.HashMultiMap;
import soot.util.MultiMap;

public class JimpleConstructorFolder
extends BodyTransformer {
    private static final Logger logger = LoggerFactory.getLogger(JimpleConstructorFolder.class);
    private static final boolean DEBUG_DUMP_BODIES = false;

    static Value rhs(Stmt s2) {
        return ((AssignStmt)s2).getRightOp();
    }

    static Value lhs(Stmt s2) {
        return ((AssignStmt)s2).getLeftOp();
    }

    static Local rhsLocal(Stmt s2) {
        return (Local)JimpleConstructorFolder.rhs(s2);
    }

    static Local lhsLocal(Stmt s2) {
        return (Local)JimpleConstructorFolder.lhs(s2);
    }

    static boolean isNew(Stmt s2) {
        return s2 instanceof AssignStmt && JimpleConstructorFolder.rhs(s2) instanceof NewExpr;
    }

    static boolean isConstructor(Stmt s2) {
        InvokeExpr expr;
        if (s2 instanceof InvokeStmt && (expr = ((InvokeStmt)s2).getInvokeExpr()) instanceof SpecialInvokeExpr) {
            SpecialInvokeExpr sie = (SpecialInvokeExpr)expr;
            return "<init>".equals(sie.getMethodRef().getName());
        }
        return false;
    }

    static Local base(Stmt s2) {
        InvokeStmt is = (InvokeStmt)s2;
        InstanceInvokeExpr expr = (InstanceInvokeExpr)is.getInvokeExpr();
        return (Local)expr.getBase();
    }

    static void setBase(Stmt s2, Local l) {
        InvokeStmt is = (InvokeStmt)s2;
        InstanceInvokeExpr expr = (InstanceInvokeExpr)is.getInvokeExpr();
        expr.getBaseBox().setValue(l);
    }

    static boolean isCopy(Stmt s2) {
        return s2 instanceof AssignStmt && JimpleConstructorFolder.rhs(s2) instanceof Local && JimpleConstructorFolder.lhs(s2) instanceof Local;
    }

    @Override
    public void internalTransform(Body b, String phaseName, Map<String, String> options) {
        Fact before;
        Stmt s2;
        JimpleBody body = (JimpleBody)b;
        if (Options.v().verbose()) {
            logger.debug("[" + body.getMethod().getName() + "] Folding Jimple constructors...");
        }
        Analysis analysis = new Analysis(new BriefUnitGraph(body));
        UnitPatchingChain units = body.getUnits();
        for (Unit u : units) {
            s2 = (Stmt)u;
            if (JimpleConstructorFolder.isCopy(s2) || JimpleConstructorFolder.isConstructor(s2)) continue;
            before = (Fact)analysis.getFlowBefore(s2);
            for (ValueBox usebox : s2.getUseBoxes()) {
                Value value = usebox.getValue();
                if (!(value instanceof Local) || before.get((Local)value) == null) continue;
                throw new RuntimeException("Use of an unitialized value before constructor call; are you sure this bytecode is verifiable?\n " + s2);
            }
        }
        Iterator it = units.snapshotIterator();
        while (it.hasNext()) {
            Stmt s3 = (Stmt)it.next();
            if (!JimpleConstructorFolder.isNew(s3)) continue;
            units.remove(s3);
        }
        Jimple jimp = Jimple.v();
        Iterator it2 = units.snapshotIterator();
        while (it2.hasNext()) {
            s2 = (Stmt)it2.next();
            if (JimpleConstructorFolder.isCopy(s2)) {
                before = (Fact)analysis.getFlowBefore(s2);
                if (before.get(JimpleConstructorFolder.rhsLocal(s2)) == null) continue;
                units.remove(s2);
                continue;
            }
            if (((Fact)analysis.getFlowAfter(s2)).alloc() == null) continue;
            before = (Fact)analysis.getFlowBefore(s2);
            Local baseS = JimpleConstructorFolder.base(s2);
            Stmt newStmt = before.get(baseS);
            JimpleConstructorFolder.setBase(s2, JimpleConstructorFolder.lhsLocal(newStmt));
            units.insertBefore(newStmt, s2);
            for (Local l : before.get(newStmt)) {
                if (baseS.equals(l)) continue;
                units.insertAfter(jimp.newAssignStmt(l, baseS), s2);
            }
        }
    }

    private class Analysis
    extends ForwardFlowAnalysis<Unit, Fact> {
        public Analysis(DirectedGraph<Unit> graph) {
            super(graph);
            this.doAnalysis();
        }

        @Override
        protected Fact newInitialFlow() {
            return new Fact();
        }

        @Override
        public void flowThrough(Fact in, Unit u, Fact out) {
            Stmt newStmt;
            Stmt s2 = (Stmt)u;
            this.copy(in, out);
            out.setAlloc(null);
            if (JimpleConstructorFolder.isNew(s2)) {
                out.add(JimpleConstructorFolder.lhsLocal(s2), s2);
            } else if (JimpleConstructorFolder.isCopy(s2)) {
                Stmt newStmt2 = out.get(JimpleConstructorFolder.rhsLocal(s2));
                if (newStmt2 != null) {
                    out.add(JimpleConstructorFolder.lhsLocal(s2), newStmt2);
                }
            } else if (JimpleConstructorFolder.isConstructor(s2) && (newStmt = out.get(JimpleConstructorFolder.base(s2))) != null) {
                out.removeAll(newStmt);
                out.setAlloc(newStmt);
            }
        }

        @Override
        public void copy(Fact source, Fact dest) {
            dest.copyFrom(source);
        }

        @Override
        public void merge(Fact in1, Fact in2, Fact out) {
            out.mergeFrom(in1, in2);
        }
    }

    private static class Fact {
        private Map<Local, Stmt> varToStmt = new HashMap<Local, Stmt>();
        private MultiMap<Stmt, Local> stmtToVar = new HashMultiMap<Stmt, Local>();
        private Stmt alloc = null;

        private Fact() {
        }

        public void add(Local l, Stmt s2) {
            this.varToStmt.put(l, s2);
            this.stmtToVar.put(s2, l);
        }

        public Stmt get(Local l) {
            return this.varToStmt.get(l);
        }

        public Set<Local> get(Stmt s2) {
            return this.stmtToVar.get(s2);
        }

        public void removeAll(Stmt s2) {
            for (Local var : this.stmtToVar.get(s2)) {
                this.varToStmt.remove(var);
            }
            this.stmtToVar.remove(s2);
        }

        public Stmt alloc() {
            return this.alloc;
        }

        public void setAlloc(Stmt newAlloc) {
            this.alloc = newAlloc;
        }

        public void copyFrom(Fact in) {
            this.varToStmt = new HashMap<Local, Stmt>(in.varToStmt);
            this.stmtToVar = new HashMultiMap<Stmt, Local>(in.stmtToVar);
            this.alloc = in.alloc;
        }

        public void mergeFrom(Fact in1, Fact in2) {
            this.varToStmt = new HashMap<Local, Stmt>();
            for (Map.Entry<Local, Stmt> e : in1.varToStmt.entrySet()) {
                Local l = e.getKey();
                Stmt newStmt = e.getValue();
                if (in2.varToStmt.containsKey(l) && !newStmt.equals(in2.varToStmt.get(l))) {
                    throw new RuntimeException("Merge of different uninitialized values; are you sure this bytecode is verifiable?");
                }
                this.add(l, newStmt);
            }
            for (Map.Entry<Local, Stmt> e : in2.varToStmt.entrySet()) {
                this.add(e.getKey(), e.getValue());
            }
            Stmt alloc1 = in1.alloc;
            this.alloc = alloc1 != null && alloc1.equals(in2.alloc) ? alloc1 : null;
        }

        public boolean equals(Object other) {
            if (!(other instanceof Fact)) {
                return false;
            }
            Fact o = (Fact)other;
            if (this.alloc == null && o.alloc != null || this.alloc != null && o.alloc == null) {
                return false;
            }
            return (this.alloc == null || this.alloc.equals(o.alloc)) && this.stmtToVar.equals(o.stmtToVar);
        }

        public int hashCode() {
            int hash = 7;
            hash = 89 * hash + Objects.hashCode(this.stmtToVar);
            hash = 89 * hash + Objects.hashCode(this.alloc);
            return hash;
        }
    }
}

