/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.toolkits.base;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.Body;
import soot.BodyTransformer;
import soot.G;
import soot.Local;
import soot.PhaseOptions;
import soot.Singletons;
import soot.Timers;
import soot.Unit;
import soot.UnitPatchingChain;
import soot.Value;
import soot.ValueBox;
import soot.jimple.ArrayRef;
import soot.jimple.AssignStmt;
import soot.jimple.DefinitionStmt;
import soot.jimple.FieldRef;
import soot.jimple.InvokeExpr;
import soot.jimple.MonitorStmt;
import soot.jimple.Stmt;
import soot.jimple.StmtBody;
import soot.jimple.toolkits.base.Zonation;
import soot.jimple.toolkits.base.Zone;
import soot.options.Options;
import soot.toolkits.graph.ExceptionalUnitGraph;
import soot.toolkits.graph.ExceptionalUnitGraphFactory;
import soot.toolkits.graph.PseudoTopologicalOrderer;
import soot.toolkits.scalar.LocalDefs;
import soot.toolkits.scalar.LocalUses;
import soot.toolkits.scalar.UnitValueBoxPair;

public class Aggregator
extends BodyTransformer {
    private static final Logger logger = LoggerFactory.getLogger(Aggregator.class);

    public Aggregator(Singletons.Global g2) {
    }

    public static Aggregator v() {
        return G.v().soot_jimple_toolkits_base_Aggregator();
    }

    @Override
    protected void internalTransform(Body b, String phaseName, Map<String, String> options) {
        int aggregateCount;
        StmtBody body = (StmtBody)b;
        boolean time = Options.v().time();
        if (time) {
            Timers.v().aggregationTimer.start();
        }
        HashMap<ValueBox, Zone> boxToZone = new HashMap<ValueBox, Zone>(body.getUnits().size() * 2 + 1, 0.7f);
        Zonation zonation = new Zonation(body);
        for (Unit u : body.getUnits()) {
            Zone zone = zonation.getZoneOf(u);
            for (ValueBox box : u.getUseAndDefBoxes()) {
                boxToZone.put(box, zone);
            }
        }
        boolean onlyStackVars = PhaseOptions.getBoolean(options, "only-stack-locals");
        int n = aggregateCount = Options.v().verbose() ? 1 : 0;
        do {
            if (aggregateCount == 0) continue;
            logger.debug("[" + body.getMethod().getName() + "] Aggregating iteration " + aggregateCount + "...");
            ++aggregateCount;
        } while (Aggregator.internalAggregate(body, boxToZone, onlyStackVars));
        if (time) {
            Timers.v().aggregationTimer.end();
        }
    }

    private static boolean internalAggregate(StmtBody body, Map<ValueBox, Zone> boxToZone, boolean onlyStackVars) {
        boolean hadAggregation = false;
        UnitPatchingChain units = body.getUnits();
        ExceptionalUnitGraph graph = ExceptionalUnitGraphFactory.createExceptionalUnitGraph(body);
        LocalDefs localDefs = G.v().soot_toolkits_scalar_LocalDefsFactory().newLocalDefs(graph);
        LocalUses localUses = LocalUses.Factory.newLocalUses(body, localDefs);
        block0: for (Unit u : new PseudoTopologicalOrderer<Unit>().newList(graph, false)) {
            List<Unit> path;
            List<UnitValueBoxPair> lu;
            AssignStmt s2;
            Value lhs;
            if (!(u instanceof AssignStmt) || !((lhs = (s2 = (AssignStmt)u).getLeftOp()) instanceof Local)) continue;
            Local lhsLocal = (Local)lhs;
            if (onlyStackVars && !lhsLocal.isStackLocal() || (lu = localUses.getUsesOf(s2)).size() != 1) continue;
            UnitValueBoxPair usepair = lu.get(0);
            Unit usepairUnit = usepair.unit;
            ValueBox usepairValueBox = usepair.valueBox;
            if (localDefs.getDefsOfAt(lhsLocal, usepairUnit).size() != 1 || boxToZone.get(s2.getRightOpBox()) != boxToZone.get(usepairValueBox) || (path = graph.getExtendedBasicBlockPathBetween(s2, usepairUnit)) == null) continue;
            boolean propagatingInvokeExpr = false;
            boolean propagatingFieldRef = false;
            boolean propagatingArrayRef = false;
            ArrayList<FieldRef> fieldRefList = new ArrayList<FieldRef>();
            HashSet<Value> localsUsed = new HashSet<Value>();
            for (ValueBox vb : s2.getUseBoxes()) {
                Value v = vb.getValue();
                if (v instanceof Local) {
                    localsUsed.add(v);
                    continue;
                }
                if (v instanceof InvokeExpr) {
                    propagatingInvokeExpr = true;
                    continue;
                }
                if (v instanceof ArrayRef) {
                    propagatingArrayRef = true;
                    continue;
                }
                if (!(v instanceof FieldRef)) continue;
                propagatingFieldRef = true;
                fieldRefList.add((FieldRef)v);
            }
            Iterator<Unit> pathIt = path.iterator();
            assert (pathIt.hasNext());
            pathIt.next();
            block2: while (pathIt.hasNext()) {
                Value v;
                Stmt between = (Stmt)pathIt.next();
                if (between != usepairUnit) {
                    if (propagatingInvokeExpr && between instanceof MonitorStmt) continue block0;
                    for (ValueBox vb : between.getDefBoxes()) {
                        v = vb.getValue();
                        if (localsUsed.contains(v)) continue block0;
                        if (v instanceof FieldRef) {
                            if (propagatingInvokeExpr) continue block0;
                            if (!propagatingFieldRef) continue;
                            for (FieldRef fieldRef : fieldRefList) {
                                if (!Aggregator.isSameField((FieldRef)v, fieldRef)) continue;
                                continue block0;
                            }
                            continue;
                        }
                        if (!(v instanceof ArrayRef) || !propagatingInvokeExpr && !propagatingArrayRef) continue;
                        continue block0;
                    }
                }
                if (!propagatingInvokeExpr && !propagatingFieldRef && !propagatingArrayRef) continue;
                for (ValueBox box : between.getUseBoxes()) {
                    if (between == usepairUnit && box == usepairValueBox) continue block2;
                    v = box.getValue();
                    if (!(v instanceof InvokeExpr) && (!propagatingInvokeExpr || !(v instanceof FieldRef) && !(v instanceof ArrayRef))) continue;
                    continue block0;
                }
            }
            Value aggregatee = s2.getRightOp();
            if (!usepairValueBox.canContainValue(aggregatee)) continue;
            boolean wasSimpleCopy = Aggregator.isSimpleCopy(usepairUnit);
            usepairValueBox.setValue(aggregatee);
            units.remove(s2);
            if (wasSimpleCopy) {
                usepairUnit.addAllTagsOf(s2);
            }
            hadAggregation = true;
        }
        return hadAggregation;
    }

    private static boolean isSameField(FieldRef ref1, FieldRef ref2) {
        return ref1 == ref2 || ref1.getFieldRef().equals(ref2.getFieldRef());
    }

    private static boolean isSimpleCopy(Unit u) {
        if (!(u instanceof DefinitionStmt)) {
            return false;
        }
        DefinitionStmt defstmt = (DefinitionStmt)u;
        return defstmt.getRightOp() instanceof Local && defstmt.getLeftOp() instanceof Local;
    }
}

