/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.toolkits.annotation.tags;

import soot.jimple.toolkits.annotation.tags.OneByteCodeTag;

public class ArrayCheckTag
implements OneByteCodeTag {
    public static final String NAME = "ArrayCheckTag";
    private final boolean lowerCheck;
    private final boolean upperCheck;

    public ArrayCheckTag(boolean lower, boolean upper) {
        this.lowerCheck = lower;
        this.upperCheck = upper;
    }

    @Override
    public byte[] getValue() {
        byte b = 0;
        if (this.lowerCheck) {
            b = (byte)(b | 1);
        }
        if (this.upperCheck) {
            b = (byte)(b | 2);
        }
        return new byte[]{b};
    }

    public boolean isCheckUpper() {
        return this.upperCheck;
    }

    public boolean isCheckLower() {
        return this.lowerCheck;
    }

    @Override
    public String getName() {
        return NAME;
    }

    public String toString() {
        return (this.lowerCheck ? "[potentially unsafe lower bound]" : "[safe lower bound]") + (this.upperCheck ? "[potentially unsafe upper bound]" : "[safe upper bound]");
    }
}

