/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.toolkits.annotation.purity;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.Local;
import soot.RefLikeType;
import soot.SootMethod;
import soot.Type;
import soot.Value;
import soot.jimple.Stmt;
import soot.jimple.toolkits.annotation.purity.PurityEdge;
import soot.jimple.toolkits.annotation.purity.PurityGlobalNode;
import soot.jimple.toolkits.annotation.purity.PurityMethodNode;
import soot.jimple.toolkits.annotation.purity.PurityNode;
import soot.jimple.toolkits.annotation.purity.PurityParamNode;
import soot.jimple.toolkits.annotation.purity.PurityStmtNode;
import soot.jimple.toolkits.annotation.purity.PurityThisNode;
import soot.util.HashMultiMap;
import soot.util.MultiMap;
import soot.util.dot.DotGraph;
import soot.util.dot.DotGraphEdge;
import soot.util.dot.DotGraphNode;

public class PurityGraph {
    private static final Logger logger = LoggerFactory.getLogger(PurityGraph.class);
    public static final boolean doCheck = false;
    private static final Map<PurityNode, PurityNode> nodeCache = new HashMap<PurityNode, PurityNode>();
    private static final Map<PurityEdge, PurityEdge> edgeCache = new HashMap<PurityEdge, PurityEdge>();
    static final int PARAM_RW = 0;
    static final int PARAM_RO = 1;
    static final int PARAM_SAFE = 2;
    private static int maxInsideNodes = 0;
    private static int maxLoadNodes = 0;
    private static int maxInsideEdges = 0;
    private static int maxOutsideEdges = 0;
    private static int maxMutated = 0;
    protected Set<PurityNode> nodes;
    protected Set<PurityNode> paramNodes;
    protected MultiMap<PurityNode, PurityEdge> edges;
    protected MultiMap<Local, PurityNode> locals;
    protected Set<PurityNode> ret;
    protected Set<PurityNode> globEscape;
    protected MultiMap<PurityNode, PurityEdge> backEdges;
    protected MultiMap<PurityNode, Local> backLocals;
    protected MultiMap<PurityNode, String> mutated;

    PurityGraph() {
        this.nodes = new HashSet<PurityNode>();
        this.paramNodes = new HashSet<PurityNode>();
        this.edges = new HashMultiMap<PurityNode, PurityEdge>();
        this.locals = new HashMultiMap<Local, PurityNode>();
        this.ret = new HashSet<PurityNode>();
        this.globEscape = new HashSet<PurityNode>();
        this.backEdges = new HashMultiMap<PurityNode, PurityEdge>();
        this.backLocals = new HashMultiMap<PurityNode, Local>();
        this.mutated = new HashMultiMap<PurityNode, String>();
    }

    PurityGraph(PurityGraph x) {
        this.nodes = new HashSet<PurityNode>(x.nodes);
        this.paramNodes = new HashSet<PurityNode>(x.paramNodes);
        this.edges = new HashMultiMap<PurityNode, PurityEdge>(x.edges);
        this.locals = new HashMultiMap<Local, PurityNode>(x.locals);
        this.ret = new HashSet<PurityNode>(x.ret);
        this.globEscape = new HashSet<PurityNode>(x.globEscape);
        this.backEdges = new HashMultiMap<PurityNode, PurityEdge>(x.backEdges);
        this.backLocals = new HashMultiMap<PurityNode, Local>(x.backLocals);
        this.mutated = new HashMultiMap<PurityNode, String>(x.mutated);
    }

    public int hashCode() {
        return this.nodes.hashCode() + this.edges.hashCode() + this.locals.hashCode() + this.ret.hashCode() + this.globEscape.hashCode() + this.mutated.hashCode();
    }

    public boolean equals(Object o) {
        if (!(o instanceof PurityGraph)) {
            return false;
        }
        PurityGraph g2 = (PurityGraph)o;
        return this.nodes.equals(g2.nodes) && this.edges.equals(g2.edges) && this.locals.equals(g2.locals) && this.ret.equals(g2.ret) && this.globEscape.equals(g2.globEscape) && this.mutated.equals(g2.mutated);
    }

    private static PurityNode cacheNode(PurityNode p) {
        if (!nodeCache.containsKey(p)) {
            nodeCache.put(p, p);
        }
        return nodeCache.get(p);
    }

    private static PurityEdge cacheEdge(PurityEdge e) {
        if (!edgeCache.containsKey(e)) {
            edgeCache.put(e, e);
        }
        return edgeCache.get(e);
    }

    public static PurityGraph conservativeGraph(SootMethod m4, boolean withEffect) {
        PurityGraph g2 = new PurityGraph();
        PurityGlobalNode glob = PurityGlobalNode.node;
        g2.nodes.add(glob);
        int i = 0;
        for (Type next : m4.getParameterTypes()) {
            if (next instanceof RefLikeType) {
                PurityNode n = PurityGraph.cacheNode(new PurityParamNode(i));
                g2.globEscape.add(n);
                g2.nodes.add(n);
                g2.paramNodes.add(n);
            }
            ++i;
        }
        if (m4.getReturnType() instanceof RefLikeType) {
            g2.ret.add(glob);
        }
        if (withEffect) {
            g2.mutated.put(glob, "outside-world");
        }
        return g2;
    }

    public static PurityGraph freshGraph(SootMethod m4) {
        PurityGraph g2 = new PurityGraph();
        if (m4.getReturnType() instanceof RefLikeType) {
            PurityNode n = PurityGraph.cacheNode(new PurityMethodNode(m4));
            g2.ret.add(n);
            g2.nodes.add(n);
        }
        return g2;
    }

    void union(PurityGraph arg) {
        this.nodes.addAll(arg.nodes);
        this.paramNodes.addAll(arg.paramNodes);
        this.edges.putAll(arg.edges);
        this.locals.putAll(arg.locals);
        this.ret.addAll(arg.ret);
        this.globEscape.addAll(arg.globEscape);
        this.backEdges.putAll(arg.backEdges);
        this.backLocals.putAll(arg.backLocals);
        this.mutated.putAll(arg.mutated);
    }

    protected void sanityCheck() {
        boolean err = false;
        for (PurityNode src : this.edges.keySet()) {
            for (PurityEdge e : this.edges.get(src)) {
                if (!src.equals(e.getSource())) {
                    logger.debug("invalid edge source " + e + ", should be " + src);
                    err = true;
                }
                if (!this.nodes.contains(e.getSource())) {
                    logger.debug("nodes does not contain edge source " + e);
                    err = true;
                }
                if (!this.nodes.contains(e.getTarget())) {
                    logger.debug("nodes does not contain edge target " + e);
                    err = true;
                }
                if (!this.backEdges.get(e.getTarget()).contains(e)) {
                    logger.debug("backEdges does not contain edge " + e);
                    err = true;
                }
                if (e.isInside() || e.getTarget().isLoad()) continue;
                logger.debug("target of outside edge is not a load node " + e);
                err = true;
            }
        }
        for (PurityNode dst : this.backEdges.keySet()) {
            for (PurityEdge e : this.backEdges.get(dst)) {
                if (!dst.equals(e.getTarget())) {
                    logger.debug("invalid backEdge dest " + e + ", should be " + dst);
                    err = true;
                }
                if (this.edges.get(e.getSource()).contains(e)) continue;
                logger.debug("backEdge not in edges " + e);
                err = true;
            }
        }
        for (PurityNode n : this.nodes) {
            if (!n.isParam() || this.paramNodes.contains(n)) continue;
            logger.debug("paramNode not in paramNodes " + n);
            err = true;
        }
        for (PurityNode n : this.paramNodes) {
            if (!n.isParam()) {
                logger.debug("paramNode contains a non-param node " + n);
                err = true;
            }
            if (this.nodes.contains(n)) continue;
            logger.debug("paramNode not in nodes " + n);
            err = true;
        }
        for (PurityNode n : this.globEscape) {
            if (this.nodes.contains(n)) continue;
            logger.debug("globEscape not in nodes " + n);
            err = true;
        }
        for (Local l : this.locals.keySet()) {
            for (PurityNode n : this.locals.get(l)) {
                if (!this.nodes.contains(n)) {
                    logger.debug("target of local node in nodes " + l + " / " + n);
                    err = true;
                }
                if (this.backLocals.get(n).contains(l)) continue;
                logger.debug("backLocals does contain local " + l + " / " + n);
                err = true;
            }
        }
        for (PurityNode n : this.backLocals.keySet()) {
            for (Local l : this.backLocals.get(n)) {
                if (!this.nodes.contains(n)) {
                    logger.debug("backLocal node not in in nodes " + l + " / " + n);
                    err = true;
                }
                if (this.locals.get(l).contains(n)) continue;
                logger.debug("locals does contain backLocal " + l + " / " + n);
                err = true;
            }
        }
        for (PurityNode n : this.ret) {
            if (this.nodes.contains(n)) continue;
            logger.debug("target of ret not in nodes " + n);
            err = true;
        }
        for (PurityNode n : this.mutated.keySet()) {
            if (this.nodes.contains(n)) continue;
            logger.debug("mutated node not in nodes " + n);
            err = true;
        }
        if (err) {
            this.dump();
            DotGraph dot = new DotGraph("sanityCheckFailure");
            this.fillDotGraph("chk", dot);
            dot.plot("sanityCheckFailure.dot");
            throw new Error("PurityGraph sanity check failed!!!");
        }
    }

    protected void internalPassEdges(Set<PurityEdge> toColor, Set<PurityNode> dest, boolean consider_inside) {
        for (PurityEdge edge : toColor) {
            PurityNode node;
            if (!consider_inside && edge.isInside() || dest.contains(node = edge.getTarget())) continue;
            dest.add(node);
            this.internalPassEdges(this.edges.get(node), dest, consider_inside);
        }
    }

    protected void internalPassNode(PurityNode node, Set<PurityNode> dest, boolean consider_inside) {
        if (!dest.contains(node)) {
            dest.add(node);
            this.internalPassEdges(this.edges.get(node), dest, consider_inside);
        }
    }

    protected void internalPassNodes(Set<PurityNode> toColor, Set<PurityNode> dest, boolean consider_inside) {
        for (PurityNode n : toColor) {
            this.internalPassNode(n, dest, consider_inside);
        }
    }

    protected Set<PurityNode> getEscaping() {
        HashSet<PurityNode> escaping = new HashSet<PurityNode>();
        this.internalPassNodes(this.ret, escaping, true);
        this.internalPassNodes(this.globEscape, escaping, true);
        this.internalPassNode(PurityGlobalNode.node, escaping, true);
        this.internalPassNodes(this.paramNodes, escaping, true);
        return escaping;
    }

    public boolean isPure() {
        if (!this.mutated.get(PurityGlobalNode.node).isEmpty()) {
            return false;
        }
        HashSet<PurityNode> A3 = new HashSet<PurityNode>();
        HashSet<PurityNode> B2 = new HashSet<PurityNode>();
        this.internalPassNodes(this.paramNodes, A3, false);
        this.internalPassNodes(this.globEscape, B2, true);
        this.internalPassNode(PurityGlobalNode.node, B2, true);
        for (PurityNode n : A3) {
            if (!B2.contains(n) && this.mutated.get(n).isEmpty()) continue;
            return false;
        }
        return true;
    }

    public boolean isPureConstructor() {
        if (!this.mutated.get(PurityGlobalNode.node).isEmpty()) {
            return false;
        }
        HashSet<PurityNode> A3 = new HashSet<PurityNode>();
        HashSet<PurityNode> B2 = new HashSet<PurityNode>();
        this.internalPassNodes(this.paramNodes, A3, false);
        this.internalPassNodes(this.globEscape, B2, true);
        this.internalPassNode(PurityGlobalNode.node, B2, true);
        PurityThisNode th = PurityThisNode.node;
        for (PurityNode n : A3) {
            if (!B2.contains(n) && (n.equals(th) || this.mutated.get(n).isEmpty())) continue;
            return false;
        }
        return true;
    }

    protected int internalParamStatus(PurityNode p) {
        if (!this.paramNodes.contains(p)) {
            return 0;
        }
        HashSet<PurityNode> S1 = new HashSet<PurityNode>();
        this.internalPassNode(p, S1, false);
        for (PurityNode n : S1) {
            if (!n.isLoad() && !n.equals(p) || this.mutated.get(n).isEmpty() && !this.globEscape.contains(n)) continue;
            return 0;
        }
        HashSet<PurityNode> S2 = new HashSet<PurityNode>();
        this.internalPassNodes(this.ret, S2, true);
        this.internalPassNodes(this.paramNodes, S2, true);
        for (PurityNode n : S2) {
            for (PurityEdge e : this.edges.get(n)) {
                if (!e.isInside() || !S1.contains(e.getTarget())) continue;
                return 1;
            }
        }
        return 2;
    }

    public int paramStatus(int param) {
        return this.internalParamStatus(PurityGraph.cacheNode(new PurityParamNode(param)));
    }

    public int thisStatus() {
        return this.internalParamStatus(PurityThisNode.node);
    }

    public Object clone() {
        return new PurityGraph(this);
    }

    protected final boolean localsRemove(Local local) {
        for (PurityNode node : this.locals.get(local)) {
            this.backLocals.remove(node, local);
        }
        return this.locals.remove(local);
    }

    protected final boolean localsPut(Local local, PurityNode node) {
        this.backLocals.put(node, local);
        return this.locals.put(local, node);
    }

    protected final boolean localsPutAll(Local local, Set<PurityNode> nodes) {
        for (PurityNode node : nodes) {
            this.backLocals.put(node, local);
        }
        return this.locals.putAll(local, nodes);
    }

    protected final void removeNode(PurityNode n) {
        for (PurityEdge e : this.edges.get(n)) {
            this.backEdges.remove(e.getTarget(), e);
        }
        for (PurityEdge e : this.backEdges.get(n)) {
            this.edges.remove(e.getSource(), e);
        }
        for (Local l : this.backLocals.get(n)) {
            this.locals.remove(l, n);
        }
        this.ret.remove(n);
        this.edges.remove(n);
        this.backEdges.remove(n);
        this.backLocals.remove(n);
        this.nodes.remove(n);
        this.paramNodes.remove(n);
        this.globEscape.remove(n);
        this.mutated.remove(n);
    }

    protected final void mergeNodes(PurityNode src, PurityNode dst) {
        PurityEdge ee;
        PurityNode n;
        for (PurityEdge e : new ArrayList<PurityEdge>(this.edges.get(src))) {
            n = e.getTarget();
            if (n.equals(src)) {
                n = dst;
            }
            ee = PurityGraph.cacheEdge(new PurityEdge(dst, e.getField(), n, e.isInside()));
            this.edges.remove(src, e);
            this.edges.put(dst, ee);
            this.backEdges.remove(n, e);
            this.backEdges.put(n, ee);
        }
        for (PurityEdge e : new ArrayList<PurityEdge>(this.backEdges.get(src))) {
            n = e.getSource();
            if (n.equals(src)) {
                n = dst;
            }
            ee = PurityGraph.cacheEdge(new PurityEdge(n, e.getField(), dst, e.isInside()));
            this.edges.remove(n, e);
            this.edges.put(n, ee);
            this.backEdges.remove(src, e);
            this.backEdges.put(dst, ee);
        }
        for (Local l : new ArrayList<Local>(this.backLocals.get(src))) {
            this.locals.remove(l, src);
            this.backLocals.remove(src, l);
            this.locals.put(l, dst);
            this.backLocals.put(dst, l);
        }
        Set<String> m4 = this.mutated.get(src);
        this.mutated.remove(src);
        this.mutated.putAll(dst, m4);
        if (this.ret.contains(src)) {
            this.ret.remove(src);
            this.ret.add(dst);
        }
        if (this.globEscape.contains(src)) {
            this.globEscape.remove(src);
            this.globEscape.add(dst);
        }
        this.nodes.remove(src);
        this.nodes.add(dst);
        this.paramNodes.remove(src);
        if (dst.isParam()) {
            this.paramNodes.add(dst);
        }
    }

    void simplifyLoad() {
        for (PurityNode p : new ArrayList<PurityNode>(this.nodes)) {
            HashMap<String, PurityNode> fmap = new HashMap<String, PurityNode>();
            for (PurityEdge e : new ArrayList<PurityEdge>(this.edges.get(p))) {
                PurityNode tgt = e.getTarget();
                if (e.isInside() || tgt.equals(p)) continue;
                String f = e.getField();
                if (fmap.containsKey(f) && this.nodes.contains(fmap.get(f))) {
                    this.mergeNodes(tgt, (PurityNode)fmap.get(f));
                    continue;
                }
                fmap.put(f, tgt);
            }
        }
    }

    void simplifyInside() {
        HashSet<PurityNode> r = new HashSet<PurityNode>();
        this.internalPassNodes(this.paramNodes, r, true);
        this.internalPassNodes(this.ret, r, true);
        this.internalPassNodes(this.globEscape, r, true);
        this.internalPassNode(PurityGlobalNode.node, r, true);
        for (PurityNode n : this.nodes) {
            if (!n.isLoad()) continue;
            this.internalPassNode(n, r, true);
        }
        for (PurityNode n : new ArrayList<PurityNode>(this.nodes)) {
            if (!n.isInside() || r.contains(n)) continue;
            this.removeNode(n);
        }
    }

    void removeLocals() {
        this.locals = new HashMultiMap<Local, PurityNode>();
        this.backLocals = new HashMultiMap<PurityNode, Local>();
    }

    void assignParamToLocal(int right, Local left) {
        PurityNode node = PurityGraph.cacheNode(new PurityParamNode(right));
        this.localsRemove(left);
        this.localsPut(left, node);
        this.nodes.add(node);
        this.paramNodes.add(node);
    }

    void assignThisToLocal(Local left) {
        PurityThisNode node = PurityThisNode.node;
        this.localsRemove(left);
        this.localsPut(left, node);
        this.nodes.add(node);
        this.paramNodes.add(node);
    }

    void assignLocalToLocal(Local right, Local left) {
        this.localsRemove(left);
        this.localsPutAll(left, this.locals.get(right));
    }

    void returnLocal(Local right) {
        this.ret.clear();
        this.ret.addAll(this.locals.get(right));
    }

    void assignFieldToLocal(Stmt stmt, Local right, String field, Local left) {
        HashSet<PurityNode> esc = new HashSet<PurityNode>();
        Set<PurityNode> escaping = this.getEscaping();
        this.localsRemove(left);
        for (PurityNode nodeRight : this.locals.get(right)) {
            for (PurityEdge edge : this.edges.get(nodeRight)) {
                if (!edge.isInside() || !edge.getField().equals(field)) continue;
                this.localsPut(left, edge.getTarget());
            }
            if (!escaping.contains(nodeRight)) continue;
            esc.add(nodeRight);
        }
        if (!esc.isEmpty()) {
            PurityNode loadNode = PurityGraph.cacheNode(new PurityStmtNode(stmt, false));
            this.nodes.add(loadNode);
            for (PurityNode node : esc) {
                PurityEdge edge;
                if (!this.edges.put(node, edge = PurityGraph.cacheEdge(new PurityEdge(node, field, loadNode, false)))) continue;
                this.backEdges.put(loadNode, edge);
            }
            this.localsPut(left, loadNode);
        }
    }

    void assignLocalToField(Local right, Local left, String field) {
        for (PurityNode nodeLeft : this.locals.get(left)) {
            for (PurityNode nodeRight : this.locals.get(right)) {
                PurityEdge edge = PurityGraph.cacheEdge(new PurityEdge(nodeLeft, field, nodeRight, true));
                if (!this.edges.put(nodeLeft, edge)) continue;
                this.backEdges.put(nodeRight, edge);
            }
            if (nodeLeft.isInside()) continue;
            this.mutated.put(nodeLeft, field);
        }
    }

    void assignNewToLocal(Stmt stmt, Local left) {
        PurityNode node = PurityGraph.cacheNode(new PurityStmtNode(stmt, true));
        this.localsRemove(left);
        this.localsPut(left, node);
        this.nodes.add(node);
    }

    void localEscapes(Local l) {
        this.globEscape.addAll(this.locals.get(l));
    }

    void localIsUnknown(Local l) {
        PurityGlobalNode node = PurityGlobalNode.node;
        this.localsRemove(l);
        this.localsPut(l, node);
        this.nodes.add(node);
    }

    void assignLocalToStaticField(Local right, String field) {
        PurityGlobalNode node = PurityGlobalNode.node;
        this.localEscapes(right);
        this.mutated.put(node, field);
        this.nodes.add(node);
    }

    void mutateField(Local left, String field) {
        for (PurityNode n : this.locals.get(left)) {
            if (n.isInside()) continue;
            this.mutated.put(n, field);
        }
    }

    void mutateStaticField(String field) {
        PurityGlobalNode node = PurityGlobalNode.node;
        this.mutated.put(node, field);
        this.nodes.add(node);
    }

    void methodCall(PurityGraph g2, Local right, List<Value> args, Local left) {
        HashMultiMap<PurityNode, PurityNode> mu = new HashMultiMap<PurityNode, PurityNode>();
        int nb = 0;
        for (Value value : args) {
            Local local;
            if (value instanceof Local && (local = (Local)value).getType() instanceof RefLikeType) {
                mu.putAll(PurityGraph.cacheNode(new PurityParamNode(nb)), this.locals.get(local));
            }
            ++nb;
        }
        if (right != null) {
            mu.putAll(PurityThisNode.node, this.locals.get(right));
        }
        boolean hasChanged = true;
        while (hasChanged) {
            hasChanged = false;
            for (PurityNode purityNode : new ArrayList(mu.keySet())) {
                for (PurityNode n3 : new ArrayList(mu.get(purityNode))) {
                    for (PurityEdge e12 : g2.edges.get(purityNode)) {
                        if (e12.isInside()) continue;
                        for (PurityEdge purityEdge : this.edges.get(n3)) {
                            if (!purityEdge.isInside() || !e12.getField().equals(purityEdge.getField()) || !mu.put(e12.getTarget(), purityEdge.getTarget())) continue;
                            hasChanged = true;
                        }
                    }
                }
            }
            for (PurityNode purityNode : g2.edges.keySet()) {
                for (PurityNode n3 : g2.edges.keySet()) {
                    boolean cond;
                    Set mu1 = mu.get(purityNode);
                    Set mu3 = mu.get(n3);
                    boolean bl = cond = purityNode.equals(n3) || mu1.contains(n3) || mu3.contains(purityNode);
                    if (!cond) {
                        PurityNode next;
                        Iterator iterator = mu1.iterator();
                        while (iterator.hasNext() && !(cond |= mu3.contains(next = (PurityNode)iterator.next()))) {
                        }
                    }
                    if (!cond || purityNode.equals(n3) && !purityNode.isLoad()) continue;
                    for (PurityEdge e12 : g2.edges.get(purityNode)) {
                        if (e12.isInside()) continue;
                        for (PurityEdge e342 : g2.edges.get(n3)) {
                            if (!e342.isInside() || !e12.getField().equals(e342.getField())) continue;
                            PurityNode n2 = e12.getTarget();
                            PurityNode n4 = e342.getTarget();
                            if (!n4.isParam() && mu.put(n2, n4)) {
                                hasChanged = true;
                            }
                            if (!mu.putAll(n2, mu.get(n4))) continue;
                            hasChanged = true;
                        }
                    }
                }
            }
        }
        for (PurityNode purityNode : g2.nodes) {
            if (purityNode.isParam()) continue;
            mu.put(purityNode, purityNode);
            this.nodes.add(purityNode);
        }
        for (PurityNode purityNode : g2.edges.keySet()) {
            for (PurityEdge e12 : g2.edges.get(purityNode)) {
                String f = e12.getField();
                PurityNode n2 = e12.getTarget();
                for (PurityNode mu1 : mu.get(purityNode)) {
                    if (e12.isInside()) {
                        for (PurityNode mu2 : mu.get(n2)) {
                            PurityEdge edge = PurityGraph.cacheEdge(new PurityEdge(mu1, f, mu2, true));
                            this.edges.put(mu1, edge);
                            this.backEdges.put(mu2, edge);
                        }
                        continue;
                    }
                    PurityEdge purityEdge = PurityGraph.cacheEdge(new PurityEdge(mu1, f, n2, false));
                    this.edges.put(mu1, purityEdge);
                    this.backEdges.put(n2, purityEdge);
                }
            }
        }
        if (left != null) {
            this.localsRemove(left);
            for (PurityNode purityNode : g2.ret) {
                this.localsPutAll(left, mu.get(purityNode));
            }
        }
        for (PurityNode purityNode : g2.globEscape) {
            this.globEscape.addAll(mu.get(purityNode));
        }
        Set<PurityNode> escaping = this.getEscaping();
        for (PurityNode purityNode : new ArrayList<PurityNode>(this.nodes)) {
            if (escaping.contains(purityNode)) continue;
            if (purityNode.isLoad()) {
                this.removeNode(purityNode);
                continue;
            }
            for (PurityEdge e : new ArrayList<PurityEdge>(this.edges.get(purityNode))) {
                if (e.isInside()) continue;
                this.edges.remove(purityNode, e);
                this.backEdges.remove(e.getTarget(), e);
            }
        }
        for (PurityNode purityNode : g2.mutated.keySet()) {
            for (PurityNode nn : mu.get(purityNode)) {
                if (!this.nodes.contains(nn) || nn.isInside()) continue;
                for (String next : g2.mutated.get(purityNode)) {
                    this.mutated.put(nn, next);
                }
            }
        }
    }

    void fillDotGraph(String prefix, DotGraph out) {
        DotGraphNode node;
        Object label;
        HashMap<PurityNode, Object> nodeId = new HashMap<PurityNode, Object>();
        int id = 0;
        for (PurityNode purityNode : this.nodes) {
            label = "N" + prefix + "_" + id;
            node = out.drawNode((String)label);
            node.setLabel(purityNode.toString());
            if (!purityNode.isInside()) {
                node.setStyle("dashed");
                node.setAttribute("color", "gray50");
            }
            if (this.globEscape.contains(purityNode)) {
                node.setAttribute("fontcolor", "red");
            }
            nodeId.put(purityNode, label);
            ++id;
        }
        for (PurityNode purityNode : this.edges.keySet()) {
            for (PurityEdge e : this.edges.get(purityNode)) {
                DotGraphEdge edge = out.drawEdge((String)nodeId.get(e.getSource()), (String)nodeId.get(e.getTarget()));
                edge.setLabel(e.getField());
                if (e.isInside()) continue;
                edge.setStyle("dashed");
                edge.setAttribute("color", "gray50");
                edge.setAttribute("fontcolor", "gray40");
            }
        }
        for (Local local : this.locals.keySet()) {
            if (this.locals.get(local).isEmpty()) continue;
            label = "L" + prefix + "_" + id;
            node = out.drawNode((String)label);
            node.setLabel(local.toString());
            node.setShape("plaintext");
            for (PurityNode dst : this.locals.get(local)) {
                out.drawEdge((String)label, (String)nodeId.get(dst));
            }
            ++id;
        }
        if (!this.ret.isEmpty()) {
            DotGraphNode node2 = out.drawNode("ret_" + prefix);
            node2.setLabel("ret");
            node2.setShape("plaintext");
            for (PurityNode dst : this.ret) {
                out.drawEdge("ret_" + prefix, (String)nodeId.get(dst));
            }
        }
        for (PurityNode purityNode : this.mutated.keySet()) {
            for (String next : this.mutated.get(purityNode)) {
                String label2 = "M" + prefix + "_" + id;
                DotGraphNode node3 = out.drawNode(label2);
                node3.setLabel("");
                node3.setShape("plaintext");
                DotGraphEdge edge = out.drawEdge((String)nodeId.get(purityNode), label2);
                edge.setLabel(next);
                ++id;
            }
        }
    }

    private static void dumpSet(String name, Set<PurityNode> s2) {
        logger.debug(name);
        for (PurityNode next : s2) {
            logger.debug("  " + next);
        }
    }

    private static <A, B> void dumpMultiMap(String name, MultiMap<A, B> s2) {
        logger.debug(name);
        for (A key : s2.keySet()) {
            logger.debug("  " + key);
            for (B value : s2.get(key)) {
                logger.debug("    " + value);
            }
        }
    }

    void dump() {
        PurityGraph.dumpSet("nodes Set:", this.nodes);
        PurityGraph.dumpSet("paramNodes Set:", this.paramNodes);
        PurityGraph.dumpMultiMap("edges MultiMap:", this.edges);
        PurityGraph.dumpMultiMap("locals MultiMap:", this.locals);
        PurityGraph.dumpSet("ret Set:", this.ret);
        PurityGraph.dumpSet("globEscape Set:", this.globEscape);
        PurityGraph.dumpMultiMap("backEdges MultiMap:", this.backEdges);
        PurityGraph.dumpMultiMap("backLocals MultiMap:", this.backLocals);
        PurityGraph.dumpMultiMap("mutated MultiMap:", this.mutated);
        logger.debug("");
    }

    static void dumpStat() {
        logger.debug("Stat: " + maxInsideNodes + " inNodes, " + maxLoadNodes + " loadNodes, " + maxInsideEdges + " inEdges, " + maxOutsideEdges + " outEdges, " + maxMutated + " mutated.");
    }

    void updateStat() {
        boolean bl;
        int insideNodes = 0;
        int loadNodes = 0;
        for (PurityNode n : this.nodes) {
            if (n.isInside()) {
                ++insideNodes;
                continue;
            }
            if (!n.isLoad()) continue;
            ++loadNodes;
        }
        int insideEdges = 0;
        int outsideEdges = 0;
        for (PurityNode purityNode : this.edges.keySet()) {
            for (PurityEdge e : this.edges.get(purityNode)) {
                if (e.isInside()) {
                    ++insideEdges;
                    continue;
                }
                ++outsideEdges;
            }
        }
        int mutatedFields = 0;
        for (PurityNode next : this.mutated.keySet()) {
            mutatedFields += this.mutated.get(next).size();
        }
        boolean bl2 = false;
        if (insideNodes > maxInsideNodes) {
            maxInsideNodes = insideNodes;
            boolean bl3 = true;
        }
        if (loadNodes > maxLoadNodes) {
            maxLoadNodes = loadNodes;
            boolean bl4 = true;
        }
        if (insideEdges > maxInsideEdges) {
            maxInsideEdges = insideEdges;
            boolean bl5 = true;
        }
        if (outsideEdges > maxOutsideEdges) {
            maxOutsideEdges = outsideEdges;
            boolean bl6 = true;
        }
        if (mutatedFields > maxMutated) {
            maxMutated = mutatedFields;
            bl = true;
        }
        if (bl) {
            PurityGraph.dumpStat();
        }
    }
}

