/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.toolkits.annotation.nullcheck;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.ArrayType;
import soot.EquivalentValue;
import soot.Local;
import soot.NullType;
import soot.RefType;
import soot.Type;
import soot.Unit;
import soot.Value;
import soot.ValueBox;
import soot.jimple.ArrayRef;
import soot.jimple.AssignStmt;
import soot.jimple.BinopExpr;
import soot.jimple.CastExpr;
import soot.jimple.CaughtExceptionRef;
import soot.jimple.DefinitionStmt;
import soot.jimple.EqExpr;
import soot.jimple.IfStmt;
import soot.jimple.InstanceFieldRef;
import soot.jimple.InstanceInvokeExpr;
import soot.jimple.LengthExpr;
import soot.jimple.MonitorStmt;
import soot.jimple.NeExpr;
import soot.jimple.NewArrayExpr;
import soot.jimple.NewExpr;
import soot.jimple.NewMultiArrayExpr;
import soot.jimple.NullConstant;
import soot.jimple.StaticFieldRef;
import soot.jimple.Stmt;
import soot.jimple.StringConstant;
import soot.jimple.ThisRef;
import soot.jimple.ThrowStmt;
import soot.jimple.toolkits.annotation.nullcheck.RefIntPair;
import soot.toolkits.graph.UnitGraph;
import soot.toolkits.scalar.ArrayFlowUniverse;
import soot.toolkits.scalar.ArrayPackedSet;
import soot.toolkits.scalar.FlowSet;
import soot.toolkits.scalar.ForwardBranchedFlowAnalysis;

@Deprecated
public class BranchedRefVarsAnalysis
extends ForwardBranchedFlowAnalysis<FlowSet<RefIntPair>> {
    private static final Logger logger = LoggerFactory.getLogger(BranchedRefVarsAnalysis.class);
    private static final boolean isNotConservative = false;
    private static final boolean isBranched = true;
    private static final boolean careForAliases = false;
    private static final boolean careForMethodCalls = true;
    public static final int kBottom = 0;
    public static final int kNull = 1;
    public static final int kNonNull = 2;
    public static final int kTop = 99;
    protected final FlowSet<RefIntPair> emptySet;
    protected final FlowSet<RefIntPair> fullSet;
    protected final Map<Unit, FlowSet<RefIntPair>> unitToGenerateSet;
    protected final Map<Unit, FlowSet<RefIntPair>> unitToPreserveSet;
    protected final Map<Unit, HashSet<Value>> unitToAnalyzedChecksSet;
    protected final Map<Unit, HashSet<Value>> unitToArrayRefChecksSet;
    protected final Map<Unit, HashSet<Value>> unitToInstanceFieldRefChecksSet;
    protected final Map<Unit, HashSet<Value>> unitToInstanceInvokeExprChecksSet;
    protected final Map<Unit, HashSet<Value>> unitToLengthExprChecksSet;
    protected final List<EquivalentValue> refTypeLocals;
    protected final List<EquivalentValue> refTypeInstFields;
    protected final List<EquivalentValue> refTypeInstFieldBases;
    protected final List<EquivalentValue> refTypeStaticFields;
    protected final List<EquivalentValue> refTypeValues;
    private final HashMap<Value, EquivalentValue> valueToEquivValue = new HashMap(2293, 0.7f);
    private final HashMap<EquivalentValue, RefIntPair> kRefBotttomPairs = new HashMap(2293, 0.7f);
    private final HashMap<EquivalentValue, RefIntPair> kRefNonNullPairs = new HashMap(2293, 0.7f);
    private final HashMap<EquivalentValue, RefIntPair> kRefNullPairs = new HashMap(2293, 0.7f);
    private final HashMap<EquivalentValue, RefIntPair> kRefTopPairs = new HashMap(2293, 0.7f);
    protected FlowSet<RefIntPair> tempFlowSet = null;

    @Deprecated
    public BranchedRefVarsAnalysis(UnitGraph g2) {
        super(g2);
        this.refTypeLocals = new ArrayList<EquivalentValue>();
        this.refTypeInstFields = new ArrayList<EquivalentValue>();
        this.refTypeInstFieldBases = new ArrayList<EquivalentValue>();
        this.refTypeStaticFields = new ArrayList<EquivalentValue>();
        this.refTypeValues = new ArrayList<EquivalentValue>();
        this.initRefTypeLists();
        int len = this.refTypeValues.size();
        RefIntPair[] universeArray = new RefIntPair[2 * len];
        for (int i = 0; i < len; ++i) {
            int j = i * 2;
            EquivalentValue r = this.refTypeValues.get(i);
            universeArray[j] = this.getKRefIntPair(r, 1);
            universeArray[j + 1] = this.getKRefIntPair(r, 2);
        }
        ArrayPackedSet<RefIntPair> temp = new ArrayPackedSet<RefIntPair>(new ArrayFlowUniverse<RefIntPair>(universeArray));
        this.emptySet = temp;
        this.fullSet = temp.clone();
        temp.complement(this.fullSet);
        this.tempFlowSet = this.newInitialFlow();
        int cap = this.graph.size() * 2 + 1;
        this.unitToGenerateSet = new HashMap<Unit, FlowSet<RefIntPair>>(cap, 0.7f);
        this.unitToPreserveSet = new HashMap<Unit, FlowSet<RefIntPair>>(cap, 0.7f);
        this.unitToAnalyzedChecksSet = new HashMap<Unit, HashSet<Value>>(cap, 0.7f);
        this.unitToArrayRefChecksSet = new HashMap<Unit, HashSet<Value>>(cap, 0.7f);
        this.unitToInstanceFieldRefChecksSet = new HashMap<Unit, HashSet<Value>>(cap, 0.7f);
        this.unitToInstanceInvokeExprChecksSet = new HashMap<Unit, HashSet<Value>>(cap, 0.7f);
        this.unitToLengthExprChecksSet = new HashMap<Unit, HashSet<Value>>(cap, 0.7f);
        this.initUnitSets();
        this.doAnalysis();
    }

    public EquivalentValue getEquivalentValue(Value v) {
        if (this.valueToEquivValue.containsKey(v)) {
            return this.valueToEquivValue.get(v);
        }
        EquivalentValue ev = new EquivalentValue(v);
        this.valueToEquivValue.put(v, ev);
        return ev;
    }

    public RefIntPair getKRefIntPair(EquivalentValue r, int v) {
        HashMap<EquivalentValue, RefIntPair> pairsMap;
        switch (v) {
            case 2: {
                pairsMap = this.kRefNonNullPairs;
                break;
            }
            case 1: {
                pairsMap = this.kRefNullPairs;
                break;
            }
            case 99: {
                pairsMap = this.kRefTopPairs;
                break;
            }
            case 0: {
                pairsMap = this.kRefBotttomPairs;
                break;
            }
            default: {
                throw new RuntimeException("invalid constant (" + v + ")");
            }
        }
        if (pairsMap.containsKey(r)) {
            return pairsMap.get(r);
        }
        RefIntPair pair = new RefIntPair(r, v, this);
        pairsMap.put(r, pair);
        return pair;
    }

    private static boolean isAlwaysNull(Value r) {
        return r instanceof NullConstant || r.getType() instanceof NullType;
    }

    private static boolean isAlwaysTop(Value r) {
        return r instanceof InstanceFieldRef || r instanceof StaticFieldRef;
    }

    private static boolean isAlwaysNonNull(Value ro) {
        return ro instanceof NewExpr || ro instanceof NewArrayExpr || ro instanceof NewMultiArrayExpr || ro instanceof ThisRef || ro instanceof CaughtExceptionRef || ro instanceof StringConstant;
    }

    private static boolean isAnalyzedRef(Value r) {
        if (BranchedRefVarsAnalysis.isAlwaysNull(r) || BranchedRefVarsAnalysis.isAlwaysTop(r)) {
            return false;
        }
        if (r instanceof Local || r instanceof InstanceFieldRef || r instanceof StaticFieldRef) {
            Type rType = r.getType();
            return rType instanceof RefType || rType instanceof ArrayType;
        }
        return false;
    }

    protected final int refInfo(EquivalentValue r, FlowSet<RefIntPair> fs) {
        boolean isNull = fs.contains(this.getKRefIntPair(r, 1));
        boolean isNonNull = fs.contains(this.getKRefIntPair(r, 2));
        if (isNull && isNonNull) {
            return 99;
        }
        if (isNull) {
            return 1;
        }
        if (isNonNull) {
            return 2;
        }
        return 0;
    }

    private int refInfo(Value r, FlowSet<RefIntPair> fs) {
        return this.refInfo(this.getEquivalentValue(r), fs);
    }

    public final int anyRefInfo(Value r, FlowSet<RefIntPair> f) {
        if (BranchedRefVarsAnalysis.isAlwaysNull(r)) {
            return 1;
        }
        if (BranchedRefVarsAnalysis.isAlwaysTop(r)) {
            return 99;
        }
        if (BranchedRefVarsAnalysis.isAlwaysNonNull(r)) {
            return 2;
        }
        return this.refInfo(r, f);
    }

    private void uAddTopToFlowSet(EquivalentValue r, FlowSet<RefIntPair> genFS, FlowSet<RefIntPair> preFS) {
        RefIntPair nullPair = this.getKRefIntPair(r, 1);
        RefIntPair nullNonPair = this.getKRefIntPair(r, 2);
        if (genFS != preFS) {
            preFS.remove(nullPair, preFS);
            preFS.remove(nullNonPair, preFS);
        }
        genFS.add(nullPair, genFS);
        genFS.add(nullNonPair, genFS);
    }

    private void uAddTopToFlowSet(Value r, FlowSet<RefIntPair> genFS, FlowSet<RefIntPair> preFS) {
        this.uAddTopToFlowSet(this.getEquivalentValue(r), genFS, preFS);
    }

    private void uAddTopToFlowSet(Value r, FlowSet<RefIntPair> fs) {
        this.uAddTopToFlowSet(this.getEquivalentValue(r), fs, fs);
    }

    private void uAddTopToFlowSet(EquivalentValue r, FlowSet<RefIntPair> fs) {
        this.uAddTopToFlowSet(r, fs, fs);
    }

    private void uAddInfoToFlowSet(EquivalentValue r, int v, FlowSet<RefIntPair> genFS, FlowSet<RefIntPair> preFS) {
        int kill;
        switch (v) {
            case 1: {
                kill = 2;
                break;
            }
            case 2: {
                kill = 1;
                break;
            }
            default: {
                throw new RuntimeException("invalid info");
            }
        }
        if (genFS != preFS) {
            preFS.remove(this.getKRefIntPair(r, kill), preFS);
        }
        genFS.remove(this.getKRefIntPair(r, kill), genFS);
        genFS.add(this.getKRefIntPair(r, v), genFS);
    }

    private void uAddInfoToFlowSet(Value r, int v, FlowSet<RefIntPair> genF, FlowSet<RefIntPair> preF) {
        this.uAddInfoToFlowSet(this.getEquivalentValue(r), v, genF, preF);
    }

    private void uAddInfoToFlowSet(Value r, int v, FlowSet<RefIntPair> fs) {
        this.uAddInfoToFlowSet(this.getEquivalentValue(r), v, fs, fs);
    }

    private void uAddInfoToFlowSet(EquivalentValue r, int v, FlowSet<RefIntPair> fs) {
        this.uAddInfoToFlowSet(r, v, fs, fs);
    }

    private void uListAddTopToFlowSet(List<EquivalentValue> refs, FlowSet<RefIntPair> genFS, FlowSet<RefIntPair> preFS) {
        for (EquivalentValue ev : refs) {
            this.uAddTopToFlowSet(ev, genFS, preFS);
        }
    }

    private void initRefTypeLists() {
        for (Local l : ((UnitGraph)this.graph).getBody().getLocals()) {
            Type type = l.getType();
            if (!(type instanceof RefType) && !(type instanceof ArrayType)) continue;
            this.refTypeLocals.add(this.getEquivalentValue(l));
        }
        this.refTypeValues.addAll(this.refTypeLocals);
        this.refTypeValues.addAll(this.refTypeInstFields);
        this.refTypeValues.addAll(this.refTypeStaticFields);
    }

    private void initRefTypeLists(ValueBox box) {
        EquivalentValue esr;
        StaticFieldRef sr;
        Type opType;
        Value val = box.getValue();
        if (val instanceof InstanceFieldRef) {
            EquivalentValue eir;
            InstanceFieldRef ir = (InstanceFieldRef)val;
            Type opType2 = ir.getType();
            if ((opType2 instanceof RefType || opType2 instanceof ArrayType) && !this.refTypeInstFields.contains(eir = this.getEquivalentValue(ir))) {
                this.refTypeInstFields.add(eir);
                EquivalentValue eirbase = this.getEquivalentValue(ir.getBase());
                if (!this.refTypeInstFieldBases.contains(eirbase)) {
                    this.refTypeInstFieldBases.add(eirbase);
                }
            }
        } else if (val instanceof StaticFieldRef && ((opType = (sr = (StaticFieldRef)val).getType()) instanceof RefType || opType instanceof ArrayType) && !this.refTypeStaticFields.contains(esr = this.getEquivalentValue(sr))) {
            this.refTypeStaticFields.add(esr);
        }
    }

    private void initUnitSets() {
        for (Unit s2 : this.graph) {
            Value boxValue;
            Value base;
            FlowSet<RefIntPair> genSet = this.emptySet.clone();
            FlowSet<RefIntPair> preSet = this.fullSet.clone();
            if (((Stmt)s2).containsInvokeExpr()) {
                this.uListAddTopToFlowSet(this.refTypeInstFields, genSet, preSet);
                this.uListAddTopToFlowSet(this.refTypeStaticFields, genSet, preSet);
            }
            for (ValueBox box : s2.getDefBoxes()) {
                Value val = box.getValue();
                if (!BranchedRefVarsAnalysis.isAnalyzedRef(val)) continue;
                this.uAddTopToFlowSet(val, genSet, preSet);
            }
            if (s2 instanceof DefinitionStmt) {
                Value lo;
                DefinitionStmt as = (DefinitionStmt)s2;
                Value ro = as.getRightOp();
                if (ro instanceof CastExpr) {
                    ro = ((CastExpr)ro).getOp();
                }
                if (BranchedRefVarsAnalysis.isAnalyzedRef(lo = as.getLeftOp())) {
                    if (BranchedRefVarsAnalysis.isAlwaysNonNull(ro)) {
                        this.uAddInfoToFlowSet(lo, 2, genSet, preSet);
                    } else if (BranchedRefVarsAnalysis.isAlwaysNull(ro)) {
                        this.uAddInfoToFlowSet(lo, 1, genSet, preSet);
                    } else if (BranchedRefVarsAnalysis.isAlwaysTop(ro)) {
                        this.uAddTopToFlowSet(lo, genSet, preSet);
                    }
                }
            }
            HashSet<Value> analyzedChecksSet = new HashSet<Value>(5, 0.7f);
            HashSet<Value> arrayRefChecksSet = new HashSet<Value>(5, 0.7f);
            HashSet<Value> instanceFieldRefChecksSet = new HashSet<Value>(5, 0.7f);
            HashSet<Value> instanceInvokeExprChecksSet = new HashSet<Value>(5, 0.7f);
            HashSet<Value> lengthExprChecksSet = new HashSet<Value>(5, 0.7f);
            for (ValueBox next : s2.getUseBoxes()) {
                base = null;
                boxValue = next.getValue();
                if (boxValue instanceof InstanceFieldRef) {
                    base = ((InstanceFieldRef)boxValue).getBase();
                    instanceFieldRefChecksSet.add(base);
                } else if (boxValue instanceof ArrayRef) {
                    base = ((ArrayRef)boxValue).getBase();
                    arrayRefChecksSet.add(base);
                } else if (boxValue instanceof InstanceInvokeExpr) {
                    base = ((InstanceInvokeExpr)boxValue).getBase();
                    instanceInvokeExprChecksSet.add(base);
                } else if (boxValue instanceof LengthExpr) {
                    base = ((LengthExpr)boxValue).getOp();
                    lengthExprChecksSet.add(base);
                } else if (s2 instanceof ThrowStmt) {
                    base = ((ThrowStmt)s2).getOp();
                } else if (s2 instanceof MonitorStmt) {
                    base = ((MonitorStmt)s2).getOp();
                }
                if (base == null || !BranchedRefVarsAnalysis.isAnalyzedRef(base)) continue;
                this.uAddInfoToFlowSet(base, 2, genSet, preSet);
                analyzedChecksSet.add(base);
            }
            for (ValueBox name : s2.getDefBoxes()) {
                base = null;
                boxValue = name.getValue();
                if (boxValue instanceof InstanceFieldRef) {
                    base = ((InstanceFieldRef)boxValue).getBase();
                    instanceFieldRefChecksSet.add(base);
                } else if (boxValue instanceof ArrayRef) {
                    base = ((ArrayRef)boxValue).getBase();
                    arrayRefChecksSet.add(base);
                } else if (boxValue instanceof InstanceInvokeExpr) {
                    base = ((InstanceInvokeExpr)boxValue).getBase();
                    instanceInvokeExprChecksSet.add(base);
                } else if (boxValue instanceof LengthExpr) {
                    base = ((LengthExpr)boxValue).getOp();
                    lengthExprChecksSet.add(base);
                } else if (s2 instanceof ThrowStmt) {
                    base = ((ThrowStmt)s2).getOp();
                } else if (s2 instanceof MonitorStmt) {
                    base = ((MonitorStmt)s2).getOp();
                }
                if (base == null || !BranchedRefVarsAnalysis.isAnalyzedRef(base)) continue;
                this.uAddInfoToFlowSet(base, 2, genSet, preSet);
                analyzedChecksSet.add(base);
            }
            this.unitToGenerateSet.put(s2, genSet);
            this.unitToPreserveSet.put(s2, preSet);
            this.unitToAnalyzedChecksSet.put(s2, analyzedChecksSet);
            this.unitToArrayRefChecksSet.put(s2, arrayRefChecksSet);
            this.unitToInstanceFieldRefChecksSet.put(s2, instanceFieldRefChecksSet);
            this.unitToInstanceInvokeExprChecksSet.put(s2, instanceInvokeExprChecksSet);
            this.unitToLengthExprChecksSet.put(s2, lengthExprChecksSet);
        }
    }

    @Override
    protected void flowThrough(FlowSet<RefIntPair> in, Unit stmt, List<FlowSet<RefIntPair>> outFall, List<FlowSet<RefIntPair>> outBranch) {
        FlowSet<RefIntPair> out = this.tempFlowSet;
        FlowSet<RefIntPair> pre = this.unitToPreserveSet.get(stmt);
        FlowSet<RefIntPair> gen = this.unitToGenerateSet.get(stmt);
        in.intersection(pre, out);
        out.union(gen, out);
        if (stmt instanceof AssignStmt) {
            Value leftOp;
            AssignStmt as = (AssignStmt)stmt;
            Value rightOp = as.getRightOp();
            if (rightOp instanceof CastExpr) {
                rightOp = ((CastExpr)rightOp).getOp();
            }
            if (BranchedRefVarsAnalysis.isAnalyzedRef(leftOp = as.getLeftOp()) && BranchedRefVarsAnalysis.isAnalyzedRef(rightOp)) {
                int roInfo = this.refInfo(rightOp, in);
                if (roInfo == 99) {
                    this.uAddTopToFlowSet(leftOp, out);
                } else if (roInfo != 0) {
                    this.uAddInfoToFlowSet(leftOp, roInfo, out);
                }
            }
        }
        for (FlowSet<RefIntPair> fs : outBranch) {
            this.copy(out, fs);
        }
        for (FlowSet<RefIntPair> fs : outFall) {
            this.copy(out, fs);
        }
        if (stmt instanceof IfStmt) {
            Value cond = ((IfStmt)stmt).getCondition();
            Value op1 = ((BinopExpr)cond).getOp1();
            Value op2 = ((BinopExpr)cond).getOp2();
            if (!BranchedRefVarsAnalysis.isAlwaysTop(op1) && !BranchedRefVarsAnalysis.isAlwaysTop(op2) && (BranchedRefVarsAnalysis.isAnalyzedRef(op1) || BranchedRefVarsAnalysis.isAnalyzedRef(op2))) {
                boolean op2isKnown;
                Value toGen = null;
                int toGenInfo = 0;
                int op1Info = this.anyRefInfo(op1, in);
                int op2Info = this.anyRefInfo(op2, in);
                boolean bl = op2isKnown = op2Info == 1 || op2Info == 2;
                if (op1Info == 1 || op1Info == 2) {
                    if (!op2isKnown) {
                        toGen = op2;
                        toGenInfo = op1Info;
                    }
                } else if (op2isKnown) {
                    toGen = op1;
                    toGenInfo = op2Info;
                }
                if (toGen != null && BranchedRefVarsAnalysis.isAnalyzedRef(toGen)) {
                    int fInfo = 0;
                    int bInfo = 0;
                    if (cond instanceof EqExpr) {
                        bInfo = toGenInfo;
                        if (toGenInfo == 1) {
                            fInfo = 2;
                        }
                    } else if (cond instanceof NeExpr) {
                        fInfo = toGenInfo;
                        if (toGenInfo == 1) {
                            bInfo = 2;
                        }
                    } else {
                        throw new RuntimeException("invalid condition");
                    }
                    if (fInfo != 0) {
                        for (FlowSet<RefIntPair> fs : outFall) {
                            this.copy(out, fs);
                            this.uAddInfoToFlowSet(toGen, fInfo, fs);
                        }
                    }
                    if (bInfo != 0) {
                        for (FlowSet<RefIntPair> fs : outBranch) {
                            this.copy(out, fs);
                            this.uAddInfoToFlowSet(toGen, bInfo, fs);
                        }
                    }
                }
            }
        }
    }

    @Override
    protected void merge(FlowSet<RefIntPair> in1, FlowSet<RefIntPair> in2, FlowSet<RefIntPair> out) {
        FlowSet<RefIntPair> inSet1Copy = in1.clone();
        FlowSet<RefIntPair> inSet2Copy = in2.clone();
        in1.intersection(in2, out);
        for (EquivalentValue r : this.refTypeValues) {
            int refInfoIn2;
            int refInfoIn1 = this.refInfo(r, inSet1Copy);
            if (refInfoIn1 == (refInfoIn2 = this.refInfo(r, inSet2Copy))) continue;
            if (refInfoIn1 == 99 || refInfoIn2 == 99) {
                this.uAddTopToFlowSet(r, out);
                continue;
            }
            if (refInfoIn1 == 0) {
                this.uAddInfoToFlowSet(r, refInfoIn2, out);
                continue;
            }
            if (refInfoIn2 == 0) {
                this.uAddInfoToFlowSet(r, refInfoIn1, out);
                continue;
            }
            this.uAddTopToFlowSet(r, out);
        }
    }

    @Override
    protected void copy(FlowSet<RefIntPair> source, FlowSet<RefIntPair> dest) {
        source.copy(dest);
    }

    @Override
    protected FlowSet<RefIntPair> newInitialFlow() {
        return this.emptySet.clone();
    }

    @Override
    protected FlowSet<RefIntPair> entryInitialFlow() {
        return this.fullSet.clone();
    }

    @Override
    public boolean treatTrapHandlersAsEntries() {
        return true;
    }
}

