/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.toolkits.annotation.arraycheck;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.LinkedList;
import soot.jimple.toolkits.annotation.arraycheck.IntContainer;
import soot.jimple.toolkits.annotation.arraycheck.WeightedDirectedEdge;

class WeightedDirectedSparseGraph {
    private boolean isUnknown;
    private Hashtable<Object, Hashtable<Object, IntContainer>> sources = new Hashtable();
    private HashSet vertexes = new HashSet();
    private final HashSet<Object> reachableNodes = new HashSet();
    private final HashSet<WeightedDirectedEdge> reachableEdges = new HashSet();
    private final Hashtable<Object, IntContainer> distance = new Hashtable();
    private final Hashtable<Object, Object> pei = new Hashtable();

    public WeightedDirectedSparseGraph(HashSet vertexset) {
        this(vertexset, false);
    }

    public WeightedDirectedSparseGraph(HashSet vertexset, boolean isTop) {
        this.vertexes = vertexset;
        this.isUnknown = !isTop;
    }

    public void setTop() {
        this.isUnknown = false;
        this.sources.clear();
    }

    public HashSet getVertexes() {
        return this.vertexes;
    }

    public void setVertexes(HashSet newset) {
        this.vertexes = newset;
        this.sources.clear();
    }

    public void addEdge(Object from, Object to, int w) {
        IntContainer weight;
        if (this.isUnknown) {
            throw new RuntimeException("Unknown graph can not have edges");
        }
        Hashtable<Object, IntContainer> targets = this.sources.get(from);
        if (targets == null) {
            targets = new Hashtable();
            this.sources.put(from, targets);
        }
        if ((weight = targets.get(to)) == null) {
            weight = new IntContainer(w);
            targets.put(to, weight);
        } else if (weight.value > w) {
            weight.value = w;
        }
    }

    public void addMutualEdges(Object from, Object to, int weight) {
        this.addEdge(from, to, weight);
        this.addEdge(to, from, -weight);
    }

    public void removeEdge(Object from, Object to) {
        Hashtable<Object, IntContainer> targets = this.sources.get(from);
        if (targets == null) {
            return;
        }
        targets.remove(to);
        if (targets.size() == 0) {
            this.sources.remove(from);
        }
    }

    public boolean hasEdge(Object from, Object to) {
        Hashtable<Object, IntContainer> targets = this.sources.get(from);
        if (targets == null) {
            return false;
        }
        return targets.containsKey(to);
    }

    public int edgeWeight(Object from, Object to) {
        Hashtable<Object, IntContainer> targets = this.sources.get(from);
        if (targets == null) {
            throw new RuntimeException("No such edge (" + from + " ," + to + ") exists.");
        }
        IntContainer weight = targets.get(to);
        if (weight == null) {
            throw new RuntimeException("No such edge (" + from + ", " + to + ") exists.");
        }
        return weight.value;
    }

    public void unionSelf(WeightedDirectedSparseGraph other) {
        if (other == null) {
            return;
        }
        WeightedDirectedSparseGraph othergraph = other;
        if (othergraph.isUnknown) {
            return;
        }
        if (this.isUnknown) {
            this.addAll(othergraph);
        }
        ArrayList<Object> sourceList = new ArrayList<Object>(this.sources.keySet());
        for (Object e : sourceList) {
            Hashtable<Object, IntContainer> src1 = this.sources.get(e);
            Hashtable<Object, IntContainer> src2 = othergraph.sources.get(e);
            if (src2 == null) {
                this.sources.remove(e);
                continue;
            }
            ArrayList<Object> targetList = new ArrayList<Object>(src1.keySet());
            for (Object e2 : targetList) {
                IntContainer w1 = src1.get(e2);
                IntContainer w2 = src2.get(e2);
                if (w2 == null) {
                    src1.remove(e2);
                    continue;
                }
                if (w2.value <= w1.value) continue;
                w1.value = w2.value;
            }
            if (src1.size() != 0) continue;
            this.sources.remove(e);
        }
    }

    public void widenEdges(WeightedDirectedSparseGraph othergraph) {
        WeightedDirectedSparseGraph other = othergraph;
        if (other.isUnknown) {
            return;
        }
        Hashtable<Object, Hashtable<Object, IntContainer>> othersources = other.sources;
        ArrayList<Object> sourceList = new ArrayList<Object>(this.sources.keySet());
        for (Object e : sourceList) {
            Hashtable<Object, IntContainer> thistargets = this.sources.get(e);
            Hashtable<Object, IntContainer> othertargets = othersources.get(e);
            if (othertargets == null) {
                this.sources.remove(e);
                continue;
            }
            ArrayList<Object> targetList = new ArrayList<Object>(thistargets.keySet());
            for (Object e2 : targetList) {
                IntContainer thisweight = thistargets.get(e2);
                IntContainer otherweight = othertargets.get(e2);
                if (otherweight == null) {
                    thistargets.remove(e2);
                    continue;
                }
                if (thisweight.value <= otherweight.value) continue;
                thistargets.remove(e2);
            }
            if (thistargets.size() != 0) continue;
            this.sources.remove(e);
        }
    }

    public void killNode(Object tokill) {
        if (!this.vertexes.contains(tokill)) {
            return;
        }
        this.makeShortestPathGraph();
        ArrayList<Object> sourceList = new ArrayList<Object>(this.sources.keySet());
        for (Object e : sourceList) {
            Hashtable<Object, IntContainer> targets = this.sources.get(e);
            targets.remove(tokill);
            if (targets.size() != 0) continue;
            this.sources.remove(e);
        }
        this.sources.remove(tokill);
        this.makeShortestPathGraph();
    }

    public void updateWeight(Object which, int c) {
        for (Object from : this.sources.keySet()) {
            Hashtable<Object, IntContainer> targets = this.sources.get(from);
            IntContainer weight = targets.get(which);
            if (weight == null) continue;
            weight.value += c;
        }
        Hashtable<Object, IntContainer> toset = this.sources.get(which);
        if (toset == null) {
            return;
        }
        for (Object to : toset.keySet()) {
            IntContainer weight = toset.get(to);
            weight.value -= c;
        }
    }

    public void clear() {
        this.sources.clear();
    }

    public void replaceAllEdges(WeightedDirectedSparseGraph other) {
        this.isUnknown = other.isUnknown;
        this.vertexes = other.vertexes;
        this.sources = other.sources;
    }

    public void addBoundedAll(WeightedDirectedSparseGraph another) {
        this.isUnknown = another.isUnknown;
        Hashtable<Object, Hashtable<Object, IntContainer>> othersources = another.sources;
        for (Object src : this.vertexes) {
            Hashtable<Object, IntContainer> othertargets = othersources.get(src);
            if (othertargets == null) continue;
            Hashtable<Object, IntContainer> thistargets = new Hashtable<Object, IntContainer>();
            for (Object key : othertargets.keySet()) {
                if (!this.vertexes.contains(key)) continue;
                IntContainer weight = othertargets.get(key);
                thistargets.put(key, weight.dup());
            }
            if (thistargets.size() <= 0) continue;
            this.sources.put(src, thistargets);
        }
    }

    public void addAll(WeightedDirectedSparseGraph othergraph) {
        WeightedDirectedSparseGraph another = othergraph;
        this.isUnknown = another.isUnknown;
        this.clear();
        Hashtable<Object, Hashtable<Object, IntContainer>> othersources = another.sources;
        for (Object src : othersources.keySet()) {
            Hashtable<Object, IntContainer> othertargets = othersources.get(src);
            Hashtable<Object, IntContainer> thistargets = new Hashtable<Object, IntContainer>(othersources.size());
            this.sources.put(src, thistargets);
            for (Object target : othertargets.keySet()) {
                IntContainer otherweight = othertargets.get(target);
                thistargets.put(target, otherweight.dup());
            }
        }
    }

    public boolean equals(Object other) {
        if (other == null || !(other instanceof WeightedDirectedSparseGraph)) {
            return false;
        }
        WeightedDirectedSparseGraph othergraph = (WeightedDirectedSparseGraph)other;
        if (this.isUnknown != othergraph.isUnknown) {
            return false;
        }
        if (this.isUnknown) {
            return true;
        }
        Hashtable<Object, Hashtable<Object, IntContainer>> othersources = othergraph.sources;
        if (this.sources.size() != othersources.size()) {
            return false;
        }
        for (Object src : this.sources.keySet()) {
            Hashtable<Object, IntContainer> thistarget = this.sources.get(src);
            Hashtable<Object, IntContainer> othertarget = othersources.get(src);
            if (othertarget == null || thistarget.size() != othertarget.size()) {
                return false;
            }
            for (Object target : thistarget.keySet()) {
                IntContainer thisweight = thistarget.get(target);
                IntContainer otherweight = othertarget.get(target);
                if (otherweight == null) {
                    return false;
                }
                if (thisweight.value == otherweight.value) continue;
                return false;
            }
        }
        return true;
    }

    public String toString() {
        Object graphstring = "WeightedDirectedSparseGraph:\n";
        graphstring = (String)graphstring + this.vertexes + "\n";
        for (Object src : this.sources.keySet()) {
            graphstring = (String)graphstring + src + " : ";
            Hashtable<Object, IntContainer> targets = this.sources.get(src);
            for (Object target : targets.keySet()) {
                IntContainer weight = targets.get(target);
                graphstring = (String)graphstring + target + "(" + weight.value + ")  ";
            }
            graphstring = (String)graphstring + "\n";
        }
        return graphstring;
    }

    public WeightedDirectedSparseGraph dup() {
        WeightedDirectedSparseGraph newone = new WeightedDirectedSparseGraph(this.vertexes);
        newone.addAll(this);
        return newone;
    }

    public boolean makeShortestPathGraph() {
        boolean nonegcycle = true;
        ArrayList<Object> srcList = new ArrayList<Object>(this.sources.keySet());
        for (Object e : srcList) {
            if (this.SSSPFinder(e)) continue;
            nonegcycle = false;
        }
        return nonegcycle;
    }

    private boolean SSSPFinder(Object src) {
        Hashtable<Object, IntContainer> outedges = this.sources.get(src);
        if (outedges == null || outedges.size() == 0) {
            return true;
        }
        this.InitializeSingleSource(src);
        this.getReachableNodesAndEdges(src);
        int vSize = this.reachableNodes.size();
        for (int i = 0; i < vSize; ++i) {
            for (WeightedDirectedEdge edge : this.reachableEdges) {
                this.Relax(edge.from, edge.to, edge.weight);
            }
        }
        this.distance.remove(src);
        for (WeightedDirectedEdge edge : this.reachableEdges) {
            IntContainer dto;
            IntContainer dfrom = this.distance.get(edge.from);
            if (dfrom == null || (dto = this.distance.get(edge.to)) == null || dto.value <= dfrom.value + edge.weight) continue;
            return false;
        }
        outedges.clear();
        for (Object to : this.distance.keySet()) {
            IntContainer dist = this.distance.get(to);
            outedges.put(to, dist.dup());
        }
        return true;
    }

    private void InitializeSingleSource(Object src) {
        this.reachableNodes.clear();
        this.reachableEdges.clear();
        this.pei.clear();
        this.distance.clear();
        this.distance.put(src, new IntContainer(0));
    }

    private void getReachableNodesAndEdges(Object src) {
        LinkedList<Object> worklist = new LinkedList<Object>();
        this.reachableNodes.add(src);
        worklist.add(src);
        while (!worklist.isEmpty()) {
            Object from = worklist.removeFirst();
            Hashtable<Object, IntContainer> targets = this.sources.get(from);
            if (targets == null) continue;
            for (Object target : targets.keySet()) {
                if (!this.reachableNodes.contains(target)) {
                    worklist.add(target);
                    this.reachableNodes.add(target);
                }
                IntContainer weight = targets.get(target);
                this.reachableEdges.add(new WeightedDirectedEdge(from, target, weight.value));
            }
        }
    }

    private void Relax(Object from, Object to, int weight) {
        IntContainer dfrom = this.distance.get(from);
        IntContainer dto = this.distance.get(to);
        if (dfrom != null) {
            int vfrom = dfrom.value;
            int vnew = vfrom + weight;
            if (dto == null) {
                this.distance.put(to, new IntContainer(vnew));
                this.pei.put(to, from);
            } else {
                int vto = dto.value;
                if (vto > vnew) {
                    this.distance.put(to, new IntContainer(vnew));
                    this.pei.put(to, from);
                }
            }
        }
    }
}

