/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.spark.solver;

import java.util.HashSet;
import java.util.Stack;
import soot.jimple.spark.pag.Node;
import soot.jimple.spark.pag.PAG;
import soot.jimple.spark.pag.VarNode;

public class TopoSorter {
    protected boolean ignoreTypes;
    protected PAG pag;
    protected int nextFinishNumber = 1;
    protected HashSet<VarNode> visited;

    public void sort() {
        for (VarNode v : this.pag.getVarNodeNumberer()) {
            this.dfsVisit(v);
        }
        this.visited = null;
    }

    public TopoSorter(PAG pag, boolean ignoreTypes) {
        this.pag = pag;
        this.ignoreTypes = ignoreTypes;
        this.visited = new HashSet();
    }

    protected void dfsVisit(VarNode n) {
        if (!this.visited.add(n)) {
            return;
        }
        Stack<VarNode> stack = new Stack<VarNode>();
        HashSet<VarNode> visitedSuccessors = new HashSet<VarNode>();
        stack.add(n);
        while (!stack.isEmpty()) {
            VarNode s2 = (VarNode)stack.peek();
            if (visitedSuccessors.add(s2)) {
                Node[] succs;
                for (Node element : succs = this.pag.simpleLookup(s2)) {
                    if (!this.ignoreTypes && !this.pag.getTypeManager().castNeverFails(n.getType(), element.getType()) || !this.visited.add((VarNode)element)) continue;
                    stack.push((VarNode)element);
                }
                continue;
            }
            stack.pop();
            s2.setFinishingNumber(this.nextFinishNumber++);
        }
    }
}

