/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.spark.solver;

import java.util.Collections;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Set;
import java.util.TreeSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.RefType;
import soot.Scene;
import soot.SootClass;
import soot.Type;
import soot.jimple.spark.pag.AllocDotField;
import soot.jimple.spark.pag.AllocNode;
import soot.jimple.spark.pag.ClassConstantNode;
import soot.jimple.spark.pag.FieldRefNode;
import soot.jimple.spark.pag.NewInstanceNode;
import soot.jimple.spark.pag.Node;
import soot.jimple.spark.pag.PAG;
import soot.jimple.spark.pag.SparkField;
import soot.jimple.spark.pag.VarNode;
import soot.jimple.spark.sets.P2SetVisitor;
import soot.jimple.spark.sets.PointsToSetInternal;
import soot.jimple.spark.solver.OnFlyCallGraph;
import soot.jimple.spark.solver.Propagator;
import soot.jimple.spark.solver.TopoSorter;
import soot.util.queue.QueueReader;

public class PropWorklist
extends Propagator {
    private static final Logger logger = LoggerFactory.getLogger(PropWorklist.class);
    protected final TreeSet<VarNode> varNodeWorkList = new TreeSet();
    protected PAG pag;
    protected OnFlyCallGraph ofcg;

    public PropWorklist(PAG pag) {
        this.pag = pag;
    }

    @Override
    public void propagate() {
        this.ofcg = this.pag.getOnFlyCallGraph();
        new TopoSorter(this.pag, false).sort();
        for (AllocNode object : this.pag.allocSources()) {
            this.handleAllocNode(object);
        }
        boolean verbose = this.pag.getOpts().verbose();
        do {
            VarNode vsrc;
            if (verbose) {
                logger.debug("Worklist has " + this.varNodeWorkList.size() + " nodes.");
            }
            while ((vsrc = this.varNodeWorkList.pollFirst()) != null) {
                this.handleVarNode(vsrc);
            }
            if (verbose) {
                logger.debug("Now handling field references");
            }
            for (final VarNode varNode : this.pag.storeSources()) {
                Node[] targets;
                for (Node element0 : targets = this.pag.storeLookup(varNode)) {
                    final FieldRefNode target = (FieldRefNode)element0;
                    target.getBase().makeP2Set().forall(new P2SetVisitor(){

                        @Override
                        public final void visit(Node n) {
                            AllocDotField nDotF = PropWorklist.this.pag.makeAllocDotField((AllocNode)n, target.getField());
                            if (PropWorklist.this.ofcg != null) {
                                PropWorklist.this.ofcg.updatedFieldRef(nDotF, varNode.getP2Set());
                            }
                            nDotF.makeP2Set().addAll(varNode.getP2Set(), null);
                        }
                    });
                }
            }
            HashSet<Object[]> edgesToPropagate = new HashSet<Object[]>();
            for (FieldRefNode object : this.pag.loadSources()) {
                this.handleFieldRefNode(object, edgesToPropagate);
            }
            Set<PointsToSetInternal> set = Collections.newSetFromMap(new IdentityHashMap());
            for (Object[] pair : edgesToPropagate) {
                PointsToSetInternal nDotF = (PointsToSetInternal)pair[0];
                PointsToSetInternal newP2Set = nDotF.getNewSet();
                VarNode loadTarget = (VarNode)pair[1];
                if (loadTarget.makeP2Set().addAll(newP2Set, null)) {
                    this.varNodeWorkList.add(loadTarget);
                }
                set.add(nDotF);
            }
            for (PointsToSetInternal nDotF : set) {
                nDotF.flushNew();
            }
        } while (!this.varNodeWorkList.isEmpty());
    }

    protected boolean handleAllocNode(AllocNode src) {
        Node[] targets;
        boolean ret = false;
        for (Node element : targets = this.pag.allocLookup(src)) {
            if (!element.makeP2Set().add(src)) continue;
            this.varNodeWorkList.add((VarNode)element);
            ret = true;
        }
        return ret;
    }

    protected boolean handleVarNode(VarNode src) {
        Node[] storeTargets;
        boolean ret = false;
        boolean flush = true;
        if (src.getReplacement() != src) {
            throw new RuntimeException("Got bad node " + src + " with rep " + src.getReplacement());
        }
        final PointsToSetInternal newP2Set = src.getP2Set().getNewSet();
        if (newP2Set.isEmpty()) {
            return false;
        }
        if (this.ofcg != null) {
            QueueReader<Node> addedEdges = this.pag.edgeReader();
            this.ofcg.updatedNode(src);
            this.ofcg.build();
            while (addedEdges.hasNext()) {
                Node edgeTgt;
                Node edgeSrc;
                Node addedSrc = addedEdges.next();
                Node addedTgt = addedEdges.next();
                ret = true;
                if (addedSrc instanceof VarNode) {
                    edgeSrc = (VarNode)addedSrc.getReplacement();
                    if (addedTgt instanceof VarNode) {
                        edgeTgt = (VarNode)addedTgt.getReplacement();
                        if (!edgeTgt.makeP2Set().addAll(edgeSrc.getP2Set(), null)) continue;
                        this.varNodeWorkList.add((VarNode)edgeTgt);
                        if (edgeTgt != src) continue;
                        flush = false;
                        continue;
                    }
                    if (!(addedTgt instanceof NewInstanceNode) || !(edgeTgt = (NewInstanceNode)addedTgt.getReplacement()).makeP2Set().addAll(edgeSrc.getP2Set(), null)) continue;
                    for (Node element : this.pag.assignInstanceLookup((NewInstanceNode)edgeTgt)) {
                        this.varNodeWorkList.add((VarNode)element);
                        if (element != src) continue;
                        flush = false;
                    }
                    continue;
                }
                if (addedSrc instanceof AllocNode) {
                    VarNode edgeTgt2 = (VarNode)addedTgt.getReplacement();
                    if (!edgeTgt2.makeP2Set().add(addedSrc)) continue;
                    this.varNodeWorkList.add(edgeTgt2);
                    if (edgeTgt2 != src) continue;
                    flush = false;
                    continue;
                }
                if (!(addedSrc instanceof NewInstanceNode) || !(addedTgt instanceof VarNode)) continue;
                edgeSrc = (NewInstanceNode)addedSrc.getReplacement();
                edgeTgt = (VarNode)addedTgt.getReplacement();
                addedSrc.getP2Set().forall(new P2SetVisitor((VarNode)edgeTgt, (NewInstanceNode)edgeSrc){
                    final /* synthetic */ VarNode val$edgeTgt;
                    final /* synthetic */ NewInstanceNode val$edgeSrc;
                    {
                        this.val$edgeTgt = varNode;
                        this.val$edgeSrc = newInstanceNode;
                    }

                    @Override
                    public void visit(Node n) {
                        if (n instanceof ClassConstantNode) {
                            ClassConstantNode ccn = (ClassConstantNode)n;
                            Type ccnType = ccn.getClassConstant().toSootType();
                            SootClass targetClass = ((RefType)ccnType).getSootClass();
                            if (targetClass.resolvingLevel() == 0) {
                                Scene.v().forceResolve(targetClass.getName(), 2);
                            }
                            this.val$edgeTgt.makeP2Set().add(PropWorklist.this.pag.makeAllocNode(this.val$edgeSrc.getValue(), ccnType, ccn.getMethod()));
                            PropWorklist.this.varNodeWorkList.add(this.val$edgeTgt);
                        }
                    }
                });
                if (!edgeTgt.makeP2Set().add(addedSrc) || edgeTgt != src) continue;
                flush = false;
            }
        }
        Node[] simpleTargets = this.pag.simpleLookup(src);
        for (Node element : simpleTargets) {
            if (!element.makeP2Set().addAll(newP2Set, null)) continue;
            this.varNodeWorkList.add((VarNode)element);
            if (element == src) {
                flush = false;
            }
            ret = true;
        }
        for (Node element : storeTargets = this.pag.storeLookup(src)) {
            FieldRefNode fr = (FieldRefNode)element;
            final SparkField f = fr.getField();
            ret = fr.getBase().getP2Set().forall(new P2SetVisitor(){

                @Override
                public final void visit(Node n) {
                    AllocDotField nDotF = PropWorklist.this.pag.makeAllocDotField((AllocNode)n, f);
                    if (nDotF.makeP2Set().addAll(newP2Set, null)) {
                        this.returnValue = true;
                    }
                }
            }) | ret;
        }
        final HashSet storesToPropagate = new HashSet();
        final HashSet loadsToPropagate = new HashSet();
        for (FieldRefNode fr : src.getAllFieldRefs()) {
            Node[] loadTargets;
            final SparkField field = fr.getField();
            final Node[] storeSources = this.pag.storeInvLookup(fr);
            if (storeSources.length > 0) {
                newP2Set.forall(new P2SetVisitor(){

                    @Override
                    public final void visit(Node n) {
                        AllocDotField nDotF = PropWorklist.this.pag.makeAllocDotField((AllocNode)n, field);
                        for (Node element : storeSources) {
                            Node[] pair = new Node[]{element, nDotF.getReplacement()};
                            storesToPropagate.add(pair);
                        }
                    }
                });
            }
            if ((loadTargets = this.pag.loadLookup(fr)).length <= 0) continue;
            newP2Set.forall(new P2SetVisitor(){

                @Override
                public final void visit(Node n) {
                    AllocDotField nDotF = PropWorklist.this.pag.makeAllocDotField((AllocNode)n, field);
                    if (nDotF != null) {
                        for (Node element : loadTargets) {
                            Node[] pair = new Node[]{nDotF.getReplacement(), element};
                            loadsToPropagate.add(pair);
                        }
                    }
                }
            });
        }
        if (flush) {
            src.getP2Set().flushNew();
        }
        for (Node[] p : storesToPropagate) {
            VarNode storeSource = (VarNode)p[0];
            AllocDotField nDotF = (AllocDotField)p[1];
            if (!nDotF.makeP2Set().addAll(storeSource.getP2Set(), null)) continue;
            ret = true;
        }
        for (Node[] p : loadsToPropagate) {
            AllocDotField nDotF = (AllocDotField)p[0];
            VarNode loadTarget = (VarNode)p[1];
            if (!loadTarget.makeP2Set().addAll(nDotF.getP2Set(), null)) continue;
            this.varNodeWorkList.add(loadTarget);
            ret = true;
        }
        return ret;
    }

    protected final void handleFieldRefNode(FieldRefNode src, final HashSet<Object[]> edgesToPropagate) {
        final Node[] loadTargets = this.pag.loadLookup(src);
        if (loadTargets.length == 0) {
            return;
        }
        final SparkField field = src.getField();
        src.getBase().getP2Set().forall(new P2SetVisitor(){

            @Override
            public final void visit(Node n) {
                PointsToSetInternal p2Set;
                AllocDotField nDotF = PropWorklist.this.pag.makeAllocDotField((AllocNode)n, field);
                if (nDotF != null && !(p2Set = nDotF.getP2Set()).getNewSet().isEmpty()) {
                    for (Node element : loadTargets) {
                        Object[] pair = new Object[]{p2Set, element};
                        edgesToPropagate.add(pair);
                    }
                }
            }
        });
    }
}

