/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.spark.geom.dataRep;

import soot.jimple.spark.geom.dataRep.SegmentNode;

public class RectangleNode
extends SegmentNode {
    public long L_prime;

    public RectangleNode() {
    }

    public RectangleNode(RectangleNode other) {
        this.copyRectangle(other);
    }

    public void copyRectangle(RectangleNode other) {
        this.I1 = other.I1;
        this.I2 = other.I2;
        this.L = other.L;
        this.L_prime = other.L_prime;
    }

    public RectangleNode(long I1, long I2, long L2, long LL) {
        super(I1, I2, L2);
        this.L_prime = LL;
    }

    public boolean equals(RectangleNode other) {
        return this.I1 == other.I1 && this.I2 == other.I2 && this.L == other.L && this.L_prime == other.L_prime;
    }

    @Override
    public long yEnd() {
        return this.I2 + this.L_prime;
    }

    @Override
    public boolean intersect(SegmentNode q) {
        RectangleNode p = this;
        if (q instanceof SegmentNode) {
            if (this.point_within_rectangle(q.I1, q.I2, p) || this.point_within_rectangle(q.I1 + q.L - 1L, q.I2 + q.L - 1L, p)) {
                return true;
            }
            return this.diagonal_line_intersect_horizontal(q, p.I1, p.I2, p.L) || this.diagonal_line_intersect_horizontal(q, p.I1, p.I2 + p.L_prime - 1L, p.L) || this.diagonal_line_intersect_vertical(q, p.I1, p.I2, p.L_prime) || this.diagonal_line_intersect_vertical(q, p.I1 + p.L - 1L, p.I2, p.L_prime);
        }
        RectangleNode rect_q = (RectangleNode)q;
        return p.I2 < rect_q.I2 + rect_q.L_prime && p.I2 + p.L_prime > rect_q.I2 && p.I1 + p.L > rect_q.I1 && p.I1 < rect_q.I1 + rect_q.L;
    }

    private boolean point_within_rectangle(long x, long y, RectangleNode rect) {
        return x >= rect.I1 && x < rect.I1 + rect.L && y >= rect.I2 && y < rect.I2 + rect.L_prime;
    }

    private boolean diagonal_line_intersect_vertical(SegmentNode p, long x, long y, long L2) {
        long y_cross;
        return x >= p.I1 && x < p.I1 + p.L && (y_cross = x - p.I1 + p.I2) >= y && y_cross < y + L2;
    }

    private boolean diagonal_line_intersect_horizontal(SegmentNode p, long x, long y, long L2) {
        long x_cross;
        return y >= p.I2 && y < p.I2 + p.L && (x_cross = y - p.I2 + p.I1) >= x && x_cross < x + L2;
    }
}

