/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.internal;

import java.util.ArrayList;
import java.util.List;
import soot.Unit;
import soot.UnitBox;
import soot.UnitPrinter;
import soot.Value;
import soot.ValueBox;
import soot.baf.Baf;
import soot.baf.PlaceholderInst;
import soot.baf.TableSwitchInst;
import soot.jimple.ConvertToBaf;
import soot.jimple.Jimple;
import soot.jimple.JimpleToBafContext;
import soot.jimple.StmtSwitch;
import soot.jimple.TableSwitchStmt;
import soot.jimple.internal.AbstractSwitchStmt;
import soot.util.Switch;

public class JTableSwitchStmt
extends AbstractSwitchStmt
implements TableSwitchStmt {
    protected int lowIndex;
    protected int highIndex;

    public JTableSwitchStmt(Value key, int lowIndex, int highIndex, List<? extends Unit> targets, Unit defaultTarget) {
        this(Jimple.v().newImmediateBox(key), lowIndex, highIndex, JTableSwitchStmt.getTargetBoxesArray(targets, Jimple.v()::newStmtBox), Jimple.v().newStmtBox(defaultTarget));
    }

    public JTableSwitchStmt(Value key, int lowIndex, int highIndex, List<? extends UnitBox> targets, UnitBox defaultTarget) {
        this(Jimple.v().newImmediateBox(key), lowIndex, highIndex, targets.toArray(new UnitBox[targets.size()]), defaultTarget);
    }

    protected JTableSwitchStmt(ValueBox keyBox, int lowIndex, int highIndex, UnitBox[] targetBoxes, UnitBox defaultTargetBox) {
        super(keyBox, defaultTargetBox, targetBoxes);
        if (lowIndex > highIndex) {
            throw new RuntimeException("Error creating tableswitch: lowIndex(" + lowIndex + ") can't be greater than highIndex(" + highIndex + ").");
        }
        this.lowIndex = lowIndex;
        this.highIndex = highIndex;
    }

    @Override
    public Object clone() {
        return new JTableSwitchStmt(Jimple.cloneIfNecessary(this.getKey()), this.lowIndex, this.highIndex, this.getTargets(), this.getDefaultTarget());
    }

    public String toString() {
        int endOfLine = 32;
        StringBuilder buf = new StringBuilder("tableswitch(");
        buf.append(this.keyBox.getValue().toString()).append(')').append(' ');
        buf.append('{').append(' ');
        int low = this.lowIndex;
        int high = this.highIndex;
        for (int i = low; i < high; ++i) {
            buf.append("    case ").append(i).append(": goto ");
            Unit target = this.getTarget(i - low);
            buf.append(target == this ? "self" : target).append(';').append(' ');
        }
        buf.append("    case ").append(high).append(": goto ");
        Unit target = this.getTarget(high - low);
        buf.append(target == this ? "self" : target).append(';').append(' ');
        target = this.getDefaultTarget();
        buf.append("    default: goto ");
        buf.append(target == this ? "self" : target).append(';').append(' ');
        buf.append('}');
        return buf.toString();
    }

    @Override
    public void toString(UnitPrinter up) {
        up.literal("tableswitch");
        up.literal("(");
        this.keyBox.toString(up);
        up.literal(")");
        up.newline();
        up.literal("{");
        up.newline();
        int high = this.highIndex;
        for (int i = this.lowIndex; i < high; ++i) {
            this.printCaseTarget(up, i);
        }
        this.printCaseTarget(up, high);
        up.literal("    default: goto ");
        this.defaultTargetBox.toString(up);
        up.literal(";");
        up.newline();
        up.literal("}");
    }

    private void printCaseTarget(UnitPrinter up, int targetIndex) {
        up.literal("    case ");
        up.literal(Integer.toString(targetIndex));
        up.literal(": goto ");
        ((UnitBox)this.targetBoxes.get(targetIndex - this.lowIndex)).toString(up);
        up.literal(";");
        up.newline();
    }

    public List<UnitBox> getTargetBoxes() {
        return this.targetBoxes;
    }

    @Override
    public void setLowIndex(int lowIndex) {
        this.lowIndex = lowIndex;
    }

    @Override
    public void setHighIndex(int highIndex) {
        this.highIndex = highIndex;
    }

    @Override
    public int getLowIndex() {
        return this.lowIndex;
    }

    @Override
    public int getHighIndex() {
        return this.highIndex;
    }

    @Override
    public void apply(Switch sw) {
        ((StmtSwitch)sw).caseTableSwitchStmt(this);
    }

    @Override
    public void convertToBaf(JimpleToBafContext context, List<Unit> out) {
        ((ConvertToBaf)((Object)this.getKey())).convertToBaf(context, out);
        Baf vaf = Baf.v();
        List<Unit> targets = this.getTargets();
        ArrayList<PlaceholderInst> targetPlaceholders = new ArrayList<PlaceholderInst>(targets.size());
        for (Unit target : targets) {
            targetPlaceholders.add(vaf.newPlaceholderInst(target));
        }
        TableSwitchInst u = vaf.newTableSwitchInst(vaf.newPlaceholderInst(this.getDefaultTarget()), this.lowIndex, this.highIndex, targetPlaceholders);
        u.addAllTagsOf(this);
        out.add(u);
    }

    @Override
    public Unit getTargetForValue(int value) {
        int high = this.highIndex;
        int tgtIdx = 0;
        for (int i = this.lowIndex; i < high; ++i) {
            if (value == i) {
                return this.getTarget(tgtIdx);
            }
            ++tgtIdx;
        }
        if (high == value) {
            return this.getTarget(tgtIdx);
        }
        return this.getDefaultTarget();
    }
}

