/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.internal;

import java.util.Collections;
import java.util.List;
import soot.Unit;
import soot.UnitBox;
import soot.UnitPrinter;
import soot.baf.Baf;
import soot.baf.GotoInst;
import soot.jimple.GotoStmt;
import soot.jimple.Jimple;
import soot.jimple.JimpleToBafContext;
import soot.jimple.StmtSwitch;
import soot.jimple.internal.AbstractStmt;
import soot.util.Switch;

public class JGotoStmt
extends AbstractStmt
implements GotoStmt {
    protected final UnitBox targetBox;
    protected final List<UnitBox> targetBoxes;

    public JGotoStmt(Unit target) {
        this(Jimple.v().newStmtBox(target));
    }

    public JGotoStmt(UnitBox box) {
        this.targetBox = box;
        this.targetBoxes = Collections.singletonList(box);
    }

    @Override
    public Object clone() {
        return new JGotoStmt(this.getTarget());
    }

    public String toString() {
        Unit t2 = this.getTarget();
        String target = t2.branches() ? "(branch)" : t2.toString();
        return "goto [?= " + target + "]";
    }

    @Override
    public void toString(UnitPrinter up) {
        up.literal("goto ");
        this.targetBox.toString(up);
    }

    @Override
    public Unit getTarget() {
        return this.targetBox.getUnit();
    }

    @Override
    public void setTarget(Unit target) {
        this.targetBox.setUnit(target);
    }

    @Override
    public UnitBox getTargetBox() {
        return this.targetBox;
    }

    @Override
    public List<UnitBox> getUnitBoxes() {
        return this.targetBoxes;
    }

    @Override
    public void apply(Switch sw) {
        ((StmtSwitch)sw).caseGotoStmt(this);
    }

    @Override
    public void convertToBaf(JimpleToBafContext context, List<Unit> out) {
        Baf vaf = Baf.v();
        GotoInst u = vaf.newGotoInst(vaf.newPlaceholderInst(this.getTarget()));
        u.addAllTagsOf(this);
        out.add(u);
    }

    @Override
    public boolean fallsThrough() {
        return false;
    }

    @Override
    public boolean branches() {
        return true;
    }
}

