/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.internal;

import java.util.ArrayList;
import java.util.List;
import soot.BooleanType;
import soot.Type;
import soot.UnitPrinter;
import soot.Value;
import soot.ValueBox;
import soot.jimple.ExprSwitch;
import soot.jimple.InstanceOfExpr;
import soot.util.Switch;

public abstract class AbstractInstanceOfExpr
implements InstanceOfExpr {
    protected final ValueBox opBox;
    protected Type checkType;

    protected AbstractInstanceOfExpr(ValueBox opBox, Type checkType) {
        this.opBox = opBox;
        this.checkType = checkType;
    }

    @Override
    public abstract Object clone();

    @Override
    public boolean equivTo(Object o) {
        if (o instanceof AbstractInstanceOfExpr) {
            AbstractInstanceOfExpr aie = (AbstractInstanceOfExpr)o;
            return this.opBox.getValue().equivTo(aie.opBox.getValue()) && this.checkType.equals(aie.checkType);
        }
        return false;
    }

    @Override
    public int equivHashCode() {
        return this.opBox.getValue().equivHashCode() * 101 + this.checkType.hashCode() * 17;
    }

    public String toString() {
        return this.opBox.getValue().toString() + " instanceof " + this.checkType.toString();
    }

    @Override
    public void toString(UnitPrinter up) {
        this.opBox.toString(up);
        up.literal(" instanceof ");
        up.type(this.checkType);
    }

    @Override
    public Value getOp() {
        return this.opBox.getValue();
    }

    @Override
    public void setOp(Value op) {
        this.opBox.setValue(op);
    }

    @Override
    public ValueBox getOpBox() {
        return this.opBox;
    }

    @Override
    public final List<ValueBox> getUseBoxes() {
        ArrayList<ValueBox> list = new ArrayList<ValueBox>(this.opBox.getValue().getUseBoxes());
        list.add(this.opBox);
        return list;
    }

    @Override
    public Type getType() {
        return BooleanType.v();
    }

    @Override
    public Type getCheckType() {
        return this.checkType;
    }

    @Override
    public void setCheckType(Type checkType) {
        this.checkType = checkType;
    }

    @Override
    public void apply(Switch sw) {
        ((ExprSwitch)sw).caseInstanceOfExpr(this);
    }
}

