/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Set;
import soot.Body;
import soot.Local;
import soot.PointsToAnalysis;
import soot.RefLikeType;
import soot.Scene;
import soot.SootClass;
import soot.SootMethod;
import soot.Type;

public class ReachingTypeDumper {
    protected PointsToAnalysis pa;
    protected String output_dir;

    public ReachingTypeDumper(PointsToAnalysis pa, String output_dir) {
        this.pa = pa;
        this.output_dir = output_dir;
    }

    public void dump() {
        try {
            PrintWriter file = new PrintWriter(new FileOutputStream(new File(this.output_dir, "types")));
            for (SootClass cls : Scene.v().getApplicationClasses()) {
                this.handleClass(file, cls);
            }
            for (SootClass cls : Scene.v().getLibraryClasses()) {
                this.handleClass(file, cls);
            }
            file.close();
        }
        catch (IOException e) {
            throw new RuntimeException("Couldn't dump reaching types." + e);
        }
    }

    protected void handleClass(PrintWriter out, SootClass c) {
        for (SootMethod m4 : c.getMethods()) {
            if (!m4.isConcrete()) continue;
            Body b = m4.retrieveActiveBody();
            Local[] sortedLocals = b.getLocals().toArray(new Local[b.getLocalCount()]);
            Arrays.sort(sortedLocals, new StringComparator());
            for (Local l : sortedLocals) {
                out.println("V " + m4 + l);
                if (!(l.getType() instanceof RefLikeType)) continue;
                Set<Type> types = this.pa.reachingObjects(l).possibleTypes();
                Type[] sortedTypes = types.toArray(new Type[types.size()]);
                Arrays.sort(sortedTypes, new StringComparator());
                for (Type type : sortedTypes) {
                    out.println("T " + type);
                }
            }
        }
    }

    private static class StringComparator<T>
    implements Comparator<T> {
        private StringComparator() {
        }

        @Override
        public int compare(T o1, T o2) {
            return o1.toString().compareTo(o2.toString());
        }
    }
}

