/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple;

import soot.FloatType;
import soot.Type;
import soot.jimple.ConstantSwitch;
import soot.jimple.IntConstant;
import soot.jimple.NumericConstant;
import soot.jimple.RealConstant;
import soot.util.Switch;

public class FloatConstant
extends RealConstant {
    private static final long serialVersionUID = 8670501761494749605L;
    public static final FloatConstant ZERO = new FloatConstant(0.0f);
    public static final FloatConstant ONE = new FloatConstant(1.0f);
    public final float value;

    protected FloatConstant(float value) {
        this.value = value;
    }

    public static FloatConstant v(float value) {
        if (Float.compare(value, 0.0f) == 0) {
            return ZERO;
        }
        if (Float.compare(value, 1.0f) == 0) {
            return ONE;
        }
        return new FloatConstant(value);
    }

    public boolean equals(Object c) {
        return c instanceof FloatConstant && Float.compare(((FloatConstant)c).value, this.value) == 0;
    }

    public int hashCode() {
        return Float.floatToIntBits(this.value);
    }

    @Override
    public NumericConstant add(NumericConstant c) {
        this.assertInstanceOf(c);
        return FloatConstant.v(this.value + ((FloatConstant)c).value);
    }

    @Override
    public NumericConstant subtract(NumericConstant c) {
        this.assertInstanceOf(c);
        return FloatConstant.v(this.value - ((FloatConstant)c).value);
    }

    @Override
    public NumericConstant multiply(NumericConstant c) {
        this.assertInstanceOf(c);
        return FloatConstant.v(this.value * ((FloatConstant)c).value);
    }

    @Override
    public NumericConstant divide(NumericConstant c) {
        this.assertInstanceOf(c);
        return FloatConstant.v(this.value / ((FloatConstant)c).value);
    }

    @Override
    public NumericConstant remainder(NumericConstant c) {
        this.assertInstanceOf(c);
        return FloatConstant.v(this.value % ((FloatConstant)c).value);
    }

    @Override
    public NumericConstant equalEqual(NumericConstant c) {
        this.assertInstanceOf(c);
        return IntConstant.v(Float.compare(this.value, ((FloatConstant)c).value) == 0 ? 1 : 0);
    }

    @Override
    public NumericConstant notEqual(NumericConstant c) {
        this.assertInstanceOf(c);
        return IntConstant.v(Float.compare(this.value, ((FloatConstant)c).value) != 0 ? 1 : 0);
    }

    @Override
    public boolean isLessThan(NumericConstant c) {
        this.assertInstanceOf(c);
        return Float.compare(this.value, ((FloatConstant)c).value) < 0;
    }

    @Override
    public NumericConstant lessThan(NumericConstant c) {
        this.assertInstanceOf(c);
        return IntConstant.v(Float.compare(this.value, ((FloatConstant)c).value) < 0 ? 1 : 0);
    }

    @Override
    public NumericConstant lessThanOrEqual(NumericConstant c) {
        this.assertInstanceOf(c);
        return IntConstant.v(Float.compare(this.value, ((FloatConstant)c).value) <= 0 ? 1 : 0);
    }

    @Override
    public NumericConstant greaterThan(NumericConstant c) {
        this.assertInstanceOf(c);
        return IntConstant.v(Float.compare(this.value, ((FloatConstant)c).value) > 0 ? 1 : 0);
    }

    @Override
    public NumericConstant greaterThanOrEqual(NumericConstant c) {
        this.assertInstanceOf(c);
        return IntConstant.v(Float.compare(this.value, ((FloatConstant)c).value) >= 0 ? 1 : 0);
    }

    @Override
    public IntConstant cmpg(RealConstant constant) {
        this.assertInstanceOf(constant);
        float cValue = ((FloatConstant)constant).value;
        if (this.value < cValue) {
            return IntConstant.v(-1);
        }
        if (this.value == cValue) {
            return IntConstant.v(0);
        }
        return IntConstant.v(1);
    }

    @Override
    public IntConstant cmpl(RealConstant constant) {
        this.assertInstanceOf(constant);
        float cValue = ((FloatConstant)constant).value;
        if (this.value > cValue) {
            return IntConstant.v(1);
        }
        if (this.value == cValue) {
            return IntConstant.v(0);
        }
        return IntConstant.v(-1);
    }

    @Override
    public NumericConstant negate() {
        return FloatConstant.v(-this.value);
    }

    public String toString() {
        String floatString;
        switch (floatString = Float.toString(this.value)) {
            case "NaN": 
            case "Infinity": 
            case "-Infinity": {
                return "#" + floatString + "F";
            }
        }
        return floatString + "F";
    }

    @Override
    public Type getType() {
        return FloatType.v();
    }

    @Override
    public void apply(Switch sw) {
        ((ConstantSwitch)sw).caseFloatConstant(this);
    }

    private void assertInstanceOf(NumericConstant constant) {
        if (!(constant instanceof FloatConstant)) {
            throw new IllegalArgumentException("FloatConstant expected");
        }
    }

    @Override
    public Number getNumericValue() {
        return Float.valueOf(this.value);
    }
}

