/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple;

import soot.ArrayType;
import soot.BooleanType;
import soot.ByteType;
import soot.CharType;
import soot.DoubleType;
import soot.FloatType;
import soot.IntType;
import soot.LongType;
import soot.PrimType;
import soot.RefType;
import soot.ShortType;
import soot.Type;
import soot.jimple.Constant;
import soot.jimple.ConstantSwitch;
import soot.options.Options;
import soot.util.StringTools;
import soot.util.Switch;

public class ClassConstant
extends Constant {
    public final String value;

    protected ClassConstant(String s2) {
        this.value = s2;
    }

    public static ClassConstant v(String value) {
        if (value.indexOf(46) > -1) {
            throw new RuntimeException("ClassConstants must use class names separated by '/', not '.'!");
        }
        return new ClassConstant(value);
    }

    public static ClassConstant fromType(Type tp) {
        return ClassConstant.v(ClassConstant.sootTypeToString(tp));
    }

    private static String sootTypeToString(Type tp) {
        if (tp instanceof RefType) {
            return "L" + ((RefType)tp).getClassName().replace('.', '/') + ";";
        }
        if (tp instanceof ArrayType) {
            return "[" + ClassConstant.sootTypeToString(((ArrayType)tp).getElementType());
        }
        if (tp instanceof PrimType) {
            if (tp instanceof IntType) {
                return "I";
            }
            if (tp instanceof ByteType) {
                return "B";
            }
            if (tp instanceof CharType) {
                return "C";
            }
            if (tp instanceof DoubleType) {
                return "D";
            }
            if (tp instanceof FloatType) {
                return "F";
            }
            if (tp instanceof LongType) {
                return "J";
            }
            if (tp instanceof ShortType) {
                return "S";
            }
            if (tp instanceof BooleanType) {
                return "Z";
            }
            throw new RuntimeException("Unsupported primitive type");
        }
        throw new RuntimeException("Unsupported type" + tp);
    }

    public boolean isRefType() {
        String tmp = this.value;
        return !tmp.isEmpty() && tmp.charAt(0) == 'L' && tmp.charAt(tmp.length() - 1) == ';';
    }

    public Type toSootType() {
        int numDimensions = 0;
        String tmp = this.value;
        while (!tmp.isEmpty() && tmp.charAt(0) == '[') {
            ++numDimensions;
            tmp = tmp.substring(1);
        }
        Type baseType = null;
        if (!tmp.isEmpty() && tmp.charAt(0) == 'L') {
            tmp = tmp.substring(1);
            int lastIdx = tmp.length() - 1;
            if (!tmp.isEmpty() && tmp.charAt(lastIdx) == ';') {
                tmp = tmp.substring(0, lastIdx);
            }
            tmp = tmp.replace('/', '.');
            baseType = RefType.v(tmp);
        } else {
            switch (tmp) {
                case "I": {
                    baseType = IntType.v();
                    break;
                }
                case "B": {
                    baseType = ByteType.v();
                    break;
                }
                case "C": {
                    baseType = CharType.v();
                    break;
                }
                case "D": {
                    baseType = DoubleType.v();
                    break;
                }
                case "F": {
                    baseType = FloatType.v();
                    break;
                }
                case "J": {
                    baseType = LongType.v();
                    break;
                }
                case "S": {
                    baseType = ShortType.v();
                    break;
                }
                case "Z": {
                    baseType = BooleanType.v();
                    break;
                }
                default: {
                    throw new RuntimeException("Unsupported class constant: " + this.value);
                }
            }
        }
        return numDimensions > 0 ? ArrayType.v(baseType, numDimensions) : baseType;
    }

    public String toInternalString() {
        String internal = this.value;
        while (!internal.isEmpty() && internal.charAt(0) == '[') {
            internal = internal.substring(1);
        }
        int lastIdx = internal.length() - 1;
        if (!internal.isEmpty() && internal.charAt(lastIdx) == ';' && !(internal = internal.substring(0, lastIdx)).isEmpty() && internal.charAt(0) == 'L') {
            internal = internal.substring(1);
        }
        return internal;
    }

    public boolean equals(Object c) {
        return c instanceof ClassConstant && ((ClassConstant)c).value.equals(this.value);
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    public String toString() {
        return "class " + StringTools.getQuotedStringOf(this.value);
    }

    public String getValue() {
        return this.value;
    }

    @Override
    public Type getType() {
        if (Options.v().src_prec() == 7) {
            return RefType.v("System.RuntimeTypeHandle");
        }
        return RefType.v("java.lang.Class");
    }

    @Override
    public void apply(Switch sw) {
        ((ConstantSwitch)sw).caseClassConstant(this);
    }
}

