/*
 * Decompiled with CFR 0.152.
 */
package soot.grimp;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.Body;
import soot.Local;
import soot.PackManager;
import soot.SootMethod;
import soot.Trap;
import soot.Unit;
import soot.UnitPatchingChain;
import soot.ValueBox;
import soot.grimp.Grimp;
import soot.jimple.AbstractStmtSwitch;
import soot.jimple.AssignStmt;
import soot.jimple.BreakpointStmt;
import soot.jimple.EnterMonitorStmt;
import soot.jimple.ExitMonitorStmt;
import soot.jimple.GotoStmt;
import soot.jimple.IdentityStmt;
import soot.jimple.IfStmt;
import soot.jimple.InvokeStmt;
import soot.jimple.JimpleBody;
import soot.jimple.LookupSwitchStmt;
import soot.jimple.NopStmt;
import soot.jimple.ReturnStmt;
import soot.jimple.ReturnVoidStmt;
import soot.jimple.Stmt;
import soot.jimple.StmtBody;
import soot.jimple.TableSwitchStmt;
import soot.jimple.ThrowStmt;
import soot.jimple.internal.StmtBox;
import soot.options.Options;
import soot.tagkit.Tag;
import soot.util.Chain;

public class GrimpBody
extends StmtBody {
    private static final Logger logger = LoggerFactory.getLogger(GrimpBody.class);

    GrimpBody(SootMethod m4) {
        super(m4);
    }

    @Override
    public Object clone() {
        GrimpBody b = Grimp.v().newBody(this.getMethodUnsafe());
        b.importBodyContentsFrom(this);
        return b;
    }

    @Override
    public Object clone(boolean noLocalsClone) {
        GrimpBody b = Grimp.v().newBody(this.getMethod());
        b.importBodyContentsFrom(this, true);
        return b;
    }

    GrimpBody(Body body) {
        super(body.getMethod());
        if (Options.v().verbose()) {
            logger.debug("[" + this.getMethod().getName() + "] Constructing GrimpBody...");
        }
        if (!(body instanceof JimpleBody)) {
            throw new RuntimeException("Can only construct GrimpBody's from JimpleBody's (for now)");
        }
        JimpleBody jBody = (JimpleBody)body;
        Chain<Local> thisLocals = this.getLocals();
        for (Local loc : jBody.getLocals()) {
            thisLocals.add(loc);
        }
        final Grimp grimp = Grimp.v();
        UnitPatchingChain thisUnits = this.getUnits();
        final HashMap<Stmt, Stmt> oldToNew = new HashMap<Stmt, Stmt>(thisUnits.size() * 2 + 1, 0.7f);
        ArrayList<Unit> updates = new ArrayList<Unit>();
        for (Unit u : jBody.getUnits()) {
            Tag slpTag;
            Tag lnTag;
            Stmt oldStmt = (Stmt)u;
            final StmtBox newStmtBox = (StmtBox)grimp.newStmtBox(null);
            final StmtBox updateStmtBox = (StmtBox)grimp.newStmtBox(null);
            oldStmt.apply(new AbstractStmtSwitch(){

                @Override
                public void caseAssignStmt(AssignStmt s2) {
                    newStmtBox.setUnit(grimp.newAssignStmt(s2));
                }

                @Override
                public void caseIdentityStmt(IdentityStmt s2) {
                    newStmtBox.setUnit(grimp.newIdentityStmt(s2));
                }

                @Override
                public void caseBreakpointStmt(BreakpointStmt s2) {
                    newStmtBox.setUnit(grimp.newBreakpointStmt(s2));
                }

                @Override
                public void caseInvokeStmt(InvokeStmt s2) {
                    newStmtBox.setUnit(grimp.newInvokeStmt(s2));
                }

                @Override
                public void caseEnterMonitorStmt(EnterMonitorStmt s2) {
                    newStmtBox.setUnit(grimp.newEnterMonitorStmt(s2));
                }

                @Override
                public void caseExitMonitorStmt(ExitMonitorStmt s2) {
                    newStmtBox.setUnit(grimp.newExitMonitorStmt(s2));
                }

                @Override
                public void caseGotoStmt(GotoStmt s2) {
                    newStmtBox.setUnit(grimp.newGotoStmt(s2));
                    updateStmtBox.setUnit(s2);
                }

                @Override
                public void caseIfStmt(IfStmt s2) {
                    newStmtBox.setUnit(grimp.newIfStmt(s2));
                    updateStmtBox.setUnit(s2);
                }

                @Override
                public void caseLookupSwitchStmt(LookupSwitchStmt s2) {
                    newStmtBox.setUnit(grimp.newLookupSwitchStmt(s2));
                    updateStmtBox.setUnit(s2);
                }

                @Override
                public void caseNopStmt(NopStmt s2) {
                    newStmtBox.setUnit(grimp.newNopStmt(s2));
                }

                @Override
                public void caseReturnStmt(ReturnStmt s2) {
                    newStmtBox.setUnit(grimp.newReturnStmt(s2));
                }

                @Override
                public void caseReturnVoidStmt(ReturnVoidStmt s2) {
                    newStmtBox.setUnit(grimp.newReturnVoidStmt(s2));
                }

                @Override
                public void caseTableSwitchStmt(TableSwitchStmt s2) {
                    newStmtBox.setUnit(grimp.newTableSwitchStmt(s2));
                    updateStmtBox.setUnit(s2);
                }

                @Override
                public void caseThrowStmt(ThrowStmt s2) {
                    newStmtBox.setUnit(grimp.newThrowStmt(s2));
                }
            });
            Stmt newStmt = (Stmt)newStmtBox.getUnit();
            for (ValueBox box : newStmt.getUseBoxes()) {
                box.setValue(grimp.newExpr(box.getValue()));
            }
            for (ValueBox box : newStmt.getDefBoxes()) {
                box.setValue(grimp.newExpr(box.getValue()));
            }
            thisUnits.add(newStmt);
            oldToNew.put(oldStmt, newStmt);
            if (updateStmtBox.getUnit() != null) {
                updates.add(updateStmtBox.getUnit());
            }
            if ((lnTag = oldStmt.getTag("LineNumberTag")) != null) {
                newStmt.addTag(lnTag);
            }
            if ((slpTag = oldStmt.getTag("SourceLnPosTag")) == null) continue;
            newStmt.addTag(slpTag);
        }
        AbstractStmtSwitch tgtUpdateSwitch = new AbstractStmtSwitch(){

            @Override
            public void caseGotoStmt(GotoStmt s2) {
                GotoStmt newStmt = (GotoStmt)oldToNew.get(s2);
                newStmt.setTarget((Unit)oldToNew.get((Stmt)newStmt.getTarget()));
            }

            @Override
            public void caseIfStmt(IfStmt s2) {
                IfStmt newStmt = (IfStmt)oldToNew.get(s2);
                newStmt.setTarget((Unit)oldToNew.get(newStmt.getTarget()));
            }

            @Override
            public void caseLookupSwitchStmt(LookupSwitchStmt s2) {
                LookupSwitchStmt newStmt = (LookupSwitchStmt)oldToNew.get(s2);
                newStmt.setDefaultTarget((Unit)oldToNew.get((Stmt)newStmt.getDefaultTarget()));
                Unit[] newTargList = new Unit[newStmt.getTargetCount()];
                for (int i = 0; i < newTargList.length; ++i) {
                    newTargList[i] = (Unit)oldToNew.get((Stmt)newStmt.getTarget(i));
                }
                newStmt.setTargets(newTargList);
            }

            @Override
            public void caseTableSwitchStmt(TableSwitchStmt s2) {
                TableSwitchStmt newStmt = (TableSwitchStmt)oldToNew.get(s2);
                newStmt.setDefaultTarget((Unit)oldToNew.get((Stmt)newStmt.getDefaultTarget()));
                int tc = newStmt.getHighIndex() - newStmt.getLowIndex() + 1;
                LinkedList<Unit> newTargList = new LinkedList<Unit>();
                for (int i = 0; i < tc; ++i) {
                    newTargList.add((Unit)oldToNew.get((Stmt)newStmt.getTarget(i)));
                }
                newStmt.setTargets(newTargList);
            }
        };
        for (Unit u : updates) {
            u.apply(tgtUpdateSwitch);
        }
        Chain<Trap> thisTraps = this.getTraps();
        for (Trap oldTrap : jBody.getTraps()) {
            thisTraps.add(grimp.newTrap(oldTrap.getException(), (Unit)oldToNew.get((Stmt)oldTrap.getBeginUnit()), (Unit)oldToNew.get((Stmt)oldTrap.getEndUnit()), (Unit)oldToNew.get((Stmt)oldTrap.getHandlerUnit())));
        }
        PackManager.v().getPack("gb").apply(this);
    }
}

