/*
 * Decompiled with CFR 0.152.
 */
package soot.dotnet.values;

import java.util.ArrayList;
import soot.RefType;
import soot.Scene;
import soot.SootClass;
import soot.SootMethodRef;
import soot.Type;
import soot.dotnet.members.ByReferenceWrapperGenerator;
import soot.dotnet.members.DotnetMethod;
import soot.dotnet.proto.ProtoAssemblyAllTypes;
import soot.dotnet.types.DotnetTypeFactory;
import soot.jimple.Constant;
import soot.util.Switch;

public class FunctionPointerConstant
extends Constant {
    private static final long serialVersionUID = 1L;
    private DotnetMethod method;
    private boolean virtual;
    private SootMethodRef methodRef;

    public FunctionPointerConstant(DotnetMethod method, boolean virtual) {
        this.method = method;
        this.virtual = virtual;
        ArrayList<Type> parameterDefs = new ArrayList<Type>();
        for (ProtoAssemblyAllTypes.ParameterDefinition parameterDefinition : method.getProtoMessage().getParameterList()) {
            Type t2 = DotnetTypeFactory.toSootType(parameterDefinition.getType());
            if (ByReferenceWrapperGenerator.needsWrapper(parameterDefinition)) {
                SootClass sc = ByReferenceWrapperGenerator.getWrapperClass(t2);
                t2 = sc.getType();
            }
            parameterDefs.add(t2);
        }
        this.methodRef = Scene.v().makeMethodRef(method.getDeclaringClass(), method.getName(), parameterDefs, DotnetTypeFactory.toSootType(method.getReturnType()), method.isStatic());
    }

    public int hashCode() {
        SootMethodRef mr = this.methodRef;
        int hash = mr.getName().hashCode();
        hash = hash * 31 + mr.getParameterTypes().size();
        hash = hash * 31 + mr.getReturnType().hashCode();
        hash = hash * 31 + (this.virtual ? 1 : 0);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj instanceof FunctionPointerConstant) {
            FunctionPointerConstant other = (FunctionPointerConstant)obj;
            SootMethodRef omr = other.methodRef;
            SootMethodRef mr = this.methodRef;
            if (this.virtual != other.virtual) {
                return false;
            }
            if (this.virtual) {
                return mr.resolve() == omr.resolve();
            }
            if (!(mr.getName().equals(omr.getName()) && mr.getParameterTypes().equals(omr.getParameterTypes()) && mr.getReturnType().equals(omr.getReturnType()))) {
                return false;
            }
            return mr.getDeclaringClass() == omr.getDeclaringClass();
        }
        return super.equals(obj);
    }

    public DotnetMethod getDotnetMethod() {
        return this.method;
    }

    public boolean isVirtual() {
        return this.virtual;
    }

    public SootMethodRef getSootMethodRef() {
        return this.methodRef;
    }

    @Override
    public FunctionPointerConstant clone() {
        throw new RuntimeException("Not supported");
    }

    @Override
    public boolean equivTo(Object o) {
        throw new RuntimeException("Not supported");
    }

    @Override
    public int equivHashCode() {
        throw new RuntimeException("Not supported");
    }

    @Override
    public Type getType() {
        return RefType.v("System.Delegate");
    }

    @Override
    public void apply(Switch sw) {
        throw new RuntimeException("Not supported");
    }

    public String toString() {
        return "Function Ptr: " + this.methodRef + " - " + (this.virtual ? "virtual" : "non-virtual");
    }
}

