/*
 * Decompiled with CFR 0.152.
 */
package soot.dotnet.types;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import soot.ArrayType;
import soot.BooleanConstant;
import soot.BooleanType;
import soot.ByteConstant;
import soot.ByteType;
import soot.CharType;
import soot.DecimalConstant;
import soot.DecimalType;
import soot.DoubleType;
import soot.FloatType;
import soot.IntType;
import soot.Local;
import soot.LongType;
import soot.RefType;
import soot.ShortType;
import soot.Type;
import soot.UByteConstant;
import soot.UByteType;
import soot.UIntType;
import soot.ULongType;
import soot.UShortType;
import soot.Value;
import soot.VoidType;
import soot.dotnet.proto.ProtoAssemblyAllTypes;
import soot.jimple.DoubleConstant;
import soot.jimple.FloatConstant;
import soot.jimple.IntConstant;
import soot.jimple.LongConstant;
import soot.jimple.NullConstant;
import soot.jimple.UIntConstant;
import soot.jimple.ULongConstant;

public class DotnetTypeFactory {
    public static Type toSootType(String type) {
        switch (type) {
            case "System.Byte": {
                return UByteType.v();
            }
            case "System.SByte": {
                return ByteType.v();
            }
            case "System.Char": {
                return CharType.v();
            }
            case "System.Double": {
                return DoubleType.v();
            }
            case "System.Single": {
                return FloatType.v();
            }
            case "System.Int64": {
                return LongType.v();
            }
            case "System.Int16": {
                return ShortType.v();
            }
            case "System.Boolean": {
                return BooleanType.v();
            }
            case "System.Void": {
                return VoidType.v();
            }
            case "System.UInt32": {
                return UIntType.v();
            }
            case "System.Decimal": {
                return DecimalType.v();
            }
            case "System.UInt64": {
                return ULongType.v();
            }
            case "System.UInt16": {
                return UShortType.v();
            }
            case "System.Int32": {
                return IntType.v();
            }
            case "System.IntPtr": 
            case "System.UIntPtr": 
            case "nint": 
            case "nuint": {
                return IntType.v();
            }
        }
        if (type.startsWith("`") || type.startsWith("``")) {
            return RefType.v("System.Object");
        }
        return RefType.v(type);
    }

    public static Type toSootType(ProtoAssemblyAllTypes.TypeDefinition dotnetType) {
        if (dotnetType.getTypeKind().equals(ProtoAssemblyAllTypes.TypeKindDef.ARRAY) || dotnetType.getTypeKind().equals(ProtoAssemblyAllTypes.TypeKindDef.BY_REF_AND_ARRAY)) {
            return ArrayType.v(DotnetTypeFactory.toSootType(dotnetType.getFullname()), dotnetType.getArrayDimensions());
        }
        return DotnetTypeFactory.toSootType(dotnetType.getFullname());
    }

    public static Type toSootType(Type type) {
        if (type instanceof RefType) {
            return DotnetTypeFactory.toSootType(type.toString());
        }
        return type;
    }

    public static List<Type> toSootTypeList(List<String> types) {
        ArrayList<Type> ret = new ArrayList<Type>();
        for (String type : types) {
            ret.add(DotnetTypeFactory.toSootType(type));
        }
        return ret;
    }

    public static Value initType(Local variable) {
        Type t2 = variable.getType();
        return DotnetTypeFactory.initType(t2);
    }

    public static Value initType(Type t2) {
        if (t2 instanceof IntType) {
            return IntConstant.v(0);
        }
        if (t2 instanceof FloatType) {
            return FloatConstant.v(0.0f);
        }
        if (t2 instanceof DecimalType) {
            return DecimalConstant.v(BigDecimal.ZERO);
        }
        if (t2 instanceof DoubleType) {
            return DoubleConstant.v(0.0);
        }
        if (t2 instanceof LongType) {
            return LongConstant.v(0L);
        }
        if (t2 instanceof ULongType) {
            return ULongConstant.v(0L);
        }
        if (t2 instanceof ByteType) {
            return ByteConstant.v(0);
        }
        if (t2 instanceof UByteType) {
            return UByteConstant.v(0);
        }
        if (t2 instanceof BooleanType) {
            return BooleanConstant.v(0);
        }
        if (t2 instanceof UIntType) {
            return UIntConstant.v(0);
        }
        if (t2 instanceof ShortType || t2 instanceof CharType || t2 instanceof UShortType) {
            return IntConstant.v(0);
        }
        return NullConstant.v();
    }

    public static List<String> listOfCilPrimitives() {
        ArrayList<String> lst = new ArrayList<String>();
        lst.add("System.IntPtr");
        lst.add("System.UIntPtr");
        lst.add("nint");
        lst.add("nuint");
        lst.add("System.UInt32");
        lst.add("System.SByte");
        lst.add("System.Decimal");
        lst.add("System.UInt64");
        lst.add("System.UInt16");
        return lst;
    }
}

