/*
 * Decompiled with CFR 0.152.
 */
package soot.dotnet.types;

import com.google.common.base.Strings;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.ArrayType;
import soot.Body;
import soot.BooleanConstant;
import soot.BooleanType;
import soot.IntType;
import soot.Local;
import soot.MethodSource;
import soot.PrimType;
import soot.RefType;
import soot.Scene;
import soot.SootClass;
import soot.SootField;
import soot.SootFieldRef;
import soot.SootMethod;
import soot.SootMethodRef;
import soot.SootResolver;
import soot.Type;
import soot.UnitPatchingChain;
import soot.Value;
import soot.VoidType;
import soot.dotnet.AssemblyFile;
import soot.dotnet.AssemblyTag;
import soot.dotnet.members.DotnetEvent;
import soot.dotnet.members.DotnetField;
import soot.dotnet.members.DotnetMethod;
import soot.dotnet.members.DotnetProperty;
import soot.dotnet.proto.ProtoAssemblyAllTypes;
import soot.dotnet.specifications.DotnetAttributeArgument;
import soot.dotnet.specifications.DotnetModifier;
import soot.dotnet.types.StructTag;
import soot.javaToJimple.IInitialResolver;
import soot.jimple.IfStmt;
import soot.jimple.IntConstant;
import soot.jimple.Jimple;
import soot.jimple.JimpleBody;
import soot.jimple.NopStmt;
import soot.jimple.NullConstant;
import soot.jimple.ReturnStmt;
import soot.options.Options;
import soot.tagkit.AnnotationElem;
import soot.tagkit.AnnotationTag;
import soot.tagkit.DeprecatedTag;

public class DotnetType {
    public static final String COPY_STRUCT = "CreateDeepStructCopy";
    private static final Logger logger = LoggerFactory.getLogger(DotnetType.class);
    private final ProtoAssemblyAllTypes.TypeDefinition typeDefinition;
    private Set<SootField> structFields;
    private final AssemblyFile assemblyFile;

    public DotnetType(ProtoAssemblyAllTypes.TypeDefinition typeDefinition, File assemblyFile) {
        if (typeDefinition == null) {
            throw new NullPointerException("Passed Type Definition is null!");
        }
        this.typeDefinition = typeDefinition;
        if (!(assemblyFile instanceof AssemblyFile)) {
            throw new RuntimeException("Given File object is no assembly file!");
        }
        this.assemblyFile = (AssemblyFile)assemblyFile;
    }

    public IInitialResolver.Dependencies resolveSootClass(SootClass sootClass) {
        sootClass.addTag(new AssemblyTag(this.assemblyFile.getAbsolutePath()));
        IInitialResolver.Dependencies dependencies = new IInitialResolver.Dependencies();
        this.resolveModifier(sootClass);
        this.resolveSuperclassInterfaces(sootClass, dependencies);
        this.resolveOuterClass(sootClass, dependencies);
        this.resolveFields(sootClass);
        this.resolveMethods(sootClass);
        if (this.typeDefinition.getTypeKind() == ProtoAssemblyAllTypes.TypeKindDef.STRUCT) {
            sootClass.addTag(new StructTag());
            SootMethod ctor = this.createStructConstructorMethod(sootClass);
            this.createStructCopyMethod(sootClass, ctor);
            DotnetType.createStructDefaultHashCodeEquals(sootClass);
        }
        this.resolveProperties(sootClass);
        this.resolveEvents(sootClass);
        this.resolveAttributes(sootClass);
        return dependencies;
    }

    public static void createStructDefaultHashCodeEquals(SootClass sootClass) {
        SootMethod getHashCodeMethod;
        Scene sc = Scene.v();
        Jimple j = Jimple.v();
        RefType sysObject = RefType.v("System.Object");
        SootMethod equalsMethod = sootClass.getMethodUnsafe("boolean Equals(System.Object)");
        if (equalsMethod == null) {
            equalsMethod = sc.makeSootMethod("Equals", Arrays.asList(sc.getObjectType()), BooleanType.v());
            SootMethodRef objEquals = sc.makeMethodRef(sysObject.getSootClass(), "Equals", Arrays.asList(sc.getObjectType()), BooleanType.v(), false);
            JimpleBody body = j.newBody(equalsMethod);
            equalsMethod.setActiveBody(body);
            sootClass.addMethod(equalsMethod);
            body.insertIdentityStmts();
            HashMap<Type, Local> tmpCompareLocalsMine = new HashMap<Type, Local>();
            HashMap<Type, Local> tmpCompareLocalsOther = new HashMap<Type, Local>();
            ReturnStmt retFalse = j.newReturnStmt(BooleanConstant.v(false));
            ReturnStmt retTrue = j.newReturnStmt(BooleanConstant.v(true));
            for (SootField field : sootClass.getFields()) {
                if (field.isStatic()) continue;
                Local result = j.newLocal("result", BooleanType.v());
                body.getLocals().add(result);
                Type type = field.getType();
                if (type instanceof ArrayType) continue;
                if (type instanceof RefType) {
                    type = sysObject;
                }
                Local lclMine = DotnetType.createTempVar("mine", j, body, tmpCompareLocalsMine, type);
                Local lclOther = DotnetType.createTempVar("other", j, body, tmpCompareLocalsOther, type);
                body.getUnits().add(j.newAssignStmt(lclMine, j.newInstanceFieldRef(body.getThisLocal(), field.makeRef())));
                body.getUnits().add(j.newAssignStmt(lclOther, j.newInstanceFieldRef(body.getParameterLocal(0), field.makeRef())));
                if (type instanceof RefType) {
                    IfStmt s2 = j.newIfStmt((Value)j.newEqExpr(lclOther, NullConstant.v()), retTrue);
                    body.getUnits().add(j.newIfStmt((Value)j.newEqExpr(lclMine, NullConstant.v()), s2));
                    body.getUnits().add(j.newAssignStmt(result, j.newVirtualInvokeExpr(lclMine, objEquals, (Value)lclOther)));
                    body.getUnits().add(j.newIfStmt((Value)j.newEqExpr(result, BooleanConstant.v(false)), retFalse));
                    NopStmt nop = j.newNopStmt();
                    body.getUnits().add(j.newGotoStmt(nop));
                    body.getUnits().add(s2);
                    body.getUnits().add(j.newReturnStmt(BooleanConstant.v(false)));
                    body.getUnits().add(nop);
                    continue;
                }
                if (type instanceof PrimType) {
                    body.getUnits().add(j.newIfStmt((Value)j.newNeExpr(lclMine, lclOther), retFalse));
                    continue;
                }
                logger.error(sootClass.getName() + ": Unsupported type for struct default hashcode/equals: " + type);
            }
            body.getUnits().add(retTrue);
            body.getUnits().add(retFalse);
        }
        if ((getHashCodeMethod = sootClass.getMethodUnsafe("int GetHashCode()")) == null) {
            getHashCodeMethod = sc.makeSootMethod("GetHashCode", Collections.emptyList(), IntType.v());
            SootMethodRef objEquals = sc.makeMethodRef(sysObject.getSootClass(), "GetHashCode", Collections.emptyList(), IntType.v(), false);
            JimpleBody body = j.newBody(getHashCodeMethod);
            getHashCodeMethod.setActiveBody(body);
            sootClass.addMethod(getHashCodeMethod);
            body.insertIdentityStmts();
            Local hashCode = j.newLocal("hashcode", IntType.v());
            body.getLocals().add(hashCode);
            Local hcsingle = j.newLocal("hcsingle", IntType.v());
            body.getLocals().add(hcsingle);
            body.getUnits().add(j.newAssignStmt(hashCode, IntConstant.v(17)));
            HashMap<Type, Local> tmpCompareLocalsMine = new HashMap<Type, Local>();
            for (SootField field : sootClass.getFields()) {
                Type type;
                if (field.isStatic() || (type = field.getType()) instanceof ArrayType) continue;
                if (type instanceof RefType) {
                    type = sysObject;
                }
                Local lclMine = DotnetType.createTempVar("", j, body, tmpCompareLocalsMine, type);
                body.getUnits().add(j.newAssignStmt(lclMine, j.newInstanceFieldRef(body.getThisLocal(), field.makeRef())));
                if (type instanceof RefType) {
                    body.getUnits().add(j.newAssignStmt(hcsingle, j.newVirtualInvokeExpr(hcsingle, objEquals)));
                } else if (type instanceof PrimType) {
                    body.getUnits().add(j.newAssignStmt(hcsingle, j.newCastExpr(lclMine, IntType.v())));
                } else {
                    logger.error(sootClass.getName() + ": Unsupported type for struct default hashcode/equals: " + type);
                    continue;
                }
                body.getUnits().add(j.newAssignStmt(hashCode, j.newMulExpr(hashCode, IntConstant.v(23))));
                body.getUnits().add(j.newAssignStmt(hashCode, j.newAddExpr(hashCode, hcsingle)));
            }
            body.getUnits().add(j.newReturnStmt(hashCode));
        }
    }

    private static Local createTempVar(String prefix, Jimple j, JimpleBody body, Map<Type, Local> tmpCompareLocalsMine, Type type) {
        Local lclMine = tmpCompareLocalsMine.get(type);
        if (lclMine == null) {
            lclMine = j.newLocal("tmp" + prefix + type, type);
            body.getLocals().add(lclMine);
            tmpCompareLocalsMine.put(type, lclMine);
        }
        return lclMine;
    }

    private SootMethod createStructConstructorMethod(final SootClass sootClass) {
        final Scene sc = Scene.v();
        final Jimple j = Jimple.v();
        SootMethod m4 = sc.makeSootMethod("<init>", Collections.emptyList(), VoidType.v(), 1);
        m4 = sootClass.getOrAddMethod(m4);
        m4.setModifiers(1);
        m4.setPhantom(false);
        m4.setSource(new MethodSource(){

            @Override
            public Body getBody(SootMethod m4, String phaseName) {
                JimpleBody body = j.newBody(m4);
                m4.setActiveBody(body);
                body.insertIdentityStmts();
                UnitPatchingChain uchain = body.getUnits();
                HashMap<Type, Local> mapLocals = new HashMap<Type, Local>();
                for (SootField f : sootClass.getFields()) {
                    if (f.isStatic() || DotnetType.this.structFields == null || !DotnetType.this.structFields.contains(f)) continue;
                    RefType rt = (RefType)f.getType();
                    Local l = (Local)mapLocals.get(rt);
                    if (l == null) {
                        l = j.newLocal("instance", rt);
                        body.getLocals().add(l);
                        mapLocals.put(f.getType(), l);
                    }
                    uchain.add(j.newAssignStmt(l, j.newNewExpr(rt)));
                    uchain.add(j.newInvokeStmt(j.newSpecialInvokeExpr(l, sc.makeMethodRef(rt.getSootClass(), "<init>", Collections.emptyList(), VoidType.v(), false))));
                    uchain.add(j.newAssignStmt(j.newInstanceFieldRef(body.getThisLocal(), f.makeRef()), l));
                }
                uchain.add(j.newReturnVoidStmt());
                return body;
            }
        });
        return m4;
    }

    private void createStructCopyMethod(final SootClass sootClass, final SootMethod ctor) {
        final Scene sc = Scene.v();
        final Jimple j = Jimple.v();
        SootMethod m4 = this.createOrGetCopyMethod(sootClass, sc);
        m4.setSource(new MethodSource(){

            @Override
            public Body getBody(SootMethod m4, String phaseName) {
                JimpleBody body = j.newBody(m4);
                m4.setActiveBody(body);
                body.insertIdentityStmts();
                Local copy = j.newLocal("copy", sootClass.getType());
                body.getLocals().add(copy);
                Local tmp = j.newLocal("tmp", RefType.v("System.Object"));
                body.getLocals().add(tmp);
                UnitPatchingChain uchain = body.getUnits();
                Local thisO = body.getThisLocal();
                uchain.add(j.newAssignStmt(copy, j.newNewExpr(sootClass.getType())));
                uchain.add(j.newInvokeStmt(j.newSpecialInvokeExpr(copy, ctor.makeRef())));
                for (SootField f : sootClass.getFields()) {
                    if (f.isStatic()) continue;
                    SootFieldRef fr = f.makeRef();
                    if (DotnetType.this.structFields != null && DotnetType.this.structFields.contains(f)) {
                        Local linst = j.newLocal("instance", f.getType());
                        body.getLocals().add(linst);
                        uchain.add(j.newAssignStmt(linst, j.newInstanceFieldRef(thisO, fr)));
                        SootClass sct = ((RefType)f.getType()).getSootClass();
                        SootMethod copyM = DotnetType.this.createOrGetCopyMethod(sct, sc);
                        uchain.add(j.newAssignStmt(tmp, j.newSpecialInvokeExpr(linst, copyM.makeRef())));
                    } else {
                        uchain.add(j.newAssignStmt(tmp, j.newInstanceFieldRef(thisO, fr)));
                    }
                    uchain.add(j.newAssignStmt(j.newInstanceFieldRef(copy, fr), tmp));
                }
                uchain.add(j.newReturnStmt(copy));
                return body;
            }
        });
    }

    private SootMethod createOrGetCopyMethod(SootClass sootClass, Scene sc) {
        SootMethod m4 = sc.makeSootMethod(COPY_STRUCT, Collections.emptyList(), sootClass.getType(), 1);
        return sootClass.getOrAddMethod(m4);
    }

    public static SootMethod getCopyMethod(SootClass sootClass) {
        return sootClass.getMethodUnsafe(COPY_STRUCT, Collections.emptyList(), sootClass.getType());
    }

    private void resolveModifier(SootClass sootClass) {
        sootClass.setModifiers(DotnetModifier.toSootModifier(this.typeDefinition));
    }

    private void resolveSuperclassInterfaces(SootClass sootClass, IInitialResolver.Dependencies deps) {
        for (ProtoAssemblyAllTypes.TypeDefinition baseType : this.typeDefinition.getDirectBaseTypesList()) {
            SootClass superClass;
            if (baseType.getTypeKind().equals(ProtoAssemblyAllTypes.TypeKindDef.CLASS)) {
                superClass = SootResolver.v().makeClassRef(baseType.getFullname());
                sootClass.setSuperclass(superClass);
                deps.typesToHierarchy.add(superClass.getType());
            }
            if (!baseType.getTypeKind().equals(ProtoAssemblyAllTypes.TypeKindDef.INTERFACE)) continue;
            superClass = SootResolver.v().makeClassRef(baseType.getFullname());
            if (!sootClass.getInterfaces().stream().noneMatch(x -> x.getName().equals(baseType.getFullname()))) continue;
            sootClass.addInterface(superClass);
            deps.typesToHierarchy.add(superClass.getType());
        }
    }

    private void resolveOuterClass(SootClass declaringClass, IInitialResolver.Dependencies deps) {
        if (!Strings.isNullOrEmpty(this.typeDefinition.getDeclaringOuterClass())) {
            SootClass outerClass = SootResolver.v().makeClassRef(this.typeDefinition.getDeclaringOuterClass());
            declaringClass.setOuterClass(outerClass);
            deps.typesToHierarchy.add(outerClass.getType());
        }
    }

    private void resolveFields(SootClass declaringClass) {
        for (ProtoAssemblyAllTypes.FieldDefinition field : this.typeDefinition.getFieldsList()) {
            DotnetField dotnetField = this.createDotnetField(field);
            SootField sootField = dotnetField.makeSootField();
            if (declaringClass.declaresField(sootField.getSubSignature())) continue;
            declaringClass.addField(sootField);
            if (field.getTypeKind() != ProtoAssemblyAllTypes.TypeKindDef.STRUCT || sootField.getType() instanceof PrimType) continue;
            if (this.structFields == null) {
                this.structFields = new HashSet<SootField>();
            }
            this.structFields.add(sootField);
        }
    }

    protected DotnetField createDotnetField(ProtoAssemblyAllTypes.FieldDefinition field) {
        return new DotnetField(field);
    }

    private void resolveMethods(SootClass declaringClass) {
        for (ProtoAssemblyAllTypes.MethodDefinition method : this.typeDefinition.getMethodsList()) {
            DotnetMethod dotnetMethod = new DotnetMethod(method, declaringClass);
            if (!Options.v().resolve_all_dotnet_methods() && (method.getIsUnsafe() || method.getName().equals("InternalCopy") && declaringClass.getName().equals("System.String"))) continue;
            SootMethod sootMethod = dotnetMethod.toSootMethod();
            if (declaringClass.declaresMethod(sootMethod.getName(), sootMethod.getParameterTypes(), sootMethod.getReturnType())) {
                return;
            }
            declaringClass.addMethod(sootMethod);
        }
    }

    private void resolveProperties(SootClass declaringClass) {
        for (ProtoAssemblyAllTypes.PropertyDefinition property : this.typeDefinition.getPropertiesList()) {
            SootMethod setter;
            DotnetProperty dotnetProperty = new DotnetProperty(property, declaringClass);
            if (dotnetProperty.getCanGet()) {
                SootMethod getter = dotnetProperty.makeSootMethodGetter();
                if (getter == null || declaringClass.declaresMethod(getter.getName(), getter.getParameterTypes(), getter.getReturnType())) continue;
                declaringClass.addMethod(getter);
            }
            if (!dotnetProperty.getCanSet() || (setter = dotnetProperty.makeSootMethodSetter()) == null || declaringClass.declaresMethod(setter.getName(), setter.getParameterTypes(), setter.getReturnType())) continue;
            declaringClass.addMethod(setter);
        }
    }

    private void resolveEvents(SootClass declaringClass) {
        for (ProtoAssemblyAllTypes.EventDefinition eventDefinition : this.typeDefinition.getEventsList()) {
            this.loadEvent(declaringClass, eventDefinition);
        }
    }

    private void loadEvent(SootClass declaringClass, ProtoAssemblyAllTypes.EventDefinition protoEvent) {
        SootMethod setter;
        DotnetEvent dotnetEvent = new DotnetEvent(protoEvent, declaringClass);
        if (dotnetEvent.getCanAdd()) {
            SootMethod getter = dotnetEvent.makeSootMethodAdd();
            if (declaringClass.declaresMethod(getter.getName(), getter.getParameterTypes(), getter.getReturnType())) {
                return;
            }
            declaringClass.addMethod(getter);
        }
        if (dotnetEvent.getCanInvoke()) {
            setter = dotnetEvent.makeSootMethodInvoke();
            if (declaringClass.declaresMethod(setter.getName(), setter.getParameterTypes(), setter.getReturnType())) {
                return;
            }
            declaringClass.addMethod(setter);
        }
        if (dotnetEvent.getCanRemove()) {
            setter = dotnetEvent.makeSootMethodRemove();
            if (declaringClass.declaresMethod(setter.getName(), setter.getParameterTypes(), setter.getReturnType())) {
                return;
            }
            declaringClass.addMethod(setter);
        }
    }

    private void resolveAttributes(SootClass declaringClass) {
        if (this.typeDefinition.getAttributesCount() == 0) {
            return;
        }
        for (ProtoAssemblyAllTypes.AttributeDefinition attrMsg : this.typeDefinition.getAttributesList()) {
            try {
                String annotationType = attrMsg.getAttributeType().getFullname();
                ArrayList<AnnotationElem> elements = new ArrayList<AnnotationElem>();
                for (ProtoAssemblyAllTypes.AttributeArgumentDefinition fixedArg : attrMsg.getFixedArgumentsList()) {
                    elements.add(DotnetAttributeArgument.toAnnotationElem(fixedArg));
                }
                for (ProtoAssemblyAllTypes.AttributeArgumentDefinition namedArg : attrMsg.getNamedArgumentsList()) {
                    elements.add(DotnetAttributeArgument.toAnnotationElem(namedArg));
                }
                declaringClass.addTag(new AnnotationTag(annotationType, elements));
                if (!annotationType.equals("System.ObsoleteAttribute")) continue;
                declaringClass.addTag(new DeprecatedTag());
            }
            catch (Exception ignore) {
                logger.info("Ignored", ignore);
            }
        }
    }
}

