/*
 * Decompiled with CFR 0.152.
 */
package soot.dotnet.specifications;

import soot.dotnet.proto.ProtoAssemblyAllTypes;

public class DotnetModifier {
    public static int toSootModifier(ProtoAssemblyAllTypes.TypeDefinition protoType) {
        int modifier = DotnetModifier.convertAccessibility(protoType.getAccessibility());
        if (protoType.getIsAbstract()) {
            modifier |= 0x400;
        }
        if (protoType.getIsStatic()) {
            modifier |= 8;
        }
        if (protoType.getIsSealed()) {
            modifier |= 0x10;
        }
        if (protoType.getTypeKind().equals(ProtoAssemblyAllTypes.TypeKindDef.INTERFACE)) {
            modifier |= 0x200;
        }
        if (protoType.getTypeKind().equals(ProtoAssemblyAllTypes.TypeKindDef.ENUM)) {
            modifier |= 0x4000;
        }
        return modifier;
    }

    public static int toSootModifier(ProtoAssemblyAllTypes.MethodDefinition methodDefinition) {
        int modifier = DotnetModifier.convertAccessibility(methodDefinition.getAccessibility());
        if (methodDefinition.getIsAbstract()) {
            modifier |= 0x400;
        }
        if (methodDefinition.getIsStatic()) {
            modifier |= 8;
        }
        if (methodDefinition.getIsSealed()) {
            modifier |= 0x10;
        }
        if (methodDefinition.getIsExtern()) {
            modifier |= 0x100;
        }
        return modifier;
    }

    public static int toSootModifier(ProtoAssemblyAllTypes.FieldDefinition fieldDefinition) {
        int modifier = DotnetModifier.convertAccessibility(fieldDefinition.getAccessibility());
        if (fieldDefinition.getIsAbstract() || fieldDefinition.getIsVirtual()) {
            modifier |= 0x400;
        }
        if (fieldDefinition.getIsStatic()) {
            modifier |= 8;
        }
        if (fieldDefinition.getIsReadOnly()) {
            modifier |= 0x10;
        }
        return modifier;
    }

    private static int convertAccessibility(ProtoAssemblyAllTypes.Accessibility accessibility) {
        int modifier = 0;
        switch (accessibility) {
            case PRIVATE: {
                modifier |= 2;
                break;
            }
            case INTERNAL: 
            case PROTECTED_AND_INTERNAL: 
            case PROTECTED_OR_INTERNAL: 
            case PUBLIC: {
                modifier |= 1;
                break;
            }
            case PROTECTED: {
                modifier |= 4;
            }
        }
        return modifier;
    }
}

