/*
 * Decompiled with CFR 0.152.
 */
package soot.dotnet.members.method;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import soot.ArrayType;
import soot.Body;
import soot.Local;
import soot.LocalGenerator;
import soot.NullType;
import soot.PrimType;
import soot.RefType;
import soot.SootClass;
import soot.Type;
import soot.Unit;
import soot.UnknownType;
import soot.Value;
import soot.dotnet.members.ByReferenceWrapperGenerator;
import soot.dotnet.members.DotnetMethod;
import soot.dotnet.members.method.DotnetBody;
import soot.dotnet.proto.ProtoAssemblyAllTypes;
import soot.dotnet.proto.ProtoIlInstructions;
import soot.dotnet.types.DotnetTypeFactory;
import soot.javaToJimple.DefaultLocalGenerator;
import soot.jimple.AssignStmt;
import soot.jimple.CastExpr;
import soot.jimple.Jimple;
import soot.jimple.NullConstant;
import soot.jimple.internal.JAssignStmt;
import soot.jimple.internal.JimpleLocal;

public class DotnetBodyVariableManager {
    private final DotnetBody dotnetBody;
    private final Body mainJb;
    public final LocalGenerator localGenerator;
    private final Set<String> localsToCast = new HashSet<String>();
    private final Map<Local, Local> localsToReference = new HashMap<Local, Local>();

    public DotnetBodyVariableManager(DotnetBody dotnetBody, Body mainJb) {
        this.dotnetBody = dotnetBody;
        this.mainJb = mainJb;
        this.localGenerator = new DefaultLocalGenerator(mainJb);
    }

    public void fillMethodParameter(List<Unit> unwrapCalls, Map<Local, Local> unwrappedToWrapped) {
        DotnetMethod dotnetMethodSig = this.dotnetBody.getDotnetMethodSig();
        this.fillMethodParameter(this.mainJb, dotnetMethodSig.getParameterDefinitions(), unwrapCalls, unwrappedToWrapped);
    }

    public void fillMethodParameter(Body jb, List<ProtoAssemblyAllTypes.ParameterDefinition> parameters, List<Unit> unwrapCalls, Map<Local, Local> unwrappedToWrapped) {
        for (int i = 0; i < parameters.size(); ++i) {
            ProtoAssemblyAllTypes.ParameterDefinition parameter = parameters.get(i);
            Type type = DotnetTypeFactory.toSootType(parameter.getType());
            if (ByReferenceWrapperGenerator.needsWrapper(parameter)) {
                SootClass wrapperClass = ByReferenceWrapperGenerator.getWrapperClass(type);
                RefType wrappedType = wrapperClass.getType();
                Local paramLocal = Jimple.v().newLocal(parameter.getParameterName() + "wrapped", wrappedType);
                jb.getLocals().add(paramLocal);
                jb.getUnits().add(Jimple.v().newIdentityStmt(paramLocal, Jimple.v().newParameterRef(wrappedType, i)));
                Local unwrappedParamLocal = Jimple.v().newLocal(parameter.getParameterName(), type);
                jb.getLocals().add(unwrappedParamLocal);
                unwrapCalls.add(ByReferenceWrapperGenerator.getUnwrapCall(wrapperClass, paramLocal, unwrappedParamLocal));
                unwrappedToWrapped.put(unwrappedParamLocal, paramLocal);
                continue;
            }
            Local paramLocal = Jimple.v().newLocal(parameter.getParameterName(), type);
            jb.getLocals().add(paramLocal);
            jb.getUnits().add(Jimple.v().newIdentityStmt(paramLocal, Jimple.v().newParameterRef(type, i)));
        }
    }

    public void addInitLocalVariables(List<ProtoIlInstructions.IlVariableMsg> variableMsgList) {
        ArrayList<ProtoIlInstructions.IlVariableMsg> initLocalValueTypes = new ArrayList<ProtoIlInstructions.IlVariableMsg>();
        for (ProtoIlInstructions.IlVariableMsg v : variableMsgList) {
            if (v.getVariableKind() != ProtoIlInstructions.IlVariableMsg.IlVariableKind.LOCAL) continue;
            this.addOrGetVariable(v, this.mainJb);
            if (v.getHasInitialValue()) {
                initLocalValueTypes.add(v);
            }
            if (v.getType().getFullname().equals("System.Object")) continue;
            initLocalValueTypes.add(v);
        }
        this.initLocalVariables(initLocalValueTypes);
    }

    private void initLocalVariables(List<ProtoIlInstructions.IlVariableMsg> locals) {
        for (ProtoIlInstructions.IlVariableMsg v : locals) {
            AssignStmt assignStmt;
            if (v.getVariableKind() != ProtoIlInstructions.IlVariableMsg.IlVariableKind.LOCAL) continue;
            Local variable = this.addOrGetVariable(v, this.mainJb);
            if (variable.getType() instanceof PrimType) {
                assignStmt = Jimple.v().newAssignStmt(variable, DotnetTypeFactory.initType(variable));
                this.mainJb.getUnits().add(assignStmt);
                continue;
            }
            if (variable.getType() instanceof ArrayType) {
                assignStmt = Jimple.v().newAssignStmt(variable, NullConstant.v());
                this.mainJb.getUnits().add(assignStmt);
                continue;
            }
            assignStmt = Jimple.v().newAssignStmt(variable, Jimple.v().newNewExpr(RefType.v(v.getType().getFullname())));
            this.mainJb.getUnits().add(assignStmt);
        }
    }

    public Local addOrGetVariable(ProtoIlInstructions.IlVariableMsg v, Body jbTmp) {
        return this.addOrGetVariable(v, null, jbTmp);
    }

    public Local addOrGetVariable(ProtoIlInstructions.IlVariableMsg v, Type type, Body jbTmp) {
        if (v == null) {
            return null;
        }
        if (v.getName().equals("this")) {
            return this.mainJb.getThisLocal();
        }
        if (this.mainJb.getLocals().stream().anyMatch(x -> x.getName().equals(v.getName()))) {
            return this.mainJb.getLocals().stream().filter(x -> x.getName().equals(v.getName())).findFirst().orElse(null);
        }
        Type localType = type == null || type instanceof UnknownType || type instanceof NullType ? DotnetTypeFactory.toSootType(v.getType()) : DotnetTypeFactory.toSootType(type);
        String n = v.getName();
        if (n.isEmpty()) {
            n = "noname";
        }
        Local newLocal = Jimple.v().newLocal(n, localType);
        this.mainJb.getLocals().add(newLocal);
        if (jbTmp != null && jbTmp != this.mainJb) {
            jbTmp.getLocals().add(newLocal);
        }
        return newLocal;
    }

    public void addLocalVariable(Local local) {
        if (this.mainJb.getLocals().contains(local)) {
            return;
        }
        this.mainJb.getLocals().add(local);
    }

    public static Value inlineLocals(Value v, Body jb) {
        Unit unit = jb.getUnits().stream().filter(x -> x instanceof JAssignStmt && ((JAssignStmt)x).getLeftOp().equals(v)).findFirst().orElse(null);
        if (unit instanceof AssignStmt) {
            if (((AssignStmt)unit).getRightOp() instanceof JimpleLocal) {
                return DotnetBodyVariableManager.inlineLocals(((JAssignStmt)unit).getRightOp(), jb);
            }
            if (((AssignStmt)unit).getRightOp() instanceof CastExpr) {
                CastExpr ce = (CastExpr)((AssignStmt)unit).getRightOp();
                return DotnetBodyVariableManager.inlineLocals(ce.getOp(), jb);
            }
            return ((AssignStmt)unit).getRightOp();
        }
        return null;
    }

    public void addLocalsToCast(String local) {
        this.localsToCast.add(local);
    }

    public boolean localsToCastContains(String local) {
        return this.localsToCast.contains(local);
    }

    public void addReferenceLocal(Local element, Local referenceHolder) {
        this.localsToReference.put(element, referenceHolder);
    }

    public Local getReferenceLocal(Local element) {
        return this.localsToReference.get(element);
    }
}

