/*
 * Decompiled with CFR 0.152.
 */
package soot.dotnet.members.method;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import soot.Body;
import soot.BooleanConstant;
import soot.ByteConstant;
import soot.Immediate;
import soot.Local;
import soot.LocalGenerator;
import soot.PrimType;
import soot.RefType;
import soot.Scene;
import soot.SootField;
import soot.SootMethod;
import soot.Type;
import soot.Unit;
import soot.UnitPatchingChain;
import soot.Value;
import soot.ValueBox;
import soot.VoidType;
import soot.dotnet.instructions.CilBlockContainer;
import soot.dotnet.members.ByReferenceWrapperGenerator;
import soot.dotnet.members.DotnetMethod;
import soot.dotnet.members.InitialFieldTagValue;
import soot.dotnet.members.method.BlockEntryPointsManager;
import soot.dotnet.members.method.DelegateHandler;
import soot.dotnet.members.method.DotnetBodyVariableManager;
import soot.dotnet.members.method.TransformIntsToBooleans;
import soot.dotnet.proto.ProtoIlInstructions;
import soot.dotnet.types.DotnetTypeFactory;
import soot.dotnet.values.FunctionPointerConstant;
import soot.jimple.AssignStmt;
import soot.jimple.CastExpr;
import soot.jimple.ConditionExpr;
import soot.jimple.IdentityStmt;
import soot.jimple.IfStmt;
import soot.jimple.IntConstant;
import soot.jimple.InvokeExpr;
import soot.jimple.InvokeStmt;
import soot.jimple.Jimple;
import soot.jimple.JimpleBody;
import soot.jimple.MethodHandle;
import soot.jimple.NewExpr;
import soot.jimple.NullConstant;
import soot.jimple.SpecialInvokeExpr;
import soot.jimple.Stmt;
import soot.jimple.toolkits.base.Aggregator;
import soot.jimple.toolkits.scalar.ConditionalBranchFolder;
import soot.jimple.toolkits.scalar.ConstantCastEliminator;
import soot.jimple.toolkits.scalar.CopyPropagator;
import soot.jimple.toolkits.scalar.DeadAssignmentEliminator;
import soot.jimple.toolkits.scalar.IdentityCastEliminator;
import soot.jimple.toolkits.scalar.IdentityOperationEliminator;
import soot.jimple.toolkits.scalar.NopEliminator;
import soot.jimple.toolkits.scalar.UnconditionalBranchFolder;
import soot.jimple.toolkits.scalar.UnreachableCodeEliminator;
import soot.toolkits.exceptions.TrapTightener;
import soot.toolkits.graph.ExceptionalUnitGraph;
import soot.toolkits.scalar.LocalDefs;
import soot.toolkits.scalar.SimpleLocalDefs;
import soot.toolkits.scalar.SimpleLocalUses;
import soot.toolkits.scalar.UnitValueBoxPair;
import soot.toolkits.scalar.UnusedLocalEliminator;

public class DotnetBody {
    private static final String INIT_ARRAY = "<System.Runtime.CompilerServices.RuntimeHelpers:void InitializeArray(System.Array,System.RuntimeFieldHandle)>";
    private final ProtoIlInstructions.IlFunctionMsg ilFunctionMsg;
    private JimpleBody jb;
    public BlockEntryPointsManager blockEntryPointsManager;
    public DotnetBodyVariableManager variableManager;
    private final DotnetMethod dotnetMethodSig;

    public DotnetMethod getDotnetMethodSig() {
        return this.dotnetMethodSig;
    }

    public ProtoIlInstructions.IlFunctionMsg getFunctionMsg() {
        return this.ilFunctionMsg;
    }

    public DotnetBody(DotnetMethod methodSignature, ProtoIlInstructions.IlFunctionMsg ilFunctionMsg) {
        this.dotnetMethodSig = methodSignature;
        this.ilFunctionMsg = ilFunctionMsg;
        this.blockEntryPointsManager = new BlockEntryPointsManager();
    }

    public void jimplify(JimpleBody jb) {
        this.jb = jb;
        this.variableManager = new DotnetBodyVariableManager(this, this.jb);
        this.addThisStmt();
        ArrayList<Unit> unwrapCalls = new ArrayList<Unit>();
        HashMap<Local, Local> unwrappedToWrapped = new HashMap<Local, Local>();
        this.variableManager.fillMethodParameter(unwrapCalls, unwrappedToWrapped);
        jb.getUnits().addAll(unwrapCalls);
        this.variableManager.addInitLocalVariables(this.ilFunctionMsg.getVariablesList());
        CilBlockContainer blockContainer = new CilBlockContainer(this.ilFunctionMsg.getBody(), this);
        Body b = blockContainer.jimplify();
        Set allLocals = Collections.newSetFromMap(new IdentityHashMap());
        allLocals.addAll(jb.getLocals());
        for (Local l : b.getLocals()) {
            if (!allLocals.add(l)) continue;
            jb.getLocals().add(l);
        }
        jb.getUnits().addAll(b.getUnits());
        jb.getTraps().addAll(b.getTraps());
        this.blockEntryPointsManager.swapGotoEntriesInJBody(jb);
        this.replaceWrappedRefWrites(jb, unwrapCalls, unwrappedToWrapped);
        this.rewriteConditionsToIfs(jb);
        DelegateHandler.replaceDelegates(jb);
        UnconditionalBranchFolder.v().transform(jb);
        TrapTightener.v().transform(jb);
        Aggregator.v().transform(jb);
        ConditionalBranchFolder.v().transform(jb);
        ConstantCastEliminator.v().transform(jb);
        IdentityCastEliminator.v().transform(jb);
        IdentityOperationEliminator.v().transform(jb);
        UnreachableCodeEliminator.v().transform(jb);
        TransformIntsToBooleans.v().transform(jb);
        CopyPropagator.v().transform(jb);
        TransformIntsToBooleans.v().transform(jb);
        CopyPropagator.v().transform(jb);
        this.rewriteConditionsToIfs(jb);
        this.removeDeadNewExpr(jb);
        DeadAssignmentEliminator.v().transform(jb);
        UnusedLocalEliminator.v().transform(jb);
        ConditionalBranchFolder.v().transform(jb);
        UnconditionalBranchFolder.v().transform(jb);
        this.introduceStructConstructorCalls(jb);
        NopEliminator.v().transform(jb);
        this.replaceInitArray(jb);
        this.renameLocals(jb);
        for (Unit u : jb.getUnits()) {
            for (ValueBox d : u.getUseBoxes()) {
                if (!(d.getValue() instanceof FunctionPointerConstant)) continue;
                if (this.dotnetMethodSig.getProtoMessage().getIsUnsafe()) {
                    throw new RuntimeException("Function pointer left in unsafe method; this is expected.");
                }
                throw new RuntimeException("Function pointer left in normal method.");
            }
        }
    }

    protected void renameLocals(JimpleBody jb) {
        HashSet<String> names = new HashSet<String>();
        int id = 0;
        for (Local l : jb.getLocals()) {
            if (names.add(l.getName())) continue;
            l.setName(l.getName() + "_" + id++);
        }
    }

    private void replaceInitArray(JimpleBody jb2) {
        UnitPatchingChain uchain = this.jb.getUnits();
        Object crt = uchain.getFirst();
        Jimple j = Jimple.v();
        while (crt != null) {
            Value ref;
            InvokeExpr invExpr;
            Object next = uchain.getSuccOf(crt);
            Stmt c = (Stmt)crt;
            if (c.containsInvokeExpr() && (invExpr = c.getInvokeExpr()).getMethodRef().getName().equals("InitializeArray") && invExpr.getMethodRef().getSignature().equals(INIT_ARRAY) && (ref = invExpr.getArg(1)) instanceof MethodHandle) {
                MethodHandle mh = (MethodHandle)ref;
                SootField f = mh.getFieldRef().resolve();
                InitialFieldTagValue t2 = (InitialFieldTagValue)f.getTag("InitialFieldValue");
                Value arg = invExpr.getArg(0);
                if (t2 != null) {
                    byte[] val = t2.getValue();
                    ArrayList<AssignStmt> toInsert = new ArrayList<AssignStmt>(val.length);
                    for (int i = 0; i < val.length; ++i) {
                        toInsert.add(j.newAssignStmt(j.newArrayRef(arg, IntConstant.v(i)), ByteConstant.v(val[i])));
                    }
                    uchain.insertAfter(toInsert, c);
                    uchain.remove(c);
                }
            }
            crt = next;
        }
    }

    private void introduceStructConstructorCalls(JimpleBody jb) {
        SimpleLocalUses uses = null;
        UnitPatchingChain uchain = jb.getUnits();
        Object crt = uchain.getFirst();
        Jimple j = Jimple.v();
        block0: while (crt != null) {
            RefType rt;
            AssignStmt assign;
            Value rop;
            Object next = uchain.getSuccOf(crt);
            if (crt instanceof AssignStmt && (rop = (assign = (AssignStmt)crt).getRightOp()) instanceof NewExpr && (rt = (RefType)rop.getType()).hasSootClass() && rt.getSootClass().hasTag("StructTag")) {
                if (uses == null) {
                    uses = new SimpleLocalUses(jb, (LocalDefs)new SimpleLocalDefs(new ExceptionalUnitGraph(jb)));
                }
                Local base = (Local)assign.getLeftOp();
                for (UnitValueBoxPair u : uses.getUsesOf(assign)) {
                    SpecialInvokeExpr si;
                    InvokeExpr expr;
                    Stmt c = (Stmt)u.getUnit();
                    if (!c.containsInvokeExpr() || !((expr = c.getInvokeExpr()) instanceof SpecialInvokeExpr) || !expr.getMethodRef().getName().equals("<init>") || (si = (SpecialInvokeExpr)expr).getBase() != base) continue;
                    crt = next;
                    continue block0;
                }
                SootMethod ctor = rt.getSootClass().getMethod("<init>", Collections.emptyList());
                InvokeStmt ctorcall = j.newInvokeStmt(j.newSpecialInvokeExpr(base, ctor.makeRef()));
                uchain.insertAfter(ctorcall, crt);
            }
            crt = next;
        }
    }

    private void replaceWrappedRefWrites(JimpleBody jb, List<Unit> unwrapCalls, Map<Local, Local> unwrappedToWrapped) {
        UnitPatchingChain unitchain = jb.getUnits();
        Object u = unitchain.getFirst();
        while (u != null) {
            Local unwrapped;
            Local wrapped;
            AssignStmt assign;
            Value lop;
            Object next = unitchain.getSuccOf(u);
            if (!unwrapCalls.contains(u) && u instanceof AssignStmt && (lop = (assign = (AssignStmt)u).getLeftOp()) instanceof Local && (wrapped = unwrappedToWrapped.get(unwrapped = (Local)lop)) != null) {
                unitchain.insertAfter(ByReferenceWrapperGenerator.getUpdateWrappedValueCall(wrapped, unwrapped), u);
            }
            u = next;
        }
    }

    protected void removeDeadNewExpr(JimpleBody jb) {
        UnitPatchingChain up = jb.getUnits();
        ExceptionalUnitGraph g2 = new ExceptionalUnitGraph(jb);
        SimpleLocalUses ld = new SimpleLocalUses(g2, (LocalDefs)new SimpleLocalDefs(g2));
        Object u = up.getFirst();
        while (u != null) {
            AssignStmt assign;
            Object next = up.getSuccOf(u);
            if (u instanceof AssignStmt && (assign = (AssignStmt)u).getRightOp() instanceof NewExpr && ld.getUsesOf(assign).isEmpty()) {
                up.remove(assign);
            }
            u = next;
        }
    }

    protected void rewriteConditionsToIfs(JimpleBody jb) {
        UnitPatchingChain up = jb.getUnits();
        Object u = up.getFirst();
        Jimple j = Jimple.v();
        while (u != null) {
            AssignStmt assign;
            Object next = up.getSuccOf(u);
            if (u instanceof AssignStmt && (assign = (AssignStmt)u).getRightOp() instanceof ConditionExpr) {
                AssignStmt assignTrue = j.newAssignStmt(assign.getLeftOp(), BooleanConstant.v(true));
                AssignStmt assignFalse = j.newAssignStmt(assign.getLeftOp(), BooleanConstant.v(false));
                IfStmt ifs = j.newIfStmt(assign.getRightOp(), assignTrue);
                up.insertBefore(Arrays.asList(ifs, assignFalse, j.newGotoStmt((Unit)next), assignTrue), assign);
                up.remove(assign);
            }
            u = next;
        }
    }

    protected Value createTempVar(Body jb, Jimple jimple, Value inv) {
        Local interimLocal = this.variableManager.localGenerator.generateLocal(inv.getType());
        jb.getLocals().add(interimLocal);
        jb.getUnits().add(jimple.newAssignStmt(interimLocal, inv));
        return interimLocal;
    }

    private void addThisStmt() {
        if (this.dotnetMethodSig.isStatic()) {
            return;
        }
        RefType thisType = this.dotnetMethodSig.getDeclaringClass().getType();
        Local l = Jimple.v().newLocal("this", thisType);
        IdentityStmt identityStmt = Jimple.v().newIdentityStmt(l, Jimple.v().newThisRef(thisType));
        this.jb.getLocals().add(l);
        this.jb.getUnits().add(identityStmt);
    }

    public static Value inlineCastExpr(Value v) {
        if (v instanceof Immediate) {
            return v;
        }
        if (v instanceof CastExpr) {
            return DotnetBody.inlineCastExpr(((CastExpr)v).getOp());
        }
        return v;
    }

    public static JimpleBody getEmptyJimpleBody(SootMethod m4) {
        JimpleBody b = Jimple.v().newBody(m4);
        DotnetBody.resolveEmptyJimpleBody(b, m4);
        return b;
    }

    public static void resolveEmptyJimpleBody(JimpleBody b, SootMethod m4) {
        Jimple j = Jimple.v();
        if (!m4.isStatic()) {
            RefType thisType = m4.getDeclaringClass().getType();
            Local l = j.newLocal("this", thisType);
            IdentityStmt identityStmt = j.newIdentityStmt(l, j.newThisRef(thisType));
            b.getLocals().add(l);
            b.getUnits().add(identityStmt);
        }
        for (int i = 0; i < m4.getParameterCount(); ++i) {
            Type parameterType = m4.getParameterType(i);
            Local paramLocal = j.newLocal("arg" + i, parameterType);
            b.getLocals().add(paramLocal);
            b.getUnits().add(j.newIdentityStmt(paramLocal, j.newParameterRef(parameterType, i)));
        }
        LocalGenerator lg = Scene.v().createLocalGenerator(b);
        b.getUnits().add(j.newThrowStmt(lg.generateLocal(RefType.v("java.lang.Throwable"))));
        if (m4.getReturnType() instanceof VoidType) {
            b.getUnits().add(j.newReturnVoidStmt());
        } else if (m4.getReturnType() instanceof PrimType) {
            b.getUnits().add(j.newReturnStmt(DotnetTypeFactory.initType(m4.getReturnType())));
        } else {
            b.getUnits().add(j.newReturnStmt(NullConstant.v()));
        }
    }
}

