/*
 * Decompiled with CFR 0.152.
 */
package soot.dotnet.members.method;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import soot.FastHierarchy;
import soot.IntType;
import soot.Local;
import soot.LongType;
import soot.RefType;
import soot.Scene;
import soot.SootClass;
import soot.SootField;
import soot.SootMethod;
import soot.SootMethodRef;
import soot.Type;
import soot.Unit;
import soot.UnitBox;
import soot.UnitPatchingChain;
import soot.Value;
import soot.VoidType;
import soot.dotnet.types.DotnetType;
import soot.dotnet.values.FunctionPointerConstant;
import soot.jimple.AssignStmt;
import soot.jimple.IfStmt;
import soot.jimple.InstanceInvokeExpr;
import soot.jimple.IntConstant;
import soot.jimple.InvokeExpr;
import soot.jimple.InvokeStmt;
import soot.jimple.Jimple;
import soot.jimple.JimpleBody;
import soot.jimple.LongConstant;
import soot.jimple.NullConstant;
import soot.jimple.ReturnStmt;
import soot.jimple.SpecialInvokeExpr;
import soot.jimple.StaticInvokeExpr;
import soot.jimple.Stmt;
import soot.jimple.StringConstant;
import soot.jimple.internal.JTableSwitchStmt;
import soot.tagkit.AttributeValueException;
import soot.tagkit.Tag;

public class DelegateHandler {
    public static final String DELEGATE_HOLDER_CLASSNAME = "DelegateHolder";
    private static final String DELEGATE_INTERFACE_CLASSNAME = "IDelegate";
    private static final String FUNCTION_ID_FIELDNAME = "functionID";
    private static final String INSTANCE_FIELDNAME = "instance";
    private static final String GET_LIST = "getList";
    public static final String REMOVE_METHOD_NAME = "removeDelegate";
    public static final String COMBINE_WITH_METHOD_NAME = "combineWith";
    public static final String COMBINE = "combine";
    public static final String INVOKE_METHOD_NAME = "doInvoke";
    public static final String DELEGATE_LIST_NAME = "DelegateList";

    public static void replaceDelegates(JimpleBody jb) {
        UnitPatchingChain u = jb.getUnits();
        Stmt c = (Stmt)u.getFirst();
        RefType obj = Scene.v().getObjectType();
        FastHierarchy fh = null;
        SootClass delegateClass = Scene.v().getSootClassUnsafe("System.Delegate");
        SootClass multidelegateClass = Scene.v().getSootClassUnsafe("System.MulticastDelegate");
        if (delegateClass == null) {
            return;
        }
        Scene sc = Scene.v();
        Jimple j = Jimple.v();
        while (c != null) {
            Stmt next = u.getSuccOf(c);
            if (c.containsInvokeExpr()) {
                InvokeExpr inv = c.getInvokeExpr();
                if (inv instanceof InstanceInvokeExpr && inv.getMethodRef().getName().equals("Invoke")) {
                    SootClass decl = inv.getMethodRef().getDeclaringClass();
                    if (fh == null) {
                        fh = Scene.v().getOrMakeFastHierarchy();
                    }
                    if (fh.canStoreClass(decl, delegateClass) || fh.canStoreClass(decl, multidelegateClass)) {
                        InstanceInvokeExpr istinv = (InstanceInvokeExpr)inv;
                        SootMethodRef invoke = sc.makeMethodRef(decl, INVOKE_METHOD_NAME, inv.getMethodRef().getParameterTypes(), inv.getMethodRef().getReturnType(), false);
                        c.getInvokeExprBox().setValue(j.newSpecialInvokeExpr((Local)istinv.getBase(), invoke, inv.getArgs()));
                    }
                }
                if (inv instanceof SpecialInvokeExpr && inv.getArgCount() == 2) {
                    SootMethod m4 = inv.getMethod();
                    if (m4.getParameterType(0) == obj && m4.isConstructor()) {
                        if (fh == null) {
                            fh = Scene.v().getOrMakeFastHierarchy();
                        }
                        if (fh.canStoreClass(m4.getDeclaringClass(), delegateClass) || fh.canStoreClass(m4.getDeclaringClass(), multidelegateClass)) {
                            SootClass actualDelegateClass = m4.getDeclaringClass();
                            DelegateInfo d = DelegateInfo.getTag(actualDelegateClass);
                            FunctionPointerConstant fpc = (FunctionPointerConstant)inv.getArg(1);
                            int num = d.addDelegateMethod(fpc);
                            InstanceInvokeExpr instInvoke = (InstanceInvokeExpr)inv;
                            InvokeStmt newInvStatement = d.getCallToDelegateCreator((Local)instInvoke.getBase(), inv.getArg(0), num);
                            u.swapWith(c, newInvStatement);
                        }
                    }
                } else if (inv instanceof StaticInvokeExpr && c instanceof AssignStmt) {
                    AssignStmt assign = (AssignStmt)c;
                    switch (inv.getMethodRef().getSignature()) {
                        case "<System.Delegate: System.Delegate Combine(System.Delegate,System.Delegate)>": {
                            SootClass delegateInterface = DelegateHandler.getOrCreateCommonDelegateInterface(sc);
                            SootMethodRef combineMRef = delegateInterface.getMethodByName(COMBINE).makeRef();
                            assign.setRightOp(j.newStaticInvokeExpr(combineMRef, inv.getArg(0), inv.getArg(1)));
                            break;
                        }
                        case "<System.Delegate: System.Delegate Remove(System.Delegate,System.Delegate)>": {
                            SootClass delegateInterface = DelegateHandler.getOrCreateCommonDelegateInterface(sc);
                            SootMethodRef removeMRef = delegateInterface.getMethodByName(REMOVE_METHOD_NAME).makeRef();
                            assign.setRightOp(j.newInterfaceInvokeExpr((Local)inv.getArg(0), removeMRef, inv.getArg(1)));
                        }
                    }
                }
            }
            c = next;
        }
    }

    public static SootClass getOrCreateCommonDelegateInterface(Scene scene) {
        SootClass delegateInterface = scene.getSootClassUnsafe(DELEGATE_INTERFACE_CLASSNAME);
        if (delegateInterface == null) {
            delegateInterface = DelegateInfo.createDelegateInterface(scene);
        }
        return delegateInterface;
    }

    public static class DelegateInfo
    implements Tag {
        public static String DELEGATE_NAME = "DelegateInfo";
        private RefType listType = RefType.v("System.Collections.Generic.List`1");
        public List<Type> delegateParameters;
        public Type delegateReturn;
        private SootMethod callSingle;
        private JTableSwitchStmt tableSwitch;
        public final AtomicInteger counter = new AtomicInteger();
        private SootField listField;
        private SootField instanceField;
        private SootField functionIDField;
        private Local retLocal;
        private Local instanceParameter;
        private JimpleBody callSingleBody;
        private SootMethod mCtorSingle;
        private SootMethod mCtorList;
        private Map<FunctionPointerConstant, Integer> signatureToFunctionID = new HashMap<FunctionPointerConstant, Integer>();

        @Override
        public String getName() {
            return DELEGATE_NAME;
        }

        @Override
        public byte[] getValue() throws AttributeValueException {
            return null;
        }

        public SootMethodRef getListMethod(Type retType, String methodName, Type ... paramTypes) {
            return Scene.v().makeMethodRef(Scene.v().getSootClass("System.Collections.Generic.List`1"), methodName, Arrays.asList(paramTypes), retType, false);
        }

        private DelegateInfo(SootClass actualDelegateClass) {
            Stmt uret;
            SootMethod m4 = actualDelegateClass.getMethodByName("Invoke");
            this.delegateParameters = m4.getParameterTypes();
            this.delegateReturn = m4.getReturnType();
            Scene sc = Scene.v();
            SootClass dh = DelegateInfo.createDelegateHolder(sc);
            this.instanceField = dh.getFieldByName(DelegateHandler.INSTANCE_FIELDNAME);
            this.functionIDField = dh.getFieldByName(DelegateHandler.FUNCTION_ID_FIELDNAME);
            actualDelegateClass.addInterface(dh);
            ArrayList<Type> callSinglePTypes = new ArrayList<Type>(this.delegateParameters.size() + 1);
            callSinglePTypes.add(sc.getObjectType());
            callSinglePTypes.add(IntType.v());
            callSinglePTypes.addAll(this.delegateParameters);
            Jimple j = Jimple.v();
            this.listField = sc.makeSootField(DelegateHandler.DELEGATE_LIST_NAME, this.listType);
            actualDelegateClass.addField(this.listField);
            DelegateInfo.createDelegateInterface(sc);
            this.createListConstructor(sc, actualDelegateClass);
            this.callSingle = sc.makeSootMethod("callSingle", callSinglePTypes, this.delegateReturn, 9);
            actualDelegateClass.addMethod(this.callSingle);
            this.callSingleBody = j.newBody(this.callSingle);
            this.callSingle.setActiveBody(this.callSingleBody);
            this.callSingleBody.insertIdentityStmts();
            this.instanceParameter = this.callSingleBody.getParameterLocal(0);
            this.retLocal = null;
            if (this.delegateReturn instanceof VoidType) {
                uret = j.newReturnVoidStmt();
            } else {
                this.retLocal = j.newLocal("retVal", this.delegateReturn);
                this.callSingleBody.getLocals().add(this.retLocal);
                uret = j.newReturnStmt(NullConstant.v());
            }
            this.tableSwitch = (JTableSwitchStmt)j.newTableSwitchStmt((Value)this.callSingleBody.getParameterLocal(1), 0, 0, new ArrayList(), uret);
            this.callSingleBody.getUnits().add(this.tableSwitch);
            this.callSingleBody.getUnits().add(uret);
            this.createDelegateMethods(sc, actualDelegateClass, callSinglePTypes);
            this.createSingleConstructor(sc, actualDelegateClass);
        }

        private void createDelegateMethods(Scene sc, SootClass actualDelegateClass, List<Type> callSinglePTypes) {
            SootClass delegateInterface = sc.getSootClass(DelegateHandler.DELEGATE_INTERFACE_CLASSNAME);
            Jimple j = Jimple.v();
            SootMethod combineWith = sc.makeSootMethod(DelegateHandler.COMBINE_WITH_METHOD_NAME, Arrays.asList(delegateInterface.getType()), delegateInterface.getType(), 1);
            RefType enumerable = RefType.v("System.Collections.Generic.IEnumerable`1");
            RefType delegateHolderType = RefType.v(DelegateHandler.DELEGATE_HOLDER_CLASSNAME);
            RefType at = actualDelegateClass.getType();
            JimpleBody bodycombi = j.newBody(combineWith);
            combineWith.setActiveBody(bodycombi);
            actualDelegateClass.addMethod(combineWith);
            bodycombi.insertIdentityStmts();
            Local lclList = j.newLocal("List", this.listType);
            Local lclMyList = j.newLocal("MyList", this.listType);
            Local lclOtherList = j.newLocal("OtherList", this.listType);
            bodycombi.getLocals().add(lclList);
            bodycombi.getLocals().add(lclMyList);
            bodycombi.getLocals().add(lclOtherList);
            bodycombi.getUnits().add(j.newAssignStmt(lclMyList, j.newInstanceFieldRef(bodycombi.getThisLocal(), this.listField.makeRef())));
            bodycombi.getUnits().add(j.newAssignStmt(lclOtherList, j.newInterfaceInvokeExpr(bodycombi.getParameterLocal(0), delegateInterface.getMethodByName(DelegateHandler.GET_LIST).makeRef())));
            bodycombi.getUnits().add(j.newAssignStmt(lclList, j.newNewExpr(this.listType)));
            bodycombi.getUnits().add(j.newInvokeStmt(j.newSpecialInvokeExpr(lclList, this.getListMethod(VoidType.v(), "<init>", enumerable), (Value)lclMyList)));
            bodycombi.getUnits().add(j.newInvokeStmt(j.newVirtualInvokeExpr(lclList, this.getListMethod(VoidType.v(), "AddRange", enumerable), (Value)lclOtherList)));
            Local del = j.newLocal("resDelegate", at);
            bodycombi.getLocals().add(del);
            bodycombi.getUnits().add(j.newAssignStmt(del, j.newNewExpr(at)));
            bodycombi.getUnits().add(j.newInvokeStmt(j.newSpecialInvokeExpr(del, this.mCtorList.makeRef(), (Value)lclList)));
            bodycombi.getUnits().add(j.newReturnStmt(del));
            SootMethod removeFrom = sc.makeSootMethod(DelegateHandler.REMOVE_METHOD_NAME, Arrays.asList(delegateInterface.getType()), delegateInterface.getType(), 1);
            lclList = j.newLocal("List", this.listType);
            lclMyList = j.newLocal("MyList", this.listType);
            lclOtherList = j.newLocal("OtherList", this.listType);
            actualDelegateClass.addMethod(removeFrom);
            JimpleBody bodyrem = j.newBody(removeFrom);
            removeFrom.setActiveBody(bodyrem);
            bodyrem.insertIdentityStmts();
            bodyrem.getLocals().add(lclList);
            bodyrem.getLocals().add(lclMyList);
            bodyrem.getLocals().add(lclOtherList);
            bodyrem.getUnits().add(j.newAssignStmt(lclMyList, j.newInstanceFieldRef(bodyrem.getThisLocal(), this.listField.makeRef())));
            bodyrem.getUnits().add(j.newAssignStmt(lclOtherList, j.newInterfaceInvokeExpr(bodyrem.getParameterLocal(0), delegateInterface.getMethodByName(DelegateHandler.GET_LIST).makeRef())));
            bodyrem.getUnits().add(j.newAssignStmt(lclList, j.newNewExpr(this.listType)));
            bodyrem.getUnits().add(j.newInvokeStmt(j.newSpecialInvokeExpr(lclList, this.getListMethod(VoidType.v(), "<init>", enumerable), (Value)lclMyList)));
            Local idx = j.newLocal("idx", IntType.v());
            Local otherCount = j.newLocal("otherCount", IntType.v());
            SootMethodRef getCount = this.getListMethod(IntType.v(), "get_Count", new Type[0]);
            Local del2 = j.newLocal("resDelegate", at);
            bodyrem.getLocals().add(idx);
            bodyrem.getLocals().add(del2);
            bodyrem.getLocals().add(otherCount);
            AssignStmt beforeEnd = j.newAssignStmt(del2, j.newNewExpr(at));
            bodyrem.getUnits().add(j.newAssignStmt(idx, j.newVirtualInvokeExpr(lclList, getCount)));
            bodyrem.getUnits().add(j.newAssignStmt(otherCount, j.newVirtualInvokeExpr(lclOtherList, getCount)));
            bodyrem.getUnits().add(j.newAssignStmt(idx, j.newSubExpr(idx, otherCount)));
            bodyrem.getUnits().add(j.newIfStmt((Value)j.newEqExpr(otherCount, IntConstant.v(0)), beforeEnd));
            Local firstOtherElem = j.newLocal("firstElem", sc.getObjectType());
            bodyrem.getLocals().add(firstOtherElem);
            bodyrem.getUnits().add(j.newAssignStmt(firstOtherElem, j.newVirtualInvokeExpr(lclOtherList, this.getListMethod(sc.getObjectType(), "get_Item", IntType.v()), (Value)IntConstant.v(0))));
            IfStmt outerLoop = j.newIfStmt((Value)j.newLtExpr(idx, IntConstant.v(0)), beforeEnd);
            bodyrem.getUnits().add(outerLoop);
            bodyrem.getUnits().add(j.newAssignStmt(idx, j.newVirtualInvokeExpr(lclList, this.getListMethod(IntType.v(), "LastIndexOf", sc.getObjectType(), IntType.v()), firstOtherElem, idx)));
            bodyrem.getUnits().add(j.newIfStmt((Value)j.newEqExpr(idx, IntConstant.v(-1)), beforeEnd));
            Local i = j.newLocal("i", IntType.v());
            Local x = j.newLocal("x", IntType.v());
            bodyrem.getLocals().add(i);
            bodyrem.getLocals().add(x);
            bodyrem.getUnits().add(j.newAssignStmt(i, idx));
            bodyrem.getUnits().add(j.newAssignStmt(x, IntConstant.v(0)));
            Local to = j.newLocal("toTarget", IntType.v());
            bodyrem.getLocals().add(to);
            bodyrem.getUnits().add(j.newAssignStmt(to, j.newAddExpr(idx, otherCount)));
            InvokeStmt remove = j.newInvokeStmt(j.newVirtualInvokeExpr(lclList, this.getListMethod(VoidType.v(), "RemoveRange", IntType.v(), IntType.v()), idx, otherCount));
            IfStmt loopHeader = j.newIfStmt((Value)j.newGeExpr(i, to), remove);
            bodyrem.getUnits().add(loopHeader);
            Local delegate1 = j.newLocal("delegate1", delegateHolderType);
            Local delegate2 = j.newLocal("delegate2", delegateHolderType);
            bodyrem.getLocals().add(delegate1);
            bodyrem.getLocals().add(delegate2);
            bodyrem.getUnits().add(j.newAssignStmt(delegate1, j.newVirtualInvokeExpr(lclList, this.getListMethod(sc.getObjectType(), "get_Item", IntType.v()), (Value)i)));
            bodyrem.getUnits().add(j.newAssignStmt(delegate2, j.newVirtualInvokeExpr(lclOtherList, this.getListMethod(sc.getObjectType(), "get_Item", IntType.v()), (Value)x)));
            AssignStmt incX = j.newAssignStmt(x, j.newAddExpr(x, IntConstant.v(1)));
            bodyrem.getUnits().add(j.newIfStmt((Value)j.newEqExpr(delegate1, delegate2), incX));
            bodyrem.getUnits().add(j.newAssignStmt(idx, j.newSubExpr(idx, IntConstant.v(1))));
            bodyrem.getUnits().add(j.newGotoStmt(outerLoop));
            bodyrem.getUnits().add(incX);
            bodyrem.getUnits().add(j.newAssignStmt(i, j.newAddExpr(i, IntConstant.v(1))));
            bodyrem.getUnits().add(j.newGotoStmt(loopHeader));
            bodyrem.getUnits().add(remove);
            bodyrem.getUnits().add(beforeEnd);
            bodyrem.getUnits().add(j.newInvokeStmt(j.newSpecialInvokeExpr(del2, this.mCtorList.makeRef(), (Value)lclList)));
            ReturnStmt ret = j.newReturnStmt(del2);
            bodyrem.getUnits().add(ret);
            SootMethod getList = sc.makeSootMethod(DelegateHandler.GET_LIST, Collections.emptyList(), RefType.v("System.Collections.Generic.List`1"), 1);
            actualDelegateClass.addMethod(getList);
            JimpleBody bodylist = j.newBody(getList);
            getList.setActiveBody(bodylist);
            bodylist.insertIdentityStmts();
            Local lclList2 = j.newLocal("List", this.listType);
            bodylist.getLocals().add(lclList2);
            bodylist.getUnits().add(j.newAssignStmt(lclList2, j.newInstanceFieldRef(bodylist.getThisLocal(), this.listField.makeRef())));
            bodylist.getUnits().add(j.newReturnStmt(lclList2));
            Type retType = this.delegateReturn instanceof VoidType ? VoidType.v() : sc.getObjectType();
            SootMethod doInvoke = sc.makeSootMethod(DelegateHandler.INVOKE_METHOD_NAME, this.delegateParameters, retType, 1);
            SootMethod m4 = actualDelegateClass.getMethodByName("callSingle");
            actualDelegateClass.addMethod(doInvoke);
            JimpleBody bodyInvoke = j.newBody(doInvoke);
            doInvoke.setActiveBody(bodyInvoke);
            bodyInvoke.insertIdentityStmts();
            Local lclList3 = j.newLocal("List", this.listType);
            bodyInvoke.getLocals().add(lclList3);
            Local lclRet = null;
            if (!(this.delegateReturn instanceof VoidType)) {
                lclRet = j.newLocal("RetVal", this.delegateReturn);
                bodyInvoke.getLocals().add(lclRet);
            }
            bodyInvoke.getUnits().add(j.newAssignStmt(lclList3, j.newInstanceFieldRef(bodyInvoke.getThisLocal(), this.listField.makeRef())));
            Local lclCurrentDelegateHolder = j.newLocal("currentDH", delegateHolderType);
            bodyInvoke.getLocals().add(lclCurrentDelegateHolder);
            Local lclCount = j.newLocal("count", IntType.v());
            bodyInvoke.getLocals().add(lclCount);
            SootMethodRef getCount2 = this.getListMethod(IntType.v(), "get_Count", new Type[0]);
            bodyInvoke.getUnits().add(j.newAssignStmt(lclCount, j.newVirtualInvokeExpr(lclList3, getCount2)));
            Local lclIndex = j.newLocal("i", IntType.v());
            bodyInvoke.getLocals().add(lclIndex);
            bodyInvoke.getUnits().add(j.newAssignStmt(lclIndex, IntConstant.v(0)));
            Stmt retS = lclRet != null ? j.newReturnStmt(lclRet) : j.newReturnVoidStmt();
            IfStmt backedge = j.newIfStmt((Value)j.newEqExpr(lclIndex, lclCount), retS);
            bodyInvoke.getUnits().add(backedge);
            ArrayList<Local> parameters = new ArrayList<Local>();
            Local objFromDelegate = j.newLocal("objFromDelegate", sc.getObjectType());
            bodyInvoke.getLocals().add(objFromDelegate);
            Local instanceFromDelegate = j.newLocal(DelegateHandler.INSTANCE_FIELDNAME, IntType.v());
            bodyInvoke.getLocals().add(instanceFromDelegate);
            bodyInvoke.getUnits().add(j.newAssignStmt(lclCurrentDelegateHolder, j.newVirtualInvokeExpr(lclList3, this.getListMethod(sc.getObjectType(), "get_Item", IntType.v()), (Value)lclIndex)));
            bodyInvoke.getUnits().add(j.newAssignStmt(objFromDelegate, j.newInstanceFieldRef(lclCurrentDelegateHolder, this.instanceField.makeRef())));
            bodyInvoke.getUnits().add(j.newAssignStmt(instanceFromDelegate, j.newInstanceFieldRef(lclCurrentDelegateHolder, this.functionIDField.makeRef())));
            parameters.add(objFromDelegate);
            parameters.add(instanceFromDelegate);
            parameters.addAll(bodyInvoke.getParameterLocals());
            StaticInvokeExpr inv = j.newStaticInvokeExpr(m4.makeRef(), parameters);
            if (lclRet == null) {
                bodyInvoke.getUnits().add(j.newInvokeStmt(inv));
            } else {
                bodyInvoke.getUnits().add(j.newAssignStmt(lclRet, inv));
            }
            bodyInvoke.getUnits().add(j.newAssignStmt(lclIndex, j.newAddExpr(lclIndex, IntConstant.v(1))));
            bodyInvoke.getUnits().add(j.newGotoStmt(backedge));
            bodyInvoke.getUnits().add(retS);
            SootMethod toString = sc.makeSootMethod("ToString", Collections.emptyList(), RefType.v("System.String"), 1);
            JimpleBody jb = j.newBody(toString);
            toString.setActiveBody(jb);
            actualDelegateClass.addMethod(toString);
            jb.insertIdentityStmts();
            Local list = j.newLocal("list", this.listType);
            Local res = j.newLocal("res", RefType.v("System.String"));
            jb.getLocals().add(list);
            jb.getLocals().add(res);
            jb.getUnits().add(j.newAssignStmt(list, j.newInstanceFieldRef(jb.getThisLocal(), this.listField.makeRef())));
            SootMethodRef mr = this.getListMethod(RefType.v("System.String"), "ToString", new Type[0]);
            jb.getUnits().add(j.newAssignStmt(res, j.newVirtualInvokeExpr(list, mr)));
            jb.getUnits().add(j.newReturnStmt(res));
        }

        protected void createSingleConstructor(Scene sc, SootClass actualDelegateClass) {
            Jimple j = Jimple.v();
            this.mCtorSingle = sc.makeSootMethod("<init>", Arrays.asList(sc.getObjectType(), LongType.v()), VoidType.v(), 1);
            JimpleBody bodyctorsingle = j.newBody(this.mCtorSingle);
            this.mCtorSingle.setActiveBody(bodyctorsingle);
            actualDelegateClass.addMethod(this.mCtorSingle);
            bodyctorsingle.insertIdentityStmts();
            Local lclList = j.newLocal("List", this.listType);
            bodyctorsingle.getLocals().add(lclList);
            Local intConverter = j.newLocal("intConverter", IntType.v());
            bodyctorsingle.getLocals().add(intConverter);
            bodyctorsingle.getUnits().add(j.newAssignStmt(intConverter, j.newCastExpr(bodyctorsingle.getParameterLocal(1), IntType.v())));
            bodyctorsingle.getUnits().add(j.newAssignStmt(lclList, j.newNewExpr(this.listType)));
            bodyctorsingle.getUnits().add(j.newInvokeStmt(j.newSpecialInvokeExpr(lclList, this.getListMethod(VoidType.v(), "<init>", new Type[0]))));
            Local val = DelegateInfo.createHolderInstance(bodyctorsingle, bodyctorsingle.getParameterLocal(0), intConverter);
            bodyctorsingle.getUnits().add(j.newInvokeStmt(j.newVirtualInvokeExpr(lclList, this.getListMethod(VoidType.v(), "Add", sc.getObjectType()), (Value)val)));
            bodyctorsingle.getUnits().add(j.newAssignStmt(j.newInstanceFieldRef(bodyctorsingle.getThisLocal(), this.listField.makeRef()), lclList));
            bodyctorsingle.getUnits().add(j.newReturnVoidStmt());
        }

        protected void createListConstructor(Scene sc, SootClass actualDelegateClass) {
            Jimple j = Jimple.v();
            this.mCtorList = sc.makeSootMethod("<init>", Arrays.asList(this.listType), VoidType.v(), 1);
            JimpleBody bodyctorlist = j.newBody(this.mCtorList);
            this.mCtorList.setActiveBody(bodyctorlist);
            actualDelegateClass.addMethod(this.mCtorList);
            bodyctorlist.insertIdentityStmts();
            bodyctorlist.getUnits().add(j.newAssignStmt(j.newInstanceFieldRef(bodyctorlist.getThisLocal(), this.listField.makeRef()), bodyctorlist.getParameterLocal(0)));
            bodyctorlist.getUnits().add(j.newReturnVoidStmt());
        }

        private static Local createHolderInstance(JimpleBody jb, Value instance, Value functionid) {
            Jimple j = Jimple.v();
            RefType holderType = RefType.v(DelegateHandler.DELEGATE_HOLDER_CLASSNAME);
            Local l = j.newLocal("holder", holderType);
            jb.getLocals().add(l);
            jb.getUnits().add(j.newAssignStmt(l, j.newNewExpr(holderType)));
            jb.getUnits().add(j.newInvokeStmt(j.newSpecialInvokeExpr(l, holderType.getSootClass().getMethodByName("<init>").makeRef(), instance, functionid)));
            return l;
        }

        public static synchronized SootClass createDelegateInterface(Scene sc) {
            SootClass delegateInterface = sc.getSootClassUnsafe(DelegateHandler.DELEGATE_INTERFACE_CLASSNAME);
            if (delegateInterface != null) {
                return delegateInterface;
            }
            delegateInterface = sc.makeSootClass(DelegateHandler.DELEGATE_INTERFACE_CLASSNAME, 1537);
            delegateInterface.setApplicationClass();
            SootMethod combineWith = sc.makeSootMethod(DelegateHandler.COMBINE_WITH_METHOD_NAME, Arrays.asList(delegateInterface.getType()), delegateInterface.getType(), 1025);
            delegateInterface.addMethod(combineWith);
            SootMethod removeFrom = sc.makeSootMethod(DelegateHandler.REMOVE_METHOD_NAME, Arrays.asList(delegateInterface.getType()), delegateInterface.getType(), 1025);
            delegateInterface.addMethod(removeFrom);
            SootMethod getList = sc.makeSootMethod(DelegateHandler.GET_LIST, Collections.emptyList(), RefType.v("System.Collections.Generic.List`1"), 1025);
            delegateInterface.addMethod(getList);
            SootMethod combine = sc.makeSootMethod(DelegateHandler.COMBINE, Arrays.asList(delegateInterface.getType(), delegateInterface.getType()), delegateInterface.getType(), 9);
            delegateInterface.addMethod(combine);
            Jimple j = Jimple.v();
            JimpleBody bd = j.newBody(combine);
            combine.setActiveBody(bd);
            bd.insertIdentityStmts();
            UnitPatchingChain uc = bd.getUnits();
            Local l = j.newLocal("retHandler", delegateInterface.getType());
            bd.getLocals().add(l);
            ReturnStmt retOne = j.newReturnStmt(bd.getParameterLocal(1));
            ReturnStmt retTwo = j.newReturnStmt(bd.getParameterLocal(0));
            uc.add(j.newIfStmt((Value)j.newEqExpr(bd.getParameterLocal(0), NullConstant.v()), retOne));
            uc.add(j.newIfStmt((Value)j.newEqExpr(bd.getParameterLocal(1), NullConstant.v()), retTwo));
            uc.add(j.newAssignStmt(l, j.newInterfaceInvokeExpr(bd.getParameterLocal(0), combineWith.makeRef(), (Value)bd.getParameterLocal(1))));
            uc.add(j.newReturnStmt(l));
            uc.add(retOne);
            uc.add(retTwo);
            return delegateInterface;
        }

        protected static synchronized SootClass createDelegateHolder(Scene sc) {
            SootClass dh = sc.getSootClassUnsafe(DelegateHandler.DELEGATE_HOLDER_CLASSNAME);
            if (dh != null) {
                return dh;
            }
            SootClass delegateHolder = sc.makeSootClass(DelegateHandler.DELEGATE_HOLDER_CLASSNAME, 1);
            delegateHolder.setApplicationClass();
            SootField instanceField = sc.makeSootField(DelegateHandler.INSTANCE_FIELDNAME, sc.getObjectType(), 1);
            delegateHolder.addField(instanceField);
            SootField functionIDField = sc.makeSootField(DelegateHandler.FUNCTION_ID_FIELDNAME, IntType.v(), 1);
            delegateHolder.addField(functionIDField);
            SootMethod ctor = sc.makeSootMethod("<init>", Arrays.asList(sc.getObjectType(), IntType.v()), VoidType.v(), 1);
            Jimple j = Jimple.v();
            JimpleBody jb = j.newBody(ctor);
            ctor.setActiveBody(jb);
            delegateHolder.addMethod(ctor);
            jb.insertIdentityStmts();
            jb.getUnits().add(j.newAssignStmt(j.newInstanceFieldRef(jb.getThisLocal(), instanceField.makeRef()), jb.getParameterLocal(0)));
            jb.getUnits().add(j.newAssignStmt(j.newInstanceFieldRef(jb.getThisLocal(), functionIDField.makeRef()), jb.getParameterLocal(1)));
            jb.getUnits().add(j.newReturnVoidStmt());
            DotnetType.createStructDefaultHashCodeEquals(delegateHolder);
            SootMethod toString = sc.makeSootMethod("ToString", Collections.emptyList(), RefType.v("System.String"), 1);
            jb = j.newBody(toString);
            toString.setActiveBody(jb);
            delegateHolder.addMethod(toString);
            jb.insertIdentityStmts();
            Local l1 = j.newLocal("l1", RefType.v("System.Object"));
            Local l2 = j.newLocal("l2", IntType.v());
            Local res = j.newLocal("res", RefType.v("System.String"));
            jb.getLocals().add(l1);
            jb.getLocals().add(l2);
            jb.getLocals().add(res);
            jb.getUnits().add(j.newAssignStmt(l1, j.newInstanceFieldRef(jb.getThisLocal(), instanceField.makeRef())));
            jb.getUnits().add(j.newAssignStmt(l2, j.newInstanceFieldRef(jb.getThisLocal(), functionIDField.makeRef())));
            SootMethodRef mr = sc.makeMethodRef(Scene.v().getSootClass("System.String"), "Concat", Arrays.asList(sc.getObjectType(), sc.getObjectType(), sc.getObjectType()), RefType.v("System.String"), true);
            jb.getUnits().add(j.newAssignStmt(res, j.newStaticInvokeExpr(mr, l1, StringConstant.v(" - "), l2)));
            jb.getUnits().add(j.newReturnStmt(res));
            return delegateHolder;
        }

        public static synchronized DelegateInfo getTag(SootClass actualDelegateClass) {
            DelegateInfo i = (DelegateInfo)actualDelegateClass.getTag(DELEGATE_NAME);
            if (i == null) {
                i = new DelegateInfo(actualDelegateClass);
                actualDelegateClass.addTag(i);
            }
            return i;
        }

        public synchronized int addDelegateMethod(FunctionPointerConstant fpc) {
            Stmt ret;
            Stmt call;
            SootMethod resolved;
            Integer id = this.signatureToFunctionID.get(fpc);
            if (id != null) {
                return id;
            }
            id = this.counter.getAndIncrement();
            Jimple j = Jimple.v();
            ArrayList<Value> args = new ArrayList<Value>();
            List<Local> locals = this.callSingleBody.getParameterLocals();
            for (int i = 2; i < locals.size(); ++i) {
                args.add(locals.get(i));
            }
            InvokeExpr expr = fpc.isVirtual() ? j.newVirtualInvokeExpr(this.instanceParameter, fpc.getSootMethodRef(), args) : ((resolved = fpc.getSootMethodRef().resolve()).isStatic() ? j.newStaticInvokeExpr(fpc.getSootMethodRef(), args) : j.newSpecialInvokeExpr(this.instanceParameter, fpc.getSootMethodRef(), args));
            if (this.delegateReturn instanceof VoidType) {
                call = j.newInvokeStmt(expr);
                ret = j.newReturnVoidStmt();
            } else {
                call = j.newAssignStmt(this.retLocal, expr);
                ret = j.newReturnStmt(this.retLocal);
            }
            List<Unit> toAdd = Arrays.asList(call, ret);
            this.callSingleBody.getUnits().insertBeforeNoRedirect(toAdd, this.callSingleBody.getUnits().getLast());
            List<UnitBox> boxes = this.tableSwitch.getUnitBoxes();
            UnitBox box = j.newStmtBox(call);
            boxes.add(boxes.size() - 1, box);
            this.tableSwitch.getTargetBoxes().add(box);
            this.tableSwitch.setHighIndex(id);
            this.signatureToFunctionID.put(fpc, id);
            return id;
        }

        public InvokeStmt getCallToDelegateCreator(Local delegateObj, Value base, int num) {
            Jimple j = Jimple.v();
            return j.newInvokeStmt(j.newSpecialInvokeExpr(delegateObj, this.mCtorSingle.makeRef(), base, LongConstant.v(num)));
        }
    }
}

