/*
 * Decompiled with CFR 0.152.
 */
package soot.dotnet.members.method;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import soot.Body;
import soot.Unit;
import soot.jimple.GotoStmt;
import soot.jimple.IfStmt;
import soot.jimple.TableSwitchStmt;

public class BlockEntryPointsManager {
    private final HashMap<String, Unit> methodBlockEntryPoints = new HashMap();
    public final HashMap<Unit, String> gotoTargetsInBody = new HashMap();

    public void putBlockEntryPoint(String blockName, Unit entryUnit) {
        this.methodBlockEntryPoints.put(blockName, entryUnit);
    }

    public Unit getBlockEntryPoint(String blockName) {
        return this.methodBlockEntryPoints.get(blockName);
    }

    public void swapGotoEntriesInJBody(Body jb) {
        this.methodBlockEntryPoints.put("RETURNLEAVE", (Unit)jb.getUnits().getLast());
        for (Unit unit : jb.getUnits()) {
            Unit unitToSwap;
            Unit unitToSwap2;
            String entryPointString;
            if (unit instanceof GotoStmt) {
                entryPointString = this.gotoTargetsInBody.get(((GotoStmt)unit).getTarget());
                if (entryPointString == null || (unitToSwap2 = this.methodBlockEntryPoints.get(entryPointString)) == null) continue;
                ((GotoStmt)unit).setTarget(unitToSwap2);
            }
            if (unit instanceof IfStmt) {
                entryPointString = this.gotoTargetsInBody.get(((IfStmt)unit).getTarget());
                if (entryPointString == null || (unitToSwap2 = this.methodBlockEntryPoints.get(entryPointString)) == null) continue;
                ((IfStmt)unit).setTarget(unitToSwap2);
            }
            if (!(unit instanceof TableSwitchStmt)) continue;
            TableSwitchStmt tableSwitchStmt = (TableSwitchStmt)unit;
            List<Unit> targets = tableSwitchStmt.getTargets();
            for (int i = 0; i < targets.size(); ++i) {
                Unit unitToSwap3;
                Unit target = targets.get(i);
                String entryPointString2 = this.gotoTargetsInBody.get(target);
                if (entryPointString2 == null || (unitToSwap3 = this.methodBlockEntryPoints.get(entryPointString2)) == null) continue;
                tableSwitchStmt.setTarget(i, unitToSwap3);
            }
            String entryPointStringDefault = this.gotoTargetsInBody.get(tableSwitchStmt.getDefaultTarget());
            if (entryPointStringDefault == null || (unitToSwap = this.methodBlockEntryPoints.get(entryPointStringDefault)) == null) continue;
            tableSwitchStmt.setDefaultTarget(unitToSwap);
        }
    }

    public void swapGotoEntryUnit(Unit in, Unit out) {
        for (Map.Entry<String, Unit> set : this.methodBlockEntryPoints.entrySet()) {
            if (set.getValue() != out) continue;
            set.setValue(in);
        }
    }
}

