/*
 * Decompiled with CFR 0.152.
 */
package soot.dotnet.members;

import java.math.BigDecimal;
import soot.BooleanConstant;
import soot.ByteConstant;
import soot.Scene;
import soot.ShortConstant;
import soot.SootField;
import soot.Type;
import soot.UByteConstant;
import soot.dotnet.members.AbstractDotnetMember;
import soot.dotnet.members.InitialFieldTagValue;
import soot.dotnet.proto.ProtoAssemblyAllTypes;
import soot.dotnet.specifications.DotnetModifier;
import soot.dotnet.types.DotnetTypeFactory;
import soot.jimple.UIntConstant;
import soot.jimple.ULongConstant;
import soot.tagkit.DecimalConstantValueTag;
import soot.tagkit.DoubleConstantValueTag;
import soot.tagkit.FloatConstantValueTag;
import soot.tagkit.IntegerConstantValueTag;
import soot.tagkit.LongConstantValueTag;
import soot.tagkit.StringConstantValueTag;

public class DotnetField
extends AbstractDotnetMember {
    private final ProtoAssemblyAllTypes.FieldDefinition protoField;

    public DotnetField(ProtoAssemblyAllTypes.FieldDefinition protoField) {
        this.protoField = protoField;
    }

    public SootField makeSootField() {
        int modifier = DotnetModifier.toSootModifier(this.protoField);
        Type type = DotnetTypeFactory.toSootType(this.protoField.getType());
        String name = this.protoField.getName();
        SootField mf = Scene.v().makeSootField(name, type, modifier);
        if (this.protoField.getInitialValue() != null && !this.protoField.getInitialValue().isEmpty()) {
            mf.addTag(new InitialFieldTagValue(this.protoField.getInitialValue().toByteArray()));
        }
        switch (this.protoField.getConstantType()) {
            case type_unknown: {
                break;
            }
            default: {
                throw new RuntimeException("Unsupported: " + this.protoField.getConstantType());
            }
            case type_double: {
                mf.addTag(new DoubleConstantValueTag(this.protoField.getValueConstantDouble()));
                break;
            }
            case type_float: {
                mf.addTag(new FloatConstantValueTag(this.protoField.getValueConstantFloat()));
                break;
            }
            case type_int32: {
                mf.addTag(new IntegerConstantValueTag((int)this.protoField.getValueConstantInt64()));
                break;
            }
            case type_int64: {
                mf.addTag(new LongConstantValueTag(this.protoField.getValueConstantInt64()));
                break;
            }
            case type_string: {
                mf.addTag(new StringConstantValueTag(this.protoField.getValueConstantString()));
                break;
            }
            case type_bool: {
                mf.addTag(new IntegerConstantValueTag(BooleanConstant.v(this.protoField.getValueConstantBool() ? 1 : 0)));
                break;
            }
            case type_sbyte: {
                mf.addTag(new IntegerConstantValueTag(ByteConstant.v((byte)this.protoField.getValueConstantInt64())));
                break;
            }
            case type_byte: {
                mf.addTag(new IntegerConstantValueTag(UByteConstant.v((int)this.protoField.getValueConstantInt64())));
                break;
            }
            case type_uint16: {
                mf.addTag(new IntegerConstantValueTag(ShortConstant.v((short)this.protoField.getValueConstantInt64())));
                break;
            }
            case type_int16: {
                mf.addTag(new IntegerConstantValueTag(ShortConstant.v((short)this.protoField.getValueConstantInt64())));
                break;
            }
            case type_char: {
                mf.addTag(new IntegerConstantValueTag(ShortConstant.v((char)this.protoField.getValueConstantInt64())));
                break;
            }
            case type_uint32: {
                mf.addTag(new IntegerConstantValueTag(UIntConstant.v((int)this.protoField.getValueConstantInt64())));
                break;
            }
            case type_uint64: {
                mf.addTag(new LongConstantValueTag(ULongConstant.v(this.protoField.getValueConstantUint64())));
                break;
            }
            case type_decimal: {
                mf.addTag(new DecimalConstantValueTag(new BigDecimal(this.protoField.getValueConstantString())));
            }
        }
        return mf;
    }
}

