/*
 * Decompiled with CFR 0.152.
 */
package soot.dotnet.members;

import java.util.Arrays;
import soot.Body;
import soot.Local;
import soot.RefType;
import soot.Scene;
import soot.SootClass;
import soot.SootField;
import soot.SootMethod;
import soot.Type;
import soot.Unit;
import soot.Value;
import soot.VoidType;
import soot.dotnet.proto.ProtoAssemblyAllTypes;
import soot.jimple.Jimple;
import soot.jimple.JimpleBody;

public class ByReferenceWrapperGenerator {
    public static final String WRAPPER_FIELD_NAME = "r";
    public static final String WRAPPER_CLASS_NAME = "ByReferenceWrappers.Wrapper";

    public static synchronized SootClass getWrapperClass(Type t2) {
        Scene scene = Scene.v();
        String name = WRAPPER_CLASS_NAME;
        RefType rt = RefType.v(name);
        if (rt.hasSootClass()) {
            return rt.getSootClass();
        }
        SootClass sc = scene.makeSootClass(name, 24);
        sc.setApplicationClass();
        SootField r = scene.makeSootField(WRAPPER_FIELD_NAME, RefType.v("System.Object"));
        r.setModifiers(1);
        sc.addField(r);
        SootMethod ctor = scene.makeSootMethod("<init>", Arrays.asList(RefType.v("System.Object")), VoidType.v());
        Jimple j = Jimple.v();
        JimpleBody b = j.newBody(ctor);
        ctor.setActiveBody(b);
        sc.addMethod(ctor);
        b.insertIdentityStmts();
        b.getUnits().add(j.newAssignStmt(j.newInstanceFieldRef(b.getThisLocal(), r.makeRef()), b.getParameterLocal(0)));
        b.getUnits().add(j.newReturnVoidStmt());
        return sc;
    }

    public static boolean needsWrapper(ProtoAssemblyAllTypes.ParameterDefinition parameter) {
        return parameter.getIsIn() || parameter.getIsOut() || parameter.getIsRef();
    }

    public static Value insertWrapperCall(Body jb, SootClass wrapperClass, Value arg) {
        SootMethod mCtor = wrapperClass.getMethodByName("<init>");
        Jimple j = Jimple.v();
        Local l = j.newLocal("wrap", wrapperClass.getType());
        jb.getLocals().add(l);
        jb.getUnits().add(j.newAssignStmt(l, j.newNewExpr(wrapperClass.getType())));
        jb.getUnits().add(j.newInvokeStmt(j.newSpecialInvokeExpr(l, mCtor.makeRef(), arg)));
        return l;
    }

    public static Unit getUnwrapCall(SootClass wrapperClass, Value argToUnwrap, Value target) {
        SootField f = ByReferenceWrapperGenerator.getWrapperField(wrapperClass);
        Jimple j = Jimple.v();
        return j.newAssignStmt(target, j.newInstanceFieldRef(argToUnwrap, f.makeRef()));
    }

    public static SootField getWrapperField(SootClass wrapperClass) {
        return wrapperClass.getFieldByName(WRAPPER_FIELD_NAME);
    }

    public static Unit getUpdateWrappedValueCall(Local wrapped, Local unwrapped) {
        RefType rt = (RefType)wrapped.getType();
        SootField f = rt.getSootClass().getFieldByName(WRAPPER_FIELD_NAME);
        Jimple j = Jimple.v();
        return j.newAssignStmt(j.newInstanceFieldRef(wrapped, f.makeRef()), unwrapped);
    }
}

