/*
 * Decompiled with CFR 0.152.
 */
package soot.dotnet.members;

import java.util.Arrays;
import java.util.Collections;
import soot.ArrayType;
import soot.IntType;
import soot.Local;
import soot.RefType;
import soot.Scene;
import soot.SootClass;
import soot.SootField;
import soot.SootMethod;
import soot.Type;
import soot.Unit;
import soot.Value;
import soot.VoidType;
import soot.dotnet.types.DotNetBasicTypes;
import soot.jimple.Jimple;
import soot.jimple.JimpleBody;

public class ArrayByReferenceWrapperGenerator {
    private static final String SET_ELEMENT = "setElement";
    private static final String GET_ELEMENT = "getElement";
    public static final String WRAPPER_CLASS_NAME_START = "ArrayElementReferenceWrappers.Wrapper";

    public static synchronized SootClass getWrapperClass(Type elementType) {
        Scene scene = Scene.v();
        Object name = WRAPPER_CLASS_NAME_START;
        String suffix = "";
        if (DotNetBasicTypes.isValueType(elementType)) {
            name = (String)name + elementType.toString().replace(".", "_");
        } else {
            name = (String)name + "Object";
            elementType = RefType.v("System.Object");
        }
        name = (String)name + suffix;
        RefType rt = RefType.v((String)name);
        if (rt.hasSootClass()) {
            return rt.getSootClass();
        }
        ArrayType arrType = elementType.makeArrayType();
        SootClass sc = scene.makeSootClass((String)name, 24);
        sc.setApplicationClass();
        SootField arrayField = scene.makeSootField("array", arrType);
        arrayField.setModifiers(17);
        sc.addField(arrayField);
        SootField elemField = scene.makeSootField("elem", IntType.v());
        elemField.setModifiers(17);
        sc.addField(elemField);
        SootMethod ctor = scene.makeSootMethod("<init>", Arrays.asList(arrType, IntType.v()), VoidType.v());
        Jimple j = Jimple.v();
        JimpleBody b = j.newBody(ctor);
        ctor.setActiveBody(b);
        sc.addMethod(ctor);
        b.insertIdentityStmts();
        b.getUnits().add(j.newAssignStmt(j.newInstanceFieldRef(b.getThisLocal(), arrayField.makeRef()), b.getParameterLocal(0)));
        b.getUnits().add(j.newAssignStmt(j.newInstanceFieldRef(b.getThisLocal(), elemField.makeRef()), b.getParameterLocal(1)));
        b.getUnits().add(j.newReturnVoidStmt());
        SootMethod get = scene.makeSootMethod(GET_ELEMENT, Collections.emptyList(), elementType);
        b = j.newBody(get);
        get.setActiveBody(b);
        sc.addMethod(get);
        b.insertIdentityStmts();
        Local arr = j.newLocal("arr", arrType);
        b.getLocals().add(arr);
        Local elemIdx = j.newLocal("elemIdx", IntType.v());
        b.getLocals().add(elemIdx);
        Local elem = j.newLocal("elem", elementType);
        b.getLocals().add(elem);
        b.getUnits().add(j.newAssignStmt(arr, j.newInstanceFieldRef(b.getThisLocal(), arrayField.makeRef())));
        b.getUnits().add(j.newAssignStmt(elemIdx, j.newInstanceFieldRef(b.getThisLocal(), elemField.makeRef())));
        b.getUnits().add(j.newAssignStmt(elem, j.newArrayRef(arr, elemIdx)));
        b.getUnits().add(j.newReturnStmt(elem));
        SootMethod set = scene.makeSootMethod(SET_ELEMENT, Collections.singletonList(elementType), VoidType.v());
        b = j.newBody(set);
        set.setActiveBody(b);
        sc.addMethod(set);
        b.insertIdentityStmts();
        arr = j.newLocal("arr", arrType);
        b.getLocals().add(arr);
        elem = j.newLocal("elem", elementType);
        b.getLocals().add(elem);
        b.getUnits().add(j.newAssignStmt(arr, j.newInstanceFieldRef(b.getThisLocal(), arrayField.makeRef())));
        b.getUnits().add(j.newAssignStmt(elem, j.newInstanceFieldRef(b.getThisLocal(), elemField.makeRef())));
        b.getUnits().add(j.newAssignStmt(j.newArrayRef(arr, elem), b.getParameterLocal(0)));
        b.getUnits().add(j.newReturnVoidStmt());
        return sc;
    }

    public static Value createGet(Value holder) {
        RefType rt = (RefType)holder.getType();
        return Jimple.v().newSpecialInvokeExpr((Local)holder, rt.getSootClass().getMethodByName(GET_ELEMENT).makeRef());
    }

    public static Unit createSet(Value holder, Value newValue) {
        RefType rt = (RefType)holder.getType();
        Jimple j = Jimple.v();
        return j.newInvokeStmt(j.newSpecialInvokeExpr((Local)holder, rt.getSootClass().getMethodByName(SET_ELEMENT).makeRef(), newValue));
    }
}

