/*
 * Decompiled with CFR 0.152.
 */
package soot.dotnet.instructions;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import soot.Body;
import soot.RefType;
import soot.SootMethod;
import soot.Trap;
import soot.Type;
import soot.Unit;
import soot.Value;
import soot.dotnet.exceptions.NoExpressionInstructionException;
import soot.dotnet.instructions.AbstractCilnstruction;
import soot.dotnet.instructions.CilBlock;
import soot.dotnet.instructions.CilBlockContainer;
import soot.dotnet.members.method.DotnetBody;
import soot.dotnet.proto.ProtoIlInstructions;

public class CilTryFaultInstruction
extends AbstractCilnstruction {
    public CilTryFaultInstruction(ProtoIlInstructions.IlInstructionMsg instruction, DotnetBody dotnetBody, CilBlock cilBlock) {
        super(instruction, dotnetBody, cilBlock);
    }

    @Override
    public void jimplify(Body jb) {
        CilBlockContainer tryContainer = new CilBlockContainer(this.instruction.getTryBlock(), this.dotnetBody, CilBlockContainer.BlockContainerKind.TRY);
        Body tryContainerBlock = tryContainer.jimplify();
        CilBlockContainer faultBlockContainer = new CilBlockContainer(this.instruction.getFaultBlock(), this.dotnetBody, CilBlockContainer.BlockContainerKind.FAULT);
        Body faultBlockContainerBody = faultBlockContainer.jimplify();
        tryContainerBlock.getLocals().addAll(faultBlockContainerBody.getLocals());
        HashMap<Trap, Unit> tmpTrapEnds = new HashMap<Trap, Unit>();
        Iterator<Object> iterator = tryContainerBlock.getTraps().iterator();
        if (iterator.hasNext()) {
            Trap trap = iterator.next();
            tmpTrapEnds.put(trap, trap.getEndUnit());
            Unit handlerUnit = trap.getHandlerUnit();
            Iterator<Unit> iterator2 = tryContainerBlock.getUnits().iterator(handlerUnit);
            ArrayList<Unit> tmpUnits = new ArrayList<Unit>();
            while (iterator2.hasNext()) {
                Unit next = iterator2.next();
                if (!CilBlockContainer.isExitStmt(next)) continue;
                tmpUnits.add(next);
            }
            for (Unit unit : tmpUnits) {
                faultBlockContainerBody.setMethod(new SootMethod("", new ArrayList<Type>(), RefType.v("")));
                Body cloneFaultBlock = (Body)faultBlockContainerBody.clone(true);
                tryContainerBlock.getUnits().insertBefore(cloneFaultBlock.getUnits(), unit);
                tryContainerBlock.getTraps().addAll(cloneFaultBlock.getTraps());
            }
        }
        for (Map.Entry entry : tmpTrapEnds.entrySet()) {
            ((Trap)entry.getKey()).setEndUnit((Unit)entry.getValue());
        }
        jb.getLocals().addAll(tryContainerBlock.getLocals());
        jb.getUnits().addAll(tryContainerBlock.getUnits());
        jb.getTraps().addAll(tryContainerBlock.getTraps());
    }

    @Override
    public Value jimplifyExpr(Body jb) {
        throw new NoExpressionInstructionException(this.instruction);
    }
}

