/*
 * Decompiled with CFR 0.152.
 */
package soot.dotnet.instructions;

import soot.Body;
import soot.ByteConstant;
import soot.Immediate;
import soot.Local;
import soot.ShortConstant;
import soot.UByteConstant;
import soot.Value;
import soot.dotnet.exceptions.NoExpressionInstructionException;
import soot.dotnet.instructions.AbstractCilnstruction;
import soot.dotnet.instructions.CilBlock;
import soot.dotnet.instructions.CilInstruction;
import soot.dotnet.instructions.CilInstructionFactory;
import soot.dotnet.instructions.CilLdElemInstruction;
import soot.dotnet.members.ArrayByReferenceWrapperGenerator;
import soot.dotnet.members.method.DotnetBody;
import soot.dotnet.proto.ProtoIlInstructions;
import soot.jimple.AssignStmt;
import soot.jimple.CastExpr;
import soot.jimple.IntConstant;
import soot.jimple.Jimple;
import soot.jimple.UShortConstant;

public class CilStObjInstruction
extends AbstractCilnstruction {
    public CilStObjInstruction(ProtoIlInstructions.IlInstructionMsg instruction, DotnetBody dotnetBody, CilBlock cilBlock) {
        super(instruction, dotnetBody, cilBlock);
    }

    @Override
    public void jimplify(Body jb) {
        Local l;
        Local ref;
        Value target;
        CilInstruction cilTargetExpr;
        if (this.instruction.getTarget().getOpCode() == ProtoIlInstructions.IlInstructionMsg.IlOpCode.LDELEMA) {
            cilTargetExpr = new CilLdElemInstruction(this.instruction.getTarget(), this.dotnetBody, this.cilBlock);
            target = cilTargetExpr.jimplifyExpr(jb);
        } else {
            cilTargetExpr = CilInstructionFactory.fromInstructionMsg(this.instruction.getTarget(), this.dotnetBody, this.cilBlock);
            target = cilTargetExpr.jimplifyExpr(jb);
        }
        CilInstruction cilExpr = CilInstructionFactory.fromInstructionMsg(this.instruction.getValueInstruction(), this.dotnetBody, this.cilBlock);
        Value value = cilExpr.jimplifyExpr(jb);
        if (value instanceof IntConstant) {
            IntConstant ii = (IntConstant)value;
            switch (this.instruction.getTarget().getType().getFullname()) {
                case "System.Byte": {
                    value = UByteConstant.v((byte)ii.value);
                    break;
                }
                case "System.SByte": {
                    value = ByteConstant.v((byte)ii.value);
                    break;
                }
                case "System.Int16": {
                    value = ShortConstant.v((short)ii.value);
                    break;
                }
                case "System.UInt16": {
                    value = UShortConstant.v((short)ii.value);
                }
            }
        }
        if (value instanceof Local && !target.getType().toString().equals(value.getType().toString()) && value.getType().toString().equals("System.Object")) {
            value = Jimple.v().newCastExpr(value, target.getType());
        }
        if (value instanceof CastExpr && !(target instanceof Local)) {
            Local generatedLocal = this.dotnetBody.variableManager.localGenerator.generateLocal(target.getType());
            AssignStmt assignStmt = Jimple.v().newAssignStmt(generatedLocal, value);
            jb.getUnits().add(assignStmt);
            value = generatedLocal;
        }
        if (!(value instanceof Immediate) && !(target instanceof Local)) {
            value = this.simplifyComplexExpression(jb, value);
        }
        if (target instanceof CastExpr) {
            target = ((CastExpr)target).getOp();
        }
        if (target instanceof Local && (ref = this.dotnetBody.variableManager.getReferenceLocal(l = (Local)target)) != null) {
            jb.getUnits().add(ArrayByReferenceWrapperGenerator.createSet(ref, value));
        }
        AssignStmt astm = Jimple.v().newAssignStmt(target, value);
        jb.getUnits().add(astm);
    }

    @Override
    public Value jimplifyExpr(Body jb) {
        throw new NoExpressionInstructionException(this.instruction);
    }
}

