/*
 * Decompiled with CFR 0.152.
 */
package soot.dotnet.instructions;

import soot.Body;
import soot.FastHierarchy;
import soot.IntType;
import soot.Local;
import soot.RefType;
import soot.Scene;
import soot.SootMethod;
import soot.Type;
import soot.Value;
import soot.dotnet.exceptions.NoExpressionInstructionException;
import soot.dotnet.instructions.AbstractCilnstruction;
import soot.dotnet.instructions.CilBlock;
import soot.dotnet.instructions.CilInstruction;
import soot.dotnet.instructions.CilInstructionFactory;
import soot.dotnet.instructions.CilLdElemaInstruction;
import soot.dotnet.members.ArrayByReferenceWrapperGenerator;
import soot.dotnet.members.method.DotnetBody;
import soot.dotnet.proto.ProtoAssemblyAllTypes;
import soot.dotnet.proto.ProtoIlInstructions;
import soot.dotnet.types.DotnetType;
import soot.jimple.AssignStmt;
import soot.jimple.Constant;
import soot.jimple.Jimple;
import soot.jimple.NewExpr;

public class CilStLocInstruction
extends AbstractCilnstruction {
    public CilStLocInstruction(ProtoIlInstructions.IlInstructionMsg instruction, DotnetBody dotnetBody, CilBlock cilBlock) {
        super(instruction, dotnetBody, cilBlock);
    }

    @Override
    public void jimplify(Body jb) {
        RefType rt;
        SootMethod cm;
        Local variable = this.dotnetBody.variableManager.addOrGetVariable(this.instruction.getVariable(), jb);
        if (this.instruction.getValueInstruction().getOpCode() == ProtoIlInstructions.IlInstructionMsg.IlOpCode.LDELEMA) {
            CilLdElemaInstruction cilExpr = new CilLdElemaInstruction(this.instruction.getValueInstruction(), this.dotnetBody, this.cilBlock, variable);
            Value value = cilExpr.jimplifyExpr(jb);
            AssignStmt astm = Jimple.v().newAssignStmt(variable, ArrayByReferenceWrapperGenerator.createGet(value));
            jb.getUnits().add(astm);
            return;
        }
        CilInstruction cilExpr = CilInstructionFactory.fromInstructionMsg(this.instruction.getValueInstruction(), this.dotnetBody, this.cilBlock);
        Value value = cilExpr.jimplifyExpr(jb);
        Local ref = this.dotnetBody.variableManager.getReferenceLocal(variable);
        if (ref != null) {
            jb.getUnits().add(ArrayByReferenceWrapperGenerator.createSet(ref, value));
        }
        if (value.getType() instanceof IntType && Scene.v().getOrMakeFastHierarchy().canStoreType(variable.getType(), RefType.v("System.Enum"))) {
            value = Jimple.v().newCastExpr(value, variable.getType());
        } else if (value instanceof Local && variable.getType() != value.getType() && this.dotnetBody.variableManager.localsToCastContains(((Local)value).getName())) {
            value = Jimple.v().newCastExpr(value, variable.getType());
        } else if (value instanceof Local && value.getType().toString().equals("System.Object") && !variable.getType().toString().equals("System.Object")) {
            value = Jimple.v().newCastExpr(value, variable.getType());
        }
        FastHierarchy fh = Scene.v().getOrMakeFastHierarchy();
        RefType valueType = RefType.v("System.ValueType");
        Type modType = variable.getType();
        ProtoAssemblyAllTypes.TypeKindDef varkind = this.instruction.getVariable().getType().getTypeKind();
        if (varkind != ProtoAssemblyAllTypes.TypeKindDef.BY_REF && fh.canStoreType(modType, valueType) && !(value instanceof Constant) && (cm = DotnetType.getCopyMethod((rt = (RefType)modType).getSootClass())) != null) {
            Jimple j = Jimple.v();
            boolean doCopy = true;
            if (!(value instanceof Local)) {
                if (value instanceof NewExpr) {
                    doCopy = false;
                }
                value = this.simplifyComplexExpression(jb, value);
            }
            if (doCopy) {
                value = this.createTempVar(jb, j, j.newSpecialInvokeExpr((Local)value, cm.makeRef()));
            }
        }
        AssignStmt astm = Jimple.v().newAssignStmt(variable, value);
        jb.getUnits().add(astm);
    }

    @Override
    public Value jimplifyExpr(Body jb) {
        throw new NoExpressionInstructionException(this.instruction);
    }
}

