/*
 * Decompiled with CFR 0.152.
 */
package soot.dotnet.instructions;

import soot.Body;
import soot.Local;
import soot.NullType;
import soot.Scene;
import soot.SootClass;
import soot.Value;
import soot.dotnet.instructions.AbstractNewObjInstanceInstruction;
import soot.dotnet.instructions.CilBlock;
import soot.dotnet.instructions.CilCallInstruction;
import soot.dotnet.members.DotnetMethod;
import soot.dotnet.members.method.DotnetBody;
import soot.dotnet.proto.ProtoIlInstructions;
import soot.jimple.InvokeExpr;
import soot.jimple.Jimple;
import soot.jimple.NewExpr;

public class CilNewObjInstruction
extends AbstractNewObjInstanceInstruction {
    private Local lhs;

    public CilNewObjInstruction(ProtoIlInstructions.IlInstructionMsg instruction, DotnetBody dotnetBody, CilBlock cilBlock) {
        super(instruction, dotnetBody, cilBlock);
    }

    @Override
    protected boolean hasBaseObj() {
        return false;
    }

    @Override
    public void jimplify(Body jb) {
    }

    @Override
    public Value jimplifyExpr(Body jb) {
        this.lhs = this.createTempVar(jb, NullType.v());
        Value j = super.jimplifyExpr(jb);
        if (j != null) {
            throw new RuntimeException("Should never happen.");
        }
        return this.lhs;
    }

    @Override
    protected InvokeExpr createInvokeExpr(Body jb, SootClass clazz, DotnetMethod method, CilCallInstruction.MethodParams methodParams) {
        Jimple j = Jimple.v();
        NewExpr newExpr = j.newNewExpr(clazz.getType());
        this.lhs.setType(clazz.getType());
        jb.getUnits().add(j.newAssignStmt(this.lhs, newExpr));
        this.methodRef = Scene.v().makeConstructorRef(clazz, methodParams.methodRef.getParameterTypes());
        return j.newSpecialInvokeExpr(this.lhs, this.methodRef, methodParams.argumentVariables);
    }
}

