/*
 * Decompiled with CFR 0.152.
 */
package soot.dotnet.instructions;

import soot.Body;
import soot.Immediate;
import soot.Local;
import soot.Value;
import soot.dotnet.exceptions.NoExpressionInstructionException;
import soot.dotnet.instructions.AbstractCilnstruction;
import soot.dotnet.instructions.AbstractNewObjInstanceInstruction;
import soot.dotnet.instructions.CilBlock;
import soot.dotnet.instructions.CilInstruction;
import soot.dotnet.instructions.CilInstructionFactory;
import soot.dotnet.members.method.DotnetBody;
import soot.dotnet.proto.ProtoIlInstructions;
import soot.jimple.AssignStmt;
import soot.jimple.GotoStmt;
import soot.jimple.Jimple;
import soot.jimple.NopStmt;
import soot.jimple.ReturnStmt;

public class CilLeaveInstruction
extends AbstractCilnstruction {
    public CilLeaveInstruction(ProtoIlInstructions.IlInstructionMsg instruction, DotnetBody dotnetBody, CilBlock cilBlock) {
        super(instruction, dotnetBody, cilBlock);
    }

    @Override
    public void jimplify(Body jb) {
        boolean isNop = this.instruction.getValueInstruction().getOpCode().equals(ProtoIlInstructions.IlInstructionMsg.IlOpCode.NOP);
        if (isNop && !this.instruction.getIsLeavingFunction() && this.instruction.getTargetLabel() != null) {
            NopStmt target = Jimple.v().newNopStmt();
            GotoStmt gotoStmt = Jimple.v().newGotoStmt(target);
            jb.getUnits().add(gotoStmt);
            this.dotnetBody.blockEntryPointsManager.gotoTargetsInBody.put(target, this.instruction.getTargetLabel());
            this.cilBlock.getDeclaredBlockContainer().blockEntryPointsManager.gotoTargetsInBody.put(target, "RETURNLEAVE");
            return;
        }
        if (isNop) {
            jb.getUnits().add(Jimple.v().newReturnVoidStmt());
        } else {
            CilInstruction cilValueExpr = CilInstructionFactory.fromInstructionMsg(this.instruction.getValueInstruction(), this.dotnetBody, this.cilBlock);
            Value value = cilValueExpr.jimplifyExpr(jb);
            if (cilValueExpr instanceof AbstractNewObjInstanceInstruction) {
                Local tmpVariable = this.dotnetBody.variableManager.localGenerator.generateLocal(value.getType());
                AssignStmt assignStmt = Jimple.v().newAssignStmt(tmpVariable, value);
                jb.getUnits().add(assignStmt);
                ReturnStmt ret = Jimple.v().newReturnStmt(tmpVariable);
                jb.getUnits().add(ret);
                return;
            }
            if (!(value instanceof Immediate)) {
                Local tmpVariable = this.dotnetBody.variableManager.localGenerator.generateLocal(value.getType());
                AssignStmt assignStmt = Jimple.v().newAssignStmt(tmpVariable, value);
                jb.getUnits().add(assignStmt);
                ReturnStmt ret = Jimple.v().newReturnStmt(tmpVariable);
                jb.getUnits().add(ret);
                return;
            }
            ReturnStmt ret = Jimple.v().newReturnStmt(value);
            jb.getUnits().add(ret);
        }
    }

    @Override
    public Value jimplifyExpr(Body jb) {
        throw new NoExpressionInstructionException(this.instruction);
    }
}

