/*
 * Decompiled with CFR 0.152.
 */
package soot.dotnet.instructions;

import java.io.Serializable;
import soot.Body;
import soot.Local;
import soot.SootClass;
import soot.Type;
import soot.Value;
import soot.dotnet.exceptions.NoStatementInstructionException;
import soot.dotnet.instructions.AbstractCilnstruction;
import soot.dotnet.instructions.CilBlock;
import soot.dotnet.instructions.CilInstruction;
import soot.dotnet.instructions.CilInstructionFactory;
import soot.dotnet.members.ArrayByReferenceWrapperGenerator;
import soot.dotnet.members.method.DotnetBody;
import soot.dotnet.proto.ProtoIlInstructions;
import soot.jimple.Jimple;
import soot.jimple.internal.JArrayRef;

public class CilLdElemaInstruction
extends AbstractCilnstruction {
    private Local targetVar;

    public CilLdElemaInstruction(ProtoIlInstructions.IlInstructionMsg instruction, DotnetBody dotnetBody, CilBlock cilBlock, Local variable) {
        super(instruction, dotnetBody, cilBlock);
        this.targetVar = variable;
    }

    @Override
    public void jimplify(Body jb) {
        throw new NoStatementInstructionException(this.instruction);
    }

    @Override
    public Value jimplifyExpr(Body jb) {
        Serializable ind;
        CilInstruction cilExpr = CilInstructionFactory.fromInstructionMsg(this.instruction.getArray(), this.dotnetBody, this.cilBlock);
        Value baseArrayLocal = cilExpr.jimplifyExpr(jb);
        baseArrayLocal = this.simplifyComplexExpression(jb, baseArrayLocal);
        for (int i = 0; i < this.instruction.getIndicesCount() - 1; ++i) {
            ind = this.instruction.getIndices(i);
            Value indExpr = CilInstructionFactory.fromInstructionMsg(ind, this.dotnetBody, this.cilBlock).jimplifyExpr(jb);
            Value index = this.simplifyComplexExpression(jb, indExpr);
            baseArrayLocal = this.simplifyComplexExpression(jb, Jimple.v().newArrayRef(baseArrayLocal, index));
        }
        ProtoIlInstructions.IlInstructionMsg last = this.instruction.getIndices(this.instruction.getIndicesCount() - 1);
        ind = CilInstructionFactory.fromInstructionMsg(last, this.dotnetBody, this.cilBlock).jimplifyExpr(jb);
        Value index = this.simplifyComplexExpression(jb, (Value)ind);
        Type elemType = JArrayRef.getElementType(baseArrayLocal.getType());
        SootClass wc = ArrayByReferenceWrapperGenerator.getWrapperClass(elemType);
        Jimple j = Jimple.v();
        Local base = this.dotnetBody.variableManager.getReferenceLocal(this.targetVar);
        if (base == null) {
            base = (Local)this.simplifyComplexExpression(jb, j.newNewExpr(wc.getType()));
            this.dotnetBody.variableManager.addReferenceLocal(this.targetVar, base);
        }
        jb.getUnits().add(j.newInvokeStmt(j.newSpecialInvokeExpr(base, wc.getMethodByName("<init>").makeRef(), baseArrayLocal, index)));
        return base;
    }
}

