/*
 * Decompiled with CFR 0.152.
 */
package soot.dotnet.instructions;

import soot.Body;
import soot.Value;
import soot.dotnet.exceptions.NoStatementInstructionException;
import soot.dotnet.instructions.AbstractCilnstruction;
import soot.dotnet.instructions.CilBlock;
import soot.dotnet.instructions.CilInstruction;
import soot.dotnet.instructions.CilInstructionFactory;
import soot.dotnet.members.method.DotnetBody;
import soot.dotnet.proto.ProtoIlInstructions;
import soot.jimple.Jimple;

public class CilLdElemInstruction
extends AbstractCilnstruction {
    public CilLdElemInstruction(ProtoIlInstructions.IlInstructionMsg instruction, DotnetBody dotnetBody, CilBlock cilBlock) {
        super(instruction, dotnetBody, cilBlock);
    }

    @Override
    public void jimplify(Body jb) {
        throw new NoStatementInstructionException(this.instruction);
    }

    @Override
    public Value jimplifyExpr(Body jb) {
        CilInstruction cilExpr = CilInstructionFactory.fromInstructionMsg(this.instruction.getArray(), this.dotnetBody, this.cilBlock);
        Value baseArrayLocal = cilExpr.jimplifyExpr(jb);
        baseArrayLocal = this.simplifyComplexExpression(jb, baseArrayLocal);
        for (int i = 0; i < this.instruction.getIndicesCount() - 1; ++i) {
            ProtoIlInstructions.IlInstructionMsg ind = this.instruction.getIndicesList().get(i);
            Value indExpr = CilInstructionFactory.fromInstructionMsg(ind, this.dotnetBody, this.cilBlock).jimplifyExpr(jb);
            Value index = this.simplifyComplexExpression(jb, indExpr);
            baseArrayLocal = this.simplifyComplexExpression(jb, Jimple.v().newArrayRef(baseArrayLocal, index));
        }
        Value ind = CilInstructionFactory.fromInstructionMsg(this.instruction.getIndices(this.instruction.getIndicesCount() - 1), this.dotnetBody, this.cilBlock).jimplifyExpr(jb);
        Value index = this.simplifyComplexExpression(jb, ind);
        return Jimple.v().newArrayRef(baseArrayLocal, index);
    }
}

