/*
 * Decompiled with CFR 0.152.
 */
package soot.dotnet.instructions;

import soot.Body;
import soot.Local;
import soot.Value;
import soot.dotnet.exceptions.NoStatementInstructionException;
import soot.dotnet.instructions.AbstractCilnstruction;
import soot.dotnet.instructions.CilBlock;
import soot.dotnet.instructions.CilInstruction;
import soot.dotnet.instructions.CilInstructionFactory;
import soot.dotnet.members.method.DotnetBody;
import soot.dotnet.proto.ProtoIlInstructions;
import soot.dotnet.types.DotnetTypeFactory;
import soot.jimple.AssignStmt;
import soot.jimple.GotoStmt;
import soot.jimple.IfStmt;
import soot.jimple.InstanceOfExpr;
import soot.jimple.IntConstant;
import soot.jimple.Jimple;
import soot.jimple.NopStmt;
import soot.jimple.NullConstant;

public class CilIsInstInstruction
extends AbstractCilnstruction {
    public CilIsInstInstruction(ProtoIlInstructions.IlInstructionMsg instruction, DotnetBody dotnetBody, CilBlock cilBlock) {
        super(instruction, dotnetBody, cilBlock);
    }

    @Override
    public void jimplify(Body jb) {
        throw new NoStatementInstructionException(this.instruction);
    }

    @Override
    public Value jimplifyExpr(Body jb) {
        String type = this.instruction.getType().getFullname();
        CilInstruction cilExpr = CilInstructionFactory.fromInstructionMsg(this.instruction.getArgument(), this.dotnetBody, this.cilBlock);
        Value argument = cilExpr.jimplifyExpr(jb);
        argument = this.simplifyComplexExpression(jb, argument);
        return this.resolveRewritingIsInst(jb, this.createTempVar(jb, argument.getType()), Jimple.v().newInstanceOfExpr(argument, DotnetTypeFactory.toSootType(type)));
    }

    public Local resolveRewritingIsInst(Body jb, Local variable, InstanceOfExpr instanceOfExpr) {
        Jimple j = Jimple.v();
        Local local = this.dotnetBody.variableManager.localGenerator.generateLocal(DotnetTypeFactory.toSootType("System.Boolean"));
        AssignStmt assignInstanceOfStmt = j.newAssignStmt(local, instanceOfExpr);
        NopStmt nopStmt = j.newNopStmt();
        AssignStmt assignIfTrueStmt = j.newAssignStmt(variable, j.newCastExpr(instanceOfExpr.getOp(), instanceOfExpr.getCheckType()));
        AssignStmt assignIfFalseStmt = j.newAssignStmt(variable, NullConstant.v());
        IfStmt ifStmt = j.newIfStmt((Value)j.newEqExpr(local, IntConstant.v(1)), assignIfTrueStmt);
        GotoStmt gotoStmt = j.newGotoStmt(nopStmt);
        jb.getUnits().add(assignInstanceOfStmt);
        jb.getUnits().add(ifStmt);
        jb.getUnits().add(assignIfFalseStmt);
        jb.getUnits().add(gotoStmt);
        jb.getUnits().add(assignIfTrueStmt);
        jb.getUnits().add(nopStmt);
        this.dotnetBody.variableManager.addLocalsToCast(variable.getName());
        return variable;
    }
}

