/*
 * Decompiled with CFR 0.152.
 */
package soot.dotnet.instructions;

import soot.Body;
import soot.Local;
import soot.Value;
import soot.dotnet.exceptions.NoExpressionInstructionException;
import soot.dotnet.instructions.AbstractCilnstruction;
import soot.dotnet.instructions.CilBlock;
import soot.dotnet.instructions.CilInstruction;
import soot.dotnet.instructions.CilInstructionFactory;
import soot.dotnet.instructions.CilLeaveInstruction;
import soot.dotnet.members.method.DotnetBody;
import soot.dotnet.proto.ProtoIlInstructions;
import soot.jimple.ConditionExpr;
import soot.jimple.IfStmt;
import soot.jimple.IntConstant;
import soot.jimple.Jimple;
import soot.jimple.NopStmt;

public class CilIfInstruction
extends AbstractCilnstruction {
    public CilIfInstruction(ProtoIlInstructions.IlInstructionMsg instruction, DotnetBody dotnetBody, CilBlock cilBlock) {
        super(instruction, dotnetBody, cilBlock);
    }

    @Override
    public void jimplify(Body jb) {
        Value eqExpr;
        CilInstruction cilExpr = CilInstructionFactory.fromInstructionMsg(this.instruction.getCondition(), this.dotnetBody, this.cilBlock);
        Value condition = cilExpr.jimplifyExpr(jb);
        if (condition instanceof ConditionExpr) {
            eqExpr = condition;
        } else {
            Local tmpLocalCond = this.dotnetBody.variableManager.localGenerator.generateLocal(condition.getType());
            jb.getUnits().add(Jimple.v().newAssignStmt(tmpLocalCond, condition));
            eqExpr = Jimple.v().newNeExpr(tmpLocalCond, IntConstant.v(0));
        }
        CilInstruction trueInstruction = CilInstructionFactory.fromInstructionMsg(this.instruction.getTrueInst(), this.dotnetBody, this.cilBlock);
        NopStmt trueInstruct = Jimple.v().newNopStmt();
        IfStmt ifStmt = Jimple.v().newIfStmt(eqExpr, trueInstruct);
        jb.getUnits().add(ifStmt);
        String target = trueInstruction instanceof CilLeaveInstruction ? "RETURNLEAVE" : this.instruction.getTrueInst().getTargetLabel();
        this.cilBlock.getDeclaredBlockContainer().blockEntryPointsManager.gotoTargetsInBody.put(trueInstruct, target);
    }

    @Override
    public Value jimplifyExpr(Body jb) {
        throw new NoExpressionInstructionException(this.instruction);
    }
}

