/*
 * Decompiled with CFR 0.152.
 */
package soot.dotnet.instructions;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import soot.Body;
import soot.FastHierarchy;
import soot.Local;
import soot.PrimType;
import soot.RefType;
import soot.Scene;
import soot.SootClass;
import soot.SootMethod;
import soot.SootMethodRef;
import soot.Type;
import soot.Unit;
import soot.Value;
import soot.VoidType;
import soot.dotnet.instructions.AbstractCilnstruction;
import soot.dotnet.instructions.CilBlock;
import soot.dotnet.instructions.CilInstruction;
import soot.dotnet.instructions.CilInstructionFactory;
import soot.dotnet.members.AbstractDotnetMember;
import soot.dotnet.members.ByReferenceWrapperGenerator;
import soot.dotnet.members.DotnetMethod;
import soot.dotnet.members.method.DotnetBody;
import soot.dotnet.proto.ProtoAssemblyAllTypes;
import soot.dotnet.proto.ProtoIlInstructions;
import soot.dotnet.types.DotnetType;
import soot.dotnet.types.DotnetTypeFactory;
import soot.jimple.AssignStmt;
import soot.jimple.CastExpr;
import soot.jimple.Constant;
import soot.jimple.FieldRef;
import soot.jimple.InvokeExpr;
import soot.jimple.Jimple;
import soot.toolkits.scalar.Pair;

public class CilCallInstruction
extends AbstractCilnstruction {
    private final List<Pair<Local, Local>> localsToCastForCall = new ArrayList<Pair<Local, Local>>();
    private List<Unit> afterCallUnits;

    public CilCallInstruction(ProtoIlInstructions.IlInstructionMsg instruction, DotnetBody dotnetBody, CilBlock cilBlock) {
        super(instruction, dotnetBody, cilBlock);
    }

    @Override
    public void jimplify(Body jb) {
        CilInstruction cilExpr = CilInstructionFactory.fromInstructionMsg(this.instruction, this.dotnetBody, this.cilBlock);
        cilExpr.jimplifyExpr(jb);
    }

    @Override
    public Value jimplifyExpr(Body jb) {
        InvokeExpr invokeEx;
        MethodParams methodParams;
        DotnetMethod method;
        String clzname = this.instruction.getMethod().getDeclaringType().getFullname();
        SootClass clazz = Scene.v().getSootClassUnsafe(clzname);
        if (clazz == null) {
            clazz = Scene.v().forceResolve(clzname, 2);
        }
        if ((method = new DotnetMethod(this.instruction.getMethod(), clazz)).isStatic()) {
            this.checkMethodAvailable(method);
            Value rewriteField = AbstractDotnetMember.checkRewriteCilSpecificMember(clazz, method.getName());
            if (rewriteField != null) {
                return rewriteField;
            }
            methodParams = this.getMethodCallParams(method, false, jb);
            invokeEx = Jimple.v().newStaticInvokeExpr(methodParams.methodRef, methodParams.argumentVariables);
        } else {
            methodParams = this.getMethodCallParams(method, this.hasBaseObj(), jb);
            invokeEx = this.createInvokeExpr(jb, clazz, method, methodParams);
        }
        List<Pair<Local, Local>> locals = this.getLocalsToCastForCall();
        if (locals.size() != 0) {
            for (Pair<Local, Local> pair : locals) {
                CastExpr castExpr = Jimple.v().newCastExpr(pair.getO1(), pair.getO2().getType());
                AssignStmt assignStmt = Jimple.v().newAssignStmt(pair.getO2(), castExpr);
                jb.getUnits().add(assignStmt);
            }
        }
        Jimple j = Jimple.v();
        Local ret = null;
        if (methodParams.methodRef.getReturnType() instanceof VoidType) {
            jb.getUnits().add(j.newInvokeStmt(invokeEx));
        } else {
            ret = this.createTempVar(jb, j, invokeEx);
        }
        if (this.afterCallUnits != null) {
            for (Unit i : this.afterCallUnits) {
                jb.getUnits().add(i);
            }
        }
        return ret;
    }

    protected boolean hasBaseObj() {
        return true;
    }

    protected InvokeExpr createInvokeExpr(Body jb, SootClass clazz, DotnetMethod method, MethodParams methodParams) {
        Jimple j = Jimple.v();
        if (this.instruction.getMethod().getIsConstructor() || this.instruction.getMethod().getAccessibility().equals(ProtoAssemblyAllTypes.Accessibility.PRIVATE)) {
            return j.newSpecialInvokeExpr(methodParams.base, methodParams.methodRef, methodParams.argumentVariables);
        }
        if (this.isNonVirtualCall()) {
            return j.newSpecialInvokeExpr(methodParams.base, methodParams.methodRef, methodParams.argumentVariables);
        }
        if (clazz.isInterface()) {
            return j.newInterfaceInvokeExpr(methodParams.base, methodParams.methodRef, methodParams.argumentVariables);
        }
        return j.newVirtualInvokeExpr(methodParams.base, methodParams.methodRef, methodParams.argumentVariables);
    }

    protected boolean isNonVirtualCall() {
        return false;
    }

    public List<Pair<Local, Local>> getLocalsToCastForCall() {
        return this.localsToCastForCall;
    }

    protected MethodParams getMethodCallParams(boolean hasBase, Body jb) {
        SootClass clazz = Scene.v().getSootClass(this.instruction.getMethod().getDeclaringType().getFullname());
        DotnetMethod method = new DotnetMethod(this.instruction.getMethod(), clazz);
        return this.getMethodCallParams(method, hasBase, jb);
    }

    protected MethodParams getMethodCallParams(DotnetMethod method, boolean hasBase, Body jb) {
        this.checkMethodAvailable(method);
        ArrayList<Value> argsVariables = new ArrayList<Value>();
        ArrayList<Type> methodParamTypes = new ArrayList<Type>();
        if (hasBase && this.instruction.getArgumentsCount() == 0) {
            throw new RuntimeException("Opcode: " + this.instruction.getOpCode() + ": Given method " + method.getName() + " of declared type " + method.getDeclaringClass().getName() + " has no arguments! This means there is no base variable for the virtual invoke!");
        }
        int startIdx = 0;
        Local base = null;
        if (hasBase) {
            Value baseValue = CilInstructionFactory.fromInstructionMsg(this.instruction.getArguments(0), this.dotnetBody, this.cilBlock).jimplifyExpr(jb);
            if ((baseValue = this.simplifyComplexExpression(jb, baseValue)) instanceof Constant) {
                baseValue = this.createTempVar(jb, Jimple.v(), baseValue);
            }
            base = (Local)baseValue;
            startIdx = 1;
        }
        HashMap<Integer, SootClass> byRefWrappers = new HashMap<Integer, SootClass>();
        FieldRef[] byRefField = new FieldRef[this.instruction.getArgumentsCount()];
        if (this.instruction.getArgumentsCount() > startIdx) {
            for (int z = startIdx; z < this.instruction.getArgumentsCount(); ++z) {
                ProtoIlInstructions.IlInstructionMsg arg = this.instruction.getArguments(z);
                CilInstruction inst = CilInstructionFactory.fromInstructionMsg(arg, this.dotnetBody, this.cilBlock);
                Value argValue = inst.jimplifyExpr(jb);
                if (arg.getOpCode() == ProtoIlInstructions.IlInstructionMsg.IlOpCode.LDFLDA || arg.getOpCode() == ProtoIlInstructions.IlInstructionMsg.IlOpCode.LDSFLDA) {
                    if (!ByReferenceWrapperGenerator.needsWrapper(this.instruction.getMethod().getParameterList().get(z))) {
                        throw new IllegalStateException("We load an address of a field, but apparently this is not a by-reference paramter?");
                    }
                    if (!(argValue instanceof FieldRef)) {
                        throw new IllegalStateException("Expected a field reference");
                    }
                    byRefField[z - startIdx] = (FieldRef)argValue;
                }
                argValue = this.simplifyComplexExpression(jb, argValue);
                argsVariables.add(argValue);
            }
            int p = 0;
            for (ProtoAssemblyAllTypes.ParameterDefinition parameterDefinition : this.instruction.getMethod().getParameterList()) {
                Type t2 = DotnetTypeFactory.toSootType(parameterDefinition.getType());
                if (ByReferenceWrapperGenerator.needsWrapper(parameterDefinition)) {
                    SootClass sc = ByReferenceWrapperGenerator.getWrapperClass(t2);
                    t2 = sc.getType();
                    byRefWrappers.put(p, sc);
                }
                methodParamTypes.add(t2);
                ++p;
            }
        }
        FastHierarchy fh = Scene.v().getOrMakeFastHierarchy();
        RefType valueType = RefType.v("System.ValueType");
        for (int i = 0; i < argsVariables.size(); ++i) {
            Value originalArg;
            Value modifiedArg = originalArg = (Value)argsVariables.get(i);
            Type methodParam = (Type)methodParamTypes.get(i);
            Type argType = modifiedArg.getType();
            SootClass wrapped = (SootClass)byRefWrappers.get(i);
            if (wrapped != null) {
                modifiedArg = ByReferenceWrapperGenerator.insertWrapperCall(jb, wrapped, modifiedArg);
                if (this.afterCallUnits == null) {
                    this.afterCallUnits = new ArrayList<Unit>();
                }
                this.afterCallUnits.add(ByReferenceWrapperGenerator.getUnwrapCall(wrapped, modifiedArg, originalArg));
                FieldRef fieldRef = byRefField[i];
                if (fieldRef != null) {
                    this.afterCallUnits.add(Jimple.v().newAssignStmt(fieldRef, originalArg));
                }
            } else {
                RefType rt;
                SootMethod cm;
                Type modType;
                if (modifiedArg instanceof Local && argType.toString().equals("System.Object") && !methodParam.toString().equals("System.Object")) {
                    Local castLocal = this.dotnetBody.variableManager.localGenerator.generateLocal(methodParam);
                    this.localsToCastForCall.add(new Pair<Local, Local>((Local)modifiedArg, castLocal));
                    modifiedArg = castLocal;
                }
                if (methodParam instanceof RefType && argType instanceof PrimType) {
                    modifiedArg = this.createTempVar(jb, Jimple.v(), Jimple.v().newCastExpr(modifiedArg, methodParam));
                }
                if (fh.canStoreType(modType = modifiedArg.getType(), valueType) && modifiedArg instanceof Local && (cm = DotnetType.getCopyMethod((rt = (RefType)modType).getSootClass())) != null) {
                    Jimple j = Jimple.v();
                    modifiedArg = this.createTempVar(jb, j, j.newSpecialInvokeExpr((Local)modifiedArg, cm.makeRef()));
                }
            }
            argsVariables.set(i, modifiedArg);
        }
        String methodName = method.getUniqueName();
        Type return_type = method.getReturnType().getTypeKind().equals(ProtoAssemblyAllTypes.TypeKindDef.POINTER) && method.getReturnType().getFullname().equals("System.Void") ? DotnetTypeFactory.toSootType(method.getProtoMessage().getDeclaringType()) : DotnetTypeFactory.toSootType(method.getProtoMessage().getReturnType());
        SootMethodRef methodRef = Scene.v().makeMethodRef(method.getDeclaringClass(), DotnetMethod.convertCtorName(methodName), methodParamTypes, return_type, !hasBase);
        return new MethodParams(base, methodRef, argsVariables);
    }

    private void checkMethodAvailable(DotnetMethod method) {
        if (method.getName().trim().isEmpty()) {
            throw new RuntimeException("Opcode: " + this.instruction.getOpCode() + ": Given method " + method.getName() + " of declared type " + method.getDeclaringClass().getName() + " has no method name!");
        }
    }

    static class MethodParams {
        public Local base;
        public SootMethodRef methodRef;
        public List<Value> argumentVariables;

        public MethodParams(Local base, SootMethodRef methodRef, List<Value> argsVariables) {
            this.base = base;
            this.methodRef = methodRef;
            this.argumentVariables = argsVariables;
        }
    }
}

