/*
 * Decompiled with CFR 0.152.
 */
package soot.dotnet.instructions;

import soot.Body;
import soot.Value;
import soot.dotnet.exceptions.NoStatementInstructionException;
import soot.dotnet.instructions.AbstractCilnstruction;
import soot.dotnet.instructions.CilBlock;
import soot.dotnet.instructions.CilInstructionFactory;
import soot.dotnet.members.method.DotnetBody;
import soot.dotnet.proto.ProtoIlInstructions;
import soot.jimple.Jimple;

public class CilBinaryNumericInstruction
extends AbstractCilnstruction {
    public CilBinaryNumericInstruction(ProtoIlInstructions.IlInstructionMsg instruction, DotnetBody dotnetBody, CilBlock cilBlock) {
        super(instruction, dotnetBody, cilBlock);
    }

    @Override
    public void jimplify(Body jb) {
        throw new NoStatementInstructionException(this.instruction);
    }

    @Override
    public Value jimplifyExpr(Body jb) {
        Value left = CilInstructionFactory.fromInstructionMsg(this.instruction.getLeft(), this.dotnetBody, this.cilBlock).jimplifyExpr(jb);
        left = DotnetBody.inlineCastExpr(left);
        left = this.simplifyComplexExpression(jb, left);
        Value right = CilInstructionFactory.fromInstructionMsg(this.instruction.getRight(), this.dotnetBody, this.cilBlock).jimplifyExpr(jb);
        right = DotnetBody.inlineCastExpr(right);
        right = this.simplifyComplexExpression(jb, right);
        Jimple jimple = Jimple.v();
        switch (this.instruction.getOperator()) {
            case Add: {
                if (this.instruction.getCheckForOverflow()) {
                    return jimple.newCheckedAddExpr(left, right);
                }
                return jimple.newAddExpr(left, right);
            }
            case Sub: {
                if (this.instruction.getCheckForOverflow()) {
                    return jimple.newCheckedSubExpr(left, right);
                }
                return jimple.newSubExpr(left, right);
            }
            case Mul: {
                if (this.instruction.getCheckForOverflow()) {
                    return jimple.newCheckedMulExpr(left, right);
                }
                return jimple.newMulExpr(left, right);
            }
            case Div: {
                return jimple.newDivExpr(left, right);
            }
            case Rem: {
                return jimple.newRemExpr(left, right);
            }
            case BitAnd: {
                return jimple.newAndExpr(left, right);
            }
            case BitOr: {
                return jimple.newOrExpr(left, right);
            }
            case BitXor: {
                return jimple.newXorExpr(left, right);
            }
            case ShiftLeft: {
                return jimple.newShlExpr(left, right);
            }
            case ShiftRight: {
                if (this.instruction.getSign().equals(ProtoIlInstructions.IlInstructionMsg.IlSign.Signed)) {
                    return jimple.newShrExpr(left, right);
                }
                return jimple.newUshrExpr(left, right);
            }
        }
        return null;
    }
}

