/*
 * Decompiled with CFR 0.152.
 */
package soot.dotnet.instructions;

import soot.Body;
import soot.Immediate;
import soot.Local;
import soot.Type;
import soot.Value;
import soot.ValueBox;
import soot.dotnet.instructions.CilBlock;
import soot.dotnet.instructions.CilInstruction;
import soot.dotnet.members.method.DotnetBody;
import soot.dotnet.proto.ProtoIlInstructions;
import soot.jimple.InstanceFieldRef;
import soot.jimple.InstanceInvokeExpr;
import soot.jimple.InvokeExpr;
import soot.jimple.Jimple;
import soot.jimple.StaticFieldRef;

public abstract class AbstractCilnstruction
implements CilInstruction {
    protected final ProtoIlInstructions.IlInstructionMsg instruction;
    protected final DotnetBody dotnetBody;
    protected final CilBlock cilBlock;

    public AbstractCilnstruction(ProtoIlInstructions.IlInstructionMsg instruction, DotnetBody dotnetBody, CilBlock cilBlock) {
        this.instruction = instruction;
        this.dotnetBody = dotnetBody;
        this.cilBlock = cilBlock;
    }

    protected Value simplifyComplexExpression(Body jb, Value var) {
        if (var instanceof Immediate) {
            return var;
        }
        Jimple jimple = Jimple.v();
        if (var instanceof InvokeExpr) {
            Value base;
            InvokeExpr inv = (InvokeExpr)var;
            for (int arg = 0; arg < inv.getArgCount(); ++arg) {
                ValueBox argBox = inv.getArgBox(arg);
                argBox.setValue(this.simplifyComplexExpression(jb, argBox.getValue()));
            }
            if (var instanceof InstanceInvokeExpr && !((base = ((InstanceInvokeExpr)var).getBase()) instanceof Local)) {
                throw new RuntimeException("Non-local base value currently not supported");
            }
            return this.createTempVar(jb, jimple, inv);
        }
        if (var instanceof StaticFieldRef) {
            return this.createTempVar(jb, jimple, var);
        }
        if (var instanceof InstanceFieldRef) {
            Value base = ((InstanceFieldRef)var).getBase();
            if (!(base instanceof Local)) {
                base = this.simplifyComplexExpression(jb, base);
                ((InstanceFieldRef)var).setBase(base);
            }
            return this.createTempVar(jb, jimple, var);
        }
        for (ValueBox i : var.getUseBoxes()) {
            i.setValue(this.simplifyComplexExpression(jb, i.getValue()));
        }
        return this.createTempVar(jb, jimple, var);
    }

    protected Local createTempVar(Body jb, Jimple jimple, Value inv) {
        Local interimLocal = this.dotnetBody.variableManager.localGenerator.generateLocal(inv.getType());
        jb.getLocals().add(interimLocal);
        jb.getUnits().add(jimple.newAssignStmt(interimLocal, inv));
        return interimLocal;
    }

    protected Local createTempVar(Body jb, Type type) {
        Local interimLocal = this.dotnetBody.variableManager.localGenerator.generateLocal(type);
        jb.getLocals().add(interimLocal);
        return interimLocal;
    }
}

