/*
 * Decompiled with CFR 0.152.
 */
package soot.dotnet.exceptiontoolkits;

import soot.FastHierarchy;
import soot.G;
import soot.IntegerType;
import soot.Local;
import soot.LongType;
import soot.NullType;
import soot.RefLikeType;
import soot.RefType;
import soot.Scene;
import soot.Singletons;
import soot.SootMethod;
import soot.Type;
import soot.UnknownType;
import soot.Value;
import soot.baf.ArrayLengthInst;
import soot.baf.ArrayReadInst;
import soot.baf.ArrayWriteInst;
import soot.baf.DivInst;
import soot.baf.DynamicInvokeInst;
import soot.baf.EnterMonitorInst;
import soot.baf.ExitMonitorInst;
import soot.baf.FieldGetInst;
import soot.baf.FieldPutInst;
import soot.baf.IdentityInst;
import soot.baf.InstanceCastInst;
import soot.baf.InstanceOfInst;
import soot.baf.InterfaceInvokeInst;
import soot.baf.LoadInst;
import soot.baf.LookupSwitchInst;
import soot.baf.NewArrayInst;
import soot.baf.NewInst;
import soot.baf.NewMultiArrayInst;
import soot.baf.PrimitiveCastInst;
import soot.baf.RemInst;
import soot.baf.ReturnInst;
import soot.baf.ReturnVoidInst;
import soot.baf.SpecialInvokeInst;
import soot.baf.StaticGetInst;
import soot.baf.StaticInvokeInst;
import soot.baf.StaticPutInst;
import soot.baf.StoreInst;
import soot.baf.TableSwitchInst;
import soot.baf.ThrowInst;
import soot.baf.VirtualInvokeInst;
import soot.grimp.NewInvokeExpr;
import soot.jimple.ArrayRef;
import soot.jimple.AssignStmt;
import soot.jimple.BinopExpr;
import soot.jimple.CastExpr;
import soot.jimple.CaughtExceptionRef;
import soot.jimple.ClassConstant;
import soot.jimple.DivExpr;
import soot.jimple.DynamicInvokeExpr;
import soot.jimple.EnterMonitorStmt;
import soot.jimple.ExitMonitorStmt;
import soot.jimple.GotoStmt;
import soot.jimple.IdentityStmt;
import soot.jimple.IfStmt;
import soot.jimple.InstanceFieldRef;
import soot.jimple.InstanceInvokeExpr;
import soot.jimple.InstanceOfExpr;
import soot.jimple.IntConstant;
import soot.jimple.InterfaceInvokeExpr;
import soot.jimple.InvokeExpr;
import soot.jimple.InvokeStmt;
import soot.jimple.LengthExpr;
import soot.jimple.LongConstant;
import soot.jimple.LookupSwitchStmt;
import soot.jimple.MethodHandle;
import soot.jimple.MethodType;
import soot.jimple.NewArrayExpr;
import soot.jimple.NewExpr;
import soot.jimple.NewMultiArrayExpr;
import soot.jimple.NopStmt;
import soot.jimple.ParameterRef;
import soot.jimple.RemExpr;
import soot.jimple.RetStmt;
import soot.jimple.ReturnStmt;
import soot.jimple.ReturnVoidStmt;
import soot.jimple.SpecialInvokeExpr;
import soot.jimple.StaticFieldRef;
import soot.jimple.StaticInvokeExpr;
import soot.jimple.TableSwitchStmt;
import soot.jimple.ThrowStmt;
import soot.jimple.VirtualInvokeExpr;
import soot.jimple.internal.JCheckedAddExpr;
import soot.jimple.internal.JCheckedCastExpr;
import soot.jimple.internal.JCheckedMulExpr;
import soot.jimple.internal.JCheckedSubExpr;
import soot.toolkits.exceptions.ThrowableSet;
import soot.toolkits.exceptions.UnitThrowAnalysis;

public class DotnetThrowAnalysis
extends UnitThrowAnalysis {
    public static DotnetThrowAnalysis interproceduralAnalysis = null;
    private static final IntConstant INT_CONSTANT_ZERO = IntConstant.v(0);
    private static final LongConstant LONG_CONSTANT_ZERO = LongConstant.v(0L);

    public DotnetThrowAnalysis(Singletons.Global g2) {
    }

    public static DotnetThrowAnalysis v() {
        return G.v().soot_dotnet_exceptiontoolkits_DotnetThrowAnalysis();
    }

    protected DotnetThrowAnalysis(boolean isInterproc) {
        super(isInterproc);
    }

    public DotnetThrowAnalysis(Singletons.Global g2, boolean isInterproc) {
        super(isInterproc);
    }

    @Override
    protected ThrowableSet defaultResult() {
        return this.mgr.EMPTY;
    }

    @Override
    protected UnitThrowAnalysis.UnitSwitch unitSwitch(SootMethod sm) {
        return new UnitThrowAnalysis.UnitSwitch(sm){

            @Override
            public void caseReturnVoidInst(ReturnVoidInst i) {
            }

            @Override
            public void caseReturnInst(ReturnInst i) {
            }

            @Override
            public void caseIdentityInst(IdentityInst i) {
                Value rightOp = i.getRightOp();
                if (rightOp instanceof CaughtExceptionRef) {
                    this.result = this.result.add(Scene.v().getRefType(i.getLeftOp().getType().toString()));
                }
            }

            @Override
            public void caseStoreInst(StoreInst i) {
            }

            @Override
            public void caseLoadInst(LoadInst i) {
            }

            @Override
            public void caseArrayWriteInst(ArrayWriteInst i) {
                this.result = this.result.add(Scene.v().getRefType("System.NullReferenceException"));
                this.result = this.result.add(Scene.v().getRefType("System.IndexOutOfRangeException"));
                if (i.getOpType() instanceof RefType) {
                    this.result = this.result.add(Scene.v().getRefType("System.ArrayTypeMismatchException"));
                }
            }

            @Override
            public void caseArrayReadInst(ArrayReadInst i) {
                this.result = this.result.add(Scene.v().getRefType("System.NullReferenceException"));
                this.result = this.result.add(Scene.v().getRefType("System.IndexOutOfRangeException"));
            }

            @Override
            public void caseStaticGetInst(StaticGetInst i) {
                this.result = this.result.add(Scene.v().getRefType("System.FieldAccessException"));
                this.result = this.result.add(Scene.v().getRefType("System.MissingFieldException"));
            }

            @Override
            public void caseStaticPutInst(StaticPutInst i) {
                this.result = this.result.add(Scene.v().getRefType("System.FieldAccessException"));
                this.result = this.result.add(Scene.v().getRefType("System.MissingFieldException"));
            }

            @Override
            public void caseFieldGetInst(FieldGetInst i) {
                this.result = this.result.add(Scene.v().getRefType("System.NullReferenceException"));
                this.result = this.result.add(Scene.v().getRefType("System.FieldAccessException"));
                this.result = this.result.add(Scene.v().getRefType("System.MissingFieldException"));
            }

            @Override
            public void caseFieldPutInst(FieldPutInst i) {
                this.result = this.result.add(Scene.v().getRefType("System.NullReferenceException"));
                this.result = this.result.add(Scene.v().getRefType("System.FieldAccessException"));
                this.result = this.result.add(Scene.v().getRefType("System.MissingFieldException"));
            }

            @Override
            public void caseInstanceCastInst(InstanceCastInst i) {
                this.result = this.result.add(Scene.v().getRefType("System.InvalidCastException"));
                this.result = this.result.add(Scene.v().getRefType("System.TypeLoadException"));
            }

            @Override
            public void caseInstanceOfInst(InstanceOfInst i) {
                this.result = this.result.add(Scene.v().getRefType("System.TypeLoadException"));
            }

            @Override
            public void casePrimitiveCastInst(PrimitiveCastInst i) {
                this.result = this.result.add(Scene.v().getRefType("System.TypeLoadException"));
                this.result = this.result.add(Scene.v().getRefType("System.InvalidCastException"));
            }

            @Override
            public void caseDynamicInvokeInst(DynamicInvokeInst i) {
            }

            @Override
            public void caseStaticInvokeInst(StaticInvokeInst i) {
                this.result = this.result.add(Scene.v().getRefType("System.MethodAccessException"));
                this.result = this.result.add(Scene.v().getRefType("System.MissingMethodException"));
                this.result = this.result.add(Scene.v().getRefType("System.NullReferenceException"));
                this.result = this.result.add(DotnetThrowAnalysis.this.mightThrow(i.getMethodRef()));
            }

            @Override
            public void caseVirtualInvokeInst(VirtualInvokeInst i) {
                this.result = this.result.add(Scene.v().getRefType("System.MethodAccessException"));
                this.result = this.result.add(Scene.v().getRefType("System.MissingMethodException"));
                this.result = this.result.add(Scene.v().getRefType("System.NullReferenceException"));
                this.result = this.result.add(DotnetThrowAnalysis.this.mightThrow(i.getMethodRef()));
            }

            @Override
            public void caseInterfaceInvokeInst(InterfaceInvokeInst i) {
                this.result = this.result.add(Scene.v().getRefType("System.MethodAccessException"));
                this.result = this.result.add(Scene.v().getRefType("System.MissingMethodException"));
                this.result = this.result.add(Scene.v().getRefType("System.NullReferenceException"));
                this.result = this.result.add(DotnetThrowAnalysis.this.mightThrow(i.getMethodRef()));
            }

            @Override
            public void caseSpecialInvokeInst(SpecialInvokeInst i) {
                this.result = this.result.add(Scene.v().getRefType("System.MethodAccessException"));
                this.result = this.result.add(Scene.v().getRefType("System.MissingMethodException"));
                this.result = this.result.add(Scene.v().getRefType("System.NullReferenceException"));
                this.result = this.result.add(DotnetThrowAnalysis.this.mightThrow(i.getMethodRef()));
            }

            @Override
            public void caseThrowInst(ThrowInst i) {
                this.result = this.result.add(Scene.v().getRefType("System.NullReferenceException"));
                this.result = this.result.add(DotnetThrowAnalysis.this.mightThrowExplicitly(i));
            }

            @Override
            public void caseArrayLengthInst(ArrayLengthInst i) {
                this.result = this.result.add(Scene.v().getRefType("System.NullReferenceException"));
            }

            @Override
            public void caseDivInst(DivInst i) {
                this.result = this.result.add(Scene.v().getRefType("System.ArithmeticException"));
                this.result = this.result.add(Scene.v().getRefType("System.DivideByZeroException"));
            }

            @Override
            public void caseRemInst(RemInst i) {
                this.result = this.result.add(Scene.v().getRefType("System.ArithmeticException"));
                this.result = this.result.add(Scene.v().getRefType("System.DivideByZeroException"));
            }

            @Override
            public void caseNewInst(NewInst i) {
                this.result = this.result.add(Scene.v().getRefType("System.InvalidOperationException"));
                this.result = this.result.add(Scene.v().getRefType("System.MethodAccessException"));
                this.result = this.result.add(Scene.v().getRefType("System.OutOfMemoryException"));
                this.result = this.result.add(Scene.v().getRefType("System.MissingMethodException"));
            }

            @Override
            public void caseNewArrayInst(NewArrayInst i) {
                this.result = this.result.add(Scene.v().getRefType("System.OutOfMemoryException"));
                this.result = this.result.add(Scene.v().getRefType("System.OverflowException"));
            }

            @Override
            public void caseNewMultiArrayInst(NewMultiArrayInst i) {
                this.result = this.result.add(Scene.v().getRefType("System.OutOfMemoryException"));
                this.result = this.result.add(Scene.v().getRefType("System.OverflowException"));
            }

            @Override
            public void caseLookupSwitchInst(LookupSwitchInst i) {
            }

            @Override
            public void caseTableSwitchInst(TableSwitchInst i) {
            }

            @Override
            public void caseEnterMonitorInst(EnterMonitorInst i) {
            }

            @Override
            public void caseExitMonitorInst(ExitMonitorInst i) {
            }

            @Override
            public void caseAssignStmt(AssignStmt s2) {
                this.result = this.result.add(Scene.v().getRefType("System.NullReferenceException"));
                this.result = this.result.add(Scene.v().getRefType("System.TypeLoadException"));
                this.result = this.result.add(DotnetThrowAnalysis.this.mightThrow(s2.getLeftOp()));
                this.result = this.result.add(DotnetThrowAnalysis.this.mightThrow(s2.getRightOp()));
            }

            @Override
            public void caseEnterMonitorStmt(EnterMonitorStmt s2) {
            }

            @Override
            public void caseExitMonitorStmt(ExitMonitorStmt s2) {
            }

            @Override
            public void caseGotoStmt(GotoStmt s2) {
            }

            @Override
            public void caseIdentityStmt(IdentityStmt s2) {
                Value rightOp = s2.getRightOp();
                if (rightOp instanceof CaughtExceptionRef) {
                    this.result = this.result.add(Scene.v().getRefType(s2.getLeftOp().getType().toString()));
                }
            }

            @Override
            public void caseIfStmt(IfStmt s2) {
                this.result = this.result.add(DotnetThrowAnalysis.this.mightThrow(s2.getCondition()));
            }

            @Override
            public void caseInvokeStmt(InvokeStmt s2) {
                this.result = this.result.add(DotnetThrowAnalysis.this.mightThrow(s2.getInvokeExpr()));
            }

            @Override
            public void caseLookupSwitchStmt(LookupSwitchStmt s2) {
            }

            @Override
            public void caseNopStmt(NopStmt s2) {
            }

            @Override
            public void caseRetStmt(RetStmt s2) {
            }

            @Override
            public void caseReturnStmt(ReturnStmt s2) {
            }

            @Override
            public void caseReturnVoidStmt(ReturnVoidStmt s2) {
            }

            @Override
            public void caseTableSwitchStmt(TableSwitchStmt s2) {
                this.result = this.result.add(DotnetThrowAnalysis.this.mightThrow(s2.getKey()));
            }

            @Override
            public void caseThrowStmt(ThrowStmt s2) {
                this.result = this.result.add(Scene.v().getRefType(s2.getOp().getType().toString()));
                this.result = this.result.add(DotnetThrowAnalysis.this.mightThrowExplicitly(s2, this.sm));
            }

            @Override
            public void defaultCase(Object obj) {
            }
        };
    }

    @Override
    protected UnitThrowAnalysis.ValueSwitch valueSwitch() {
        return new UnitThrowAnalysis.ValueSwitch(){

            @Override
            public void caseCheckedAddExpr(JCheckedAddExpr v) {
                this.result = this.result.add(Scene.v().getRefType("System.OverflowException"));
            }

            @Override
            public void caseCheckedMulExpr(JCheckedMulExpr v) {
                this.result = this.result.add(Scene.v().getRefType("System.OverflowException"));
            }

            @Override
            public void caseCheckedSubExpr(JCheckedSubExpr v) {
                this.result = this.result.add(Scene.v().getRefType("System.OverflowException"));
            }

            @Override
            public void caseCheckedCastExpr(JCheckedCastExpr v) {
                this.result = this.result.add(Scene.v().getRefType("System.OverflowException"));
            }

            @Override
            public void caseClassConstant(ClassConstant c) {
                this.result = this.result.add(Scene.v().getRefType("System.TypeLoadException"));
            }

            @Override
            public void caseMethodHandle(MethodHandle handle) {
            }

            @Override
            public void caseMethodType(MethodType type) {
            }

            @Override
            public void caseDivExpr(DivExpr expr) {
                this.caseBinopDivExpr(expr);
            }

            @Override
            public void caseRemExpr(RemExpr expr) {
                this.caseBinopDivExpr(expr);
            }

            @Override
            public void caseInterfaceInvokeExpr(InterfaceInvokeExpr expr) {
                this.caseInstanceInvokeExpr(expr, false);
            }

            @Override
            public void caseSpecialInvokeExpr(SpecialInvokeExpr expr) {
                this.caseInstanceInvokeExpr(expr, false);
            }

            @Override
            public void caseStaticInvokeExpr(StaticInvokeExpr expr) {
                this.caseInstanceInvokeExpr(expr, true);
            }

            @Override
            public void caseVirtualInvokeExpr(VirtualInvokeExpr expr) {
                this.caseInstanceInvokeExpr(expr, false);
            }

            @Override
            public void caseDynamicInvokeExpr(DynamicInvokeExpr expr) {
            }

            @Override
            public void caseCastExpr(CastExpr expr) {
                this.result = this.result.add(Scene.v().getRefType("System.OutOfMemoryException"));
                this.result = this.result.add(Scene.v().getRefType("System.NullReferenceException"));
                Type fromType = expr.getOp().getType();
                Type toType = expr.getCastType();
                if (!(fromType instanceof RefLikeType)) {
                    this.result = this.result.add(Scene.v().getRefType("System.InvalidCastException"));
                }
                if (toType instanceof RefLikeType) {
                    FastHierarchy h2 = Scene.v().getOrMakeFastHierarchy();
                    if (fromType == null || fromType instanceof UnknownType || !(fromType instanceof NullType) && !h2.canStoreType(fromType, toType)) {
                        this.result = this.result.add(Scene.v().getRefType("System.TypeLoadException"));
                    }
                }
                this.result = this.result.add(DotnetThrowAnalysis.this.mightThrow(expr.getOp()));
            }

            @Override
            public void caseInstanceOfExpr(InstanceOfExpr expr) {
                this.result = this.result.add(Scene.v().getRefType("System.TypeLoadException"));
                this.result = this.result.add(DotnetThrowAnalysis.this.mightThrow(expr.getOp()));
            }

            @Override
            public void caseNewArrayExpr(NewArrayExpr expr) {
                this.result = this.result.add(Scene.v().getRefType("System.OutOfMemoryException"));
                Value count = expr.getSize();
                if (!(count instanceof IntConstant) || ((IntConstant)count).lessThan(INT_CONSTANT_ZERO).equals(INT_CONSTANT_ZERO)) {
                    this.result = this.result.add(Scene.v().getRefType("System.OverflowException"));
                }
                this.result = this.result.add(DotnetThrowAnalysis.this.mightThrow(count));
            }

            @Override
            public void caseNewMultiArrayExpr(NewMultiArrayExpr expr) {
                this.result = this.result.add(Scene.v().getRefType("System.OutOfMemoryException"));
                for (int i = 0; i < expr.getSizeCount(); ++i) {
                    Value count = expr.getSize(i);
                    if (!(count instanceof IntConstant) || ((IntConstant)count).lessThan(INT_CONSTANT_ZERO).equals(INT_CONSTANT_ZERO)) {
                        this.result = this.result.add(Scene.v().getRefType("System.OverflowException"));
                    }
                    this.result = this.result.add(DotnetThrowAnalysis.this.mightThrow(count));
                }
            }

            @Override
            public void caseNewExpr(NewExpr expr) {
            }

            @Override
            public void caseLengthExpr(LengthExpr expr) {
                this.result = this.result.add(Scene.v().getRefType("System.NullReferenceException"));
                this.result = this.result.add(DotnetThrowAnalysis.this.mightThrow(expr.getOp()));
            }

            @Override
            public void caseArrayRef(ArrayRef ref) {
                this.result = this.result.add(Scene.v().getRefType("System.NullReferenceException"));
                this.result = this.result.add(Scene.v().getRefType("System.IndexOutOfRangeException"));
                this.result = this.result.add(DotnetThrowAnalysis.this.mightThrow(ref.getBase()));
                this.result = this.result.add(DotnetThrowAnalysis.this.mightThrow(ref.getIndex()));
            }

            @Override
            public void caseStaticFieldRef(StaticFieldRef ref) {
                this.result = this.result.add(Scene.v().getRefType("System.FieldAccessException"));
                this.result = this.result.add(Scene.v().getRefType("System.MissingFieldException"));
            }

            @Override
            public void caseInstanceFieldRef(InstanceFieldRef ref) {
                this.result = this.result.add(Scene.v().getRefType("System.FieldAccessException"));
                this.result = this.result.add(Scene.v().getRefType("System.InvalidOperationException"));
                this.result = this.result.add(Scene.v().getRefType("System.MissingFieldException"));
                this.result = this.result.add(Scene.v().getRefType("System.NullReferenceException"));
                this.result = this.result.add(DotnetThrowAnalysis.this.mightThrow(ref.getBase()));
            }

            @Override
            public void caseParameterRef(ParameterRef v) {
            }

            @Override
            public void caseCaughtExceptionRef(CaughtExceptionRef v) {
                this.result = this.result.add(Scene.v().getRefType(v.getType().toString()));
            }

            @Override
            public void caseLocal(Local l) {
                this.result = this.result.add(Scene.v().getRefType("System.VerificationException"));
            }

            @Override
            public void caseNewInvokeExpr(NewInvokeExpr e) {
                this.caseStaticInvokeExpr(e);
            }

            @Override
            public void defaultCase(Object obj) {
            }

            private void caseBinopDivExpr(BinopExpr expr) {
                Value divisor = expr.getOp2();
                Type divisorType = divisor.getType();
                if (divisorType instanceof UnknownType || divisorType instanceof IntegerType && (!(divisor instanceof IntConstant) || divisor.equals(INT_CONSTANT_ZERO)) || divisorType instanceof LongType && (!(divisor instanceof LongConstant) || divisor.equals(LONG_CONSTANT_ZERO))) {
                    this.result = this.result.add(Scene.v().getRefType("System.DivideByZeroException"));
                }
                this.result = this.result.add(Scene.v().getRefType("System.ArithmeticException"));
                this.result = this.result.add(DotnetThrowAnalysis.this.mightThrow(expr.getOp1()));
                this.result = this.result.add(DotnetThrowAnalysis.this.mightThrow(expr.getOp2()));
            }

            private void caseInstanceInvokeExpr(InvokeExpr expr, boolean staticInvoke) {
                this.result = this.result.add(Scene.v().getRefType("System.MethodAccessException"));
                this.result = this.result.add(Scene.v().getRefType("System.MissingMethodException"));
                this.result = this.result.add(Scene.v().getRefType("System.NullReferenceException"));
                for (int i = 0; i < expr.getArgCount(); ++i) {
                    this.result = this.result.add(DotnetThrowAnalysis.this.mightThrow(expr.getArg(i)));
                }
                if (!staticInvoke) {
                    this.result = this.result.add(DotnetThrowAnalysis.this.mightThrow(((InstanceInvokeExpr)expr).getBase()));
                }
                this.result = this.result.add(DotnetThrowAnalysis.this.mightThrow(expr.getMethodRef()));
            }
        };
    }
}

