/*
 * Decompiled with CFR 0.152.
 */
package soot.dotnet;

import java.io.File;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.ArrayType;
import soot.ClassSource;
import soot.RefType;
import soot.SootClass;
import soot.Type;
import soot.dotnet.AssemblyFile;
import soot.dotnet.proto.ProtoAssemblyAllTypes;
import soot.dotnet.types.DotnetType;
import soot.dotnet.types.DotnetTypeFactory;
import soot.javaToJimple.IInitialResolver;
import soot.options.Options;

public class DotnetClassSource
extends ClassSource {
    private static final Logger logger = LoggerFactory.getLogger(DotnetClassSource.class);
    protected AssemblyFile assemblyFile;

    public DotnetClassSource(String className, File path) {
        super(className);
        if (!(path instanceof AssemblyFile)) {
            throw new RuntimeException("Given File object is no assembly file!");
        }
        this.assemblyFile = (AssemblyFile)path;
    }

    @Override
    public IInitialResolver.Dependencies resolve(SootClass sc) {
        if (Options.v().verbose()) {
            logger.info("resolving " + this.className + " type definition from file " + this.assemblyFile.getPath());
        }
        ProtoAssemblyAllTypes.TypeDefinition typeDefinition = this.assemblyFile.getTypeDefinition(sc.getName());
        DotnetType dotnetType = new DotnetType(typeDefinition, this.assemblyFile);
        IInitialResolver.Dependencies deps = dotnetType.resolveSootClass(sc);
        this.resolveSignatureDependencies(deps);
        return deps;
    }

    private void resolveSignatureDependencies(IInitialResolver.Dependencies deps) {
        List<String> allModuleTypesList = this.assemblyFile.getAllReferencedModuleTypes();
        for (String i : allModuleTypesList) {
            Type st = DotnetTypeFactory.toSootType(i);
            if (st instanceof ArrayType) {
                st = ((ArrayType)st).baseType;
            }
            if (!(st instanceof RefType)) continue;
            deps.typesToSignature.add(st);
        }
    }
}

