/*
 * Decompiled with CFR 0.152.
 */
package soot.dotnet;

import com.google.common.base.Strings;
import java.io.File;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FilenameUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.dotnet.members.DotnetEvent;
import soot.dotnet.proto.ProtoAssemblyAllTypes;
import soot.dotnet.proto.ProtoDotnetNativeHost;
import soot.dotnet.proto.ProtoIlInstructions;
import soot.options.Options;
import soot.toolkits.scalar.Pair;

public class AssemblyFile
extends File {
    private static final Logger logger = LoggerFactory.getLogger(AssemblyFile.class);
    private static boolean loaded;
    private static final Object lockobj;
    private final String fullyQualifiedAssemblyPathFilename;
    private ProtoAssemblyAllTypes.AssemblyAllTypes protoAllTypes;
    private Map<String, ProtoAssemblyAllTypes.TypeDefinition> allTypeMap;
    private final String pathNativeHost;
    private boolean gotAllReferencesModuleTypes = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AssemblyFile(String fullyQualifiedAssemblyPathFilename) {
        super(fullyQualifiedAssemblyPathFilename);
        this.fullyQualifiedAssemblyPathFilename = fullyQualifiedAssemblyPathFilename;
        this.pathNativeHost = Options.v().dotnet_nativehost_path();
        if (!loaded) {
            Object object = lockobj;
            synchronized (object) {
                if (loaded) {
                    return;
                }
                System.load(this.pathNativeHost);
                loaded = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProtoAssemblyAllTypes.AssemblyAllTypes getAllTypes() {
        if (this.protoAllTypes != null) {
            return this.protoAllTypes;
        }
        try {
            byte[] protobufMessageBytes;
            ProtoDotnetNativeHost.AnalyzerParamsMsg.Builder analyzerParamsBuilder = this.createAnalyzerParamsBuilder("", ProtoDotnetNativeHost.AnalyzerMethodCall.GET_ALL_TYPES);
            ProtoDotnetNativeHost.AnalyzerParamsMsg analyzerParamsMsg = analyzerParamsBuilder.build();
            logger.info("Getting all .NET types");
            Object object = lockobj;
            synchronized (object) {
                protobufMessageBytes = this.nativeGetAllTypesMsg(this.pathNativeHost, analyzerParamsMsg.toByteArray());
            }
            ProtoAssemblyAllTypes.AssemblyAllTypes a = ProtoAssemblyAllTypes.AssemblyAllTypes.parseFrom(protobufMessageBytes);
            logger.info("Finished: Getting all .NET types");
            List<ProtoAssemblyAllTypes.TypeDefinition> allTypesList = a.getListOfTypesList();
            this.allTypeMap = new HashMap<String, ProtoAssemblyAllTypes.TypeDefinition>();
            for (ProtoAssemblyAllTypes.TypeDefinition p : allTypesList) {
                this.allTypeMap.put(p.getFullname(), p);
            }
            this.protoAllTypes = a;
            return a;
        }
        catch (Exception e) {
            logger.error(MessageFormat.format("Could not read in {0}", this.getAssemblyFileName()), e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProtoIlInstructions.IlFunctionMsg getMethodBody(String className, String method, int peToken) {
        ProtoDotnetNativeHost.AnalyzerParamsMsg.Builder analyzerParamsBuilder = this.createAnalyzerParamsBuilder(className, ProtoDotnetNativeHost.AnalyzerMethodCall.GET_METHOD_BODY);
        Pair<String, String> methodNameSuffixPair = this.helperExtractMethodNameSuffix(method);
        analyzerParamsBuilder.setMethodName(methodNameSuffixPair.getO1());
        analyzerParamsBuilder.setMethodNameSuffix(methodNameSuffixPair.getO2());
        analyzerParamsBuilder.setMethodPeToken(peToken);
        ProtoDotnetNativeHost.AnalyzerParamsMsg analyzerParamsMsg = analyzerParamsBuilder.build();
        try {
            byte[] protoMsgBytes;
            Object object = lockobj;
            synchronized (object) {
                protoMsgBytes = this.nativeGetMethodBodyMsg(this.pathNativeHost, analyzerParamsMsg.toByteArray());
            }
            return ProtoIlInstructions.IlFunctionMsg.parseFrom(protoMsgBytes);
        }
        catch (Exception e) {
            if (Options.v().verbose()) {
                logger.warn("Exception while getting method body of method " + className + "." + method + ": " + e.getMessage());
            }
            return null;
        }
    }

    private Pair<String, String> helperExtractMethodNameSuffix(String sootMethodName) {
        if (!sootMethodName.contains("[[") || !sootMethodName.contains("]]")) {
            return new Pair<String, String>(sootMethodName, "");
        }
        int startSuffix = sootMethodName.indexOf("[[");
        String suffix = sootMethodName.substring(startSuffix);
        String cilMethodName = sootMethodName.substring(0, startSuffix);
        return new Pair<String, String>(cilMethodName, suffix);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProtoIlInstructions.IlFunctionMsg getMethodBodyOfProperty(String className, String propertyName, boolean isSetter) {
        ProtoDotnetNativeHost.AnalyzerParamsMsg.Builder analyzerParamsBuilder = this.createAnalyzerParamsBuilder(className, ProtoDotnetNativeHost.AnalyzerMethodCall.GET_METHOD_BODY_OF_PROPERTY);
        analyzerParamsBuilder.setPropertyName(propertyName);
        analyzerParamsBuilder.setPropertyIsSetter(isSetter);
        ProtoDotnetNativeHost.AnalyzerParamsMsg analyzerParamsMsg = analyzerParamsBuilder.build();
        try {
            byte[] protoMsgBytes;
            Object object = lockobj;
            synchronized (object) {
                protoMsgBytes = this.nativeGetMethodBodyOfPropertyMsg(this.pathNativeHost, analyzerParamsMsg.toByteArray());
            }
            return ProtoIlInstructions.IlFunctionMsg.parseFrom(protoMsgBytes);
        }
        catch (Exception e) {
            if (Options.v().verbose()) {
                logger.warn("Exception while getting method body of property " + className + "." + propertyName + ": " + e.getMessage());
                logger.warn("Return null");
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProtoIlInstructions.IlFunctionMsg getMethodBodyOfEvent(String className, String eventName, DotnetEvent.EventDirective eventDirective) {
        ProtoDotnetNativeHost.EventAccessorType accessorType;
        ProtoDotnetNativeHost.AnalyzerParamsMsg.Builder analyzerParamsBuilder = this.createAnalyzerParamsBuilder(className, ProtoDotnetNativeHost.AnalyzerMethodCall.GET_METHOD_BODY_OF_EVENT);
        analyzerParamsBuilder.setEventName(eventName);
        switch (eventDirective) {
            case ADD: {
                accessorType = ProtoDotnetNativeHost.EventAccessorType.ADD_ACCESSOR;
                break;
            }
            case REMOVE: {
                accessorType = ProtoDotnetNativeHost.EventAccessorType.REMOVE_ACCESSOR;
                break;
            }
            case INVOKE: {
                accessorType = ProtoDotnetNativeHost.EventAccessorType.INVOKE_ACCESSOR;
                break;
            }
            default: {
                throw new RuntimeException("Wrong Event Accessor Type!");
            }
        }
        analyzerParamsBuilder.setEventAccessorType(accessorType);
        ProtoDotnetNativeHost.AnalyzerParamsMsg analyzerParamsMsg = analyzerParamsBuilder.build();
        try {
            byte[] protoMsgBytes;
            Object object = lockobj;
            synchronized (object) {
                protoMsgBytes = this.nativeGetMethodBodyOfEventMsg(this.pathNativeHost, analyzerParamsMsg.toByteArray());
            }
            return ProtoIlInstructions.IlFunctionMsg.parseFrom(protoMsgBytes);
        }
        catch (Exception e) {
            if (Options.v().verbose()) {
                logger.warn("Exception while getting method body of event " + className + "." + eventName + ": " + e.getMessage());
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isAssembly() {
        Object object = lockobj;
        synchronized (object) {
            return this.nativeIsAssembly(this.pathNativeHost, this.fullyQualifiedAssemblyPathFilename);
        }
    }

    public ProtoAssemblyAllTypes.TypeDefinition getTypeDefinition(String className) {
        if (Strings.isNullOrEmpty(className)) {
            return null;
        }
        if (this.allTypeMap == null) {
            this.getAllTypes();
        }
        return this.allTypeMap.get(className);
    }

    public Collection<String> getAllTypeNames() {
        if (this.allTypeMap == null) {
            this.getAllTypes();
        }
        return this.allTypeMap.keySet();
    }

    public List<String> getAllReferencedModuleTypes() {
        ProtoAssemblyAllTypes.AssemblyAllTypes allTypes = this.getAllTypes();
        if (allTypes == null || this.gotAllReferencesModuleTypes) {
            return new ArrayList<String>();
        }
        this.gotAllReferencesModuleTypes = true;
        return allTypes.getAllReferencedModuleTypesList();
    }

    private ProtoDotnetNativeHost.AnalyzerParamsMsg.Builder createAnalyzerParamsBuilder(String className, ProtoDotnetNativeHost.AnalyzerMethodCall methodCall) {
        ProtoDotnetNativeHost.AnalyzerParamsMsg.Builder analyzerParamsBuilder = ProtoDotnetNativeHost.AnalyzerParamsMsg.newBuilder();
        analyzerParamsBuilder.setAnalyzerMethodCall(methodCall);
        analyzerParamsBuilder.setAssemblyFileAbsolutePath(this.fullyQualifiedAssemblyPathFilename);
        analyzerParamsBuilder.setTypeReflectionName(className);
        if (Options.v().verbose() || Options.v().debug()) {
            analyzerParamsBuilder.setDebugMode(true);
        }
        return analyzerParamsBuilder;
    }

    public String getFullPath() {
        return FilenameUtils.getFullPath(this.fullyQualifiedAssemblyPathFilename);
    }

    public String getAssemblyFileName() {
        return FilenameUtils.getName(this.fullyQualifiedAssemblyPathFilename);
    }

    private native byte[] nativeGetAllTypesMsg(String var1, byte[] var2);

    private native byte[] nativeGetMethodBodyMsg(String var1, byte[] var2);

    private native byte[] nativeGetMethodBodyOfPropertyMsg(String var1, byte[] var2);

    private native byte[] nativeGetMethodBodyOfEventMsg(String var1, byte[] var2);

    private native byte[] nativeGetAssemblyContentMsg(String var1, byte[] var2);

    private native boolean nativeIsAssembly(String var1, String var2);

    public native byte[] nativeGetManifestResourceStream(String var1, String var2, String var3);

    static {
        lockobj = new Object();
    }
}

