/*
 * Decompiled with CFR 0.152.
 */
package soot.dexpler.typing;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import soot.ArrayType;
import soot.Body;
import soot.BooleanType;
import soot.ByteType;
import soot.CharType;
import soot.DoubleType;
import soot.FloatType;
import soot.IntType;
import soot.Local;
import soot.LongType;
import soot.PrimType;
import soot.RefType;
import soot.ShortType;
import soot.Type;
import soot.Unit;
import soot.UnknownType;
import soot.Value;
import soot.ValueBox;
import soot.dexpler.IDalvikTyper;
import soot.dexpler.tags.DoubleOpTag;
import soot.dexpler.tags.FloatOpTag;
import soot.dexpler.tags.IntOpTag;
import soot.dexpler.tags.LongOpTag;
import soot.dexpler.typing.UntypedConstant;
import soot.dexpler.typing.UntypedIntOrFloatConstant;
import soot.dexpler.typing.UntypedLongOrDoubleConstant;
import soot.jimple.ArrayRef;
import soot.jimple.AssignStmt;
import soot.jimple.BinopExpr;
import soot.jimple.BreakpointStmt;
import soot.jimple.CastExpr;
import soot.jimple.Constant;
import soot.jimple.DefinitionStmt;
import soot.jimple.DivExpr;
import soot.jimple.DynamicInvokeExpr;
import soot.jimple.EnterMonitorStmt;
import soot.jimple.ExitMonitorStmt;
import soot.jimple.GotoStmt;
import soot.jimple.IdentityStmt;
import soot.jimple.IfStmt;
import soot.jimple.InstanceInvokeExpr;
import soot.jimple.InvokeExpr;
import soot.jimple.InvokeStmt;
import soot.jimple.LongConstant;
import soot.jimple.LookupSwitchStmt;
import soot.jimple.NewArrayExpr;
import soot.jimple.NopStmt;
import soot.jimple.NullConstant;
import soot.jimple.RemExpr;
import soot.jimple.RetStmt;
import soot.jimple.ReturnStmt;
import soot.jimple.ReturnVoidStmt;
import soot.jimple.ShlExpr;
import soot.jimple.ShrExpr;
import soot.jimple.StaticInvokeExpr;
import soot.jimple.StmtSwitch;
import soot.jimple.TableSwitchStmt;
import soot.jimple.ThrowStmt;
import soot.jimple.UnopExpr;
import soot.jimple.UshrExpr;
import soot.tagkit.Tag;
import soot.toolkits.graph.ExceptionalUnitGraph;
import soot.toolkits.graph.ExceptionalUnitGraphFactory;
import soot.toolkits.scalar.LocalDefs;
import soot.toolkits.scalar.SimpleLocalDefs;
import soot.toolkits.scalar.SimpleLocalUses;
import soot.toolkits.scalar.UnitValueBoxPair;

public class DalvikTyper
implements IDalvikTyper {
    private static DalvikTyper dt = null;
    private Set<Constraint> constraints = new HashSet<Constraint>();
    private Map<ValueBox, Type> typed = new HashMap<ValueBox, Type>();
    private Map<Local, Type> localTyped = new HashMap<Local, Type>();
    private Set<Local> localTemp = new HashSet<Local>();
    private List<LocalObj> localObjList = new ArrayList<LocalObj>();
    private Map<Local, List<LocalObj>> local2Obj = new HashMap<Local, List<LocalObj>>();

    private DalvikTyper() {
    }

    public static DalvikTyper v() {
        if (dt == null) {
            dt = new DalvikTyper();
        }
        return dt;
    }

    public void clear() {
        this.constraints.clear();
        this.typed.clear();
        this.localTyped.clear();
        this.localTemp.clear();
        this.localObjList.clear();
        this.local2Obj.clear();
    }

    @Override
    public void setType(ValueBox vb, Type t2, boolean isUse) {
        if (vb.getValue() instanceof Local) {
            LocalObj lb = new LocalObj(vb, t2, isUse);
            this.localObjList.add(lb);
            Local k = (Local)vb.getValue();
            if (!this.local2Obj.containsKey(k)) {
                this.local2Obj.put(k, new ArrayList());
            }
            this.local2Obj.get(k).add(lb);
        }
    }

    @Override
    public void addConstraint(ValueBox l, ValueBox r) {
    }

    @Override
    public void assignType(final Body b) {
        Object l;
        AssignStmt ass;
        Value r;
        this.constraints.clear();
        this.localObjList.clear();
        final HashSet<Unit> todoUnits = new HashSet<Unit>();
        for (Unit u : b.getUnits()) {
            StmtSwitch ss = new StmtSwitch(){

                @Override
                public void caseBreakpointStmt(BreakpointStmt stmt) {
                }

                @Override
                public void caseInvokeStmt(InvokeStmt stmt) {
                    DalvikTyper.v().setInvokeType(stmt.getInvokeExpr());
                }

                @Override
                public void caseAssignStmt(AssignStmt stmt) {
                    ArrayRef ar;
                    NewArrayExpr nae;
                    ValueBox sb;
                    Value l = stmt.getLeftOp();
                    Value r = stmt.getRightOp();
                    if (r instanceof NewArrayExpr && (sb = (nae = (NewArrayExpr)r).getSizeBox()).getValue() instanceof Local) {
                        DalvikTyper.v().setType(sb, IntType.v(), true);
                    }
                    if (stmt.containsArrayRef() && (sb = (ar = stmt.getArrayRef()).getIndexBox()).getValue() instanceof Local) {
                        DalvikTyper.v().setType(sb, IntType.v(), true);
                    }
                    if (l instanceof Local && r instanceof Local) {
                        DalvikTyper.v().addConstraint(stmt.getLeftOpBox(), stmt.getRightOpBox());
                        return;
                    }
                    if (stmt.containsInvokeExpr()) {
                        DalvikTyper.v().setInvokeType(stmt.getInvokeExpr());
                    }
                    if (r instanceof Local) {
                        Type leftType = stmt.getLeftOp().getType();
                        if (l instanceof ArrayRef && leftType instanceof UnknownType) {
                            todoUnits.add(stmt);
                            return;
                        }
                        DalvikTyper.v().setType(stmt.getRightOpBox(), leftType, true);
                        return;
                    }
                    if (l instanceof Local) {
                        if (r instanceof UntypedConstant) {
                            return;
                        }
                        for (Tag t2 : stmt.getTags()) {
                            if (r instanceof CastExpr) break;
                            if (t2 instanceof IntOpTag) {
                                DalvikTyper.this.checkExpr(r, IntType.v());
                                DalvikTyper.v().setType(stmt.getLeftOpBox(), IntType.v(), false);
                                return;
                            }
                            if (t2 instanceof FloatOpTag) {
                                DalvikTyper.this.checkExpr(r, FloatType.v());
                                DalvikTyper.v().setType(stmt.getLeftOpBox(), FloatType.v(), false);
                                return;
                            }
                            if (t2 instanceof DoubleOpTag) {
                                DalvikTyper.this.checkExpr(r, DoubleType.v());
                                DalvikTyper.v().setType(stmt.getLeftOpBox(), DoubleType.v(), false);
                                return;
                            }
                            if (!(t2 instanceof LongOpTag)) continue;
                            DalvikTyper.this.checkExpr(r, LongType.v());
                            DalvikTyper.v().setType(stmt.getLeftOpBox(), LongType.v(), false);
                            return;
                        }
                        Type rightType = stmt.getRightOp().getType();
                        if (r instanceof ArrayRef && rightType instanceof UnknownType) {
                            todoUnits.add(stmt);
                            return;
                        }
                        if (r instanceof CastExpr) {
                            CastExpr ce = (CastExpr)r;
                            Type castType = ce.getCastType();
                            if (castType instanceof PrimType) {
                                for (Tag t3 : stmt.getTags()) {
                                    if (t3 instanceof IntOpTag) {
                                        DalvikTyper.v().setType(ce.getOpBox(), IntType.v(), false);
                                        return;
                                    }
                                    if (t3 instanceof FloatOpTag) {
                                        DalvikTyper.v().setType(ce.getOpBox(), FloatType.v(), false);
                                        return;
                                    }
                                    if (t3 instanceof DoubleOpTag) {
                                        DalvikTyper.v().setType(ce.getOpBox(), DoubleType.v(), false);
                                        return;
                                    }
                                    if (!(t3 instanceof LongOpTag)) continue;
                                    DalvikTyper.v().setType(ce.getOpBox(), LongType.v(), false);
                                    return;
                                }
                            } else {
                                DalvikTyper.v().setType(ce.getOpBox(), RefType.v("java.lang.Object"), false);
                            }
                        }
                        DalvikTyper.v().setType(stmt.getLeftOpBox(), rightType, false);
                        return;
                    }
                }

                @Override
                public void caseIdentityStmt(IdentityStmt stmt) {
                    DalvikTyper.v().setType(stmt.getLeftOpBox(), stmt.getRightOp().getType(), false);
                }

                @Override
                public void caseEnterMonitorStmt(EnterMonitorStmt stmt) {
                    DalvikTyper.v().setType(stmt.getOpBox(), RefType.v("java.lang.Object"), true);
                }

                @Override
                public void caseExitMonitorStmt(ExitMonitorStmt stmt) {
                    DalvikTyper.v().setType(stmt.getOpBox(), RefType.v("java.lang.Object"), true);
                }

                @Override
                public void caseGotoStmt(GotoStmt stmt) {
                }

                @Override
                public void caseIfStmt(IfStmt stmt) {
                    Value c = stmt.getCondition();
                    if (c instanceof BinopExpr) {
                        BinopExpr bo = (BinopExpr)c;
                        Value op1 = bo.getOp1();
                        Value op2 = bo.getOp2();
                        if (op1 instanceof Local && op2 instanceof Local) {
                            DalvikTyper.v().addConstraint(bo.getOp1Box(), bo.getOp2Box());
                        }
                    }
                }

                @Override
                public void caseLookupSwitchStmt(LookupSwitchStmt stmt) {
                    DalvikTyper.v().setType(stmt.getKeyBox(), IntType.v(), true);
                }

                @Override
                public void caseNopStmt(NopStmt stmt) {
                }

                @Override
                public void caseRetStmt(RetStmt stmt) {
                }

                @Override
                public void caseReturnStmt(ReturnStmt stmt) {
                    DalvikTyper.v().setType(stmt.getOpBox(), b.getMethod().getReturnType(), true);
                }

                @Override
                public void caseReturnVoidStmt(ReturnVoidStmt stmt) {
                }

                @Override
                public void caseTableSwitchStmt(TableSwitchStmt stmt) {
                    DalvikTyper.v().setType(stmt.getKeyBox(), IntType.v(), true);
                }

                @Override
                public void caseThrowStmt(ThrowStmt stmt) {
                    DalvikTyper.v().setType(stmt.getOpBox(), RefType.v("java.lang.Object"), true);
                }

                @Override
                public void defaultCase(Object obj) {
                    throw new RuntimeException("error: unknown statement: " + obj);
                }
            };
            u.apply(ss);
        }
        if (!todoUnits.isEmpty()) {
            ExceptionalUnitGraph ug = ExceptionalUnitGraphFactory.createExceptionalUnitGraph(b);
            SimpleLocalDefs sld = new SimpleLocalDefs(ug);
            Iterator<Object> slu = new SimpleLocalUses(b, (LocalDefs)sld);
            for (Unit u : b.getUnits()) {
                Type rType;
                DefinitionStmt definitionStmt;
                if (!(u instanceof DefinitionStmt) || (r = (definitionStmt = (DefinitionStmt)u).getRightOp()) instanceof UntypedConstant || !((rType = r.getType()) instanceof ArrayType) || !(definitionStmt.getLeftOp() instanceof Local)) continue;
                HashSet<DefinitionStmt> done = new HashSet<DefinitionStmt>();
                HashSet<DefinitionStmt> toDo = new HashSet<DefinitionStmt>();
                toDo.add(definitionStmt);
                while (!toDo.isEmpty()) {
                    DefinitionStmt currentUnit = (DefinitionStmt)toDo.iterator().next();
                    if (done.contains(currentUnit)) {
                        toDo.remove(currentUnit);
                        continue;
                    }
                    done.add(currentUnit);
                    for (UnitValueBoxPair unitValueBoxPair : ((SimpleLocalUses)((Object)slu)).getUsesOf(currentUnit)) {
                        Unit use = unitValueBoxPair.unit;
                        Value l22 = null;
                        Value r2 = null;
                        if (!(use instanceof AssignStmt)) continue;
                        AssignStmt ass22 = (AssignStmt)use;
                        l22 = ass22.getLeftOp();
                        r2 = ass22.getRightOp();
                        if (!(l22 instanceof Local) || !(r2 instanceof Local) && !(r2 instanceof ArrayRef)) continue;
                        Type newType = null;
                        if (r2 instanceof Local) {
                            List<LocalObj> lobjs = this.local2Obj.get(r2);
                            newType = lobjs.get((int)0).t;
                        } else if (r2 instanceof ArrayRef) {
                            ArrayRef ar = (ArrayRef)r2;
                            if (ar.getIndex() == currentUnit.getLeftOp()) continue;
                            Local arBase = (Local)ar.getBase();
                            List<LocalObj> lobjs = this.local2Obj.get(arBase);
                            Type baseT = lobjs.get((int)0).t;
                            if (baseT.toString().equals("java.lang.Object")) {
                                ArrayType aTypeOtherThanObject = null;
                                for (LocalObj lo : this.local2Obj.get(arBase)) {
                                    if (!(lo.t instanceof ArrayType)) continue;
                                    aTypeOtherThanObject = (ArrayType)lo.t;
                                }
                                if (aTypeOtherThanObject == null) {
                                    throw new RuntimeException("error: did not found array type for base " + arBase + " " + this.local2Obj.get(arBase) + " \n " + b);
                                }
                                baseT = aTypeOtherThanObject;
                            }
                            ArrayType at = (ArrayType)baseT;
                            newType = at.getElementType();
                        } else {
                            throw new RuntimeException("error: expected Local or ArrayRef. Got " + r2);
                        }
                        toDo.add((DefinitionStmt)use);
                        DalvikTyper.v().setType(ass22.getLeftOpBox(), newType, true);
                    }
                }
            }
            for (Unit u : todoUnits) {
            }
            while (!todoUnits.isEmpty()) {
                ArrayType basetype;
                Type type;
                Unit unit = (Unit)todoUnits.iterator().next();
                if (!(unit instanceof AssignStmt)) {
                    throw new RuntimeException("error: expecting assign stmt. Got " + unit);
                }
                ass = (AssignStmt)unit;
                Value value = ass.getLeftOp();
                r = ass.getRightOp();
                ArrayRef ar = null;
                Local loc = null;
                if (value instanceof ArrayRef) {
                    ar = (ArrayRef)value;
                    loc = (Local)r;
                } else if (r instanceof ArrayRef) {
                    ar = (ArrayRef)r;
                    loc = (Local)value;
                } else {
                    throw new RuntimeException("error: expecting an array ref. Got " + unit);
                }
                Local baselocal = (Local)ar.getBase();
                if (!this.local2Obj.containsKey(baselocal)) {
                    throw new RuntimeException("oups");
                }
                Type baseT = this.local2Obj.get((Object)baselocal).get((int)0).t;
                if (baseT.toString().equals("java.lang.Object")) {
                    ArrayType aTypeOtherThanObject = null;
                    for (LocalObj lo : this.local2Obj.get(baselocal)) {
                        if (!(lo.t instanceof ArrayType)) continue;
                        aTypeOtherThanObject = (ArrayType)lo.t;
                    }
                    if (aTypeOtherThanObject == null) {
                        throw new RuntimeException("did not found array type for base " + baselocal + " " + this.local2Obj.get(baselocal) + " \n " + b);
                    }
                    baseT = aTypeOtherThanObject;
                }
                if ((type = (basetype = (ArrayType)baseT).getElementType()) instanceof UnknownType) {
                    todoUnits.add(unit);
                    continue;
                }
                DalvikTyper.v().setType(ar == value ? ass.getRightOpBox() : ass.getLeftOpBox(), type, true);
                todoUnits.remove(unit);
            }
        }
        List<ValueBox> vbList = b.getUseAndDefBoxes();
        ArrayList<Constraint> toRemove = new ArrayList<Constraint>();
        for (Constraint constraint : this.constraints) {
            if (vbList.contains(constraint.l) && vbList.contains(constraint.r)) continue;
            toRemove.add(constraint);
        }
        for (Constraint constraint : toRemove) {
            this.constraints.remove(constraint);
        }
        for (LocalObj localObj : this.localObjList) {
            if (!vbList.contains(localObj.vb)) continue;
            l = localObj.getLocal();
            Type type = localObj.t;
            if (this.localTemp.contains(l) && localObj.isUse) continue;
            this.localTemp.add((Local)l);
            this.typed.put(localObj.vb, type);
        }
        for (ValueBox valueBox : this.typed.keySet()) {
            if (!(valueBox.getValue() instanceof Local)) continue;
            l = (Local)valueBox.getValue();
            this.localTyped.put((Local)l, this.typed.get(valueBox));
        }
        for (Constraint constraint : this.constraints) {
            for (ValueBox valueBox : this.typed.keySet()) {
            }
        }
        for (Local local : this.localTyped.keySet()) {
        }
        while (!this.constraints.isEmpty()) {
            boolean update = false;
            for (Constraint c : this.constraints) {
                Type elementType;
                Local base;
                ArrayRef ar;
                Local leftLocal;
                Value value = c.l.getValue();
                r = c.r.getValue();
                if (value instanceof Local && r instanceof Constant) {
                    UntypedLongOrDoubleConstant ud;
                    UntypedIntOrFloatConstant uf;
                    Constant cst = (Constant)r;
                    if (!this.localTyped.containsKey(value)) continue;
                    Type lt = this.localTyped.get(value);
                    Constant newValue = null;
                    if (lt instanceof IntType || lt instanceof BooleanType || lt instanceof ShortType || lt instanceof CharType || lt instanceof ByteType) {
                        uf = (UntypedIntOrFloatConstant)cst;
                        newValue = uf.toIntConstant();
                    } else if (lt instanceof FloatType) {
                        uf = (UntypedIntOrFloatConstant)cst;
                        newValue = uf.toFloatConstant();
                    } else if (lt instanceof DoubleType) {
                        ud = (UntypedLongOrDoubleConstant)cst;
                        newValue = ud.toDoubleConstant();
                    } else if (lt instanceof LongType) {
                        ud = (UntypedLongOrDoubleConstant)cst;
                        newValue = ud.toLongConstant();
                    } else if (cst instanceof UntypedIntOrFloatConstant && ((UntypedIntOrFloatConstant)cst).value == 0) {
                        newValue = NullConstant.v();
                    } else {
                        throw new RuntimeException("unknow type for constance: " + lt);
                    }
                    c.r.setValue(newValue);
                    this.constraints.remove(c);
                    update = true;
                    break;
                }
                if (value instanceof Local && r instanceof Local) {
                    leftLocal = (Local)value;
                    Local rightLocal = (Local)r;
                    if (this.localTyped.containsKey(leftLocal)) {
                        Type leftLocalType = this.localTyped.get(leftLocal);
                        if (!this.localTyped.containsKey(rightLocal)) {
                            rightLocal.setType(leftLocalType);
                            this.setLocalTyped(rightLocal, leftLocalType);
                        }
                        this.constraints.remove(c);
                        update = true;
                        break;
                    }
                    if (!this.localTyped.containsKey(rightLocal)) continue;
                    Type rightLocalType = this.localTyped.get(rightLocal);
                    if (!this.localTyped.containsKey(leftLocal)) {
                        leftLocal.setType(rightLocalType);
                        this.setLocalTyped(leftLocal, rightLocalType);
                    }
                    this.constraints.remove(c);
                    update = true;
                    break;
                }
                if (value instanceof ArrayRef && r instanceof Local) {
                    Local rightLocal = (Local)r;
                    ar = (ArrayRef)value;
                    base = (Local)ar.getBase();
                    if (!this.localTyped.containsKey(base)) continue;
                    Type t4 = this.localTyped.get(base);
                    elementType = null;
                    if (!(t4 instanceof ArrayType)) continue;
                    ArrayType arrayType = (ArrayType)t4;
                    elementType = arrayType.getArrayElementType();
                    if (!this.localTyped.containsKey(rightLocal)) {
                        rightLocal.setType(elementType);
                        this.setLocalTyped(rightLocal, elementType);
                    }
                    this.constraints.remove(c);
                    update = true;
                    break;
                }
                if (value instanceof Local && r instanceof ArrayRef) {
                    leftLocal = (Local)value;
                    ar = (ArrayRef)r;
                    base = (Local)ar.getBase();
                    if (!this.localTyped.containsKey(base)) continue;
                    Type t2 = this.localTyped.get(base);
                    elementType = null;
                    if (!(t2 instanceof ArrayType)) continue;
                    ArrayType arrayType = (ArrayType)t2;
                    elementType = arrayType.getArrayElementType();
                    if (!this.localTyped.containsKey(leftLocal)) {
                        leftLocal.setType(elementType);
                        this.setLocalTyped(leftLocal, elementType);
                    }
                    this.constraints.remove(c);
                    update = true;
                    break;
                }
                throw new RuntimeException("error: do not handling this kind of constraint: " + c);
            }
            if (update) continue;
            break;
        }
        for (Unit unit : b.getUnits()) {
            if (!(unit instanceof AssignStmt) || !((ass = (AssignStmt)unit).getLeftOp() instanceof Local) || !(ass.getRightOp() instanceof UntypedConstant)) continue;
            UntypedConstant untypedConstant = (UntypedConstant)ass.getRightOp();
            ass.setRightOp(untypedConstant.defineType(this.localTyped.get(ass.getLeftOp())));
        }
        for (Constraint constraint : this.constraints) {
            l = constraint.l.getValue();
            Value value = constraint.r.getValue();
            if (!(l instanceof Local) || !(value instanceof Constant)) continue;
            if (value instanceof UntypedIntOrFloatConstant) {
                UntypedIntOrFloatConstant cst = (UntypedIntOrFloatConstant)value;
                Constant newValue = null;
                if (cst.value != 0) {
                    newValue = cst.toIntConstant();
                } else {
                    for (Unit u : b.getUnits()) {
                        for (ValueBox vb1 : u.getUseBoxes()) {
                            Value value2 = vb1.getValue();
                            if (value2 != l) continue;
                            if (u instanceof AssignStmt) {
                                AssignStmt a = (AssignStmt)u;
                                Value right = a.getRightOp();
                                if (right instanceof CastExpr) {
                                    newValue = NullConstant.v();
                                    continue;
                                }
                                newValue = cst.toIntConstant();
                                continue;
                            }
                            if (!(u instanceof IfStmt)) continue;
                            newValue = cst.toIntConstant();
                        }
                    }
                }
                if (newValue == null) {
                    throw new RuntimeException("error: no type found for local: " + (Value)l);
                }
                constraint.r.setValue(newValue);
                continue;
            }
            if (!(value instanceof UntypedLongOrDoubleConstant)) continue;
            LongConstant newValue = ((UntypedLongOrDoubleConstant)value).toLongConstant();
            constraint.r.setValue(newValue);
        }
        for (Unit unit : b.getUnits()) {
            StmtSwitch sw = new StmtSwitch(){

                @Override
                public void caseBreakpointStmt(BreakpointStmt stmt) {
                }

                @Override
                public void caseInvokeStmt(InvokeStmt stmt) {
                    DalvikTyper.this.changeUntypedConstantsInInvoke(stmt.getInvokeExpr());
                }

                @Override
                public void caseAssignStmt(AssignStmt stmt) {
                    UntypedConstant uc;
                    if (stmt.getRightOp() instanceof NewArrayExpr) {
                        NewArrayExpr nae = (NewArrayExpr)stmt.getRightOp();
                        if (nae.getSize() instanceof UntypedConstant) {
                            uc = (UntypedIntOrFloatConstant)nae.getSize();
                            nae.setSize(((UntypedIntOrFloatConstant)uc).defineType(IntType.v()));
                        }
                    } else if (stmt.getRightOp() instanceof UntypedConstant) {
                        UntypedConstant uc2 = (UntypedConstant)stmt.getRightOp();
                        Value l = stmt.getLeftOp();
                        Type lType = null;
                        if (l instanceof ArrayRef) {
                            ArrayRef ar = (ArrayRef)l;
                            Local baseLocal = (Local)ar.getBase();
                            ArrayType arrayType = (ArrayType)DalvikTyper.this.localTyped.get(baseLocal);
                            lType = arrayType.getElementType();
                        } else {
                            lType = l.getType();
                        }
                        stmt.setRightOp(uc2.defineType(lType));
                    } else if (stmt.getRightOp() instanceof InvokeExpr) {
                        DalvikTyper.this.changeUntypedConstantsInInvoke((InvokeExpr)stmt.getRightOp());
                    }
                    if (!stmt.containsArrayRef()) {
                        return;
                    }
                    ArrayRef ar = stmt.getArrayRef();
                    if (ar.getIndex() instanceof UntypedConstant) {
                        uc = (UntypedIntOrFloatConstant)ar.getIndex();
                        ar.setIndex(((UntypedIntOrFloatConstant)uc).toIntConstant());
                    }
                    if (stmt.getLeftOp() instanceof ArrayRef && stmt.getRightOp() instanceof UntypedConstant) {
                        uc = (UntypedConstant)stmt.getRightOp();
                        Local baseLocal = (Local)stmt.getArrayRef().getBase();
                        ArrayType lType = (ArrayType)DalvikTyper.this.localTyped.get(baseLocal);
                        Type elemType = lType.getElementType();
                        stmt.setRightOp(uc.defineType(elemType));
                    }
                }

                @Override
                public void caseIdentityStmt(IdentityStmt stmt) {
                }

                @Override
                public void caseEnterMonitorStmt(EnterMonitorStmt stmt) {
                }

                @Override
                public void caseExitMonitorStmt(ExitMonitorStmt stmt) {
                }

                @Override
                public void caseGotoStmt(GotoStmt stmt) {
                }

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                @Override
                public void caseIfStmt(IfStmt stmt) {
                    Value c = stmt.getCondition();
                    if (c instanceof BinopExpr) {
                        BinopExpr be = (BinopExpr)c;
                        Value op1 = be.getOp1();
                        Value op2 = be.getOp2();
                        if (!(op1 instanceof UntypedConstant) && !(op2 instanceof UntypedConstant)) return;
                        if (op1 instanceof Local) {
                            Type t2 = DalvikTyper.this.localTyped.get(op1);
                            UntypedConstant uc = (UntypedConstant)op2;
                            be.setOp2(uc.defineType(t2));
                            return;
                        } else if (op2 instanceof Local) {
                            Type t3 = DalvikTyper.this.localTyped.get(op2);
                            UntypedConstant uc = (UntypedConstant)op1;
                            be.setOp1(uc.defineType(t3));
                            return;
                        } else if (op1 instanceof UntypedConstant && op2 instanceof UntypedConstant) {
                            if (op1 instanceof UntypedIntOrFloatConstant && op2 instanceof UntypedIntOrFloatConstant) {
                                UntypedIntOrFloatConstant uc1 = (UntypedIntOrFloatConstant)op1;
                                UntypedIntOrFloatConstant uc2 = (UntypedIntOrFloatConstant)op2;
                                be.setOp1(uc1.toIntConstant());
                                be.setOp2(uc2.toIntConstant());
                                return;
                            } else {
                                if (!(op1 instanceof UntypedLongOrDoubleConstant) || !(op2 instanceof UntypedLongOrDoubleConstant)) throw new RuntimeException("error: expected same type of untyped constants. Got " + stmt);
                                UntypedLongOrDoubleConstant uc1 = (UntypedLongOrDoubleConstant)op1;
                                UntypedLongOrDoubleConstant uc2 = (UntypedLongOrDoubleConstant)op2;
                                be.setOp1(uc1.toLongConstant());
                                be.setOp2(uc2.toLongConstant());
                            }
                            return;
                        } else {
                            if (!(op1 instanceof UntypedConstant) && !(op2 instanceof UntypedConstant)) throw new RuntimeException("error: expected local/untyped untyped/local or untyped/untyped. Got " + stmt);
                            if (op1 instanceof UntypedConstant) {
                                UntypedConstant uc = (UntypedConstant)op1;
                                be.setOp1(uc.defineType(op2.getType()));
                                return;
                            } else {
                                if (!(op2 instanceof UntypedConstant)) return;
                                UntypedConstant uc = (UntypedConstant)op2;
                                be.setOp2(uc.defineType(op1.getType()));
                            }
                        }
                        return;
                    } else {
                        if (c instanceof UnopExpr) return;
                        throw new RuntimeException("error: expected binop or unop. Got " + stmt);
                    }
                }

                @Override
                public void caseLookupSwitchStmt(LookupSwitchStmt stmt) {
                }

                @Override
                public void caseNopStmt(NopStmt stmt) {
                }

                @Override
                public void caseRetStmt(RetStmt stmt) {
                }

                @Override
                public void caseReturnStmt(ReturnStmt stmt) {
                    if (stmt.getOp() instanceof UntypedConstant) {
                        UntypedConstant uc = (UntypedConstant)stmt.getOp();
                        Type type = b.getMethod().getReturnType();
                        stmt.setOp(uc.defineType(type));
                    }
                }

                @Override
                public void caseReturnVoidStmt(ReturnVoidStmt stmt) {
                }

                @Override
                public void caseTableSwitchStmt(TableSwitchStmt stmt) {
                }

                @Override
                public void caseThrowStmt(ThrowStmt stmt) {
                }

                @Override
                public void defaultCase(Object obj) {
                }
            };
            unit.apply(sw);
        }
    }

    private void changeUntypedConstantsInInvoke(InvokeExpr invokeExpr) {
        for (int i = 0; i < invokeExpr.getArgCount(); ++i) {
            Value v = invokeExpr.getArg(i);
            if (!(v instanceof UntypedConstant)) continue;
            Type t2 = invokeExpr.getMethodRef().parameterType(i);
            UntypedConstant uc = (UntypedConstant)v;
            invokeExpr.setArg(i, uc.defineType(t2));
        }
    }

    protected void checkExpr(Value v, Type t2) {
        for (ValueBox vb : v.getUseBoxes()) {
            Value value = vb.getValue();
            if (value instanceof Local) {
                if ((v instanceof ShrExpr || v instanceof ShlExpr || v instanceof UshrExpr) && ((BinopExpr)v).getOp2() == value) {
                    DalvikTyper.v().setType(vb, IntType.v(), true);
                    continue;
                }
                DalvikTyper.v().setType(vb, t2, true);
                continue;
            }
            if (!(value instanceof UntypedConstant)) continue;
            UntypedConstant uc = (UntypedConstant)value;
            if ((v instanceof ShrExpr || v instanceof ShlExpr || v instanceof UshrExpr) && ((BinopExpr)v).getOp2() == value) {
                UntypedIntOrFloatConstant ui = (UntypedIntOrFloatConstant)uc;
                vb.setValue(ui.toIntConstant());
                continue;
            }
            vb.setValue(uc.defineType(t2));
        }
    }

    protected void setInvokeType(InvokeExpr invokeExpr) {
        for (int i = 0; i < invokeExpr.getArgCount(); ++i) {
            Value v = invokeExpr.getArg(i);
            if (!(v instanceof Local)) continue;
            Type t2 = invokeExpr.getMethodRef().parameterType(i);
            DalvikTyper.v().setType(invokeExpr.getArgBox(i), t2, true);
        }
        if (!(invokeExpr instanceof StaticInvokeExpr)) {
            if (invokeExpr instanceof InstanceInvokeExpr) {
                InstanceInvokeExpr iie = (InstanceInvokeExpr)invokeExpr;
                DalvikTyper.v().setType(iie.getBaseBox(), RefType.v("java.lang.Object"), true);
            } else if (invokeExpr instanceof DynamicInvokeExpr) {
                DynamicInvokeExpr dynamicInvokeExpr = (DynamicInvokeExpr)invokeExpr;
            } else {
                throw new RuntimeException("error: unhandled invoke expression: " + invokeExpr + " " + invokeExpr.getClass());
            }
        }
    }

    private void setLocalTyped(Local l, Type t2) {
        this.localTyped.put(l, t2);
    }

    public void typeUntypedConstrantInDiv(final Body b) {
        for (Unit u : b.getUnits()) {
            StmtSwitch sw = new StmtSwitch(){

                @Override
                public void caseBreakpointStmt(BreakpointStmt stmt) {
                }

                @Override
                public void caseInvokeStmt(InvokeStmt stmt) {
                    DalvikTyper.this.changeUntypedConstantsInInvoke(stmt.getInvokeExpr());
                }

                @Override
                public void caseAssignStmt(AssignStmt stmt) {
                    Value r;
                    ArrayRef ar;
                    CastExpr ce;
                    UntypedConstant uc;
                    if (stmt.getRightOp() instanceof NewArrayExpr) {
                        NewArrayExpr nae = (NewArrayExpr)stmt.getRightOp();
                        if (nae.getSize() instanceof UntypedConstant) {
                            uc = (UntypedIntOrFloatConstant)nae.getSize();
                            nae.setSize(((UntypedIntOrFloatConstant)uc).defineType(IntType.v()));
                        }
                    } else if (stmt.getRightOp() instanceof InvokeExpr) {
                        DalvikTyper.this.changeUntypedConstantsInInvoke((InvokeExpr)stmt.getRightOp());
                    } else if (stmt.getRightOp() instanceof CastExpr && (ce = (CastExpr)stmt.getRightOp()).getOp() instanceof UntypedConstant) {
                        uc = (UntypedConstant)ce.getOp();
                        for (Tag t2 : stmt.getTags()) {
                            if (t2 instanceof IntOpTag) {
                                ce.setOp(uc.defineType(IntType.v()));
                                return;
                            }
                            if (t2 instanceof FloatOpTag) {
                                ce.setOp(uc.defineType(FloatType.v()));
                                return;
                            }
                            if (t2 instanceof DoubleOpTag) {
                                ce.setOp(uc.defineType(DoubleType.v()));
                                return;
                            }
                            if (!(t2 instanceof LongOpTag)) continue;
                            ce.setOp(uc.defineType(LongType.v()));
                            return;
                        }
                        ce.setOp(uc.defineType(RefType.v("java.lang.Object")));
                    }
                    if (stmt.containsArrayRef() && (ar = stmt.getArrayRef()).getIndex() instanceof UntypedConstant) {
                        uc = (UntypedIntOrFloatConstant)ar.getIndex();
                        ar.setIndex(((UntypedIntOrFloatConstant)uc).toIntConstant());
                    }
                    if ((r = stmt.getRightOp()) instanceof DivExpr || r instanceof RemExpr) {
                        for (Tag t3 : stmt.getTags()) {
                            if (t3 instanceof IntOpTag) {
                                DalvikTyper.this.checkExpr(r, IntType.v());
                                return;
                            }
                            if (t3 instanceof FloatOpTag) {
                                DalvikTyper.this.checkExpr(r, FloatType.v());
                                return;
                            }
                            if (t3 instanceof DoubleOpTag) {
                                DalvikTyper.this.checkExpr(r, DoubleType.v());
                                return;
                            }
                            if (!(t3 instanceof LongOpTag)) continue;
                            DalvikTyper.this.checkExpr(r, LongType.v());
                            return;
                        }
                    }
                }

                @Override
                public void caseIdentityStmt(IdentityStmt stmt) {
                }

                @Override
                public void caseEnterMonitorStmt(EnterMonitorStmt stmt) {
                }

                @Override
                public void caseExitMonitorStmt(ExitMonitorStmt stmt) {
                }

                @Override
                public void caseGotoStmt(GotoStmt stmt) {
                }

                @Override
                public void caseIfStmt(IfStmt stmt) {
                }

                @Override
                public void caseLookupSwitchStmt(LookupSwitchStmt stmt) {
                }

                @Override
                public void caseNopStmt(NopStmt stmt) {
                }

                @Override
                public void caseRetStmt(RetStmt stmt) {
                }

                @Override
                public void caseReturnStmt(ReturnStmt stmt) {
                    if (stmt.getOp() instanceof UntypedConstant) {
                        UntypedConstant uc = (UntypedConstant)stmt.getOp();
                        Type type = b.getMethod().getReturnType();
                        stmt.setOp(uc.defineType(type));
                    }
                }

                @Override
                public void caseReturnVoidStmt(ReturnVoidStmt stmt) {
                }

                @Override
                public void caseTableSwitchStmt(TableSwitchStmt stmt) {
                }

                @Override
                public void caseThrowStmt(ThrowStmt stmt) {
                    if (stmt.getOp() instanceof UntypedConstant) {
                        UntypedConstant uc = (UntypedConstant)stmt.getOp();
                        stmt.setOp(uc.defineType(RefType.v("java.lang.Object")));
                    }
                }

                @Override
                public void defaultCase(Object obj) {
                }
            };
            u.apply(sw);
        }
    }

    class Constraint {
        ValueBox l;
        ValueBox r;

        public Constraint(ValueBox l, ValueBox r) {
            this.l = l;
            this.r = r;
        }

        public String toString() {
            return this.l + " < " + this.r;
        }
    }

    class LocalObj {
        ValueBox vb;
        Type t;
        boolean isUse;

        public LocalObj(ValueBox vb, Type t2, boolean isUse) {
            this.vb = vb;
            this.t = t2;
            this.isUse = isUse;
        }

        public Local getLocal() {
            return (Local)this.vb.getValue();
        }
    }
}

