/*
 * Decompiled with CFR 0.152.
 */
package soot.dexpler.instructions;

import java.util.List;
import org.jf.dexlib2.iface.instruction.Instruction;
import org.jf.dexlib2.iface.instruction.formats.ArrayPayload;
import org.jf.dexlib2.iface.instruction.formats.Instruction31t;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.Local;
import soot.dexpler.DexBody;
import soot.dexpler.instructions.PseudoInstruction;
import soot.dexpler.typing.UntypedIntOrFloatConstant;
import soot.dexpler.typing.UntypedLongOrDoubleConstant;
import soot.jimple.ArrayRef;
import soot.jimple.AssignStmt;
import soot.jimple.Constant;
import soot.jimple.IntConstant;
import soot.jimple.Jimple;
import soot.jimple.Stmt;

public class FillArrayDataInstruction
extends PseudoInstruction {
    private static final Logger logger = LoggerFactory.getLogger(FillArrayDataInstruction.class);

    public FillArrayDataInstruction(Instruction instruction, int codeAdress) {
        super(instruction, codeAdress);
    }

    @Override
    public void jimplify(DexBody body) {
        if (!(this.instruction instanceof Instruction31t)) {
            throw new IllegalArgumentException("Expected Instruction31t but got: " + this.instruction.getClass());
        }
        Instruction31t fillArrayInstr = (Instruction31t)this.instruction;
        int destRegister = fillArrayInstr.getRegisterA();
        int offset = fillArrayInstr.getCodeOffset();
        int targetAddress = this.codeAddress + offset;
        Instruction referenceTable = body.instructionAtAddress((int)targetAddress).instruction;
        if (!(referenceTable instanceof ArrayPayload)) {
            throw new RuntimeException("Address " + targetAddress + "refers to an invalid PseudoInstruction.");
        }
        ArrayPayload arrayTable = (ArrayPayload)referenceTable;
        Local arrayReference = body.getRegisterLocal(destRegister);
        List<Number> elements = arrayTable.getArrayElements();
        int numElements = elements.size();
        int elementsWidth = arrayTable.getElementWidth();
        Stmt firstAssign = null;
        for (int i = 0; i < numElements; ++i) {
            ArrayRef arrayRef = Jimple.v().newArrayRef(arrayReference, IntConstant.v(i));
            Constant element = this.getArrayElement(elements.get(i), elementsWidth);
            AssignStmt assign = Jimple.v().newAssignStmt(arrayRef, element);
            this.addTags(assign);
            body.add(assign);
            if (i != 0) continue;
            firstAssign = assign;
        }
        if (firstAssign == null) {
            logger.warn("No assign statements created for array at address 0x{} - empty array data section?", (Object)Integer.toHexString(targetAddress));
            firstAssign = Jimple.v().newNopStmt();
            body.add(firstAssign);
        }
        this.setUnit(firstAssign);
    }

    private Constant getArrayElement(Number element, int elementsWidth) {
        if (elementsWidth == 2) {
            return IntConstant.v(element.shortValue());
        }
        if (elementsWidth <= 4) {
            return UntypedIntOrFloatConstant.v(element.intValue());
        }
        return UntypedLongOrDoubleConstant.v(element.longValue());
    }

    @Override
    public void computeDataOffsets(DexBody body) {
        if (!(this.instruction instanceof Instruction31t)) {
            throw new IllegalArgumentException("Expected Instruction31t but got: " + this.instruction.getClass());
        }
        Instruction31t fillArrayInstr = (Instruction31t)this.instruction;
        int offset = fillArrayInstr.getCodeOffset();
        int targetAddress = this.codeAddress + offset;
        Instruction referenceTable = body.instructionAtAddress((int)targetAddress).instruction;
        if (!(referenceTable instanceof ArrayPayload)) {
            throw new RuntimeException("Address 0x" + Integer.toHexString(targetAddress) + " refers to an invalid PseudoInstruction (" + referenceTable.getClass() + ").");
        }
        ArrayPayload arrayTable = (ArrayPayload)referenceTable;
        int numElements = arrayTable.getArrayElements().size();
        int widthElement = arrayTable.getElementWidth();
        int size = widthElement * numElements / 2;
        this.setDataFirstByte(targetAddress + 3);
        this.setDataLastByte(targetAddress + 3 + size);
        this.setDataSize(size);
    }
}

