/*
 * Decompiled with CFR 0.152.
 */
package soot.dexpler;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import soot.Body;
import soot.Local;
import soot.Scene;
import soot.SootClass;
import soot.SootField;
import soot.Type;
import soot.Unit;
import soot.dexpler.DexTransformer;
import soot.jimple.FieldRef;
import soot.jimple.Stmt;

public class DexRefsChecker
extends DexTransformer {
    Local l = null;

    public static DexRefsChecker v() {
        return new DexRefsChecker();
    }

    protected void internalTransform(Body body, String phaseName, Map options) {
        for (Unit u : this.getRefCandidates(body)) {
            Stmt s2 = (Stmt)u;
            boolean hasField = false;
            FieldRef fr = null;
            SootField sf = null;
            if (s2.containsFieldRef()) {
                fr = s2.getFieldRef();
                sf = fr.getField();
                if (sf != null) {
                    hasField = true;
                }
            } else {
                throw new RuntimeException("Unit '" + u + "' does not contain array ref nor field ref.");
            }
            if (hasField) continue;
            System.out.println("Warning: add missing field '" + fr + "' to class!");
            SootClass sc = null;
            String frStr = fr.toString();
            sc = frStr.contains(".<") ? Scene.v().getSootClass(frStr.split(".<")[1].split(" ")[0].split(":")[0]) : Scene.v().getSootClass(frStr.split(":")[0].replaceAll("^<", ""));
            String fname = fr.toString().split(">")[0].split(" ")[2];
            int modifiers = 1;
            Type ftype = fr.getType();
            sc.addField(Scene.v().makeSootField(fname, ftype, modifiers));
        }
    }

    private Set<Unit> getRefCandidates(Body body) {
        HashSet<Unit> candidates = new HashSet<Unit>();
        for (Unit u : body.getUnits()) {
            Stmt s2 = (Stmt)u;
            if (!s2.containsFieldRef()) continue;
            candidates.add(u);
        }
        return candidates;
    }
}

